jQuery(function($){
	if(typeof braintree_applepay_product_vars === "undefined"){
		return;
	}
	var applepay = {
			vars: braintree_applepay_product_vars,
			message_container: 'div.product',
			nonce_selector: '.bfwc-nonce-value',
			init: function(){
				this.button_width = $('.quantity').outerWidth(true) + $('[name="add-to-cart"]').outerWidth();
				this.gateway = this.vars.gateway;
				this.container = 'li.bfwc_product_gateway_' + this.gateway;
				
				this.$form = $(this.container).closest('form');
				this.$form.on('found_variation', this.found_variation);
				
				this.initialize();
			},
			initialize: function(){
				if(applepay.can_initialize_applepay()){
					if(typeof braintree_applepay_product_client_token === 'undefined'){
						applepay.submit_error({
							code: 'INVALID_CLIENT_TOKEN'
						});
						return;
					}
					braintree.client.create({
						authorization: braintree_applepay_product_client_token
					}, function(err, clientInstance){
						if(err){
							applepay.submit_error(err);
							return;
						}
						applepay.clientInstance = clientInstance;
						braintree.applePay.create({
							client: clientInstance
						}, function(err, applePayInstance){
							if(err){
								applepay.submit_error(err);
								return;
							}
							applepay.applePayInstance = applePayInstance;
							var promise = ApplePaySession.canMakePaymentsWithActiveCard(applePayInstance.merchantIdentifier);
							promise.then(function(bool){
								if(bool){
									if($('[name="variation_id"]').length){
										$('.apple-pay-button').prop('disabled', true);
									}
									$('.apple-pay-button').css('max-width', applepay.button_width + "px");
									$(document.body).on('click', '.apple-pay-button', applepay.start_checkout);
								}
							});
						});
					});
				}else{
					$(applepay.container).hide();
				}
			},
			start_checkout: function(e){
				e.preventDefault();
				if(!applepay.setup_wallet()){
					return;
				}
				var data = {
						product_id: $('[name="add-to-cart"]').val(),
						variation_id: $('[name="variation_id"]').val(),
						qty: $('[name="quantity"]').val()
				}
				$.blockUI({
					message : null,
					overlayCSS : {
						background : '#fff',
						opacity : 0.6
					}
				});
				$.ajax({
					url: applepay.vars.routes.add_to_cart,
					type: 'POST',
					dataType : 'json',
					data: data,
					beforeSend: function(xhr, settings) {
						xhr.setRequestHeader('X-WP-Nonce', applepay.vars._wpnonce);
					},
					success: function(response, status, xhr){
						applepay.vars._wpnonce = xhr.getResponseHeader('X-WP-Nonce');
						$.unblockUI();
						if(response.success){
							applepay.open_wallet();
						}else{
							applepay.submit_error(response.messages);
							return;
						}
					},
					error: function(jqXHR, textStatus, errorThrown){
						$.unblockUI();
						applepay.submit_error(errorThrown);
					}
				});
				
			},
			setup_wallet: function(){
				var paymentRequest = applepay.applePayInstance.createPaymentRequest({
					total: {
						label: applepay.vars.store_name,
						amount: applepay.get_product_price() * $('[name="quantity"]').val(),
						type: 'final'
					},
					currencyCode: $('#bfwc_cart_currency').val(),
					requiredBillingContactFields: applepay.get_billing_fields_array(),
					requiredShippingContactFields: applepay.get_shipping_fields_array(),
				});
				try{
					var applePaySession = new ApplePaySession(3, paymentRequest);
					applepay.applePaySession = applePaySession;
					applePaySession.onvalidatemerchant = applepay.onvalidatemerchant;
					if(!applepay.get_product_data().needs_shipping){
						applePaySession.onpaymentmethodselected = applepay.onpaymentmethodselected;
					}
					applePaySession.onshippingcontactselected = applepay.onshippingcontactselected;
					applePaySession.onshippingmethodselected = applepay.onshippingmethodselected;
					applePaySession.onpaymentauthorized = applepay.onpaymentauthorized;
					return true;
				}catch(err){
					applepay.submit_error(err);
					return false;
				}
			},
			open_wallet: function(){
				applepay.applePaySession.begin();
			},
			onvalidatemerchant: function(event){
				applepay.applePayInstance.performValidation({
					validationURL: event.validationURL,
					displayName: applepay.vars.store_name
				}, function(err, merchantSession){
					if(err){
						applepay.submit_error(err);
						applepay.applePaySession.abort();
						return;
					}
					applepay.applePaySession.completeMerchantValidation(merchantSession);
				})
			},
			onpaymentmethodselected: function(event){
				var data = {
						product_id: $('[name="add-to-cart"]').val(),
						variation_id: $('[name="variation_id"]').val(),
						qty: $('[name="quantity"]').val()
				}
				$.ajax({
					url: applepay.vars.routes.payment_method,
					type: 'POST',
					dataType : 'json',
					data: data,
					beforeSend: function(xhr, settings) {
						xhr.setRequestHeader('X-WP-Nonce', applepay.vars._wpnonce);
					},
					success: function(response, status, jqXHR){
						if(response.success){
							applepay.applePaySession.completePaymentMethodSelection(response.data);
						}else{
							applepay.applePaySession.abort();
							applepay.submit_error(response.messages);
							return;
						}
					},
					error: function(jqXHR, textStatus, errorThrown){
						applepay.applePaySession.abort();
						applepay.submit_error(errorThrown);
					}
				});
			},
			onshippingcontactselected: function(){
				var shippingContact = event.shippingContact;
				$.ajax({
					type: 'POST',
					dataType : 'json',
					url: applepay.vars.routes.shipping_address,
					data: shippingContact,
					beforeSend : function(xhr, settings) {
						xhr.setRequestHeader('X-WP-Nonce', applepay.vars._wpnonce);
					},
					success: function(response, status, jqXHR){
						if(response.success){
							applepay.applePaySession.completeShippingContactSelection(response.data);
						}else{
							applepay.applePaySession.abort();
							applepay.submit_error(response.messages);
						}
					},
					error: function(jqXHR, textStatus, errorThrown){
						applepay.applePaySession.abort();
						applepay.submit_error(errorThrown);
					}
				});
			},
			onshippingmethodselected: function(event){
				var shippingMethod = event.shippingMethod;
				$.ajax({
					type: 'POST',
					dataType : 'json',
					url: applepay.vars.routes.shipping_method,
					data: shippingMethod,
					beforeSend : function(xhr, settings) {
						xhr.setRequestHeader('X-WP-Nonce', applepay.vars._wpnonce);
					},
					success: function(response, status, jqXHR){
						if(response.success){
							applepay.applePaySession.completeShippingMethodSelection(response.shippingMethodUpdate);
						}else{
							applepay.applePaySession.abort();
							applepay.submit_error(response.messages);
						}
					},
					error: function(jqXHR, textStatus, errorThrown){
						applepay.applePaySession.abort();
						applepay.submit_error(errorThrown);
					}
				});
			},
			onpaymentauthorized: function(event){
				applepay.applePayInstance.tokenize({
					token: event.payment.token
				}, function(err, response){
					if(err){
						applepay.submit_error(err);
						applepay.applePaySession.completePayment(ApplePaySession.STATUS_FAILURE);
						return;
					}
					applepay.applePaySession.completePayment(ApplePaySession.STATUS_SUCCESS);
					applepay.set_nonce(response.nonce);
					applepay.populate_address_data(event.payment);
					applepay.tokenize_response = {payment: event.payment, response: response};
					//call service
					applepay.process_order();
				})
			},
			process_order: function(){
				// create the order using ajax;
				$form = $(applepay.container).closest('form');
				$.blockUI({
					message : null,
					overlayCSS : {
						background : '#fff',
						opacity : 0.6
					}
				});
				$.ajax({
					type : 'POST',
					url : applepay.vars.routes.order,
					data : $form.serialize(),
					dataType : 'json',
					beforeSend : function(xhr, settings) {
						xhr.setRequestHeader('X-WP-Nonce',
								applepay.vars._wpnonce);
					},
					success : function(result, status, jqXHR) {
						if (result.reload) {
							window.location.reload();
							return;
						}
						if (result.result === 'success') {
							window.location = result.redirect;
						} else {
							if (result.messages) {
								applepay.submit_error(result.messages);
							}
							applepay.set_nonce("");
							$.unblockUI();
						}
					},
					error : function(jqXHR, textStatus, errorThrown) {
						applepay.set_nonce("");
						applepay.submit_error(errorThrown);
						$.unblockUI();
					}
				});
			},
			found_variation: function(e, variation){
				$('.apple-pay-button').prop('disabled', false);
				$('#bfwc_product_price').val(variation.display_price);
			},
			can_initialize_applepay: function(){
				return window.ApplePaySession && ApplePaySession.canMakePayments();
			},
			get_product_price: function(){
				return $('#bfwc_product_price').val();
			},
			get_product_id: function(){
				return $('[name="add-to-cart"]').val();
			},
			get_billing_fields_array: function(){
				return ['postalAddress'];
			},
			get_shipping_fields_array: function(){
				var fields = ['email', 'phone'], data = applepay.get_product_data();
				if(data.needs_shipping){
					fields.push('postalAddress');
				}
				return fields;
			},
			get_product_data: function(){
				return $('#bfwc_product_data').data('product');
			},
			submit_error: function(error){
				applepay.clear_error();
				$(document.body).triggerHandler('bfwc_submit_error', {
					error : error,
					element : applepay.message_container
				});
			},
			clear_error: function(){
				$('#bfwc_checkout_error').remove();
			},
			set_nonce: function(nonce){
				$(applepay.container).find(applepay.nonce_selector).val(nonce);
			},
			populate_address_data: function(response){
				if(response.shippingContact){
					//populate the shipping fields
					var mappings = applepay.get_object_mappings();
					$.each(response.shippingContact, function(k, v){
						if(mappings[k]){
							mappings[k].set(v, "#shipping");
						}
					});
				}
				if(response.billingContact){
					//populate the billing fields
					var mappings = applepay.get_object_mappings();
					$.each(response.billingContact, function(k, v){
						if(mappings[k]){
							if(mappings[k]){
								mappings[k].set(v, "#billing");
							}
						}
					});
				}
			},
			get_object_mappings: function(){
				return {
					"givenName": {
						get: function(prefix){
							return $(prefix + "_first_name").val();
						},
						set: function(v, prefix){
							$(prefix + "_first_name").val(v);
						}
					},
					"familyName": {
						get: function(prefix){
							return $(prefix + "_last_name").val();
						},
						set: function(v, prefix){
							$(prefix + "_last_name").val(v);
						}
					},
					"addressLines": {
						get: function(prefix){
							var addressLines = [];
							if($(prefix + "_address_1").val() != ''){
								addressLines.push($(prefix + "_address_1").val());
							}
							if($(prefix + "_address_2").val() != ''){
								addressLines.push($(prefix + "_address_2").val());
							}
							return addressLines;
						},
						set: function(v, prefix){
							$(prefix + "_address_1").val(v[0]);
							if(v.length == 2){
								$(prefix + "_address_2").val(v[0]);
							}
						}
					},
					"administrativeArea": {
						get: function(prefix){
							return $(prefix + "_state").val();
						},
						set: function(v, prefix){
							if(v.length == 2){
								$(prefix + "_state").val(v.toUpperCase());
							}else{
								$(prefix + '_state option').each(function(){
									var $this = $(this);
									var text = $this.text().toLowerCase();
									v = v.toLowerCase();
									if(text.indexOf(v) >= 0){
										$(prefix + "_state").val($this.val());
									}
								});
							}
						}
					},
					"locality": {
						get: function(prefix){
							return $(prefix + "_city").val();
						},
						set: function(v, prefix){
							$(prefix + "_city").val(v);
						}
					},
					"postalCode": {
						get: function(prefix){
							return $(prefix + "_postcode").val();
						},
						set: function(v, prefix){
							$(prefix + "_postcode").val(v);
						}
					},
					"phoneNumber": {
						get: function(prefix){
							return $("#billing_phone").val();
						},
						set: function(v, prefix){
							$("#billing_phone").val(v);
						}
					},
					"emailAddress": {
						get: function(prefix){
							return $("#billing_email").val();
						},
						set: function(v, prefix){
							$("#billing_email").val(v);
						}
					},
					"countryCode": {
						get: function(prefix){
							return $(prefix + "_country").val();
						},
						set: function(v, prefix){
							$(prefix + "_country").val(v);
						}
					}
				}
			},
	};
	applepay.init();
})