jQuery(function($){
	if(typeof braintree_venmo_vars === 'undefined'){
		return;
	}
	var venmo = {
			vars: braintree_venmo_vars,
			list_container: 'li.payment_method_' + braintree_venmo_vars.gateway_id,
			container: '.payment_method_' + braintree_venmo_vars.gateway_id,
			gateway_id: braintree_venmo_vars.gateway_id,
			button_selector: '.bfwc-venmo-tokenize',
			button_class: 'bfwc-venmo-tokenize',
			nonce_selector: '.bfwc-nonce-value',
			token_selector: '.bfwc-payment-method-token',
			device_data_selector: '.bfwc-device-data',
			method_container: '.bfwc-new-payment-method-container',
			tokenize_response: null,
			can_pay: false,
			init: function(){
				$(document.body).on('click', this.button_selector, this.tokenize);
				
				$(this.container).closest('form').on('checkout_place_order_' + this.gateway_id, this.woocommerce_form_submit);
				$(this.container).closest('form').on('checkout_place_order_' + this.gateway_id, this.pre_submit_validations);
				
				$(document.body).on('updated_checkout', this.create_button);
				$(document.body).on('updated_checkout', this.show_gateway);
				
				$(document.body).on('bfwc_pre_form_submit_' + this.vars.gateway_id, this.set_device_data);
				
				$(document.body).on('checkout_error', this.checkout_error);
				
				this.initialize();
			},
			initialize: function(){
				if(typeof braintree_venmo_client_token === 'undefined'){
					this.submit_error({
						code: 'INVALID_CLIENT_TOKEN'
					});
					return;
				}
				if(typeof braintree === "undefined"){
					setTimeout(venmo.initialize, 1500);
					return;
				}
				braintree.client.create({
					authorization: braintree_venmo_client_token
				}, function(err, clientInstance){
					if(err){
						venmo.submit_error(err);
						return;
					}
					venmo.clientInstance = clientInstance;
					venmo.initialize_fraud_tools();
					braintree.venmo.create({
						client: clientInstance,
					    allowNewBrowserTab: false
					}, function(err, venmoInstance){
						if(err){
							venmo.submit_error(err);
							return;
						}
						venmo.venmoInstance = venmoInstance;
						if(venmoInstance.isBrowserSupported()){
							// show gateway since it's supported.
							venmo.can_pay = true;
							venmo.show_gateway();
							venmo.create_button();
							$(document.body).on('bfwc_payment_method_selected', venmo.payment_gateway_changed);
							//$(document.body).on('bfwc_display_saved_methods', venmo.display_saved_methods);
							//$(document.body).on('bfwc_display_new_payment_method_container', venmo.display_new_payment_method_container);
						}else{
							venmo.hide_gateway();
						}
					});
				});
			},
			initialize_fraud_tools: function(){
				if(venmo.vars.advanced_fraud.enabled){
					braintree.dataCollector.create({
						client: venmo.clientInstance,
						paypal: true,
						kount: true
					}, function(err, dataCollectorInstance){
						if(err){
							if(err.code === 'DATA_COLLECTOR_KOUNT_NOT_ENABLED'){
								return;
							}
							venmo.submit_error(err);
							return;
						}
						venmo.dataCollectorInstance = dataCollectorInstance;
					})
				}
			},
			submit_error: function(error){
				$(document.body).triggerHandler('bfwc_submit_error', {error: error, element: venmo.container});
			},
			show_gateway: function(){
				if(venmo.venmoInstance && venmo.venmoInstance.isBrowserSupported()){
					$(venmo.container).show();
				}
			},
			hide_gateway: function(){
				$(venmo.container).hide();
			},
			create_button: function(){
				if(venmo.$button){
					venmo.$button.remove();
				}
				var $parent = $('#place_order').parent();
				venmo.$button = $(venmo.vars.html.button);
				$parent.append(venmo.$button);
				venmo.$button.hide();
				if(venmo.tokenize_response){
					venmo.on_payment_method_received(venmo.tokenize_response);
				}
				venmo.payment_gateway_changed(null, $('input[name="payment_method"]:checked').val());
			},
			payment_gateway_changed: function(e, payment_gateway){
				var button = $('#place_order');
				if(payment_gateway === venmo.gateway_id && venmo.can_pay){
					if(!venmo.is_payment_method_selected() && !venmo.payment_method_received){
						venmo.$button.show();
						button.hide();
					}else{
						venmo.$button.hide();
						button.show();
					}
				}else{
					venmo.$button.hide();
				}
			},
			is_payment_method_selected: function(){
				if($(venmo.container).find(venmo.token_selector).length){
					if($(venmo.container).find(venmo.token_selector).val() !== ''){
						return true;
					}else{
						return false;
					}
				}else{
					return false;
				}
			},
			woocommerce_form_submit: function(e){
				if(venmo.payment_method_received){
					return true;
				}else{
					return false;
				}
			},
			pre_submit_validations: function(){
				if($('[name="terms"]').length > 0 && !$('[name="terms"]').is(':checked')){
					var data = {
							element: $(venmo.container),
							error: {
								message: braintree_venmo_vars.terms.message
							}
					};
					$(document.body).triggerHandler('bfwc_submit_error', data);
					return false;
				}else{
					return true;
				}
			},
			tokenize: function(e){
				e.preventDefault();
				venmo.venmoInstance.tokenize(function(err, payload){
					if(err){
						venmo.submit_error(err);
						return;
					}
					venmo.on_payment_method_received(payload);
				});
			},
			on_payment_method_received: function(payload){
				venmo.payment_method_received = true;
				venmo.tokenize_response = payload;
				$(venmo.container).find(venmo.nonce_selector).val(payload.nonce);
				venmo.$button.hide();
				$("#place_order").show();
				if (venmo.vars.form.submit) {
					$(venmo.container).closest('form').submit();
				}
			},
			checkout_error: function(){
				if(venmo.is_gateway_selected() && venmo.has_checkout_error()){
					venmo.payment_method_received = false;
					venmo.tokenize_response = null;
					venmo.payment_gateway_changed(null, venmo.gateway_id);
				}
			},
			is_gateway_selected: function(){
				return $('input[name="payment_method"]:checked').val() === venmo.gateway_id;
			},
			has_checkout_error: function(){
				return $('#wc_braintree_checkout_error').length > 0;
			},
			set_device_data: function(){
				if(venmo.dataCollectorInstance){
					$(venmo.container).find(venmo.device_data_selector).val(venmo.dataCollectorInstance.deviceData);
				}
				return true;
			}
	};
	venmo.init();
})