<?php
class Braintree_Gateway_Subscription_Settings extends Braintree_Gateway_Settings_API {

	public function __construct() {
		$this->page = 'braintree-gateway-settings';
		$this->id = 'subscription_settings';
		$this->tab = 'subscription-settings';
		$this->label = __ ( 'Subscriptions', 'braintree-payments' );
		$this->title = array( 'title' => __ ( 'Subscription Settings', 'braintree-payments' ),'description' => __ ( 'If you do not have the WooCommerce Subscriptions plugin then you can use this plugin\'s subscription functionality.', 'braintree-payments' ) 
		);
		add_filter ( 'braintree_settings_localized_variables', array( $this,'localize_vars' 
		) );
		
		add_action ( 'init', array( $this,'maybe_set_test_mode' 
		), 900 );
		
		parent::__construct ();
	}

	public function localize_vars($vars) {
		$vars[ 'subscriptions' ] = array( 'wcs_active' => bt_manager ()->is_woocommerce_subscriptions_active () 
		);
		return $vars;
	}

	public function settings() {
		$settings = array (
				/* 'my_account_subscriptions' => array (
						'type' => 'checkbox', 
						'title' => 'My Account Subscriptions Link', 
						'default' => 'yes', 
						'value' => 'yes', 
						'tool_tip' => true, 
						'description' => __( 'If enabled, the WooCommerce My Account page will have a link to the customer\'s subscriptions. This option should be disabled if you don\'t sell subscriptions in your store.', 'braintree-payments' ) 
				),  */
				'subscription_gateway_timezone' => array( 
						'type' => 'select',
						'title' => __ ( 'Gateway Timezone', 'braintree-payments' ),
						'options' => bfwc_get_timezones (),
						'default' => 'America/Chicago',
						'tool_tip' => true,
						'description' => __ ( 'This is the timezone of your Braintree gateway. This value is used to calculate the Braintree subscription start dates.' ),
						'helper' => array( 
								'enabled' => true,
								'title' => __ ( 'Gateway Timezone', 'braintree-payments' ),
								'description' => __ ( 'The gateway timezone is the timezone that your subscriptions are created in. To locate your gateay timezone, login to the Braintree control panel and navigate to the processing page and scroll to the bottom.', 'braintree-payments' ),
								'type' => 'img',
								'url' => 'https://wordpress.paymentplugins.com/woo-payment-gateway/assets/subscription_gateway_timezone.png' 
						) 
				),
				'woocommerce_subscriptions_prefix' => array( 
						'type' => 'text',
						'value' => '',
						'default' => '',
						'title' => __ ( 'Subscription Prefix', 'braintree-payments' ),
						'class' => '',
						'tool_tip' => true,
						'description' => __ ( 'If you would like the subscription order ID to contain an order prefix, you can add one here. If left blank, the order id within Braintree
						will match the WooCommerce order id.', 'braintree-payments' ) 
				),
				'braintree_subscription_combine_same_products' => array( 
						'type' => 'checkbox',
						'title' => __ ( 'Combine Subscriptions', 'braintree-payments' ),
						'default' => 'yes',
						'value' => 'yes',
						'tool_tip' => true,
						'description' => __ ( 'If enabled, subscriptions which have the same billing period, length, and trials will be combined into one subscription instead of multiple subscriptions. For example, if a customer adds
								two of the same type of subscription, they will be combined into one since they share the same.', 'braintree-payments' ) 
				),
				'wcs_enable_test_mode' => array( 
						'type' => 'checkbox',
						'title' => __ ( 'Enable Test Mode', 'braintree-payments' ),
						'default' => 'no',
						'value' => 'yes',
						'tool_tip' => true,
						'description' => __ ( 'If enabled, you will be able to test WooCommerce Subscriptions using the action scheduler.', 'braintree-payments' ) 
				),
				'bfwcs_subscriptions_endpoint' => array( 
						'title' => __ ( 'Subscriptions Endpoint', 'braintree-payments' ),
						'description' => __ ( 'Endpoint for the My account &rarr; Subscriptions page. If left blank the subscription link will not show on the My Account page.', 'braintree-payments' ),
						'type' => 'text',
						'default' => '',
						'tool_tip' => true 
				),
				'bfwcs_view-subscription_endpoint' => array( 
						'title' => __ ( 'View Subscription Endpoint', 'braintree-payments' ),
						'description' => __ ( 'Endpoint for the My account &rarr; View Subscription page.', 'braintree-payments' ),
						'type' => 'text',
						'default' => 'view-subscription',
						'tool_tip' => true 
				),
				'bfwcs_change-payment-method_endpoint' => array( 
						'title' => __ ( 'Change Payment Method', 'braintree-payments' ),
						'description' => __ ( 'Endpoint for the My account &rarr; Change Subscription Payment Method page.', 'braintree-payments' ),
						'id' => 'woocommerce_myaccount_bfwc_change-payment-method_endpoint',
						'type' => 'text',
						'default' => 'change-payment-method',
						'tool_tip' => true 
				),
				'bfwcs_pay-subscription_endpoint' => array( 'title' => __ ( 'Pay Subscription', 'braintree-payments' ),'description' => __ ( 'Endpoint for the My account &rarr; Pay Subscription page.', 'braintree-payments' ),'type' => 'text','default' => 'pay-subscription','tool_tip' => true 
				) 
		);
		
		return $settings;
	}

	function get_endpoints() {
		return array( 'bfwcs_subscriptions_endpoint','bfwcs_view-subscription_endpoint','bfwcs_change-payment-method_endpoint','bfwcs_pay-subscription_endpoint' 
		);
	}

	public function maybe_set_test_mode() {
		if (is_admin () && bt_manager ()->is_active ( 'wcs_enable_test_mode' )) {
			if (defined ( 'WP_DEBUG' ) && WP_DEBUG === false) {
				global $wp_post_types;
				if (class_exists ( 'ActionScheduler_wpPostStore' ) && isset ( $wp_post_types[ ActionScheduler_wpPostStore::POST_TYPE ] )) {
					$post_type = $wp_post_types[ ActionScheduler_wpPostStore::POST_TYPE ];
					$args = array( 'show_ui' => true,'show_in_menu' => 'tools.php','show_in_admin_bar' => false 
					);
					foreach ( $args as $property_name => $value ) {
						$post_type->$property_name = $value;
					}
					$wp_post_types[ ActionScheduler_wpPostStore::POST_TYPE ] = $post_type;
				}
			}
		}
	}

	public function save() {
		parent::save ();
		update_option ( 'woocommerce_queue_flush_rewrite_rules', 'yes' );
		if (function_exists ( 'WC' )) {
			WC ()->query->init_query_vars ();
			WC ()->query->add_endpoints ();
			
			if (version_compare ( WC ()->version, '3.3.3', '<' )) {
				$vars = bt_manager ()->query->get_query_vars ();
				
				WC ()->query->query_vars = array_merge ( WC ()->query->query_vars, $vars );
				WC ()->query->add_endpoints ();
				
				flush_rewrite_rules ();
			}
		}
	}
}
new Braintree_Gateway_Subscription_Settings ();