<?php
if (! class_exists ( 'WC_Braintree_Payment_Gateway' )) {
	return;
}

/**
 *
 * @since 2.6.21
 * @author Payment Plugins
 *        
 */
class WC_Google_Payment_Gateway extends WC_Braintree_Payment_Gateway {
	const ID = 'braintree_googlepay_gateway';
	
	/**
	 * Nonce id contained in the $_POST.
	 *
	 * @var string
	 */
	public static $nonce_id = 'braintree_googlepay_nonce';
	public static $token_id = 'braintree_googlepay_payment_method_token';

	public function __construct() {
		$this->enabled = $this->settings[ 'enabled' ] = (bwc_googlepay_enabled () ? 'yes' : 'no');
		$this->title = bt_manager ()->get_option ( 'googlepay_gateway_title' );
		$this->id = static::ID;
		$this->method_title = __ ( 'Braintree GooglePay Payment Gateway', 'braintree-payments' );
		$this->has_fields = true;
		$this->actions ();
		$this->set_supports ();
		$this->init_settings ();
		$this->icon = bt_manager ()->plugin_assets_path () . 'img/googlepay/' . bt_manager ()->get_option ( 'googlepay_icon' ) . '.svg';
	}

	public static function init() {
		add_filter ( 'bwc_add_payment_gateways', __CLASS__ . '::add_braintree_gateway' );
		
		add_filter ( 'woocommerce_payment_gateways', __CLASS__ . '::add_gateway' );
		
		add_filter ( 'woocommerce_payment_complete_order_status', __CLASS__ . '::maybe_update_order_status', 99, 3 );
		
		add_filter ( 'woocommerce_saved_payment_methods_list', __CLASS__ . '::saved_payment_method_list', 10, 2 );
		
		add_action ( 'bfwc_before_process_order_' . static::ID, __CLASS__ . '::maybe_save_payment_method' );
		
		add_action ( 'wp_loaded', __CLASS__ . '::maybe_delete_payment_method' );
	}

	public static function add_braintree_gateway($gateways) {
		$gateways[] = __CLASS__;
		return $gateways;
	}

	public static function add_gateway($gateways) {
		$gateways[] = __CLASS__;
		return $gateways;
	}

	public function payment_fields() {
		if (bwc_is_checkout () || bwcs_is_change_payment_method () || bfwcs_is_change_payment_method () || bfwcs_is_pay_for_subscription_request ()) {
			bwc_get_template ( 'checkout/googlepay.php', array( 
					'gateway' => $this 
			) );
		} else {
			bwc_get_template ( 'googlepay.php', array( 
					'has_methods' => false,
					'gateway' => $this 
			) );
		}
	}

	public function set_supports() {
		$this->supports = array( 
				'subscriptions',
				'products',
				'subscription_cancellation',
				'multiple_subscriptions',
				'subscription_amount_changes',
				'subscription_date_changes',
				'default_credit_card_form',
				'refunds',
				'pre-orders',
				'subscription_payment_method_change_admin',
				'subscription_reactivation',
				'subscription_suspension',
				'subscription_payment_method_change_customer',
				'bfwcs_change_payment_method',
				'bfwc_subscriptions',
				'bfwc_credit_card_form',
				'bfwc_fees' 
		);
	}

	public static function saved_payment_method_list($saved_methods, $user_id) {
		if (bwc_googlepay_enabled ()) {
			$methods = bwc_get_googlepay_methods ( $user_id );
			return bwc_saved_payment_methods_list ( $saved_methods, $methods, static::ID );
		}
		return $saved_methods;
	}

	public function get_key_mappings() {
		return array( 
				'enabled' => 'googlepay_enabled' 
		);
	}
}
WC_Google_Payment_Gateway::init ();