<?php
/**
 * 
 * @author Payment Plugins
 * @since 2.6.16
 *
 */
class WC_Braintree_Gateway_Kount_Validation
{
	
	const NOT_EVALUATED = 'Not Evaluated';
	
	const APPROVE = 'Approve';
	
	const REVIEW = 'Review';
	
	const DECLINE = 'Decline';
	
	/**
	 *
	 * @var \Braintree\Transaction\
	 */
	private $transaction;
	
	/**
	 *
	 * @var Braintree\RiskData
	 */
	private $risk_data;

	/**
	 *
	 * @param \Braintree\Transaction\ $riskData        	
	 */
	public function __construct( $transaction )
	{
		$this->transaction = $transaction;
		$this->risk_data = $transaction->riskData;
	}

	/**
	 * Update the order based on the kount validations set.
	 *
	 * @param WC_Order $order        	
	 */
	public function update_order( $order )
	{
		$order_id = bwc_get_order_property( 'id', $order );
		
		update_post_meta( $order_id, '_transaction_id', $this->transaction->id );
		
		update_post_meta( $order_id, '_kount_id', $this->get_risk_id() );
		
		update_post_meta( $order_id, '_kount_decision', $this->get_decision() );
		
		if ( $this->is_approved() ) {
			$order->payment_complete( $this->transaction->id );
		} elseif ( $this->is_review() ) {
			
			$action = apply_filters( 'bfwc_get_kount_review_action', bt_manager()->get_option( 'kount_review_action' ) );
			
			switch( $action ) {
				case 'review' :
					if ( bwc_kount_send_processing_email() ) {
						$this->prepare_processing_order_actions( $order_id, $order );
					}
					$order->update_status( 'kount-review' );
					break;
				case 'cancel' :
					$order->update_status( 'cancelled' );
					break;
				case 'payment_complete' :
					$order->payment_complete();
					break;
				default :
					do_action( 'bfwc_kount_action_' . $action, $this, $order );
			}
		}
	}

	/**
	 * Return true if the transaction is approved by Kount.
	 *
	 * @return boolean
	 */
	public function is_approved()
	{
		return $this->get_decision() === self::APPROVE;
	}

	public function is_review()
	{
		return $this->get_decision() === self::REVIEW;
	}

	public function is_declined()
	{
		return $this->get_decision() === self::DECLINE;
	}

	public function has_device_data()
	{
		return $this->risk_data->deviceDataCaptured;
	}

	public function get_decision()
	{
		return $this->risk_data->decision;
	}

	public function get_risk_id()
	{
		return $this->risk_data->id;
	}

	/**
	 *
	 * @since 2.6.21
	 * @param int $order_id        	
	 * @param WC_Order $order        	
	 */
	public function prepare_processing_order_actions( $order_id, $order )
	{
		$mailer = WC()->mailer();
		if ( isset( $mailer->emails [ 'WC_Email_Customer_Processing_Order' ] ) ) {
			$email = $mailer->emails [ 'WC_Email_Customer_Processing_Order' ];
			add_action( 'woocommerce_order_status_pending_to_kount-review_notification', array (
					$email, 
					'trigger' 
			), 10, 2 );
		}
	}
}