<?php
/**
 * Class that handles queries related to WC functionality.
 * @author Clayton
 *
 */
class Braintree_Gateway_WC_Query
{
	
	private $endpoints = array ();

	public function __construct()
	{
		/*
		 * add_action( 'init', array (
		 * $this,
		 * 'add_endpoints'
		 * ) );
		 */
		/*
		 * add_action( 'parse_request', array (
		 * $this,
		 * 'parse_request'
		 * ) );
		 */
		
		add_filter( 'woocommerce_get_query_vars', array (
				$this, 
				'get_query_vars' 
		) );
		
		$this->initialize_endpoints();
		
		add_action( 'init', array (
				$this, 
				'add_wc_endpoints' 
		) );
	}

	private function initialize_endpoints()
	{
		$this->endpoints = array (
				'subscriptions', 
				'view-subscription', 
				'change-payment-method', 
				'pay-subscription' 
		);
	}

	public function add_wc_endpoints()
	{
		if ( function_exists( 'WC' ) && version_compare( WC()->version, '3.3.3', '<' ) && ! bt_manager()->is_woocommerce_subscriptions_active() ) {
			$vars = $this->get_query_vars();
			WC()->query->query_vars = array_merge( WC()->query->query_vars, $vars );
			WC()->query->add_endpoints();
		}
	}

	/**
	 * Add endpoints associated with plugin.
	 * These endpoints can be used to trigger page rendering functionality, etc.
	 */
	public function add_endpoints()
	{
		global $wp_rewrite;
		foreach ( $this->get_endpoints() as $key => $value ) {
			add_rewrite_endpoint( $value, EP_PAGES );
		}
	}

	public function parse_request()
	{
		global $wp;
	}

	public function get_endpoints()
	{
		return apply_filters( 'bfwc_get_endpoints', $this->endpoints );
	}

	public function get_query_vars( $vars = array() )
	{
		if ( ! bt_manager()->is_woocommerce_subscriptions_active() ) {
			foreach ( $this->get_endpoints() as $endpoint ) {
				$key = "bfwcs_{$endpoint}_endpoint";
				$value = bt_manager()->get_option( $key );
				if ( ! empty( $value ) ) {
					$vars [ $endpoint ] = $value;
				}
			}
		}
		return $vars;
	}
}