<?php

class EIK_Validator {
	const EIK9_LENGTH = 9;
	const EIK13_LENGTH = 13;
	const EIK13_PART_LENGTH = 5;

	const MODUL = 11;
	const MODUL_MAGIC = 10;


	/**
	 *
	 * Проверява за валидност 9 или 13-цифрен ЕИК (БУЛСТАТ)
	 * @param Integer $eik ЕИК, който да бъде проверен дали е валиден
	 */
	public static function is_valid($eik) {
		$ret = false;

		if (ctype_digit($eik)) {
			$len = strlen($eik);

			if ($len == self::EIK9_LENGTH || $len == self::EIK13_LENGTH) {
				if ($len == self::EIK9_LENGTH) {
					$ret = self::validate9($eik);
				} else {
					if (self::validate9(substr($eik, 0, 9))) {
						$ret = self::validate13(substr($eik, -1 * self::EIK13_PART_LENGTH));
					}
				}
			}
		}

		return $ret;
	}
	function egn_valid($egn) {
	$EGN_WEIGHTS = array(2,4,8,5,10,9,7,3,6);
	if (strlen($egn) != 10)
	{
		return false;
	}
	$year = substr($egn,0,2);
	$mon  = substr($egn,2,2);
	$day  = substr($egn,4,2);
	if($mon > 40)
	{
		if(!checkdate($mon-40, $day, $year+2000))
		{
			return false;
		}
	}
	else if ($mon > 20)
	{
		if (!checkdate($mon-20, $day, $year+1800))
		{
			return false;
		}
	}
	else
	{
		if (!checkdate($mon, $day, $year+1900))
		{
			return false;
		}
	}
	$checksum = substr($egn,9,1);
	$egnsum = 0;
	for($i=0;$i<9;$i++)
	{
		$egnsum += substr($egn,$i,1) * $EGN_WEIGHTS[$i];
	}
	$valid_checksum = $egnsum % 11;
	if ($valid_checksum == 10)
	{
		$valid_checksum = 0;
	}
	if ($checksum == $valid_checksum)
	{
		return true;
	}
}

	private static function validate9($eik) {
		$v_9 = array(	array(1,2,3,4,5,6,7,8),
						array(3,4,5,6,7,8,9,10)
					);


		return self::validate_n($eik, self::EIK9_LENGTH, $v_9);
	}


	private static function validate13($eik) {
		$v_13 = array(	array(2,7,3,5),
						array(4,9,5,7)
						);


		return self::validate_n($eik, self::EIK13_PART_LENGTH, $v_13);
	}


	private static function validate_n($eik, $n, $coef_arr) {
		$ret = false;

		$eik_arr = str_split($eik);

		$pass_1_sum = 0;
		for($i = 0; $i < $n - 1; $i++) {
			$pass_1_sum += $coef_arr[0][$i] * $eik_arr[$i];
		}

		$rest1 = $pass_1_sum % self::MODUL;

		if ($rest1 == 10) {
			$pass_2_sum = 0;
			for($i = 0; $i < $n - 1; $i++) {
				$pass_2_sum += $coef_arr[1][$i] * $eik_arr[$i];
			}

			$rest2 = $pass_2_sum % 11;
			if ($rest2 == self::MODUL_MAGIC) {
				$rest2 = 0;
			}

			if ($rest2 == $eik_arr[$n - 1]) {
				$ret = true;
			}
		} else {
			if ($rest1 == $eik_arr[$n - 1]) {
				$ret = true;
			}
		}

		return $ret;
	}
}
