<?php
class ControllerCommonMenu extends Controller {
	public function index() {
$this->load->model('catalog/manufacturer');
		$this->load->model('tool/image');
		$results = $this->model_catalog_manufacturer->getManufacturers();
		foreach ($results as $result) {	
			if ($result['image']) {
						$image = $result['image'];
					} else {
						$image = 'no_image.jpg';
					}			
			$data['manufacturers'][] = array(
				'name' => $result['name'],
				'image' => $this->model_tool_image->resize($image, 60, 60),
				'href' => $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $result['manufacturer_id'])
			);
		}
		$this->load->language('common/menu');

		// Menu
		$this->load->model('catalog/category');

		$this->load->model('catalog/product');

		$data['categories'] = array();
$this->load->model('catalog/information');
		$data['informations'] = array();
		foreach ($this->model_catalog_information->getInformations() as $result) {
			if ($result['bottom']) {
				$data['informations'][] = array(
					'title' => $result['title'],
					'href'  => $this->url->link('information/information', 'information_id=' . $result['information_id'])
				);
			}
    	}

		$data['manufacturer'] = $this->url->link('product/manufacturer');
		$data['newsletter'] = $this->url->link('account/newsletter', '', true);
$data['config_language_id'] = $this->config->get('config_language_id');
		$data['marketshop_main_menu_style'] = $this->config->get('marketshop_main_menu_style');
			$data['marketshop_mobile_menu_title'] = $this->config->get('marketshop_mobile_menu_title');
			$data['marketshop_home_page_link_icon'] = $this->config->get('marketshop_home_page_link_icon');
			$data['marketshop_home_page_link'] = $this->config->get('marketshop_home_page_link');
			$data['marketshop_top_menu'] = $this->config->get('marketshop_top_menu');
			$data['marketshop_menu_categories_title'] = $this->config->get('marketshop_menu_categories_title');
			$data['marketshop_menu_brands'] = $this->config->get('marketshop_menu_brands');
			$data['marketshop_menu_brands_title'] = $this->config->get('marketshop_menu_brands_title');
			$data['marketshop_brands_display_style'] = $this->config->get('marketshop_brands_display_style');
			
			$data['marketshop_custom_link1'] = $this->config->get('marketshop_custom_link1');
			$data['marketshop_custom_link1_title'] = $this->config->get('marketshop_custom_link1_title');
			$data['marketshop_custom_link1_url'] = $this->config->get('marketshop_custom_link1_url');
			$data['marketshop_target_link1'] = $this->config->get('marketshop_target_link1');
			$data['marketshop_custom_link2'] = $this->config->get('marketshop_custom_link2');
			$data['marketshop_custom_link2_title'] = $this->config->get('marketshop_custom_link2_title');
			$data['marketshop_custom_link2_url'] = $this->config->get('marketshop_custom_link2_url');
			$data['marketshop_target_link2'] = $this->config->get('marketshop_target_link2');
			$data['marketshop_custom_link3'] = $this->config->get('marketshop_custom_link3');
			$data['marketshop_custom_link3_title'] = $this->config->get('marketshop_custom_link3_title');
			$data['marketshop_custom_link3_url'] = $this->config->get('marketshop_custom_link3_url');
			$data['marketshop_target_link3'] = $this->config->get('marketshop_target_link3');
			$data['marketshop_custom_link4'] = $this->config->get('marketshop_custom_link4');
			$data['marketshop_custom_link4_title'] = $this->config->get('marketshop_custom_link4_title');
			$data['marketshop_custom_link4_url'] = $this->config->get('marketshop_custom_link4_url');
			$data['marketshop_target_link4'] = $this->config->get('marketshop_target_link4');
			$data['marketshop_custom_link5'] = $this->config->get('marketshop_custom_link5');
			$data['marketshop_custom_link5_title'] = $this->config->get('marketshop_custom_link5_title');
			$data['marketshop_custom_link5_url'] = $this->config->get('marketshop_custom_link5_url');
			$data['marketshop_target_link5'] = $this->config->get('marketshop_target_link5');
			
			$data['marketshop_custom_block_status'] = $this->config->get('marketshop_custom_block_status');
			$data['marketshop_custom_block_title'] = $this->config->get('marketshop_custom_block_title');
			$data['marketshop_custom_block_content'] = $this->config->get('marketshop_custom_block_content');
			$data['marketshop_custom_block_content'] = html_entity_decode($data['marketshop_custom_block_content'][$this->config->get('config_language_id')]['description'], ENT_QUOTES, 'UTF-8');
			
			$data['marketshop_custom_block2_status'] = $this->config->get('marketshop_custom_block2_status');
			$data['marketshop_custom_block2_title'] = $this->config->get('marketshop_custom_block2_title');
			$data['marketshop_custom_block2_content'] = $this->config->get('marketshop_custom_block2_content');
			$data['marketshop_custom_block2_content'] = html_entity_decode($data['marketshop_custom_block2_content'][$this->config->get('config_language_id')]['description'], ENT_QUOTES, 'UTF-8');
			
			$data['marketshop_custom_block3_status'] = $this->config->get('marketshop_custom_block3_status');
			$data['marketshop_custom_block3_title'] = $this->config->get('marketshop_custom_block3_title');
			$data['marketshop_custom_block3_content'] = $this->config->get('marketshop_custom_block3_content');
			$data['marketshop_custom_block3_content'] = html_entity_decode($data['marketshop_custom_block3_content'][$this->config->get('config_language_id')]['description'], ENT_QUOTES, 'UTF-8');
			
			$data['marketshop_my_account'] = $this->config->get('marketshop_my_account');
			$data['marketshop_information_page'] = $this->config->get('marketshop_information_page');
			$data['marketshop_contact_us'] = $this->config->get('marketshop_contact_us');
			
			$data['marketshop_custom_link_right'] = $this->config->get('marketshop_custom_link_right');
			$data['marketshop_custom_link_right_title'] = $this->config->get('marketshop_custom_link_right_title');
			$data['marketshop_custom_link_right_url'] = $this->config->get('marketshop_custom_link_right_url');
			$data['marketshop_custom_link_right_target'] = $this->config->get('marketshop_custom_link_right_target');
			
			$data['contact'] = $this->url->link('information/contact');
		

		$categories = $this->model_catalog_category->getCategories(0);

		foreach ($categories as $category) {
			if ($category['top']) {
				// Level 2
				$children_data = array();

				$children = $this->model_catalog_category->getCategories($category['category_id']);

				foreach ($children as $child) {
// Level 3
                $grandchildren_data = array();

                $grandchildren = $this->model_catalog_category->getCategories($child['category_id']);

                foreach ($grandchildren as $grandchild) {

                    $grandchild_filter_data = array(
                        'filter_category_id'  => $grandchild['category_id'],
                        'filter_sub_category' => true
                    );

                    $grandchildren_data[] = array(
                        'name'  => $grandchild['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($grandchild_filter_data) . ')' : ''),
                        'href'  => $this->url->link('product/category', 'path=' . $category['category_id'] . '_' . $grandchild['category_id'])
                    );
                }
					$filter_data = array(
						'filter_category_id'  => $child['category_id'],
						'filter_sub_category' => true
					);

					$children_data[] = array(
						'name'  => $child['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($filter_data) . ')' : ''),
						'href'  => $this->url->link('product/category', 'path=' . $category['category_id'] . '_' . $child['category_id']),
                    'children' => $grandchildren_data,
					);
				}

				// Level 1
				$data['categories'][] = array(
					'name'     => $category['name'],
					'children' => $children_data,
					'column'   => $category['column'] ? $category['column'] : 1,
					'href'     => $this->url->link('product/category', 'path=' . $category['category_id'])
				);
			}
		}

		return $this->load->view('common/menu', $data);
	}
}
