<?php
class WC_Braintree_ApplePay_Controller {

	/**
	 *
	 * @var WP_REST_Request
	 */
	private $request;

	private $namespace = 'woo-payment-gateway/v1/applepay-checkout/';

	public static function init() {
		add_action ( 'rest_api_init', function () {
			$instance = new self ();
			register_rest_route ( $instance->namespace, 'shipping-address', array( 
					'methods' => array( 
							WP_REST_Server::CREATABLE, 
							WP_REST_Server::READABLE 
					), 
					'callback' => array( $instance, 
							'update_shipping_address' 
					) 
			) );
			register_rest_route ( $instance->namespace, 'shipping-method', array( 
					'methods' => array( 
							WP_REST_Server::CREATABLE, 
							WP_REST_Server::READABLE 
					), 
					'callback' => array( $instance, 
							'update_shipping_method' 
					) 
			) );
			register_rest_route ( $instance->namespace, 'payment-method', array( 
					'methods' => WP_REST_Server::CREATABLE, 
					'callback' => array( $instance, 
							'payment_method_selected' 
					) 
			) );
		} );
	}

	/**
	 * Method that is called when shipping address is updated in the Apple Pay wallet.
	 *
	 * @param WP_REST_Request $request        	
	 */
	public function update_shipping_address($request) {
		$this->request = $request;
		$response = new WP_REST_Response ();
		add_filter ( 'woocommerce_cart_calculate_shipping_address', array( 
				$this, 'map_address' 
		) );
		WC_Shortcode_Cart::calculate_shipping ();
		
		// remove any notices related to shipping updates. They are not needed.
		$this->clear_notices ();
		wc_maybe_define_constant ( 'WOOCOMMERCE_CART', true );
		WC ()->cart->calculate_totals ();
		$packages = WC ()->shipping->get_packages ();
		$package = $packages[ 0 ];
		$shipping_methods = array();
		foreach ( $package[ 'rates' ] as $method ) {
			$shipping_methods[] = array( 
					'label' => $method->get_label (), 
					'detail' => '', 
					'amount' => $method->cost, 
					'identifier' => esc_attr ( $method->id ) 
			);
		}
		
		$response->set_data ( array( 'success' => true, 
				'data' => array( 
						'newLineItems' => bwc_applepay_get_line_items (), 
						'newTotal' => array( 
								'type' => 'final', 
								'label' => bt_manager ()->get_option ( 'applepay_store_name' ), 
								'amount' => $this->get_cart_total () 
						), 
						'newShippingMethods' => $shipping_methods 
				) 
		) );
		// 'cart_totals' => $this->get_cart_totals_html ()
		
		return $response;
	}

	/**
	 * Method that is called when shipping method is updated in the Apple Pay wallet.
	 *
	 * @param WP_REST_Request $request        	
	 */
	public function update_shipping_method($request) {
		// update the cart totals and the chosen shipping method.
		$response = new WP_REST_Response ();
		$chosen_shipping_methods = WC ()->session->get ( 'chosen_shipping_methods', array() );
		$chosen_shipping_methods[ 0 ] = wc_clean ( $request->get_param ( 'identifier' ) );
		WC ()->session->set ( 'chosen_shipping_methods', $chosen_shipping_methods );
		wc_maybe_define_constant ( 'WOOCOMMERCE_CART', true );
		WC ()->cart->calculate_totals ();
		$response->set_data ( array( 'success' => true, 
				'shippingMethodUpdate' => array( 
						'newLineItems' => bwc_applepay_get_line_items (), 
						'newTotal' => array( 
								'type' => 'final', 
								'label' => bt_manager ()->get_option ( 'applepay_store_name' ), 
								'amount' => $this->get_cart_total () 
						) 
				), 
				'cart_totals' => $this->get_cart_totals_html () 
		) );
		return $response;
	}

	/**
	 *
	 * @param WP_REST_Request $request        	
	 */
	public function payment_method_selected($request) {
		$response = new WP_REST_Response ();
		WC ()->cart->calculate_totals ();
		$response->set_data ( array( 'success' => true, 
				'data' => array( 
						'newLineItems' => bwc_applepay_get_line_items (), 
						'newTotal' => array( 
								'type' => 'final', 
								'label' => bt_manager ()->get_option ( 'applepay_store_name' ), 
								'amount' => $this->get_cart_total () 
						) 
				) 
		) );
		return $response;
	}

	/**
	 * Populate address data from the request.
	 *
	 * @param array $address        	
	 */
	public function map_address($address) {
		$address[ 'country' ] = wc_clean ( $this->request->get_param ( 'countryCode' ) );
		$address[ 'state' ] = wc_clean ( $this->request->get_param ( 'administrativeArea' ) );
		$address[ 'postcode' ] = wc_clean ( $this->request->get_param ( 'postalCode' ) );
		$address[ 'city' ] = wc_clean ( $this->request->get_param ( 'locality' ) );
		return $address;
	}

	/**
	 * clear notices of type notice
	 */
	private function clear_notices() {
		$notices = wc_get_notices ();
		unset ( $notices[ 'notice' ] );
		wc_set_notices ( $notices );
	}

	/**
	 * Return the cart totals html string.
	 */
	private function get_cart_totals_html() {
		ob_start ();
		woocommerce_cart_totals ();
		return ob_get_clean ();
	}

	private function get_error_messages() {
		ob_start ();
		$messages = wc_print_notices ();
		return ob_get_clean ();
	}

	private function get_cart_total() {
		$total = WC ()->cart->total;
		if (bwcs_subscriptions_active ()) {
			if (WC_Subscriptions_Cart::cart_contains_subscription ()) {
				$recurring_cart = reset ( WC ()->cart->recurring_carts );
				if ($total == 0) {
					$total = $recurring_cart->total;
				}
			}
		}
		return $total;
	}
}
WC_Braintree_ApplePay_Controller::init ();