<?php
class Braintree_PayPal_Cart_Controller {

	/**
	 *
	 * @var int
	 */
	private $customer_id;

	/**
	 *
	 * @var string
	 */
	private $id;

	public static function init() {
		new self ();
	}

	public function __construct() {
		$this->id = WC_PayPal_Payment_Gateway::ID;
		add_action ( 'bfwc_process_cart_checkout_' . $this->id, array( 
				$this, 'cart_checkout' 
		) );
		// add action for billing phone validation. Send custom error message to admin alerting them how
		// to setup required billing phone
	}

	/**
	 *
	 * @param WP_REST_Request $request        	
	 */
	public function cart_checkout($request) {
		wc_maybe_define_constant ( 'WC_PAYPAL_CART_ORDER', true );
		$session = WC ()->session;
		$phone = $request->get_param ( 'billing_phone' );
		if (empty ( $phone )) {
			add_filter ( 'woocommerce_checkout_fields', function ($fields) {
				if (isset ( $fields[ 'billing' ][ 'billing_phone' ] ) && $fields[ 'billing' ][ 'billing_phone' ][ 'required' ] == true) {
					// if phone is empty and it's required, send a message to the frontend.
					add_action ( 'woocommerce_after_checkout_validation', function () {
						if (current_user_can ( 'administrator' ) || bt_manager ()->get_environment () === 'sandbox') {
							wc_add_notice ( __ ( 'In order for PayPal to capture a customer\'s phone number, you must make it a required field within your PayPal account settings. Click <a target="_blank" href="https://support.paymentplugins.com/hc/en-us/articles/360015271373-Require-Customer-Phone-Number">here</a> for a guide on how to enable this setting.', 'braintree-payments' ), 'error' );
							bwc_set_checkout_error ();
						}
					} );
				}
				return $fields;
			} );
		}
	}
}
Braintree_PayPal_Cart_Controller::init ();