<?php

function bfwc_get_error_messages() {
	$saved_messages = get_option ( 'bfwc_error_messages', array() );
	
	$defaults = array( 
			'tokenization' => array( 
					'INVALID_CLIENT_TOKEN' => __ ( 'Invalid client token supplied. Please check your API keys.', 'braintree-payments' ),
					'HOSTED_FIELDS_FIELDS_EMPTY' => __ ( 'Please fill out the payment form.', 'braintree-payments' ),
					'HOSTED_FIELDS_FIELDS_INVALID' => __ ( 'Some of your payment fields are invalid.', 'braintree-payments' ),
					'HOSTED_FIELDS_FAILED_TOKENIZATION' => __ ( 'Please check that your credit card is valid.', 'braintree-payments' ),
					'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR' => __ ( 'There was a network error. Please try again.', 'braintree-payments' ),
					'VALIDATION' => __ ( 'Please check your payment method fields.', 'braintree-payments' ),
					'THREEDS_HTTPS_REQUIRED' => __ ( '3D Secure requires HTTPS.', 'braintree-payments' ),
					'THREEDS_NOT_ENABLED' => __ ( '3D Secure is not enabled for this merchant.', 'braintree-payments' ),
					'PAYPAL_TOKENIZATION_REQUEST_ACTIVE' => __ ( 'There is already a PayPal window open.', 'braintree-payments' ),
					'PAYPAL_FLOW_OPTION_REQUIRED' => __ ( 'PayPal vault flow is required.', 'braintree-payments' ),
					'PAYPAL_INVALID_PAYMENT_OPTION_ADDRESS' => __ ( 'PayPal validation of address failed. Please verify your shipping address.', 'braintree-payments' ),
					'PAYPAL_INVALID_PAYMENT_OPTION_CITY' => __ ( 'Invalid city entered for your shipping address.', 'braintree-payments' ),
					'PAYPAL_INVALID_PAYMENT_OPTION_STATE' => __ ( 'Invalid state entered for your shipping address.', 'braintree-payments' ),
					'PAYPAL_INVALID_PAYMENT_OPTION_ZIP' => __ ( 'Invalid zip code entered for shipping address.', 'braintree-payments' ),
					'DATA_COLLECTOR_KOUNT_NOT_ENABLED' => __ ( 'Kount is not enabled for this merchant. Please enable fraud tools within your Braintree Control Panel if you have enabled Advanced Fraud Tools in the plugin settings.' ),
					'CLIENT_REQUEST_ERROR' => __ ( 'AVS rule <i>street address not provided</i> must be disabled when usig 3DS and the dropin form.', 'braintree-payments' ),
					'GOOGLE_PAYMENT_NOT_ENABLED' => __ ( 'Google Pay is not enabled for this merchant. Please enable Google Pay within your Braintree control panel.', 'braintree-payments' ),
					'DropinError' => __ ( 'Please fill out the payment form.', 'braintree-payments' ),
					''
			),
			'gateway_rejected' => array( 
					'avsPostalCodeResponseCode_N' => __ ( 'Postal code does not match.', 'braintree-payments' ),
					'avsStreetAddressResponseCode_N' => __ ( 'Street address does not match.', 'braintree-payments' ),
					'cvvResponseCode_N' => __ ( 'Card security code does not match.', 'braintree-payments' ),
					'avsPostalCodeResponseCode_U' => __ ( 'Postal code not verified.', 'braintree-payments' ),
					'avsStreetAddressResponseCode_U' => __ ( 'Street address not verified.', 'braintree-payments' ),
					'cvvResponseCode_U' => __ ( 'Card security code not verified.', 'braintree-payments' ),
					'avsPostalCodeResponseCode_I' => __ ( 'Postal code not provided.', 'braintree-payments' ),
					'avsStreetAddressResponseCode_I' => __ ( 'Street address not provided.', 'braintree-payments' ),
					'cvvResponseCode_I' => __ ( 'Card security code not provided.', 'braintree-payments' ),
					'gatewayRejectionReason_three_d_secure' => __ ( 'Your payment method was rejected due to 3D Secure.', 'braintree-payments' ) 
			),
			'processor_declined' => array( 
					'2000' => __ ( 'Do Not Honor', 'braintree-payments' ),
					'2001' => __ ( 'Insufficient Funds', 'braintree-payments' ),
					'2002' => __ ( 'Limit Exceeded', 'braintree-payments' ),
					'2003' => __ ( 'Cardholder\'s Activity Limit Exceeded', 'braintree-payments' ),
					'2004' => __ ( 'Expired Card', 'braintree-payments' ),
					'2005' => __ ( 'Invalid Credit Card Number', 'braintree-payments' ),
					'2006' => __ ( 'Invalid Expiration Date', 'braintree-payments' ),
					'2007' => __ ( 'No Account', 'braintree-payments' ),
					'2008' => __ ( 'Card Account Length Error', 'braintree-payments' ),
					'2009' => __ ( 'No Such Issuer', 'braintree-payments' ),
					'2010' => __ ( 'Card Issuer Declined CVV', 'braintree-payments' ),
					'2011' => __ ( 'Voice Authorization Required', 'braintree-payments' ),
					'2012' => __ ( 'Processor Declined Possible Lost Card', 'braintree-payments' ),
					'2013' => __ ( 'Processor Declined - Possible Stolen Card', 'braintree-payments' ),
					'2014' => __ ( 'Processor Declined - Fraud Suspected', 'braintree-payments' ),
					'2015' => __ ( 'Transaction Not Allowed', 'braintree-payments' ),
					'2016' => __ ( 'Duplicate Transaction', 'braintree-payments' ),
					'2017' => __ ( 'Cardholder Stopped Billing', 'braintree-payments' ),
					'2018' => __ ( 'Cardholder Stopped All Billing', 'braintree-payments' ),
					'2019' => __ ( 'Invalid Transaction', 'braintree-payments' ),
					'2020' => __ ( 'Violation', 'braintree-payments' ),
					'2021' => __ ( 'Security Violation', 'braintree-payments' ),
					'2022' => __ ( 'Declined - Updated Cardholder Available', 'braintree-payments' ),
					'2023' => __ ( 'Processor Does Not Support This Feature', 'braintree-payments' ),
					'2024' => __ ( 'Card Type Not Enabled', 'braintree-payments' ),
					'2025' => __ ( 'Set Up Error - Merchant', 'braintree-payments' ),
					'2026' => __ ( 'Invalid Merchant ID', 'braintree-payments' ),
					'2027' => __ ( 'Set Up Error - Amount', 'braintree-payments' ),
					'2028' => __ ( 'Set Up Error - Hierarchy', 'braintree-payments' ),
					'2029' => __ ( 'Set Up Error - Card', 'braintree-payments' ),
					'2030' => __ ( 'Set Up Error - Terminal', 'braintree-payments' ),
					'2031' => __ ( 'Encryption Error', 'braintree-payments' ),
					'2032' => __ ( 'Surcharge Not Permitted', 'braintree-payments' ),
					'2033' => __ ( 'Inconsistent Data', 'braintree-payments' ),
					'2034' => __ ( 'No Action Taken', 'braintree-payments' ),
					'2035' => __ ( 'Partial Approval For Amount In Group III Version', 'braintree-payments' ),
					'2036' => __ ( 'Authorization could not be found to reverse', 'braintree-payments' ),
					'2037' => __ ( 'Already Reversed', 'braintree-payments' ),
					'2038' => __ ( 'Processor Declined', 'braintree-payments' ),
					'2039' => __ ( 'Invalid Authorization Code', 'braintree-payments' ),
					'2040' => __ ( 'Invalid Store', 'braintree-payments' ),
					'2041' => __ ( 'Declined - Call For Approval', 'braintree-payments' ),
					'2042' => __ ( 'Invalid Client ID', 'braintree-payments' ),
					'2043' => __ ( 'Error - Do Not Retry, Call Issuer', 'braintree-payments' ),
					'2044' => __ ( 'Declined - Call Issuer', 'braintree-payments' ),
					'2045' => __ ( 'Invalid Merchant Number', 'braintree-payments' ),
					'2046' => __ ( 'Declined', 'braintree-payments' ),
					'2047' => __ ( 'Call Issuer. Pick Up Card', 'braintree-payments' ),
					'2048' => __ ( 'Invalid Amount', 'braintree-payments' ),
					'2049' => __ ( 'Invalid SKU Number', 'braintree-payments' ),
					'2050' => __ ( 'Invalid Credit Plan', 'braintree-payments' ),
					'2051' => __ ( 'Credit Card Number does not match method of payment', 'braintree-payments' ),
					'2053' => __ ( 'Card reported as lost or stolen', 'braintree-payments' ),
					'2054' => __ ( 'Reversal amount does not match authorization amount', 'braintree-payments' ),
					'2055' => __ ( 'Invalid Transaction Division Number', 'braintree-payments' ),
					'2056' => __ ( 'Transaction amount exceeds the transaction division limit', 'braintree-payments' ),
					'2057' => __ ( 'Issuer or Cardholder has put a restriction on the card', 'braintree-payments' ),
					'2058' => __ ( 'Merchant not Mastercard SecureCode enabled', 'braintree-payments' ),
					'2059' => __ ( 'Address Verification Failed', 'braintree-payments' ),
					'2060' => __ ( 'Address Verification and Card Security Code Failed', 'braintree-payments' ),
					'2061' => __ ( 'Invalid Transaction Data', 'braintree-payments' ),
					'2062' => __ ( 'Invalid Tax Amount', 'braintree-payments' ),
					'2063' => __ ( 'PayPal Business Account preference resulted in the transaction failing', 'braintree-payments' ),
					'2064' => __ ( 'Invalid Currency Code', 'braintree-payments' ),
					'2065' => __ ( 'Refund Time Limit Exceeded', 'braintree-payments' ),
					'2066' => __ ( 'PayPal Business Account Restricted', 'braintree-payments' ),
					'2067' => __ ( 'Authorization Expired', 'braintree-payments' ),
					'2068' => __ ( 'PayPal Business Account Locked or Closed', 'braintree-payments' ),
					'2069' => __ ( 'PayPal Blocking Duplicate Order IDs', 'braintree-payments' ),
					'2070' => __ ( 'PayPal Buyer Revoked Future Payment Authorization', 'braintree-payments' ),
					'2071' => __ ( 'PayPal Payee Account Invalid Or Does Not Have a Confirmed Email', 'braintree-payments' ),
					'2072' => __ ( 'PayPal Payee Email Incorrectly Formatted', 'braintree-payments' ),
					'2073' => __ ( 'PayPal Validation Error', 'braintree-payments' ),
					'2074' => __ ( 'Funding Instrument In The PayPal Account Was Declined By The Processor Or Bank, Or It Can\'t Be Used For This Payment', 'braintree-payments' ),
					'2075' => __ ( 'Payer Account Is Locked Or Closed', 'braintree-payments' ),
					'2076' => __ ( 'Payer Cannot Pay For This Transaction With PayPal', 'braintree-payments' ),
					'2077' => __ ( 'Transaction Refused Due To PayPal Risk Model', 'braintree-payments' ),
					'2079' => __ ( 'PayPal Merchant Account Configuration Error', 'braintree-payments' ),
					'2081' => __ ( 'PayPal pending payments are not supported', 'braintree-payments' ),
					'2082' => __ ( 'PayPal Domestic Transaction Required', 'braintree-payments' ),
					'2083' => __ ( 'PayPal Phone Number Required', 'braintree-payments' ),
					'2084' => __ ( 'PayPal Tax Info Required', 'braintree-payments' ),
					'2085' => __ ( 'PayPal Payee Blocked Transaction', 'braintree-payments' ),
					'2086' => __ ( 'PayPal Transaction Limit Exceeded', 'braintree-payments' ),
					'2087' => __ ( 'PayPal reference transactions not enabled for your account', 'braintree-payments' ),
					'2088' => __ ( 'Currency not enabled for your PayPal seller account', 'braintree-payments' ),
					'2089' => __ ( 'PayPal payee email permission denied for this request', 'braintree-payments' ),
					'2090' => __ ( 'PayPal account not configured to refund more than settled amount', 'braintree-payments' ),
					'2091' => __ ( 'Currency of this transaction must match currency of your PayPal account', 'braintree-payments' ),
					'3000' => __ ( 'Processor Network Unavailable - Try Again', 'braintree-payments' ) 
			),
			'exceptions' => array( 
					'Braintree\Exception\NotFound' => __ ( 'Object was not found.', 'braintree-payments' ),
					'Braintree\Exception\Authentication' => __ ( 'Authentication failed, check your API key configuration.', 'braintree-payments' ),
					'Braintree\Exception\Authorization' => __ ( 'Authorization check failed.', 'braintree-payments' ) 
			),
			'address' => array( 
					'81801' => __ ( 'Addresses must have at least one field filled in.', 'braintree-payments' ),
					'81802' => __ ( 'Company is too long.', 'braintree-payments' ),
					'81804' => __ ( 'Extended address is too long.', 'braintree-payments' ),
					'81805' => __ ( 'First name is too long.', 'braintree-payments' ),
					'81806' => __ ( 'Last name is too long.', 'braintree-payments' ),
					'81807' => __ ( 'Locality is too long.', 'braintree-payments' ),
					'81813' => __ ( 'Postal code can only contain letters, numbers, spaces, and hyphens.', 'braintree-payments' ),
					'81808' => __ ( 'Postal code is required.', 'braintree-payments' ),
					'81809' => __ ( 'Postal code may contain no more than 9 letter or number characters.', 'braintree-payments' ),
					'81810' => __ ( 'Region is too long.', 'braintree-payments' ),
					'81811' => __ ( 'Street address is required.', 'braintree-payments' ),
					'81812' => __ ( 'Street address is too long.', 'braintree-payments' ),
					'81827' => __ ( 'US state codes must be two characters to meet PayPal Seller Protection requirements.', 'braintree-payments' ),
					'91803' => __ ( 'Country name is not an accepted country.', 'braintree-payments' ),
					'91815' => __ ( 'Provided country information is inconsistent.', 'braintree-payments' ),
					'91816' => __ ( 'Country code (alpha3) is not an accepted country.', 'braintree-payments' ),
					'91817' => __ ( 'Country code (numeric) is not an accepted country.', 'braintree-payments' ),
					'91814' => __ ( 'Country code (alpha2) is not an accepted country.', 'braintree-payments' ),
					'91818' => __ ( 'Customer has already reached the maximum of 50 addresses.', 'braintree-payments' ),
					'91819' => __ ( 'First name must be a string.', 'braintree-payments' ),
					'91820' => __ ( 'Last name must be a string.', 'braintree-payments' ),
					'91821' => __ ( 'Company must be a string.', 'braintree-payments' ),
					'91822' => __ ( 'Street address must be a string.', 'braintree-payments' ),
					'91823' => __ ( 'Extended address must be a string.', 'braintree-payments' ),
					'91824' => __ ( 'Locality must be a string.', 'braintree-payments' ),
					'91825' => __ ( 'Region must be a string.', 'braintree-payments' ),
					'91826' => __ ( 'Postal code must be a string.', 'braintree-payments' ),
					'91828' => __ ( 'Address is invalid.', 'braintree-payments' ) 
			),
			'market_place' => array( 
					'82602' => __ ( 'Applicant merchant id is too long.', 'braintree-payments' ),
					'82603' => __ ( 'Applicant merchant id format is invalid.', 'braintree-payments' ),
					'82604' => __ ( 'Applicant merchant id is in use.', 'braintree-payments' ),
					'82605' => __ ( 'Applicant merchant id is not allowed.', 'braintree-payments' ),
					'82606' => __ ( 'Master merchant account ID is required.', 'braintree-payments' ),
					'82607' => __ ( 'Master merchant account ID is invalid.', 'braintree-payments' ),
					'82608' => __ ( 'Master merchant account must be active.', 'braintree-payments' ),
					'82610' => __ ( 'Terms Of Service needs to be accepted. Applicant tos_accepted required.', 'braintree-payments' ),
					'82675' => __ ( 'Merchant account id can not be updated.', 'braintree-payments' ),
					'82676' => __ ( 'Master merchant account id can not be updated.', 'braintree-payments' ),
					'82674' => __ ( 'Merchant accounts with a status of pending or suspended cannot be updated.', 'braintree-payments' ),
					'82609' => __ ( 'Applicant first name is required.', 'braintree-payments' ),
					'82637' => __ ( 'Individual first name is required.', 'braintree-payments' ),
					'82611' => __ ( 'Applicant last name is required.', 'braintree-payments' ),
					'82638' => __ ( 'Individual last name is required.', 'braintree-payments' ),
					'82612' => __ ( 'Applicant date of birth is required.', 'braintree-payments' ),
					'82639' => __ ( 'Individual date of birth is required.', 'braintree-payments' ),
					'82613' => __ ( 'Applicant routing number is required.', 'braintree-payments' ),
					'82640' => __ ( 'Funding routing number is required.', 'braintree-payments' ),
					'82614' => __ ( 'Applicant account number is required.', 'braintree-payments' ),
					'82641' => __ ( 'Funding account number is required.', 'braintree-payments' ),
					'82615' => __ ( 'Applicant SSN must be blank, last 4 digits, or full 9 digits.', 'braintree-payments' ),
					'82642' => __ ( 'Individual SSN must be blank, last 4 digits, or full 9 digits.', 'braintree-payments' ),
					'82616' => __ ( 'Applicant email is invalid.', 'braintree-payments' ),
					'82643' => __ ( 'Individual email is invalid.', 'braintree-payments' ),
					'82627' => __ ( 'Applicant first name is invalid.', 'braintree-payments' ),
					'82644' => __ ( 'Individual first name is invalid.', 'braintree-payments' ),
					'82628' => __ ( 'Applicant last name is invalid.', 'braintree-payments' ),
					'82645' => __ ( 'Individual last name is invalid.', 'braintree-payments' ),
					'82631' => __ ( 'Applicant company name is invalid.', 'braintree-payments' ),
					'82632' => __ ( 'Applicant tax ID is invalid.', 'braintree-payments' ),
					'82688' => __ ( 'Business params provided in an invalid format.', 'braintree-payments' ),
					'82647' => __ ( 'Business tax ID is invalid.', 'braintree-payments' ),
					'82633' => __ ( 'Applicant company name is required with tax ID.', 'braintree-payments' ),
					'82634' => __ ( 'Applicant tax ID is required with company name.', 'braintree-payments' ),
					'82635' => __ ( 'Applicant routing number is invalid.', 'braintree-payments' ),
					'82649' => __ ( 'Funding routing number is invalid.', 'braintree-payments' ),
					'82650' => __ ( 'An unexpected error occurred trying to save the merchant account; support has been notified and is looking into the issue. You may safely retry this request', 'braintree-payments' ),
					'82621' => __ ( 'Applicant declined due to OFAC.', 'braintree-payments' ),
					'82622' => __ ( 'Applicant declined due to MasterCard MATCH.', 'braintree-payments' ),
					'82623' => __ ( 'Applicant declined due to failed KYC.', 'braintree-payments' ),
					'82624' => __ ( 'Applicant declined due to invalid SSN.', 'braintree-payments' ),
					'82625' => __ ( 'Applicant declined due to SSN matching that of a deceased person.', 'braintree-payments' ),
					'82626' => __ ( 'Applicant declined after review.', 'braintree-payments' ),
					'82617' => __ ( 'Applicant street address is required.', 'braintree-payments' ),
					'82657' => __ ( 'Individual street address is required.', 'braintree-payments' ),
					'82618' => __ ( 'Applicant locality is required.', 'braintree-payments' ),
					'82658' => __ ( 'Individual locality is required.', 'braintree-payments' ),
					'82619' => __ ( 'Applicant postal code is required.', 'braintree-payments' ),
					'82659' => __ ( 'Individual postal code is required.', 'braintree-payments' ),
					'82620' => __ ( 'Applicant region is required.', 'braintree-payments' ),
					'82660' => __ ( 'Individual region is required.', 'braintree-payments' ),
					'82629' => __ ( 'Applicant street address is invalid.', 'braintree-payments' ),
					'82661' => __ ( 'Individual street address is invalid.', 'braintree-payments' ),
					'82664' => __ ( 'Applicant region is invalid.', 'braintree-payments' ),
					'82668' => __ ( 'Individual region is invalid.', 'braintree-payments' ),
					'82630' => __ ( 'Applicant postal code is invalid.', 'braintree-payments' ),
					'82662' => __ ( 'Individual postal code is invalid.', 'braintree-payments' ),
					'82636' => __ ( 'Applicant phone is invalid.', 'braintree-payments' ),
					'82656' => __ ( 'Individual phone is invalid.', 'braintree-payments' ),
					'82663' => __ ( 'Applicant date of birth is invalid', 'braintree-payments' ),
					'82666' => __ ( 'Individual date of birth is invalid.', 'braintree-payments' ),
					'82670' => __ ( 'Applicant account number is invalid.', 'braintree-payments' ),
					'82671' => __ ( 'Funding account number is invalid.', 'braintree-payments' ),
					'82665' => __ ( 'Applicant email is required.', 'braintree-payments' ),
					'82667' => __ ( 'Individual email is required.', 'braintree-payments' ),
					'82672' => __ ( 'Business tax ID must be blank unless business legal name is present.', 'braintree-payments' ),
					'82673' => __ ( 'Applicant tax ID must be blank unless company name present.', 'braintree-payments' ),
					'82646' => __ ( 'Business DBA name is invalid.', 'braintree-payments' ),
					'82677' => __ ( 'Business legal name is invalid.', 'braintree-payments' ),
					'82669' => __ ( 'Business legal name is required with tax ID.', 'braintree-payments' ),
					'82648' => __ ( 'Business tax ID is required with business legal name.', 'braintree-payments' ),
					'82685' => __ ( 'Business street address is invalid.', 'braintree-payments' ),
					'82686' => __ ( 'Business postal code is invalid.', 'braintree-payments' ),
					'82684' => __ ( 'Business region is invalid.', 'braintree-payments' ),
					'82679' => __ ( 'Funding destination is invalid.', 'braintree-payments' ),
					'82678' => __ ( 'Funding destination is required.', 'braintree-payments' ),
					'82681' => __ ( 'Funding email is invalid.', 'braintree-payments' ),
					'82680' => __ ( 'Funding email is required when destination is email.', 'braintree-payments' ),
					'82683' => __ ( 'Funding mobile phone is invalid.', 'braintree-payments' ),
					'82682' => __ ( 'Funding mobile phone is required when destination is mobile phone.', 'braintree-payments' ),
					'82687' => __ ( 'Individual params provided in an invalid format.', 'braintree-payments' ),
					'82689' => __ ( 'Business locality is invalid.', 'braintree-payments' ),
					'82690' => __ ( 'Individual locality is invalid.', 'braintree-payments' ),
					'82691' => __ ( 'Applicant locality is invalid.', 'braintree-payments' ),
					'92801' => __ ( 'Cannot specify make_default without a customer_id', 'braintree-payments' ),
					'92802' => __ ( 'Cannot specify verify_card without a customer_id', 'braintree-payments' ),
					'92803' => __ ( 'Cannot specify fail_on_duplicate_payment_method without a customer_id', 'braintree-payments' ),
					'92804' => __ ( 'Customer specified by customer_id does not exist', 'braintree-payments' ),
					'92806' => __ ( 'Unsupported client token version', 'braintree-payments' ),
					'92807' => __ ( 'Merchant Account specified by merchant_account_id does not exist', 'braintree-payments' ) 
			),
			'customer' => array( 
					'91602' => __ ( 'Custom field is invalid:', 'braintree-payments' ),
					'91609' => __ ( 'Customer ID has already been taken.', 'braintree-payments' ),
					'91610' => __ ( 'Customer ID is invalid (use only letters, numbers, \'-\', and \'_\').', 'braintree-payments' ),
					'91611' => __ ( 'Customer ID is not an allowed ID.', 'braintree-payments' ),
					'91612' => __ ( 'Customer ID is too long.', 'braintree-payments' ),
					'91613' => __ ( 'Customer ID is required.', 'braintree-payments' ),
					'91617' => __ ( 'Nonce references a vaulted payment instrument - cannot be transferred between customers', 'braintree-payments' ),
					'91618' => __ ( 'Customer attribute must be a map of keys and values representing a customer.', 'braintree-payments' ),
					'91619' => __ ( 'Ambiguous usage of default payment method token.', 'braintree-payments' ),
					'81601' => __ ( 'Company is too long.', 'braintree-payments' ),
					'81603' => __ ( 'Custom field is too long:', 'braintree-payments' ),
					'81604' => __ ( 'Email is an invalid format.', 'braintree-payments' ),
					'81605' => __ ( 'Email is too long.', 'braintree-payments' ),
					'81606' => __ ( 'Email is required if sending a receipt.', 'braintree-payments' ),
					'81607' => __ ( 'Fax is too long.', 'braintree-payments' ),
					'81608' => __ ( 'First name is too long.', 'braintree-payments' ),
					'81613' => __ ( 'Last name is too long.', 'braintree-payments' ),
					'81614' => __ ( 'Phone is too long.', 'braintree-payments' ),
					'81615' => __ ( 'Website is too long.', 'braintree-payments' ),
					'81616' => __ ( 'Website is an invalid format.', 'braintree-payments' ) 
			),
			'payment_method' => array( 
					'93101' => __ ( 'Payment method params are required.', 'braintree-payments' ),
					'93102' => __ ( 'Nonce is invalid.', 'braintree-payments' ),
					'93103' => __ ( 'Nonce is required.', 'braintree-payments' ),
					'93104' => __ ( 'Customer ID is required.', 'braintree-payments' ),
					'93105' => __ ( 'Customer ID is invalid.', 'braintree-payments' ),
					'93106' => __ ( 'Cannot forward a payment method of this type.', 'braintree-payments' ),
					'93107' => __ ( 'Cannot use a payment_method_nonce more than once.', 'braintree-payments' ),
					'93108' => __ ( 'Unknown or expired payment_method_nonce.', 'braintree-payments' ),
					'93109' => __ ( 'Nonce is not vaultable.', 'braintree-payments' ) 
			),
			'apple_pay' => array( 
					'83501' => __ ( 'Apple Pay cards are not accepted by this merchant account.', 'braintree-payments' ),
					'83502' => __ ( 'A customer ID is required to vault an Apple Pay Card.', 'braintree-payments' ),
					'93503' => __ ( 'Apple Pay token is taken.', 'braintree-payments' ),
					'93504' => __ ( 'Cannot use a payment_method_nonce more than once.', 'braintree-payments' ),
					'93505' => __ ( 'Unknown or expired payment_method_nonce.', 'braintree-payments' ),
					'93506' => __ ( 'Payment method nonce locked.', 'braintree-payments' ),
					'83518' => __ ( 'Credit card type is not accepted by this merchant account.', 'braintree-payments' ),
					'93507' => __ ( 'Payment method nonces cannot be used to update an existing Apple Pay Card.', 'braintree-payments' ),
					'93508' => __ ( 'Number is required for Apple Pay Card', 'braintree-payments' ),
					'93509' => __ ( 'Expiration Month is required for Apple Pay Card', 'braintree-payments' ),
					'93510' => __ ( 'Expiration Year is required for Apple Pay Card', 'braintree-payments' ),
					'93511' => __ ( 'Cryptogram is required for Apple Pay Card', 'braintree-payments' ),
					'83512' => __ ( 'Apple Pay payment data decryption failed', 'braintree-payments' ),
					'93513' => __ ( 'Apple Pay is disabled for this merchant', 'braintree-payments' ),
					'93514' => __ ( 'Apple Pay certificate, private key or merchant ID not configured', 'braintree-payments' ),
					'93517' => __ ( 'Certificate provided is not valid', 'braintree-payments' ),
					'93519' => __ ( 'Public key used to sign payment data does not match stored certificate', 'braintree-payments' ),
					'83520' => __ ( 'Payment data is malformed', 'braintree-payments' ),
					'93521' => __ ( 'Private key stored does not match private key used to encrypt payment data', 'braintree-payments' ),
					'93522' => __ ( 'Certificate does not match stored key pair', 'braintree-payments' ) 
			),
			'credit_card' => array( 
					'91701' => __ ( 'Cannot provide both a billing address and a billing address ID.', 'braintree-payments' ),
					'91702' => __ ( 'Billing address ID is invalid.', 'braintree-payments' ),
					'91704' => __ ( 'Customer ID is required.', 'braintree-payments' ),
					'91705' => __ ( 'Customer ID is invalid.', 'braintree-payments' ),
					'91708' => __ ( 'Cannot provide expirationdate if you are also providing expiration_month and expiration_year.', 'braintree-payments' ),
					'91718' => __ ( 'Token is invalid (use only letters, numbers, " - ", and \'\').', 'braintree-payments' ),
					'91719' => __ ( 'Credit card token is taken.', 'braintree-payments' ),
					'91720' => __ ( 'Credit card token is too long.', 'braintree-payments' ),
					'91721' => __ ( 'Token is not an allowed token.', 'braintree-payments' ),
					'91722' => __ ( 'Payment Method token is required.', 'braintree-payments' ),
					'91744' => __ ( 'Billing address format is invalid.', 'braintree-payments' ),
					'81723' => __ ( 'Cardholder name is too long.', 'braintree-payments' ),
					'81703' => __ ( 'Credit card type is not accepted by this merchant account.', 'braintree-payments' ),
					'81718' => __ ( 'Credit card number cannot be updated to an unsupported card type when it is associated to subscriptions.', 'braintree-payments' ),
					'81706' => __ ( 'CVV is required.', 'braintree-payments' ),
					'81707' => __ ( 'CVV must be 4 digits for American Express and 3 digits for other card types.', 'braintree-payments' ),
					'81709' => __ ( 'Expiration date is required.', 'braintree-payments' ),
					'81710' => __ ( 'Expiration date is invalid.', 'braintree-payments' ),
					'81711' => __ ( 'Expiration date year is invalid. It must be between 1975 and 2200.', 'braintree-payments' ),
					'81712' => __ ( 'Expiration month is invalid.', 'braintree-payments' ),
					'81713' => __ ( 'Expiration year is invalid.', 'braintree-payments' ),
					'81714' => __ ( 'Credit card number is required.', 'braintree-payments' ),
					'81715' => __ ( 'Credit card number is invalid.', 'braintree-payments' ),
					'81716' => __ ( 'Credit card number must be 12-19 digits.', 'braintree-payments' ),
					'81717' => __ ( 'Credit card number is not an accepted test number.', 'braintree-payments' ),
					'91723' => __ ( 'Update Existing Token is invalid.', 'braintree-payments' ),
					'81724' => __ ( 'Duplicate card exists in the vault.', 'braintree-payments' ),
					'81725' => __ ( 'Credit card must include number, payment_method_nonce, or venmo_sdk_payment_method_code.', 'braintree-payments' ),
					'91726' => __ ( 'Credit card type is not accepted by this merchant account.', 'braintree-payments' ),
					'91727' => __ ( 'Invalid VenmoSDK payment method code', 'braintree-payments' ),
					'91728' => __ ( 'Verification Merchant Account ID is invalid.', 'braintree-payments' ),
					'91729' => __ ( 'Update Existing Token is not allowed when creating a customer.', 'braintree-payments' ),
					'91730' => __ ( 'Verifications are not supported on this merchant account', 'braintree-payments' ),
					'91731' => __ ( 'Cannot use a payment_method_nonce more than once.', 'braintree-payments' ),
					'91732' => __ ( 'Unknown or expired payment_method_nonce.', 'braintree-payments' ),
					'91733' => __ ( 'Payment method nonce locked.', 'braintree-payments' ),
					'91734' => __ ( 'Credit card type is not accepted by this merchant account.', 'braintree-payments' ),
					'91735' => __ ( 'Payment method nonces cannot be used to update an existing card.', 'braintree-payments' ),
					'91738' => __ ( 'Payment method is not a credit card payment method.', 'braintree-payments' ),
					'91742' => __ ( 'Verification Merchant Account is suspended.', 'braintree-payments' ),
					'91743' => __ ( 'The current user does not have access to the specified verification_merchant_account_id', 'braintree-payments' ),
					'81736' => __ ( 'CVV verification failed.', 'braintree-payments' ),
					'81737' => __ ( 'Postal code verification failed.', 'braintree-payments' ),
					'91739' => __ ( 'Verification amount cannot be negative.', 'braintree-payments' ),
					'91740' => __ ( 'Verification amount is invalid.', 'braintree-payments' ),
					'91741' => __ ( 'Verification amount not supported by processor.', 'braintree-payments' ),
					'91745' => __ ( 'Payment method params supplied are not valid for updating a credit card.', 'braintree-payments' ),
					'81750' => __ ( 'Credit card number is prohibited.', 'braintree-payments' ),
					'91752' => __ ( 'Verification amount is too large.', 'braintree-payments' ),
					'91755' => __ ( 'Verification Merchant Account ID cannot be a sub-merchant account.', 'braintree-payments' ) 
			),
			'american_express' => array( 
					'93401' => __ ( 'Industry type is invalid.', 'braintree-payments' ),
					'93402' => __ ( 'Lodging data is empty.', 'braintree-payments' ),
					'93403' => __ ( 'Folio number is invalid.', 'braintree-payments' ),
					'93404' => __ ( 'Check in date is invalid.', 'braintree-payments' ),
					'93405' => __ ( 'Check out date is invalid.', 'braintree-payments' ),
					'93406' => __ ( 'Check out date must occur during or after the check in date.', 'braintree-payments' ),
					'93407' => __ ( 'Data fields are unknown.', 'braintree-payments' ),
					'93408' => __ ( 'Travel and Cruise data is empty.', 'braintree-payments' ),
					'93409' => __ ( 'Data fields are unknown.', 'braintree-payments' ),
					'93410' => __ ( 'Travel Package is invalid.', 'braintree-payments' ),
					'93411' => __ ( 'Departure date is invalid.', 'braintree-payments' ),
					'93412' => __ ( 'Lodging check in date is invalid.', 'braintree-payments' ),
					'93413' => __ ( 'Lodging check out date is invalid.', 'braintree-payments' ) 
			),
			'paypal' => array( 
					'82901' => __ ( 'Incomplete PayPal account information.', 'braintree-payments' ),
					'82902' => __ ( 'Pre-Approved Payment enabled PayPal account required for vaulting.', 'braintree-payments' ),
					'82903' => __ ( 'Invalid PayPal account information.', 'braintree-payments' ),
					'82904' => __ ( 'PayPal Accounts are not accepted by this merchant account.', 'braintree-payments' ),
					'82905' => __ ( 'A customer ID is required to vault a PayPal Account.', 'braintree-payments' ),
					'92906' => __ ( 'PayPal Account token is taken.', 'braintree-payments' ),
					'92907' => __ ( 'Cannot use a payment_method_nonce more than once.', 'braintree-payments' ),
					'92908' => __ ( 'Unknown or expired payment_method_nonce.', 'braintree-payments' ),
					'92909' => __ ( 'Payment method nonce locked.', 'braintree-payments' ),
					'92910' => __ ( 'Error communicating with PayPal.', 'braintree-payments' ),
					'92911' => __ ( 'PayPal authentication expired.', 'braintree-payments' ),
					'92912' => __ ( 'Funding source selection was given without an access token.', 'braintree-payments' ),
					'92913' => __ ( 'Funding source object is invalid or missing required fields.', 'braintree-payments' ),
					'92914' => __ ( 'Payment method nonces cannot be used to update an existing PayPal account.', 'braintree-payments' ),
					'92915' => __ ( 'Payment method params supplied are not valid for updating a PayPal account.', 'braintree-payments' ) 
			),
			'venmo' => array( 
					'84101' => __ ( 'Common ID is required.', 'braintree-payments' ),
					'84102' => __ ( 'Username is required.', 'braintree-payments' ),
					'84103' => __ ( 'Venmo user ID is required.', 'braintree-payments' ),
					'84104' => __ ( 'Customer ID is required.', 'braintree-payments' ),
					'84105' => __ ( 'Venmo accounts are not accepted by this merchant account.', 'braintree-payments' ),
					'84106' => __ ( 'Customer ID is invalid.', 'braintree-payments' ) 
			),
			'add_ons_and_discounts' => array( 
					'92001' => __ ( 'Quantity is invalid.', 'braintree-payments' ),
					'92002' => __ ( 'Amount is invalid.', 'braintree-payments' ),
					'92003' => __ ( 'Amount cannot be blank.', 'braintree-payments' ),
					'92004' => __ ( 'Quantity cannot be blank.', 'braintree-payments' ),
					'92005' => __ ( 'Number of billing cycles is invalid.', 'braintree-payments' ),
					'92010' => __ ( 'Quantity must be greater than zero.', 'braintree-payments' ),
					'92011' => __ ( 'Existing ID is invalid.', 'braintree-payments' ),
					'92012' => __ ( 'Existing ID is required.', 'braintree-payments' ),
					'92013' => __ ( 'Inherited From ID is invalid.', 'braintree-payments' ),
					'92014' => __ ( 'Inherited From ID is required.', 'braintree-payments' ),
					'92015' => __ ( 'Cannot update a removed add-on or discount.', 'braintree-payments' ),
					'92016' => __ ( 'Cannot remove add-on or discount if not already associated with subscription.', 'braintree-payments' ),
					'92017' => __ ( 'Number of billing cycles cannot be blank.', 'braintree-payments' ),
					'92018' => __ ( 'Cannot specify both number of billing cycles and never expires as true.', 'braintree-payments' ),
					'92019' => __ ( 'Number of billing cycles must be greater than zero.', 'braintree-payments' ),
					'92020' => __ ( 'Existing ID is not of the correct kind.', 'braintree-payments' ),
					'92021' => __ ( 'ID to remove is incorrect kind.', 'braintree-payments' ),
					'92022' => __ ( 'Cannot edit add-on or discount on a past due subscription.', 'braintree-payments' ),
					'92023' => __ ( 'Amount is too large.', 'braintree-payments' ),
					'92024' => __ ( 'Cannot pass null modification.', 'braintree-payments' ),
					'92025' => __ ( 'ID to remove is invalid.', 'braintree-payments' ) 
			),
			'subscription' => array( 
					'81901' => __ ( 'Cannot edit a canceled subscription.', 'braintree-payments' ),
					'81902' => __ ( 'ID has already been taken.', 'braintree-payments' ),
					'81903' => __ ( 'Price cannot be blank.', 'braintree-payments' ),
					'81904' => __ ( 'Price is an invalid format.', 'braintree-payments' ),
					'81905' => __ ( 'Subscription has already been canceled.', 'braintree-payments' ),
					'81906' => __ ( 'ID is invalid (use only letters, numbers, \'-\', and \'\').', 'braintree-payments' ),
					'81907' => __ ( 'Trial Duration is an invalid format.', 'braintree-payments' ),
					'81908' => __ ( 'Trial Duration is required.', 'braintree-payments' ),
					'81909' => __ ( 'Trial Duration Unit is invalid.', 'braintree-payments' ),
					'81910' => __ ( 'Cannot edit an expired subscription.', 'braintree-payments' ),
					'81923' => __ ( 'Price is too large.', 'braintree-payments' ),
					'91901' => __ ( 'Merchant Account ID is invalid.', 'braintree-payments' ),
					'91902' => __ ( 'Payment method token payment instrument type is not accepted by this merchant account.', 'braintree-payments' ),
					'91903' => __ ( 'Payment method token is invalid.', 'braintree-payments' ),
					'91904' => __ ( 'Plan ID is invalid.', 'braintree-payments' ),
					'91905' => __ ( 'Payment method token does not belong to the subscription\'s customer.', 'braintree-payments' ),
					'91906' => __ ( 'Number Of Billing Cycles must be numeric.', 'braintree-payments' ),
					'91907' => __ ( 'Number Of Billing Cycles must be greater than zero.', 'braintree-payments' ),
					'91908' => __ ( 'Cannot specify both number of billing cycles and never expires as true.', 'braintree-payments' ),
					'91909' => __ ( 'Number Of Billing Cycles is less than the current billing cycle.', 'braintree-payments' ),
					'91911' => __ ( 'Cannot add duplicate add-on or discount.', 'braintree-payments' ),
					'91912' => __ ( 'Number Of Billing Cycles cannot be blank if the subscription expires.', 'braintree-payments' ),
					'91913' => __ ( 'Billing Day of Month must be numeric.', 'braintree-payments' ),
					'91914' => __ ( 'Billing Day of Month must be between 1 and 28, or 31.', 'braintree-payments' ),
					'91915' => __ ( 'First Billing Date is invalid.', 'braintree-payments' ),
					'91916' => __ ( 'First Billing Date cannot be in the past.', 'braintree-payments' ),
					'91917' => __ ( 'Cannot specify more than one type of start date.', 'braintree-payments' ),
					'91918' => __ ( 'Billing Day of Month cannot be updated.', 'braintree-payments' ),
					'91919' => __ ( 'First Billing Date cannot be updated.', 'braintree-payments' ),
					'91920' => __ ( 'Can only edit id, merchant account id, payment method token, and descriptor on a past due subscription.', 'braintree-payments' ),
					'91921' => __ ( 'Invalid request format.', 'braintree-payments' ),
					'91922' => __ ( 'Cannot update subscription to a plan with a different billing frequency.', 'braintree-payments' ),
					'91923' => __ ( 'Subscription Plan currency must be the same as the merchant account\'s currency.', 'braintree-payments' ),
					'91924' => __ ( 'Payment method nonce payment instrument type is not accepted by this merchant account.', 'braintree-payments' ),
					'91925' => __ ( 'Payment method nonce is invalid.', 'braintree-payments' ),
					'91926' => __ ( 'Payment method nonce does not belong to the subscription\'s customer.', 'braintree-payments' ),
					'91927' => __ ( 'Payment method nonce represents an un-vaulted payment instrument.', 'braintree-payments' ),
					'91928' => __ ( 'Payment instrument type is not valid for subscriptions.', 'braintree-payments' ),
					'91929' => __ ( 'Payment instrument type is not valid for subscriptions.', 'braintree-payments' ),
					'91930' => __ ( 'Merchant Account does not support the given payment instrument type.', 'braintree-payments' ) 
			),
			'search' => array( 
					'82301' => __ ( 'Settlement Date is required', 'braintree-payments' ),
					'82302' => __ ( 'Settlement Date is invalid', 'braintree-payments' ),
					'82303' => __ ( 'Group By Custom Field is not a valid custom field', 'braintree-payments' ) 
			),
			'transaction' => array( 
					'81501' => __ ( 'Amount cannot be negative.', 'braintree-payments' ),
					'81502' => __ ( 'Amount is required.', 'braintree-payments' ),
					'81503' => __ ( 'Amount is an invalid format.', 'braintree-payments' ),
					'81528' => __ ( 'Amount is too large.', 'braintree-payments' ),
					'81509' => __ ( 'Credit card type is not accepted by this merchant account.', 'braintree-payments' ),
					'81527' => __ ( 'Custom field is too long:', 'braintree-payments' ),
					'91501' => __ ( 'Order ID is too long.', 'braintree-payments' ),
					'91530' => __ ( 'Cannot provide a billing address unless also providing a credit card.', 'braintree-payments' ),
					'91504' => __ ( 'Transaction can only be voided if status is authorized or submitted_for_settlement.', 'braintree-payments' ),
					'91505' => __ ( 'Credit transactions cannot be refunded.', 'braintree-payments' ),
					'91506' => __ ( 'Cannot refund a transaction unless it is settled.', 'braintree-payments' ),
					'91507' => __ ( 'Cannot submit for settlement unless status is authorized.', 'braintree-payments' ),
					'91508' => __ ( 'Cannot determine payment method.', 'braintree-payments' ),
					'91526' => __ ( 'Custom field is invalid:', 'braintree-payments' ),
					'91510' => __ ( 'Customer ID is invalid.', 'braintree-payments' ),
					'91511' => __ ( 'Customer does not have any credit cards.', 'braintree-payments' ),
					'91512' => __ ( 'Transaction has already been completely refunded.', 'braintree-payments' ),
					'91513' => __ ( 'Merchant account ID is invalid.', 'braintree-payments' ),
					'91514' => __ ( 'Merchant account is suspended.', 'braintree-payments' ),
					'91515' => __ ( 'Cannot provide both payment_method_token and credit_card attributes.', 'braintree-payments' ),
					'91516' => __ ( 'Cannot provide both payment_method_token and customer_id unless the payment_method belongs to the customer.', 'braintree-payments' ),
					'91527' => __ ( 'Cannot provide both payment_method_token and subscription_id unless the payment_method belongs to the subscription.', 'braintree-payments' ),
					'91517' => __ ( 'Payment instrument type is not accepted by this merchant account.', 'braintree-payments' ),
					'91518' => __ ( 'Payment method token is invalid.', 'braintree-payments' ),
					'91519' => __ ( 'Processor authorization code cannot be set unless for a voice authorization.', 'braintree-payments' ),
					'91521' => __ ( 'Refund amount is too large.', 'braintree-payments' ),
					'91538' => __ ( 'Cannot refund a transaction with a suspended merchant account.', 'braintree-payments' ),
					'91522' => __ ( 'Settlement amount is too large.', 'braintree-payments' ),
					'91529' => __ ( 'Cannot provide both subscription_id and customer_id unless the subscription belongs to the customer.', 'braintree-payments' ),
					'91528' => __ ( 'Subscription ID is invalid.', 'braintree-payments' ),
					'91523' => __ ( 'Transaction type is invalid.', 'braintree-payments' ),
					'91524' => __ ( 'Transaction type is required.', 'braintree-payments' ),
					'91525' => __ ( 'Vault is disabled.', 'braintree-payments' ),
					'91531' => __ ( 'Subscription status must be Past Due in order to retry.', 'braintree-payments' ),
					'91547' => __ ( 'Merchant account does not support refunds.', 'braintree-payments' ),
					'81531' => __ ( 'Amount must be greater than zero.', 'braintree-payments' ),
					'81534' => __ ( 'Tax amount cannot be negative.', 'braintree-payments' ),
					'81535' => __ ( 'Tax amount is an invalid format.', 'braintree-payments' ),
					'81536' => __ ( 'Tax amount is too large.', 'braintree-payments' ),
					'81571' => __ ( 'Failed to authenticate, please try a different form of payment.', 'braintree-payments' ),
					'91537' => __ ( 'Purchase order number is too long.', 'braintree-payments' ),
					'91539' => __ ( 'Voice Authorization is not allowed for this card type', 'braintree-payments' ),
					'91540' => __ ( 'Transaction cannot be cloned if payment method is stored in vault.', 'braintree-payments' ),
					'91541' => __ ( 'Cannot clone voice authorization transactions.', 'braintree-payments' ),
					'91542' => __ ( 'Unsuccessful transaction cannot be cloned.', 'braintree-payments' ),
					'91543' => __ ( 'Credits cannot be cloned.', 'braintree-payments' ),
					'91544' => __ ( 'Cannot clone transaction without submit_for_settlement flag.', 'braintree-payments' ),
					'91545' => __ ( 'Voice Authorizations are not supported for this processor.', 'braintree-payments' ),
					'91546' => __ ( 'Credits are not supported by this processor.', 'braintree-payments' ),
					'91548' => __ ( 'Purchase order number is invalid.', 'braintree-payments' ),
					'81520' => __ ( 'Processor authorization code must be 6 characters.', 'braintree-payments' ),
					'91549' => __ ( 'Cannot provide more than one of payment_method_token, payment_method_nonce, credit_card, and venmo_sdk_payment_method_code attributes.', 'braintree-payments' ),
					'91550' => __ ( 'Channel is too long.', 'braintree-payments' ),
					'91551' => __ ( 'Settlement amount cannot be less than the service fee amount.', 'braintree-payments' ),
					'91552' => __ ( 'Credits not allowed with service fee.', 'braintree-payments' ),
					'91553' => __ ( 'Sub-merchant account requires a service fee.', 'braintree-payments' ),
					'91554' => __ ( 'Amount cannot be negative.', 'braintree-payments' ),
					'91555' => __ ( 'Amount is an invalid format.', 'braintree-payments' ),
					'91556' => __ ( 'Service fee amount is larger than transaction amount.', 'braintree-payments' ),
					'91557' => __ ( 'Service fee not supported on master merchant account.', 'braintree-payments' ),
					'91558' => __ ( 'Merchant account does not support MOTO transactions unless configured by processor.', 'braintree-payments' ),
					'91559' => __ ( 'Cannot refund a transaction with a pending merchant account.', 'braintree-payments' ),
					'91560' => __ ( 'Transaction could not be held in escrow.', 'braintree-payments' ),
					'91561' => __ ( 'Cannot release a transaction that is not escrowed.', 'braintree-payments' ),
					'91562' => __ ( 'Release can only be cancelled if the transaction is submitted for release.', 'braintree-payments' ),
					'91563' => __ ( 'Escrowed transactions cannot be partially refunded.', 'braintree-payments' ),
					'91564' => __ ( 'Cannot use a payment_method_nonce more than once.', 'braintree-payments' ),
					'91565' => __ ( 'Unknown or expired payment_method_nonce.', 'braintree-payments' ),
					'91567' => __ ( 'Payment instrument type is not accepted by this merchant account.', 'braintree-payments' ),
					'91568' => __ ( 'Three D Secure Token is invalid.', 'braintree-payments' ),
					'91569' => __ ( 'payment_method_nonce does not contain a valid payment instrument type.', 'braintree-payments' ),
					'91572' => __ ( 'Current payment method does not support use_billing_for_shipping flag.', 'braintree-payments' ),
					'91575' => __ ( 'Cannot transition transaction to settled, settlement_confirmed, or settlement_declined', 'braintree-payments' ),
					'91576' => __ ( 'PayPal is not enabled for your merchant account.', 'braintree-payments' ),
					'91577' => __ ( 'Merchant account does not support payment instrument.', 'braintree-payments' ),
					'91570' => __ ( 'Transaction data does not match data from Three D Secure verify call.', 'braintree-payments' ),
					'91573' => __ ( 'Transaction cannot be cloned if payment method is a PayPal account.', 'braintree-payments' ),
					'91574' => __ ( 'Cannot refund a transaction transaction in settling status on this merchant account. Try again after the transaction has settled.', 'braintree-payments' ),
					'91578' => __ ( 'Service fee can not be applied on PayPal transactions.', 'braintree-payments' ),
					'91580' => __ ( 'PayPal custom fields must be less than 256 characters in length.', 'braintree-payments' ),
					'91581' => __ ( 'Shipping address customer does not match customer in request.', 'braintree-payments' ),
					'91582' => __ ( 'PayPal unilateral transactions must also be submitted for settlement.', 'braintree-payments' ),
					'91583' => __ ( 'This PayPal account was not vaulted with the required data', 'braintree-payments' ),
					'91584' => __ ( 'Merchant account must match the 3D Secure authorization merchant account.', 'braintree-payments' ),
					'91585' => __ ( 'Amount must match the 3D Secure authorization amount.', 'braintree-payments' ),
					'91586' => __ ( 'Shared billing address ID cannot be used in the same call as a standard billing address ID', 'braintree-payments' ),
					'91587' => __ ( 'Shared customer ID cannot be used in the same call as a standard customer ID', 'braintree-payments' ),
					'91588' => __ ( 'Shared payment method token cannot be used in the same call as a standard payment method token', 'braintree-payments' ),
					'91589' => __ ( 'Shared payment method token cannot be used in the same call as a non-shared identifier param', 'braintree-payments' ),
					'91590' => __ ( 'Shared identifier param cannot be used with non-shared payment method token', 'braintree-payments' ),
					'91591' => __ ( 'Shared shipping address ID cannot be used in the same call as a standard shipping address ID', 'braintree-payments' ),
					'91592' => __ ( 'Shared payment methods cannot be vaulted', 'braintree-payments' ),
					'91593' => __ ( 'Shared payment methods cannot be vaulted', 'braintree-payments' ),
					'91594' => __ ( 'Shared shipping addresses cannot be vaulted', 'braintree-payments' ),
					'91595' => __ ( 'Shared payment methods cannot be updated', 'braintree-payments' ),
					'91597' => __ ( 'Cannot provide both shared_payment_method_token and shared_customer_id unless the payment_method belongs to the customer.', 'braintree-payments' ),
					'91598' => __ ( 'Payment instrument type is not accepted by this merchant account.', 'braintree-payments' ),
					'91599' => __ ( 'Shared Shipping address customer does not match customer in request.', 'braintree-payments' ),
					'91596' => __ ( 'Shared payment method token is invalid.', 'braintree-payments' ),
					'915100' => __ ( 'Shared Customer ID is invalid.', 'braintree-payments' ),
					'915103' => __ ( 'Cannot submit for partial settlement.', 'braintree-payments' ),
					'915101' => __ ( 'Payment instrument type is not accepted.', 'braintree-payments' ),
					'915102' => __ ( 'Partial settlements are not supported by this processor.', 'braintree-payments' ),
					'915104' => __ ( 'Delayed settlements are not supported for this processor. The submit for settlement option is required.', 'braintree-payments' ),
					'915105' => __ ( 'Merchant account does not support Amex rewards.', 'braintree-payments' ),
					'915106' => __ ( 'Points amount is too large.', 'braintree-payments' ),
					'915107' => __ ( 'Updating order_id on submit_for_settlement is not supported by this processor.', 'braintree-payments' ),
					'915108' => __ ( 'Updating descriptor on submit_for_settlement is not supported by this processor.', 'braintree-payments' ),
					'915109' => __ ( 'PayPal supplementary data fields must be less than 4001 characters in length:', 'braintree-payments' ),
					'915110' => __ ( 'Cannot clone facilitated transactions.', 'braintree-payments' ),
					'915111' => __ ( 'PayPal supplementary data field count must be less than 101.', 'braintree-payments' ),
					'915112' => __ ( 'Shared payment method token originated from another merchant and is not allowed to be shared', 'braintree-payments' ),
					'915113' => __ ( 'EciFlag is required.', 'braintree-payments' ),
					'915114' => __ ( 'EciFlag is invalid.', 'braintree-payments' ),
					'915115' => __ ( 'Xid is required for specified EciFlag.', 'braintree-payments' ),
					'915116' => __ ( 'Cavv is required for specified EciFlag.', 'braintree-payments' ),
					'915131' => __ ( 'Merchant account does not support 3D Secure transactions for card type.', 'braintree-payments' ),
					'915133' => __ ( 'Transaction source must be either \'moto\' or \'recurring\'.', 'braintree-payments' ),
					'915134' => __ ( 'submit_for_settlement is required and must be true.', 'braintree-payments' ),
					'915135' => __ ( 'shared_payment_method_nonce does not contain valid payment instrument type.', 'braintree-payments' ),
					'915136' => __ ( 'Payment instrument type is not accepted by this merchant.', 'braintree-payments' ),
					'915137' => __ ( 'Cannot clone Braintree Marketplace transactions via the API.', 'braintree-payments' ) 
			),
			'descriptor' => array( 
					'92201' => __ ( 'Company name/DBA section is invalid.', 'braintree-payments' ),
					'92202' => __ ( 'Phone number is invalid.', 'braintree-payments' ),
					'92203' => __ ( 'Dynamic descriptors have not been enabled for this account. Please contact support@braintreepayments.com.', 'braintree-payments' ),
					'92204' => __ ( 'Descriptor format is invalid.', 'braintree-payments' ),
					'92205' => __ ( 'International phone number is invalid.', 'braintree-payments' ),
					'92206' => __ ( 'URL must be 13 characters or shorter.', 'braintree-payments' ) 
			),
			'verification' => array( 
					'94201' => __ ( 'Verification amount cannot be negative.', 'braintree-payments' ),
					'94202' => __ ( 'Verification amount is invalid.', 'braintree-payments' ),
					'94203' => __ ( 'Verification amount not supported by processor.', 'braintree-payments' ),
					'94204' => __ ( 'Verification Merchant Account ID is invalid.', 'braintree-payments' ),
					'94205' => __ ( 'Verification Merchant Account is suspended.', 'braintree-payments' ),
					'94206' => __ ( 'The current user does not have access to the specified merchant_account_id', 'braintree-payments' ),
					'94207' => __ ( 'Verification amount is too large.', 'braintree-payments' ),
					'94208' => __ ( 'Verification Merchant Account ID cannot be a sub-merchant account.', 'braintree-payments' ) 
			) 
	);
	foreach ( $defaults as $type => $data ) {
		$defaults[ $type ] = array_replace ( $defaults[ $type ], array_intersect_key ( $saved_messages, $defaults[ $type ] ) );
	}
	
	return apply_filters ( 'bfwc_get_error_messages', $defaults );
}

function bfwc_get_combined_error_messages() {
	$messages = bfwc_get_error_messages ();
	$combined_msgs = array();
	foreach ( $messages as $message_type => $codes ) {
		foreach ( $codes as $k => $text ) {
			$combined_msgs[ $k ] = $text;
		}
	}
	return apply_filters ( 'bfwc_get_combined_error_messages', $combined_msgs );
}

function bfwc_error_code_type_nicename($type) {
	$nice_names = array( 
			'tokenization' => __ ( 'Tokenization Codes', 'braintree-payments' ),
			'gateway_rejected' => __ ( 'Gateway Rejected', 'braintree-payments' ),
			'processor_declined' => __ ( 'Processor Declined Codes', 'braintree-payments' ),
			'exceptions' => __ ( 'Exception Text', 'braintree-payments' ),
			'address' => __ ( 'Address', 'braintree-payments' ),
			'market_place' => __ ( 'Market Place', 'braintree-payments' ),
			'customer' => __ ( 'Customer', 'braintree-payments' ),
			'payment_method' => __ ( 'Payment Method', 'braintree-payments' ),
			'apple_pay' => __ ( 'Apple Pay', 'braintree-payments' ),
			'credit_card' => __ ( 'Credit Card', 'braintree-payments' ),
			'american_express' => __ ( 'American Express', 'braintree-payments' ),
			'paypal' => __ ( 'PayPal', 'braintree-payments' ),
			'venmo' => __ ( 'Venmo', 'braintree-payments' ),
			'add_ons_and_discounts' => __ ( 'Add-ons/Discounts', 'braintree-payments' ),
			'subscription' => __ ( 'Subscription', 'braintree-payments' ),
			'search' => __ ( 'Search', 'braintree-payments' ),
			'transaction' => __ ( 'Transaction', 'braintree-payments' ),
			'descriptor' => __ ( 'Descriptor', 'braintree-payments' ),
			'verification' => __ ( 'Verification', 'braintree-payments' ) 
	);
	return apply_filters ( 'bfwc_error_code_type_nicename', isset ( $nice_names[ $type ] ) ? $nice_names[ $type ] : $type );
}

/**
 * Retrieve an error message from the Braintree_Result_Error object.
 *
 * @param
 *        	mixed Braintree_Result_Error|Braintree_Exception $result
 */
function bfwc_get_error_message($result) {
	global $bfwc_error_message;
	$messages = bfwc_get_combined_error_messages ();
	
	if ($result instanceof \Braintree\Exception) {
		$text = isset ( $messages[ get_class ( $result ) ] ) ? $messages[ get_class ( $result ) ] : __ ( 'An exception was encountered.', 'braintree-payments' );
	} else {
		$errors = $result->errors->deepAll ();
		$text = '';
		if (! empty ( $errors )) {
			foreach ( $errors as $error ) {
				$text .= isset ( $messages[ $error->code ] ) ? $messages[ $error->code ] : $error->message;
			}
		} else {
			$object = $result->transaction ? $result->transaction : $result->creditCardVerification;
			if ($object) {
				
				$processor_response_code = $object->processorResponseCode;
				if ($processor_response_code && array_key_exists ( $processor_response_code, $messages )) {
					$text = isset ( $messages[ $processor_response_code ] ) ? $messages[ $processor_response_code ] : '';
				} else {
					$gateway_rejection = explode ( '_and_', $object->gatewayRejectionReason );
					
					$response_attrs = array( 
							'avs' => array( 
									'avsPostalCodeResponseCode',
									'avsStreetAddressResponseCode' 
							),
							'cvv' => array( 
									'cvvResponseCode' 
							),
							'three_d_secure' => array( 
									'gatewayRejectionReason' 
							) 
					);
					foreach ( $gateway_rejection as $code ) {
						if (! empty ( $response_attrs[ $code ] )) {
							foreach ( $response_attrs[ $code ] as $attr ) {
								$key = "{$attr}_{$object->$attr}";
								$text .= isset ( $messages[ $key ] ) ? $messages[ $key ] : '';
							}
						}
					}
				}
			}
			$bfwc_error_message = $text = empty ( $text ) ? $result->message : preg_replace ( '/(\.)([\w]{2,})/', '$1 $2', $text );
		}
	}
	
	// regex to add spaces between periods.
	return apply_filters ( 'bfwc_get_error_message', $text );
}