<?php

// /usr/local/bin/php -c /home2/zhelev/public_html/kozelat.com/import_library/itr_import/php.ini /home2/zhelev/public_html/eliafj.kozelat.com/import/products-xml-import.php

echo '<pre>';

function download_image($url, $dir) {
    $parsed_url = parse_url($url);
    $filename = basename($parsed_url['path']);
    $filepath = $dir . $filename;

    $content = file_get_contents($url);

    if (!$content) {
        return false;
    }

    file_put_contents($filepath, $content);
    return 'catalog/imported-images/' . $filename;
}

function getTextFromXml($element) {
    $text = '';
    foreach ($element->children() as $child) {
        $text .= getTextFromXml($child);
    }
    return trim((string) $element) . $text;
}

$imageDir = '/home2/zhelev/public_html/eliafj.kozelat.com/image/catalog/imported-images/';

if (!file_exists($imageDir)) {
    mkdir($imageDir, 0755, true); 
}

$xml_content = file_get_contents('/home2/zhelev/public_html/eliafj.kozelat.com/import/products.xml');

$xml_content = str_replace('&nbsp;', ' ', $xml_content);

$xml = simplexml_load_string($xml_content) or die("Error: Cannot create object");

$categories = [
    96  => 'Бижута',
    97  => 'Tениски Advent Tshirt',
    98  => 'Обеци',
    99  => 'Колекция Бонбонено изкушение',
    100 => 'Колекция Пролетни цветя',
    101 => 'Колекция Синьо вълнение',
    102 => 'Колекция Японска вишнева градина',
    103 => 'Колекция Есен',
    104 => 'Колекция Геометрия и Натюрморт',
    105 => 'Колекция Лятно и морско',
    106 => 'Колекция Животни и принтове',
    107 => 'Колекция Зима',
    108 => 'Колекция Вдъхновение',
    109 => 'Брошки',
    110 => 'Халки',
    111 => 'Гривни',
    112 => 'Колекция Пиши ми',
    113 => 'Колекция Каре',
    114 => 'Колекция Любимци',
    115 => 'Колекция Вестници',
    116 => 'Колекция Барби',
    117 => 'Колиета',
    118 => 'Пръстени',
    119 => 'Амалфи, Позитано и Соренто',
    120 => 'Мегдана',
    121 => 'Фибички'
];

$servername = "localhost";
$username = "zhelev_eliafj";
$password = "u3Dy-!mB4eV_fEx1H-";
$dbname = "zhelev_eliafj";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$conn->query("SET NAMES 'utf8'");
$product_model = 10001;
// var_dump($xml);
// die();
foreach($xml->product as $product) {
   
    $description = getTextFromXml($product->description);

    $productUrl = (string)$product->url;
    $urlParts = explode('product/', $productUrl);
    $keyword = isset($urlParts[1]) ? basename($urlParts[1]) : '';

    $sku = '';
    if (!empty($product->sku)) {
        $sku = $product->sku;
    }

    $image = NULL;
    $categoryId = 0;

    $sql_product = "INSERT INTO oc_product (product_id, model, sku, upc, ean, jan, isbn, mpn, location, quantity, stock_status_id, image, manufacturer_id, price, weight, tax_class_id, date_available, date_added, date_modified) VALUES (?, ?, ?, '', '', '', '', '', '', ?, 7, ?, 12, ?, ?, 0, NOW(), NOW(), NOW() )";
    
    $stmt_product = $conn->prepare($sql_product);
    $stmt_product->bind_param("issisdd", $product->id, $product_model, $sku, $product->quantity, $image, $product->original_price, $product->weight);

    if (!$stmt_product->execute()) {
        echo "Error: " . $sql_product . "\n" . $conn->error;
    }
    $stmt_product->close();

    $sql_description = "INSERT INTO oc_product_description (product_id, language_id, name, description, tag, meta_title, meta_description, meta_keyword) VALUES (?, 1, ?, ?, ?, ?, ?, '')";

    $stmt_description = $conn->prepare($sql_description);
    $stmt_description->bind_param("isssss", $product->id, $product->title, $description, $product->tags, $product->meta_title, $product->meta_description);

    if (!$stmt_description->execute()) {
        echo "Error: " . $sql_description . "\n" . $conn->error;
    }

    $sql_description = "INSERT INTO oc_product_description (product_id, language_id, name, description, tag, meta_title, meta_description, meta_keyword) VALUES (?, 3, ?, ?, ?, ?, ?, '')";

    $stmt_description = $conn->prepare($sql_description);
    $stmt_description->bind_param("isssss", $product->id, $product->title, $description, $product->tags, $product->meta_title, $product->meta_description);

    if (!$stmt_description->execute()) {
        echo "Error: " . $sql_description . "\n" . $conn->error;
    }
    $stmt_description->close();

    $stmt = $conn->prepare("INSERT INTO oc_product_to_layout (product_id, store_id, layout_id) VALUES (?, 0, 0)");
    $stmt->bind_param('i', $product->id);
    $stmt->execute();
    $stmt->close();

    $stmt = $conn->prepare("INSERT INTO oc_product_to_store (product_id, store_id) VALUES (?, 0)");
    $stmt->bind_param('i', $product->id);
    $stmt->execute();
    $stmt->close();

    $query = 'product_id=' . $product->id;
    $en_keyword = $keyword . '-en';
    $stmt = $conn->prepare("INSERT INTO oc_seo_url (store_id, language_id, query, keyword) VALUES (0, 1, ?, ?) ON DUPLICATE KEY UPDATE keyword = VALUES(keyword)");
    $stmt->bind_param('ss', $query, $en_keyword);
    $stmt->execute();
    $stmt->close();

    $bg_keyword = $keyword . '-bg';
    $stmt = $conn->prepare("INSERT INTO oc_seo_url (store_id, language_id, query, keyword) VALUES (0, 3, ?, ?) ON DUPLICATE KEY UPDATE keyword = VALUES(keyword)");
    $stmt->bind_param('ss', $query, $bg_keyword);
    $stmt->execute();
    $stmt->close();

    if (isset($product->sub_sub_category) && !empty($product->sub_sub_category)) {
        $categoryId = array_search($product->sub_sub_category, $categories);
    } else if (isset($product->sub_category) && !empty($product->sub_category)) {
        $categoryId = array_search($product->sub_category, $categories);
    } else if (isset($product->category) && !empty($product->category)) {
        $categoryId = array_search($product->category, $categories);
    }
    
    $stmt = $conn->prepare("INSERT INTO oc_product_to_category (product_id, category_id) VALUES (?, ?)");
    $stmt->bind_param('ii', $product->id, $categoryId);
    $stmt->execute();
    $stmt->close();

    $price = floatval($product->price);
    $original_price = floatval($product->original_price);

    if ($price != $original_price) {
        $stmt_special = $conn->prepare("INSERT INTO oc_product_special (product_id, customer_group_id, price) VALUES (?, 1, ?)");

        $stmt_special->bind_param('id', $product->id, $price);
        $stmt_special->execute();
        $stmt_special->close();
    }


    if (isset($product->images->image) && count($product->images->image) > 0) {
        $images = [];
        foreach ($product->images->image as $image) {
            $images[] = (string)$image;
        }

        $mainImageUrl = $images[0];
        $mainImagePath = $imageDir . basename($mainImageUrl);

        
        $mainImageRelativePath = download_image($mainImageUrl, $imageDir);

        if ($mainImageRelativePath) {
            $stmt = $conn->prepare("UPDATE oc_product SET image = ? WHERE product_id = ?");
            $stmt->bind_param('si', $mainImageRelativePath, $product->id);
            $stmt->execute();
            $stmt->close();
        }

        for ($i = 1; $i < count($images); $i++) {
            $imageUrl = $images[$i];
                      
            $imageRelativePath = download_image($imageUrl, $imageDir);

            if ($imageRelativePath) {
                $stmt = $conn->prepare("INSERT INTO oc_product_image (product_id, image, sort_order) VALUES (?, ?, ?)");
                $stmt->bind_param('isi', $product->id, $imageRelativePath, $i);
                $stmt->execute();
                $stmt->close();
            }
            
        }


    }

    

    $product_model++;
}



// Close connection
$conn->close();

die('done');


