@extends('layouts.main')
@section('content')
<section class="section-padding-smaller">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="page-title text-center">
                    <img src="{{asset('/images/about-logo.svg')}}" alt="Logo">
                    <div class="space-20"></div>
                    <h3 class="title">{!! Lang::get('lang.lp_heading') !!}</h3>
                    <div class="space-20"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="key-success section-padding-top" id="">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-12">
                <div class="page-title text-center">
                    <h3 class="title">{!! Lang::get('lang.lp_subheading') !!}</h3>
                    <div class="space-20"></div>
                </div>
            </div>
        </div>
        <div class="">
          <div class="col-xs-12 col-sm-6">
              <div class="page-title text-left">
                  <p class="font-22">
                    <div class="space-30"></div>
                    <i class="fas fa-check"></i> {!! Lang::get('lang.lp_checkmark1') !!}
                    <i class="fas fa-check"></i> {!! Lang::get('lang.lp_checkmark2') !!}
                    <i class="fas fa-check"></i> {!! Lang::get('lang.lp_checkmark3') !!}
                    <i class="fas fa-check"></i> {!! Lang::get('lang.lp_checkmark4') !!}
                    <i class="fas fa-check"></i> {!! Lang::get('lang.lp_checkmark5') !!}
                  </p>
              </div>
          </div>
          <div class="col-xs-12 col-sm-6">
              <div class="border-box">
                <div class="page-title text-left">
                    <div class="space-10"></div>
                    <h4>{!! Lang::get('lang.lp_box1_heading') !!}</h4>
                    <div class="space-10"></div>
                    <p>
                       <i class="fas fa-arrow-right"></i> {!! Lang::get('lang.lp_box1_text1') !!} <br/>
  	                   <i class="fas fa-arrow-right"></i> {!! Lang::get('lang.lp_box1_text2') !!} <br/>
  	                   <i class="fas fa-arrow-right"></i> {!! Lang::get('lang.lp_box1_text3') !!}
                    </p>
                </div>
                <div class="text-center">
                  <div class="space-10"></div>
                  <a class="bttn-blue" href="#"> {!! Lang::get('lang.lp_box1_cta') !!} </a>

                </div>
            </div>
            <div class="border-box">
              <div class="page-title text-left">
                  <div class="space-10"></div>
                  <h4>{!! Lang::get('lang.lp_box2_heading') !!}</h4>
                  <div class="space-10"></div>
                  <p>
                    {!! Lang::get('lang.lp_box2_text1') !!}
                  </p>
              </div>
              <div class="text-center">
                <div class="space-10"></div>
                <a class="bttn-blue" data-toggle="modal" data-target="#modal-request" href="#"> {!! Lang::get('lang.lp_box2_cta') !!} </a>

              </div>
          </div>
        </div>
        </div>
    </div>
</section>
@include('layouts.partials.request-modal')
@endsection
