@extends('layouts.main')
@section('content')
<section class="section-padding-product product-heading">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-md-12 col-sm-12">
                <div class="page-title text-center">
                    <div class="clearfix"></div>
                    @include('blocks.top-product-navigation')
                    <div class="space-20"></div>
                    <h3 class="title color-dark-blue">BBoil</h3>
                    <div class="space-30"></div>
                </div>
            </div>

            <div class="col-xs-12 col-md-5 col-lg-5 col-sm-5 text-center">
                <img src="{{ asset('images/bboil.png') }}" />
                <div class="clearfix"></div>
            </div>
            <div class="col-xs-12 col-lg-7 col-md-7 col-sm-7">
                <h2 class="color-dark-blue">{!! Lang::get('lang.bboil_page_heading') !!}</h2>
                <ul style="list-style-type:none;" class="col-xs-12 col-lg-6 col-md-6 col-sm-6">
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.bboil_page_list1') !!} </li>
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.bboil_page_list2') !!} </li>
                </ul>
                <ul style="list-style-type:none;" class="col-xs-12 col-lg-6 col-md-6 col-sm-9">
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.bboil_page_list3') !!} </li>
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.bboil_page_list4') !!} </li>
                </ul>
            </div>
        </div>
    </div>
</section>
<div class="darkbluebg">
    <div class="col-xs-12 col-sm-12">
        <div class="page-title text-center full-width-box">

            <h2 class="facts-heading">{!! Lang::get('lang.bboil_page_accent1') !!}</h3>

        </div>
    </div>
</div>
<!-- About-Area-End -->
<!-- Feature-Area -->
<section class="feature-area section-padding-normal" id="">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-12">
                <div class="page-title text-center">
                    <h3 class="title">{!! Lang::get('lang.features')!!}</h3>
                    <div class="space-30"></div>
                </div>
            </div>
        </div>
        <div class="row" id="">
            <div class="col-xs-12 col-sm-3 col-md-3">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/savings.svg')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.savings') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
            <div class="col-xs-12 col-sm-3 col-md-3">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/smart-home.svg')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.remote_control') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
            <div class="col-xs-12 col-sm-3 col-md-3">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/realtime.png')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.real_time') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
            <div class="col-xs-12 col-sm-3 col-md-3">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/calendar.svg')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.schedule') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
        </div>
        <div class="row" id="">
            <div class="col-xs-12 col-sm-3 col-md-3">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/notification.svg')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.email_notificaiton') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
            <div class="col-xs-12 col-sm-3 col-md-3">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/weather.svg')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.heating_cooling') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
            <div class="col-xs-12 col-sm-3 col-md-3">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/analysis.svg')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.detailed_chart') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
            <div class="col-xs-12 col-sm-3 col-md-3">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/share.svg')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.share_access') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
        </div>
    </div>
</section>
<div class="darkbluebg">
    <div class="col-xs-12 col-sm-12">
        <div class="page-title text-center full-width-box">

            <h2 class="facts-heading">{!! Lang::get('lang.bboil_page_accent2') !!}</h3>

        </div>
    </div>
</div>
<div class="row-eq-height bluebg">
    <div class="col-xs-12 col-sm-6" id="boost">
      &nbsp;
    </div>
    <div class="col-xs-12 col-sm-6">
        <div class="page-title text-left full-width-box">
            <div class="space-20"></div>
            <h3 class="title">{!! Lang::get('lang.boost_heading') !!}</h3>
            <div class="space-20"></div>
            <h4>{!! Lang::get('lang.bboil_boost_description') !!}</h4>
        </div>
    </div>
</div>

<!-- Gallery-Area -->
<section class="gallery-area section-padding-normal" id="gallery_page">
    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12 col-sm-6 gallery-slider">
                <div class="gallery-slide">
                  <div class="item"><img src="{{asset('/images/gallery/gallery-3.PNG')}}" alt=""></div>
                  <div class="item"><img src="{{asset('/images/gallery/gallery-2.PNG')}}" alt=""></div>
                  <div class="item"><img src="{{asset('/images/gallery/gallery-1.PNG')}}" alt=""></div>
                  <div class="item"><img src="{{asset('/images/gallery/gallery-4.PNG')}}" alt=""></div>
                  <div class="item"><img src="{{asset('/images/gallery/gallery-5.PNG')}}" alt=""></div>
                  <div class="item"><img src="{{asset('/images/gallery/gallery-6.PNG')}}" alt=""></div>
                  <div class="item"><img src="{{asset('/images/gallery/gallery-7.PNG')}}" alt=""></div>
                  <div class="item"><img src="{{asset('/images/gallery/gallery-8.PNG')}}" alt=""></div>
                  <div class="item"><img src="{{asset('/images/gallery/gallery-9.PNG')}}" alt=""></div>
                  <div class="item"><img src="{{asset('/images/gallery/gallery-10.PNG')}}" alt=""></div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-5 col-lg-3">
                <div class="page-title">
                    <h5 class="white-color title wow fadeInUp" data-wow-delay="0.2s">{!! Lang::get('lang.gallery') !!}</h5>
                    <div class="space-10"></div>
                </div>
                <div class="space-20"></div>
                <div class="desc wow fadeInUp" data-wow-delay="0.6s">
                    <p>{!! Lang::get('lang.bboil_gallery_description') !!}</p>
                </div>
                <div class="space-50"></div>
                <a target="_blank" href="https://sys.prosmartsystem.com/?demo=demo@pss.com" class="bttn-cta wow fadeInUp" data-wow-delay="0.8s">{!! Lang::get('lang.demo') !!}</a>
            </div>
        </div>
    </div>
</section>
<!-- Gallery-Area-End -->
<!-- How-To-Use -->
<section class="section-padding">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-7 col-md-7">
                <div class="page-title">
                    <h3 class="title wow fadeInUp" data-wow-delay="0.2s">{!! Lang::get('lang.specifications') !!}</h3>
                    <div class="space-10"></div>
                    <!-- <h4 class="dark-color wow fadeInUp" data-wow-delay="0.4s">Wireless thermostat</h4> -->
                </div>
                <!-- <div class="space-20"></div> -->
                <div class="desc wow fadeInUp" data-wow-delay="0.6s">
                  <ul style="list-style-type:none;" class="col-xs-12 col-lg-6 col-md-6 col-sm-6">
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.specification_1') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.specification_2') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.specification_3') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.specification_4_bboil') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.specification_5') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.specification_6') !!}</li>
                  </ul>
                  <ul style="list-style-type:none;" class="col-xs-12 col-lg-6 col-md-6 col-sm-9">
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.specification_7') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.specification_8_bboil') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.specification_9_bboil') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.specification_10') !!}</li>

                  </ul>
                </div>
                <div class="space-50"></div>
                  @if(request()->segment(1) == 'en')
                  <a target="_blank" href="{{asset('/images/usermanuals/User_manual_BBoil_EN.pdf')}}" class="bttn-default wow fadeInUp" data-wow-delay="0.8s">{!! Lang::get('lang.UserManual') !!}</a>
                  @else
                  <a target="_blank" href="{{asset('/images/usermanuals/User_manual_BBoil_BG.pdf')}}" class="bttn-default wow fadeInUp" data-wow-delay="0.8s">{!! Lang::get('lang.UserManual') !!}</a>
                  @endif
            </div>
            <div class="col-xs-12 col-sm-5 col-md-5">
                <img src="{{ asset('images/bboil.png') }}" />
            </div>
        </div>
    </div>
</section>
<div class="darkbluebg">
    <div class="col-xs-12 col-sm-8">
        <div class="page-title text-center full-width-box">
            <div class="space-30"></div>
            <h2 class="">{!! Lang::get('lang.need_more_info') !!}</h3>
                <div class="space-20"></div>
        </div>
    </div>
    <div class="col-xs-12 col-sm-4">
        <div class="page-title text-center full-width-box">
            <div class="space-30"></div>
            <a class="bttn-cta" href="{{{route('get-accelerate-your-business-page')}}}">{!! Lang::get('lang.contact_cta') !!}</a>
            <div class="space-20"></div>
        </div>
    </div>
</div>
@endsection
