<?php

class ManageProducts
{
    private const HOST = 'localhost';
    private const USERNAME = 'zhelev_kefcheto'; 
    private const PASSWORD = 'h9tvu@+k?xW4NX!YLW'; 
    private const DATABASE = 'zhelev_kef4eto'; 
    private $connection;

    public function __construct()
    {
        $this->connection = new mysqli(self::HOST, self::USERNAME, self::PASSWORD, self::DATABASE);
        mysqli_set_charset($this->connection, "utf8");
        if ($this->connection->connect_error) {
            throw new Exception('Failed to connect to the database: ' . $this->connection->connect_error);
        }
    }

    public function disconnect()
    {
        if ($this->connection) {
            $this->connection->close();
        }
    }

    public function getConnection()
    {
        return $this->connection;
    }

    public function addProduct($id, $sku, $upc, $location, $price, $quantity, $stockStatusId, $name, $description, $seoURL, $image, $promoPrice, $categoryId = 0)
    {
        $manufacturerId = 0;
        $taxClassId = 9;
        $dateNow = date('Y-m-d H:i');
        $ean = '';
        $jan = '';
        $isbn = '';
        $mpn = '';
        $tag = '';
        $metaTitle = '';
        $metaDescription = '';
        $metaKeyword = '';
        $status = 1;
        $storeId = 0;
        $layoutId = 0;
        $languageId = 1;
        $id = trim($id);
        $sku = trim($sku);
        $upc = trim($upc);
        $location = trim($location);
        $name = trim($name);
        $description = (empty($description)) ? '' : trim('<pre>' . $description . '</pre>');

        $this->connection->begin_transaction();

        // oc_product
        $stmt = $this->connection->prepare("INSERT INTO oc_product (product_id, model, price, quantity, sku, upc, ean, jan, isbn, mpn, location, stock_status_id, image, manufacturer_id, tax_class_id, date_available, date_added, date_modified, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("isdisssssssisiisssi", $id, $id, $price, $quantity, $sku, $upc, $ean, $jan, $isbn, $mpn, $location, $stockStatusId, $image, $manufacturerId, $taxClassId, $dateNow, $dateNow, $dateNow, $status);

        if ($stmt->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_product table: ' . $stmt->error);
        }

        $productId = $stmt->insert_id;

        $stmt->close();
        
        // oc_product_description
        $stmt2 = $this->connection->prepare("INSERT INTO oc_product_description (product_id, language_id, name, description, tag, meta_title, meta_description, meta_keyword) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt2->bind_param("iissssss", $productId, $languageId, $name, $description, $tag, $name, $metaDescription, $metaKeyword);

        if ($stmt2->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_product_description table: ' . $stmt2->error);
        }

        $stmt2->close();

        // oc_product_to_store
        $stmt3 = $this->connection->prepare("INSERT INTO oc_product_to_store (product_id, store_id) VALUES (?, ?)");
        $stmt3->bind_param("ii", $productId, $storeId);

        if ($stmt3->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_product_to_store table: ' . $stmt3->error);
        }

        $stmt3->close();

        // oc_product_to_layout
        $stmt4 = $this->connection->prepare("INSERT INTO oc_product_to_layout (product_id, store_id, layout_id) VALUES (?, ?, ?)");
        $stmt4->bind_param("iii", $productId, $storeId, $layoutId);

        if ($stmt4->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_product_to_layout table: ' . $stmt4->error);
        }

        $stmt4->close();

        // oc_product_to_category
        $stmt5 = $this->connection->prepare("INSERT INTO oc_product_to_category (product_id, category_id) VALUES (?, ?)");
        $stmt5->bind_param("ii", $productId, $categoryId);

        if ($stmt5->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_product_to_category table: ' . $stmt5->error);
        }

        $stmt5->close();

        // oc_seo_url - add seo url
        $query = 'product_id=' . $productId;
        $seoURL = $seoURL . '-' . $productId;
        $stmt6 = $this->connection->prepare("INSERT INTO oc_seo_url (store_id, language_id, query, keyword) VALUES (?, ?, ?, ?)");
        $stmt6->bind_param("iiss", $storeId, $languageId, $query, $seoURL);

        if ($stmt6->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_seo_url table: ' . $stmt6->error);
        }

        $stmt6->close();

        if ($promoPrice) {
            $customer_group_id = 1;
            $priority = 1;
            $date_start = date('Y-m-d');
            $date = new DateTime($date_start);
            $date->modify('+5 years');
            $date_end = $date->format('Y-m-d');

            // oc_product_special
            $stmt7 = $this->connection->prepare("INSERT INTO oc_product_special (product_id, customer_group_id, priority, price, date_start, date_end) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt7->bind_param("iiidss", $productId, $customer_group_id, $priority, $promoPrice, $date_start, $date_end);

            if ($stmt7->execute() === false) {
                $this->connection->rollback();
                throw new Exception('MySQL Query Error with oc_product_special table: ' . $stmt7->error);
            }

            $stmt7->close();
        }
        
        $this->connection->commit();
    }

    public function updateProduct($productId, $quantity, $stockStatusId, $price, $name, $image, $description, $promoPrice, $categoryId = 0)
    {
        $dateModified = date('Y-m-d H:i');
        $status = 1;
        $description = (empty($description)) ? '' : trim('<pre>' . $description . '</pre>');

        $productId = trim($productId);
        
        $this->connection->begin_transaction();
        
        $stmt = $this->connection->prepare("UPDATE oc_product SET quantity = ?, stock_status_id = ?, price = ?, status = ?, image = ?, date_modified = ? WHERE product_id = ?");
        $stmt->bind_param("iidissi", $quantity, $stockStatusId, $price, $status, $image, $dateModified, $productId);

        if ($stmt->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error updating the oc_product table: ' . $stmt->error);
        }
        
        $stmt->close();

        $stmt2 = $this->connection->prepare("UPDATE oc_product_description SET name = ?, description = ? WHERE product_id = ?");
        $stmt2->bind_param("ssi", $name, $description, $productId);

        if ($stmt2->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error updating the oc_product_description table: ' . $stmt2->error);
        }
        $stmt2->close();

        $stmt3 = $this->connection->prepare("UPDATE oc_product_to_category SET category_id = ? WHERE product_id = ?");
        $stmt3->bind_param("ii", $categoryId, $productId);

        if ($stmt3->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error updating the oc_product_to_category table: ' . $stmt3->error);
        }
        $stmt3->close();

        if ($promoPrice) {
            $customer_group_id = 1;
            $priority = 1;
            $date_start = date('Y-m-d');
            $date = new DateTime($date_start);
            $date->modify('+5 years');
            $date_end = $date->format('Y-m-d');

            $stmt = $this->connection->prepare("SELECT product_id FROM oc_product_special WHERE product_id = ?");
            $stmt->bind_param("i", $productId);
            $stmt->execute();
            $result = $stmt->get_result();

    
            if ($result->num_rows == 0) {
                // oc_product_special
                $query = $this->connection->prepare("INSERT INTO oc_product_special (product_id, customer_group_id, priority, price, date_start, date_end) VALUES (?, ?, ?, ?, ?, ?)");
                $query->bind_param("iiidss", $productId, $customer_group_id, $priority, $promoPrice, $date_start, $date_end);

                if ($query->execute() === false) {
                    $this->connection->rollback();
                    throw new Exception('MySQL Query Error with oc_product_special table: ' . $query->error);
                }

                $query->close();
            }

        } else {
            $query = $this->connection->prepare("DELETE FROM `oc_product_special` WHERE product_id = ?");
            $query->bind_param("i", $productId);

            if ($query->execute() === false) {
                $this->connection->rollback();
                throw new Exception('MySQL Query Error deleting from oc_product_special table: ' . $query->error);
            }
            $query->close();
        }

        $this->connection->commit();
    }

    public function disableProduct($productId)
    {
        $dateModified = date('Y-m-d H:i');
        $quantity = 0;
        $status = 0;
        $stockStatusId = 5;
        $productId = trim($productId);

        $this->connection->begin_transaction();
        
        $stmt = $this->connection->prepare("UPDATE oc_product SET quantity = ?, stock_status_id = ?, status = ?, date_modified = ? WHERE product_id = ?");
        $stmt->bind_param("iiisi", $quantity, $stockStatusId, $status, $dateModified, $productId);

        if ($stmt->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error updating the oc_product table: ' . $stmt->error);
        }

        $stmt->close();

        $this->connection->commit();
    }

    public function getAllProductsIDs()
    {
        $query = "SELECT product_id FROM oc_product";
        $result = $this->connection->query($query);

        $ids = [];

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                if (empty($row['product_id'])) {
                    continue;
                }

                $ids[] = $row['product_id'];
            }
        }

        return $ids;
    }

    public function getUnimportedOrders()
    {
        $query = "SELECT * FROM oc_order o JOIN oc_order_history oh ON o.order_id = oh.order_id WHERE oh.order_status_id <> 17";
        $result = $this->connection->query($query);

        $orders = [];
        
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $orders[] = $row;
            }
        }

        return $orders;
    }

    public function setOrderImported($orderId)
    {
        $this->connection->begin_transaction();
        
        $stmt = $this->connection->prepare("UPDATE oc_order_history SET order_status_id = 17 WHERE order_id = ?");
        $stmt->bind_param("i", $orderId);

        if ($stmt->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error updating the oc_order_history table: ' . $stmt->error);
        }

        $stmt->close();

        $this->connection->commit();
    }

    public function getProductsForOrder($orderId)
    {
        $query = "SELECT * FROM oc_order_product op WHERE op.order_id = ?";
        $stmt = $this->connection->prepare($query);
        $stmt->bind_param("i", $orderId);
        $stmt->execute();
        $result = $stmt->get_result();

        $products = [];
        
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $products[] = $row;
            }
        }

        return $products;
    }

    public function addCategory($id, $parentId, $name, $seoURL)
    {
        $top = 0;
        $column = 1;
        $status = 1;
        $dateNow = date('Y-m-d H:i');
        $level = 0;
        $languageId = 1;
        $description = '';
        $metaTitle = $name;
        $metaDescription = '';
        $metaKeyword = '';
        $storeId = 0;
        $layoutId = 0;
        $parentId = ($parentId == -1) ? 0 : $parentId;

        $name = trim($name);

        $this->connection->begin_transaction();

        // oc_category
        $stmt = $this->connection->prepare("INSERT INTO oc_category (category_id, parent_id, top, `column`, status, date_added, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("iiiiiss", $id, $parentId, $top, $column, $status, $dateNow, $dateNow);

        if ($stmt->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_category table: ' . $stmt->error);
        }

        $stmt->close();

        // oc_category_path
        // $stmt2 = $this->connection->prepare("INSERT INTO oc_category_path (category_id, path_id, level) VALUES (?, ?, ?)");
        // $stmt2->bind_param("iii", $id, $id, $level);

        // if ($stmt2->execute() === false) {
        //     $this->connection->rollback();
        //     throw new Exception('MySQL Query Error with oc_category_path table: ' . $stmt2->error);
        // }

        // $stmt2->close();

        // oc_category_description
        $stmt3 = $this->connection->prepare("INSERT INTO oc_category_description (category_id, language_id, name, description, meta_title, meta_description, meta_keyword) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt3->bind_param("iisssss", $id, $languageId, $name, $description, $metaTitle, $metaDescription, $metaKeyword);

        if ($stmt3->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_category_description table: ' . $stmt3->error);
        }

        $stmt3->close();

        // oc_category_to_layout
        $stmt4 = $this->connection->prepare("INSERT INTO oc_category_to_layout (category_id, store_id, layout_id) VALUES (?, ?, ?)");
        $stmt4->bind_param("iii", $id, $storeId, $layoutId);

        if ($stmt4->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_category_to_layout table: ' . $stmt4->error);
        }

        $stmt4->close();

        // oc_category_to_store
        $stmt5 = $this->connection->prepare("INSERT INTO oc_category_to_store (category_id, store_id) VALUES (?, ?)");
        $stmt5->bind_param("ii", $id, $storeId);

        if ($stmt5->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_category_to_store table: ' . $stmt5->error);
        }

        $stmt5->close();

        // oc_seo_url - add seo url
        $query = 'category_id=' . $id;
        $stmt6 = $this->connection->prepare("INSERT INTO oc_seo_url (store_id, language_id, query, keyword) VALUES (?, ?, ?, ?)");
        $stmt6->bind_param("iiss", $storeId, $languageId, $query, $seoURL);

        if ($stmt6->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_seo_url table: ' . $stmt6->error);
        }

        $stmt6->close();

        $this->connection->commit();
    }

    public function getCategoriesIDs()
    {
        $query = "SELECT DISTINCT category_id FROM oc_category";
        $result = $this->connection->query($query);

        $categories = [];

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                if (empty($row['category_id'])) {
                    continue;
                }

                $categories[] = $row['category_id'];
            }
        }

        return $categories;
    }

    public function updateCategory($id, $parentId, $name)
    {
        $dateModified = date('Y-m-d H:i');
        $status = 1;
        $parentId = ($parentId == -1) ? 0 : $parentId;

        $this->connection->begin_transaction();
        
        $stmt = $this->connection->prepare("UPDATE oc_category SET parent_id = ?, status = ?, date_modified = ? WHERE category_id = ?");
        $stmt->bind_param("iisi", $parentId, $status, $dateModified, $id);

        if ($stmt->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error updating the oc_category table: ' . $stmt->error);
        }
        $stmt->close();

        $stmt2 = $this->connection->prepare("UPDATE oc_category_description SET name = ?, meta_title = ? WHERE category_id = ?");
        $stmt2->bind_param("ssi", $name, $name, $id);

        if ($stmt2->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error updating the oc_category_description table: ' . $stmt2->error);
        }
        $stmt2->close();

        $this->connection->commit();
    }

    public function disableCategory($id)
    {
        $dateModified = date('Y-m-d H:i');
        $status = 0;

        $this->connection->begin_transaction();
        
        $stmt = $this->connection->prepare("UPDATE oc_category SET status = ?, date_modified = ? WHERE category_id = ?");
        $stmt->bind_param("isi", $status, $dateModified, $id);

        if ($stmt->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error updating the oc_category table: ' . $stmt->error);
        }
        $stmt->close();

        $this->connection->commit();
    }

    public function enableAllCategories()
    {
        $dateModified = date('Y-m-d H:i');
        $status = 1;

        $this->connection->begin_transaction();
        
        $stmt = $this->connection->prepare("UPDATE oc_category SET status = ?, date_modified = ?");
        $stmt->bind_param("is", $status, $dateModified);

        if ($stmt->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error updating the oc_category table: ' . $stmt->error);
        }
        $stmt->close();

        $this->connection->commit();
    }

    public function getCategoriesIDsWithProducts()
    {
        $query = "SELECT DISTINCT category_id FROM oc_product_to_category";
        $result = $this->connection->query($query);

        $categories = [];

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                if (empty($row['category_id'])) {
                    continue;
                }

                $categories[] = $row['category_id'];
            }
        }

        return $categories;
    }

    public function getAllCategories()
    {
        $query = "SELECT category_id, parent_id FROM oc_category";
        $result = $this->connection->query($query);

        $categories = [];

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $categories[] = $row;
            }
        }

        return $categories;
    }

    public function getCategoryHierarchy($categoryId, &$hierarchy = [])
    {
        $hierarchy[] = $categoryId;
 
        $query = "SELECT parent_id FROM oc_category WHERE category_id = $categoryId";
        $result = $this->connection->query($query);
        
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $parentId = $row["parent_id"];
            
            if ($parentId != 0) {
                
                $this->getCategoryHierarchy($parentId, $hierarchy);
            }
        }

        return $hierarchy;
    }

    public function createCategoryHierarchy($cat, $path, $level)
    {
        $this->connection->begin_transaction();
        // oc_category_path
        $stmt = $this->connection->prepare("INSERT INTO oc_category_path (category_id, path_id, level) VALUES (?, ?, ?)");
        $stmt->bind_param("iii", $cat, $path, $level);

        if ($stmt->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error with oc_category_path table: ' . $stmt->error);
        }

        $stmt->close();

        $this->connection->commit();
    }

    public function truncateCategoryPath()
    {
        $this->connection->begin_transaction();
        
        $stmt = $this->connection->prepare("TRUNCATE TABLE oc_category_path");
        
        if ($stmt->execute() === false) {
            $this->connection->rollback();
            throw new Exception('MySQL Query Error while truncating oc_category_path table: ' . $stmt->error);
        }
        
        $stmt->close();
        
        $this->connection->commit();
    }

    public function getHighestHierarchyLevel()
    {
        $query = "SELECT MAX(level) AS max_level FROM oc_category_path";
        $result = $this->connection->query($query);

        $row = $result->fetch_assoc();

        if (isset($row['max_level'])) {
            return intval($row['max_level']);
        } else {
            return 0;
        }
    }

    public function getCategoriesByLevel($level)
    {
        $query = "SELECT category_id FROM oc_category_path WHERE level = $level";
        $result = $this->connection->query($query);

        $categories = [];

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $categories[] = intval($row['category_id']);
            }
        }

        return $categories;
    }

    public function getChildCategoriesIDs($catId)
    {
        $query = "SELECT category_id FROM oc_category WHERE parent_id = $catId";
        $result = $this->connection->query($query);

        $categories = [];

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $categories[] = intval($row['category_id']);
            }
        }

        return $categories;
    }

}
