<?php
set_time_limit(1800);
ini_set('display_errors', true);
date_default_timezone_set('Europe/Sofia');

require_once('yanak_api.php');
require_once('manage_products.php');
require_once('helper_functions.php');

echo '<pre>';

if (php_sapi_name() == 'cli') {
    parse_str(implode('&', array_slice($argv, 1)), $_GET);
}

if (!isset($_GET['import_mode']) || empty($_GET['import_mode'])) {
    die('import_mode parameter not specified in URL. Use between import and update value.');
}

$imageDir = '/home/zhelev/public_html/kef4eto.com/image/catalog/imported-images/';

if (!file_exists($imageDir)) {
    mkdir($imageDir, 0755, true); 
}

$yanakAPI = new YanakApi();

$email = 'kef4eto@abv.bg'; //  
$username = 'webshop'; // 

$response = $yanakAPI->login($email, $username);

if ($response['success'] !== true) {
    logMessage('Login failed. Api returned : ' . print_r($response['error'], true));
    print_r($response['error']);
    die('Login failed');
}

if ($_GET['import_mode'] == 'import-products') {
    
    $offset = 0;
    $limit = 100;

    $db = new ManageProducts();

    do {
        $products = $yanakAPI->getProductsLite($offset, $limit);
        // var_dump($products);
        // die();

        if ($products['items_count'] == 0 ) {
            logMessage('No products. Api returned ' . print_r($products, true));
            print_r($products);
            break;
        }

        $importedProducts = 0;
        $stock_status_id = 0;
        $productWithImages = 0;

        foreach ($products['items'] as $key => $product) {
            
            try {

                $image = null;
                if ($product['image'] != NULL) {
                    $imageData = base64_decode($product['image']);

                    $fileName = 'product-' . $product['code'] . '.jpg';
                    $imagePath = $imageDir . $fileName;

                    if (file_put_contents($imagePath, $imageData) !== false) {
                        $image = strstr($imagePath, '/catalog');
                        $productWithImages++;
                    }

                }

                $stock_status_id = ($product['quantity'] > 0) ? 7 : 5;
                $seoURL = convertToURL($product['stk_name']);
                $db->addProduct($product['stk_idnumb'], $product['code'], $product['code_2'], $product['location'], $product['price'], $product['quantity'], $stock_status_id, $product['stk_name'], $product['description'], $seoURL, $image, $product['gr_id']);
                $importedProducts++;

            } catch (Exception $e) {
                echo 'Error importing product: ' . $e->getMessage() . PHP_EOL;
                logMessage('Error importing product: ' . $e->getMessage());
                echo 'Product: ' . $product['stk_name'] . ' Product SKU: ' . $product['code'] . PHP_EOL;
                logMessage('Product: ' . $product['stk_name'] . ' Product SKU: ' . $product['code']);
            }


            
        }

        $offset += $limit;

    } while ($offset < $products['items_count']);
    

    $db->disconnect();
    echo 'Products imported: ' . $importedProducts;
    logMessage('Import completed. Products imported: ' . $importedProducts);
    die();
}

if ($_GET['import_mode'] == 'update-products') {
 
    $offset = 0;
    $limit = 100;

    $categories = $yanakAPI->getActiveCategories();

    if (count($categories['items']) == 0) {
        logMessage('There are no active categories in YANAK warehouse');
        die('There are no active categories in YANAK warehouse');
    }
    
    $db = new ManageProducts();
    $productsSKUs = $db->getAllProductsIDs();

    if (empty($productsSKUs)) {
        logMessage('No products in database');
        die('No products in database');
    }

    $shopCategoriesIDs = $db->getCategoriesIDs();

    if (empty($shopCategoriesIDs)) {
        logMessage('No categories in database');
        die('No categories in database');
    }
    
    $updatedProducts = 0;
    $addedProducts = 0;
    $disabledProducts = 0;
    $stock_status_id = 0;
    $updatedCategories = 0;
    $addedCategories = 0;
    $disabledCategories = 0;
    $disabledCategoriesWithoutProducts = 0;

    foreach ($categories['items'] as $cat) {
        $categoryName = preg_replace('/^\d+\./', '', $cat['name']);
        $seoURL = convertToURL($categoryName);
        $categoryName = myucfirst(mb_strtolower($categoryName));

        try {

            if (in_array($cat['id'], $shopCategoriesIDs)) {
                $db->updateCategory($cat['id'], $cat['parentID'], $categoryName);
                $updatedCategories++;

                if (($key = array_search($cat['id'], $shopCategoriesIDs)) !== false) {
                    unset($shopCategoriesIDs[$key]);
                }

            } else {
                $db->addCategory($cat['id'], $cat['parentID'], $categoryName, $seoURL);
                $addedCategories++;
            }

        } catch (Exception $e) {
            echo 'Error updating/inserting categories: ' . $e->getMessage() . PHP_EOL;
            logMessage('Error updating/inserting categories: ' . $e->getMessage());
            echo 'Category: ' . $categoryName . ' Category ID: ' . $cat['id'] . PHP_EOL;
            logMessage('Category: ' . $categoryName . ' Category ID: ' . $cat['id']);
        }    
    }

    foreach ($shopCategoriesIDs as $catID) {
        $db->disableCategory($catID);
        $disabledCategories++;
    }

    echo 'Categories updated: ' . $updatedCategories . PHP_EOL;
    echo 'Categories added: ' . $addedCategories . PHP_EOL;
    echo 'Categories disabled: ' . $disabledCategories . PHP_EOL;
    logMessage('Categories updated: ' . $updatedCategories);
    logMessage('Categories added: ' . $addedCategories);
    logMessage('Categories disabled: ' . $disabledCategories);

    do {

        $products = $yanakAPI->getProductsLite($offset, $limit);

        if ($products['items_count'] == 0 ) {
            logMessage('No products. Api returned ' . $products);
            print_r($products);
            die();
        }


        foreach ($products['items'] as $key => $product) {

            try {

                $image = null;
                if ($product['image'] != NULL) {
                    $imageData = base64_decode($product['image']);
                    
                    $fileName = 'product-' . $product['code'] . '.jpg';
                    $imagePath = $imageDir . $fileName;
                    
                    if (file_put_contents($imagePath, $imageData) !== false) {
                        $image = strstr($imagePath, '/catalog');
                    }

                }

                $stock_status_id = ($product['quantity'] > 0) ? 7 : 5;

                $promoPrice = null;
                if (!empty($product['price_list_name']) && $product['quantity'] > 0) {
                    $promoPrice = $product['price'];
                    logMessage('Promo product to be added with product id : ' . $product['stk_idnumb']);
                }

                if (in_array($product['stk_idnumb'], $productsSKUs)) {
                    $db->updateProduct($product['stk_idnumb'], $product['quantity'], $stock_status_id, $product['basic_price'], $product['stk_name'], $image, $product['description'], $promoPrice, $product['gr_id']);
                    $updatedProducts++;

                    //remove product id value from productsSKUs array
                    if (($key = array_search($product['stk_idnumb'], $productsSKUs)) !== false) {
                        unset($productsSKUs[$key]);
                    }
                } else {
                    $seoURL = convertToURL($product['stk_name']);
                    $db->addProduct($product['stk_idnumb'], $product['code'], $product['code_2'], $product['location'], $product['basic_price'], $product['quantity'], $stock_status_id, $product['stk_name'], $product['description'], $seoURL, $image, $promoPrice, $product['gr_id']);
                    $addedProducts++;
                }
                

            } catch (Exception $e) {
                echo 'Error updating/inserting product: ' . $e->getMessage() . PHP_EOL;
                logMessage('Error updating/inserting product: ' . $e->getMessage());
                echo 'Product: ' . $product['stk_name'] . ' Product SKU: ' . $product['code'] . ' Product id: ' . $product['stk_idnumb'] . PHP_EOL;
                logMessage('Product: ' . $product['stk_name'] . ' Product SKU: ' . $product['code'] . ' Product id: ' . $product['stk_idnumb']);
            }
            
        }

        $offset += $limit;

    } while ($offset < $products['items_count']);

    foreach ($productsSKUs as $id) {
        $db->disableProduct($id);
        $disabledProducts++;
    }
    
    $allCats = $db->getAllCategories();
    $db->truncateCategoryPath();

    foreach ($allCats as $cat) {
        $categoryHierarchyArr = $db->getCategoryHierarchy($cat['category_id']);
        
        $level = count($categoryHierarchyArr) - 1;

        foreach ($categoryHierarchyArr as $parentId) {
            $db->createCategoryHierarchy($cat['category_id'], $parentId, $level);
            $level--;
        }
    }

    $maxLevel = $db->getHighestHierarchyLevel();
    $catsWithProductsIDs = $db->getCategoriesIDsWithProducts();

    for ($i = $maxLevel; $i >= 0 ; $i--) {
        $categoriesForLevel = $db->getCategoriesByLevel($i);
        foreach ($categoriesForLevel as $category) {

            if (in_array($category, $catsWithProductsIDs)) {
                continue;
            }

            if ($i != $maxLevel) {
                $childCategoriesIDs = $db->getChildCategoriesIDs($category);
                foreach ($childCategoriesIDs as $childCat) {
                    if (in_array($childCat, $catsWithProductsIDs)) {
                        continue 2;
                    }
                }
            }

            $db->disableCategory($category);
            $disabledCategoriesWithoutProducts++;
        }
    }
    
    echo 'Disabled categories without products: ' . $disabledCategoriesWithoutProducts . PHP_EOL;
    logMessage('Disabled categories without products: ' . $disabledCategoriesWithoutProducts);

    $db->disconnect();
    echo 'Products updated: ' . $updatedProducts . PHP_EOL;
    echo 'Products added: ' . $addedProducts . PHP_EOL;
    echo 'Products disabled: ' . $disabledProducts . PHP_EOL;
    logMessage('Products updated: ' . $updatedProducts);
    logMessage('Products added: ' . $addedProducts);
    logMessage('Products disabled: ' . $disabledProducts);
    die();
}

if ($_GET['import_mode'] == 'import-categories') {
    
    $categories = $yanakAPI->getActiveCategories();

    if (!empty($categories['items']) && count($categories['items']) > 0) {
        $db = new ManageProducts();
        $importedCategories = 0;

        foreach($categories['items'] as $cat) {
            $categoryName = preg_replace('/^\d+\./', '', $cat['name']);
            $seoURL = convertToURL($categoryName);
            $categoryName = myucfirst(mb_strtolower($categoryName));
            
            $db->addCategory($cat['id'], $cat['parentID'], $categoryName, $seoURL);
            $importedCategories++;
        }

        $db->disconnect();
        echo 'Categories imported: ' . $importedCategories . PHP_EOL;
        die();
    }

    
    die('No categories found');
}

if ($_GET['import_mode'] == 'import-orders') {
    
    die('import orders method is not enabled');
    $db = new ManageProducts();
    $unimportedOrders = $db->getUnimportedOrders();

    if (empty($unimportedOrders)) {
        die('No orders to sync');
    }
    $importedOrders = 0;

    foreach ($unimportedOrders as $order) {
        $sessionID = md5(uniqid());
        
        try {
            $products = $db->getProductsForOrder((int)$order['order_id']);
            // var_dump($products);
            foreach ($products as $product) {
                // $addToCart = $yanakAPI->addProductToCart('315', '11', $sessionID);
                $addToCart = $yanakAPI->addProductToCart($product['product_id'], $product['quantity'], $sessionID);
                // var_dump($addToCart);
                if (!$addToCart['success']) {
                    echo 'Error adding product to cart: ' . $addToCart['error']['message'] . PHP_EOL;
                }
                
            }

            $createOrder = $yanakAPI->createOrder($order['total'], $order['customer_id'], $order['email'], $order['ip'], $sessionID);
            // $createOrder = $yanakAPI->createOrder('1513.99', $order['email'], $order['ip'], $sessionID);
            // var_dump($createOrder);
            if (!$createOrder['success']) {
                echo 'Error creating order: ' . $createOrder['error']['message'] . PHP_EOL;
            }

        } catch (Exception $e) {
            echo 'Error importing order: ' . $e->getMessage() . PHP_EOL;
        }

        $db->setOrderImported($order['order_id']);
        $importedOrders++;
    }

    echo 'Orders imported: ' . $importedOrders . PHP_EOL;
    die();
}

logMessage('choose any import_mode');
die('choose any import_mode');
