<?php

class YanakApi
{
    const LOGIN_URL = 'https://api.eyanak.com:3233/e-shop/api/login';
    const PRODUCTS_LITE = 'https://api.eyanak.com:3233/e-shop/api/getstockslite';
    const ACTIVE_CATEGORIES = 'https://api.eyanak.com:3233/e-shop/api/groups';
    const ADD_TO_CART = 'https://api.eyanak.com:3233/e-shop/api/cart';
    const ADD_TO_CART_B = 'https://api.eyanak.com:3233/e-shop/api/cart_b';
    const CREATE_ORDER = 'https://api.eyanak.com:3233/e-shop/api/order';

    private $headers;

    public function __construct()
    {
        $this->headers = [
            'Content-Type: application/json',
        ];
    }

    public function setHeader($name, $value)
    {
        $this->headers[] = $name . ': ' . $value;
    }

    public function sendRequest($endpoint, $method = 'GET', $data = [])
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $endpoint);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 0); 
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_LOW_SPEED_TIME, 0);
        curl_setopt($ch, CURLOPT_LOW_SPEED_LIMIT, 0);


        
        if ($method !== 'GET') {
            $postData = json_encode($data);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        }

        if (!empty($this->headers)) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $this->headers);
        }

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception('cURL Error: ' . curl_error($ch));
        }

        curl_close($ch);

        return $response;
    }

    public function login($email, $username)
    {
        $data = [
            'email' => $email,
            'username' => $username
        ];
        
        $response = $this->sendRequest(self::LOGIN_URL, 'POST', $data);
        
        $responseData = json_decode($response, true);

        if (isset($responseData['token'])) {
            $token = $responseData['token'];
            $this->setHeader('Authorization', 'Bearer ' . $token);
        }

        return $responseData;
    }

    public function getProductsLite($offset, $limit)
    {
        $data = [
            'get_pictures' => true,
            'begin_row_number' => $offset,
            'rows_count' => $limit
        ];

        $response = $this->sendRequest(self::PRODUCTS_LITE, 'POST', $data);

        return json_decode($response, true);
    }

    public function getLastChangedProducts()
    {
        $data = [
            'last_change_date' => date('d.m.Y 00:00:00', strtotime('-1 day')),
        ];
        
        $response = $this->sendRequest(self::PRODUCTS_LITE, 'POST', $data);

        return json_decode($response, true);
    }

    public function getActiveCategories()
    {
        $response = $this->sendRequest(self::ACTIVE_CATEGORIES, 'GET', []);

        return json_decode($response, true);
    }

    public function addProductToCart($productID, $quantity, $sessionID)
    {
        $data = [
            'sessionID' => $sessionID,
            'stockID' => $productID,
            'customerID' => '0',
            'quantity' => $quantity,
            'information' => '',
            'additions' => [],
            'rootStockID' => '-1',
            'is_eshop' => 'true',
            'selbuy_id' => '0'
        ];

        $response = $this->sendRequest(self::ADD_TO_CART, 'POST', $data);
        
        return json_decode($response, true);
    }

    public function createOrder($total, $customerEmail, $ip, $sessionID)
    {
        $data = [
            'sessionID' => $sessionID,
            'ip' => $ip,
            'warehouseID' => '',
            'email' => $customerEmail,
            'customerID' => '0',
            'total' => $total,
            'paymentMethod' => '1',
            'orderInfo' => '',
            'FiscalDevice' => '1',
            'FiscalDeviceID' => '1',
            'IPAdress' => '',
            'port' => '',
            'send_api_mail' => 'true'
        ];

        $response = $this->sendRequest(self::CREATE_ORDER, 'POST', $data);

        return json_decode($response, true);
    }

}