-- MySQL dump 10.13  Distrib 5.7.44, for Linux (x86_64)
--
-- Host: localhost    Database: zhelev_debug_kef4eto
-- ------------------------------------------------------
-- Server version	5.7.44-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `oc_address`
--

DROP TABLE IF EXISTS `oc_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_address` (
  `address_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `firstname` varchar(32) NOT NULL,
  `lastname` varchar(32) NOT NULL,
  `company` varchar(40) NOT NULL,
  `address_1` varchar(128) NOT NULL,
  `address_2` varchar(128) NOT NULL,
  `city` varchar(128) NOT NULL,
  `postcode` varchar(10) NOT NULL,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `zone_id` int(11) NOT NULL DEFAULT '0',
  `custom_field` text NOT NULL,
  PRIMARY KEY (`address_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_address`
--

LOCK TABLES `oc_address` WRITE;
/*!40000 ALTER TABLE `oc_address` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_address` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_api`
--

DROP TABLE IF EXISTS `oc_api`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_api` (
  `api_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(64) NOT NULL,
  `key` text NOT NULL,
  `status` tinyint(1) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`api_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_api`
--

LOCK TABLES `oc_api` WRITE;
/*!40000 ALTER TABLE `oc_api` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_api` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_api_ip`
--

DROP TABLE IF EXISTS `oc_api_ip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_api_ip` (
  `api_ip_id` int(11) NOT NULL AUTO_INCREMENT,
  `api_id` int(11) NOT NULL,
  `ip` varchar(40) NOT NULL,
  PRIMARY KEY (`api_ip_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_api_ip`
--

LOCK TABLES `oc_api_ip` WRITE;
/*!40000 ALTER TABLE `oc_api_ip` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_api_ip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_api_session`
--

DROP TABLE IF EXISTS `oc_api_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_api_session` (
  `api_session_id` int(11) NOT NULL AUTO_INCREMENT,
  `api_id` int(11) NOT NULL,
  `session_id` varchar(32) NOT NULL,
  `ip` varchar(40) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`api_session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_api_session`
--

LOCK TABLES `oc_api_session` WRITE;
/*!40000 ALTER TABLE `oc_api_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_api_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_attribute`
--

DROP TABLE IF EXISTS `oc_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_attribute` (
  `attribute_id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_group_id` int(11) NOT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`attribute_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_attribute`
--

LOCK TABLES `oc_attribute` WRITE;
/*!40000 ALTER TABLE `oc_attribute` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_attribute_description`
--

DROP TABLE IF EXISTS `oc_attribute_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_attribute_description` (
  `attribute_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY (`attribute_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_attribute_description`
--

LOCK TABLES `oc_attribute_description` WRITE;
/*!40000 ALTER TABLE `oc_attribute_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_attribute_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_attribute_group`
--

DROP TABLE IF EXISTS `oc_attribute_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_attribute_group` (
  `attribute_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`attribute_group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_attribute_group`
--

LOCK TABLES `oc_attribute_group` WRITE;
/*!40000 ALTER TABLE `oc_attribute_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_attribute_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_attribute_group_description`
--

DROP TABLE IF EXISTS `oc_attribute_group_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_attribute_group_description` (
  `attribute_group_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY (`attribute_group_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_attribute_group_description`
--

LOCK TABLES `oc_attribute_group_description` WRITE;
/*!40000 ALTER TABLE `oc_attribute_group_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_attribute_group_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_banner`
--

DROP TABLE IF EXISTS `oc_banner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_banner` (
  `banner_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`banner_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_banner`
--

LOCK TABLES `oc_banner` WRITE;
/*!40000 ALTER TABLE `oc_banner` DISABLE KEYS */;
INSERT INTO `oc_banner` (`banner_id`, `name`, `status`) VALUES (6,'HP Products',1),(7,'Home Page Slideshow',1),(8,'Manufacturers',1);
/*!40000 ALTER TABLE `oc_banner` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_banner_image`
--

DROP TABLE IF EXISTS `oc_banner_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_banner_image` (
  `banner_image_id` int(11) NOT NULL AUTO_INCREMENT,
  `banner_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `title` varchar(64) NOT NULL,
  `link` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`banner_image_id`)
) ENGINE=MyISAM AUTO_INCREMENT=122 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_banner_image`
--

LOCK TABLES `oc_banner_image` WRITE;
/*!40000 ALTER TABLE `oc_banner_image` DISABLE KEYS */;
INSERT INTO `oc_banner_image` (`banner_image_id`, `banner_id`, `language_id`, `title`, `link`, `image`, `sort_order`) VALUES (118,7,1,'Кефчето 2','','catalog/homepage-slider/slider-4.jpg',1),(87,6,1,'HP Banner','index.php?route=product/manufacturer/info&amp;manufacturer_id=7','catalog/demo/compaq_presario.jpg',0),(108,8,1,'Dual power','','catalog/manufacturers/dual-power.jpg',0),(107,8,1,'Dermomed','','catalog/manufacturers/dermomed.jpg',0),(106,8,1,'Dash','','catalog/manufacturers/dash.jpg',0),(105,8,1,'Chanteclair','','catalog/manufacturers/chanteclair.jpg',0),(104,8,1,'Casablanca','','catalog/manufacturers/casablanca.jpg',0),(103,8,1,'Bros','','catalog/manufacturers/bros.jpg',0),(102,8,1,'Borcam','','catalog/manufacturers/borcam.jpg',0),(101,8,1,'Ariel','','catalog/manufacturers/ariel.jpg',0),(117,7,1,'Кефчето 1','','catalog/homepage-slider/slider-5.jpg',0),(100,8,1,'Aquaphor','','catalog/manufacturers/aquaphor.jpg',0),(99,8,1,'ABC','','catalog/manufacturers/abc.jpg',0),(109,8,1,'Fino','','catalog/manufacturers/fino.jpg',0),(110,8,1,'Lenor','','catalog/manufacturers/lenor.jpg',0),(111,8,1,'Medix','','catalog/manufacturers/medix.jpg',0),(112,8,1,'Persil','','catalog/manufacturers/persil.jpg',0),(113,8,1,'Sano','','catalog/manufacturers/sano.jpg',0),(114,8,1,'Tesori d\'Oriente','','catalog/manufacturers/tesori.jpg',0),(115,8,1,'Tex','','catalog/manufacturers/tex.jpg',0),(116,8,1,'Yumos','','catalog/manufacturers/yumos.jpg',0),(119,7,1,'Кефчето 3','','catalog/homepage-slider/slider-3.jpg',2),(120,7,1,'Кефчето 4','','catalog/homepage-slider/slider-6.jpg',3),(121,7,1,'Кефчето 5','','catalog/homepage-slider/slider-2.jpg',4);
/*!40000 ALTER TABLE `oc_banner_image` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_cart`
--

DROP TABLE IF EXISTS `oc_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_cart` (
  `cart_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `api_id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `session_id` varchar(32) NOT NULL,
  `product_id` int(11) NOT NULL,
  `recurring_id` int(11) NOT NULL,
  `option` text NOT NULL,
  `quantity` int(5) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`cart_id`),
  KEY `cart_id` (`api_id`,`customer_id`,`session_id`,`product_id`,`recurring_id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_cart`
--

LOCK TABLES `oc_cart` WRITE;
/*!40000 ALTER TABLE `oc_cart` DISABLE KEYS */;
INSERT INTO `oc_cart` (`cart_id`, `api_id`, `customer_id`, `session_id`, `product_id`, `recurring_id`, `option`, `quantity`, `date_added`) VALUES (13,0,5,'9dd6e9b345c76e6be81722f0d1',3042,0,'[]',1,'2024-05-09 12:37:50'),(15,0,11,'9dd6e9b345c76e6be81722f0d1',3042,0,'[]',2,'2024-05-09 12:50:07'),(17,0,12,'9dd6e9b345c76e6be81722f0d1',2538,0,'[]',1,'2024-05-09 12:51:46'),(19,0,13,'9dd6e9b345c76e6be81722f0d1',3042,0,'[]',1,'2024-05-09 13:01:35'),(20,0,14,'9dd6e9b345c76e6be81722f0d1',306,0,'[]',1,'2024-05-09 14:08:07');
/*!40000 ALTER TABLE `oc_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_category`
--

DROP TABLE IF EXISTS `oc_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(255) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `top` tinyint(1) NOT NULL,
  `column` int(3) NOT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM AUTO_INCREMENT=97 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_category`
--

LOCK TABLES `oc_category` WRITE;
/*!40000 ALTER TABLE `oc_category` DISABLE KEYS */;
INSERT INTO `oc_category` (`category_id`, `image`, `parent_id`, `top`, `column`, `sort_order`, `status`, `date_added`, `date_modified`) VALUES (3,'catalog/imported-images/product-6421937000019.jpg',94,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(4,'catalog/imported-images/product-2400000000013.jpg',94,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(10,'catalog/imported-images/product-3800163900899.jpg',94,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(20,NULL,0,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(24,'catalog/imported-images/product-8695122002531.jpg',94,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(25,'catalog/imported-images/product-8693357361300.jpg',30,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(28,'catalog/imported-images/product-3800208723513.jpg',94,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(30,NULL,0,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(31,'catalog/imported-images/product-2090009154314.jpg',30,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(33,'catalog/imported-images/product-4895139208467.jpg',48,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(35,'catalog/imported-images/product-680678151169.jpg',30,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(38,'catalog/imported-images/product-5903355000983.jpg',44,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(44,NULL,0,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(47,'catalog/imported-images/product-8696033306589.jpg',94,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(48,NULL,0,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(49,'catalog/imported-images/product-3800501924198.jpg',30,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(55,'catalog/imported-images/product-06679.jpg',44,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(62,'catalog/manufacturers/aquaphor.jpg',94,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(64,NULL,94,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(71,NULL,0,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(72,'catalog/imported-images/product-8683130018644.jpg',71,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(73,'catalog/imported-images/product-3800069404385.jpg',71,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(74,'catalog/imported-images/product-8008731003484.jpg',71,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(75,'catalog/imported-images/product-96086223.jpg',71,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(76,'catalog/imported-images/product-3800090304524.jpg',71,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(77,'catalog/imported-images/product-3800144800392.jpg',71,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(78,'catalog/imported-images/product-3800144804987.jpg',71,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(79,NULL,0,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(80,'catalog/imported-images/product-158663.jpg',79,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(81,'catalog/imported-images/product-4895139230918.jpg',79,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(82,'catalog/imported-images/product-8699300960033.jpg',79,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(83,'catalog/imported-images/product-6954125108001.jpg',79,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(84,'catalog/imported-images/product-4895139228816.jpg',79,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(85,'catalog/imported-images/product-69801.jpg',79,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(93,'catalog/imported-images/product-10311.jpg',30,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(94,NULL,0,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(95,'catalog/imported-images/product-8699863050011.jpg',94,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00'),(96,NULL,94,0,1,0,1,'2024-01-30 13:14:00','2024-06-27 16:00:00');
/*!40000 ALTER TABLE `oc_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_category_description`
--

DROP TABLE IF EXISTS `oc_category_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_category_description` (
  `category_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `meta_title` varchar(255) NOT NULL,
  `meta_description` varchar(255) NOT NULL,
  `meta_keyword` varchar(255) NOT NULL,
  PRIMARY KEY (`category_id`,`language_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_category_description`
--

LOCK TABLES `oc_category_description` WRITE;
/*!40000 ALTER TABLE `oc_category_description` DISABLE KEYS */;
INSERT INTO `oc_category_description` (`category_id`, `language_id`, `name`, `description`, `meta_title`, `meta_description`, `meta_keyword`) VALUES (3,1,'Пластмаса','','Пластмаса','',''),(4,1,'Мушама и декомарин','','Мушама и декомарин','',''),(10,1,'Саксии и сандъчета','','Саксии и сандъчета','',''),(20,1,'Консумативи','','Консумативи','',''),(24,1,'Закачалки','','Закачалки','',''),(25,1,'Оливерници, бутилки солници, салфетници, кани','','Оливерници, бутилки солници, салфетници, кани','',''),(28,1,'Сушилници за дрехи и маси за гладене','','Сушилници за дрехи и маси за гладене','',''),(30,1,'Сервиране','','Сервиране','',''),(31,1,'Чинии','','Чинии','',''),(33,1,'Ел.уреди','','Ел.уреди','',''),(35,1,'Чаши','','Чаши','',''),(38,1,'Почистване','','Почистване','',''),(44,1,'Баня, почистване и тоалетна','','Баня, почистване и тоалетна','',''),(47,1,'Чехли','','Чехли','',''),(48,1,'Електрически уреди и материали','','Електрически уреди и материали','',''),(49,1,'Еднократни','','Еднократни','',''),(55,1,'Хавлии и покривки','','Хавлии и покривки','',''),(62,1,'Аквафор','','Аквафор','',''),(64,1,'Торбички за прахосмукачки и филтри','','Торбички за прахосмукачки и филтри','',''),(71,1,'Препарати','','Препарати','',''),(72,1,'Перилни препарати','','Перилни препарати','',''),(73,1,'Препарати за съдове','','Препарати за съдове','',''),(74,1,'Почистващи препарати','','Почистващи препарати','',''),(75,1,'Грижа за тялото и косата','','Грижа за тялото и косата','',''),(76,1,'Санитарни материали и консумативи','','Санитарни материали и консумативи','',''),(77,1,'Ароматизатори','','Ароматизатори','',''),(78,1,'Препарати за насекоми и цветя','','Препарати за насекоми и цветя','',''),(79,1,'Готвене','','Готвене','',''),(80,1,'Тенджери, тави и огнеупорни','','Тенджери, тави и огнеупорни','',''),(81,1,'Тигани и касероли','','Тигани и касероли','',''),(82,1,'Рендета, гевгири, капаци и мелнички','','Рендета, гевгири, капаци и мелнички','',''),(83,1,'Кафеварки и чайници','','Кафеварки и чайници','',''),(84,1,'Ножове, точила, стойки и дъски','','Ножове, точила, стойки и дъски','',''),(85,1,'Форми за печене','','Форми за печене','',''),(93,1,'Прибори','','Прибори','',''),(94,1,'Домашни потреби','','Домашни потреби','',''),(95,1,'Разни','','Разни','',''),(96,1,'Пепелници','','Пепелници','','');
/*!40000 ALTER TABLE `oc_category_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_category_filter`
--

DROP TABLE IF EXISTS `oc_category_filter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_category_filter` (
  `category_id` int(11) NOT NULL,
  `filter_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`,`filter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_category_filter`
--

LOCK TABLES `oc_category_filter` WRITE;
/*!40000 ALTER TABLE `oc_category_filter` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_category_filter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_category_path`
--

DROP TABLE IF EXISTS `oc_category_path`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_category_path` (
  `category_id` int(11) NOT NULL,
  `path_id` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  PRIMARY KEY (`category_id`,`path_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_category_path`
--

LOCK TABLES `oc_category_path` WRITE;
/*!40000 ALTER TABLE `oc_category_path` DISABLE KEYS */;
INSERT INTO `oc_category_path` (`category_id`, `path_id`, `level`) VALUES (3,3,1),(3,94,0),(4,4,1),(4,94,0),(10,10,1),(10,94,0),(20,20,0),(24,24,1),(24,94,0),(25,25,1),(25,30,0),(28,28,1),(28,94,0),(30,30,0),(31,31,1),(31,30,0),(33,33,1),(33,48,0),(35,35,1),(35,30,0),(38,38,1),(38,44,0),(44,44,0),(47,47,1),(47,94,0),(48,48,0),(49,49,1),(49,30,0),(55,55,1),(55,44,0),(62,62,1),(62,94,0),(64,64,1),(64,94,0),(71,71,0),(72,72,1),(72,71,0),(73,73,1),(73,71,0),(74,74,1),(74,71,0),(75,75,1),(75,71,0),(76,76,1),(76,71,0),(77,77,1),(77,71,0),(78,78,1),(78,71,0),(79,79,0),(80,80,1),(80,79,0),(81,81,1),(81,79,0),(82,82,1),(82,79,0),(83,83,1),(83,79,0),(84,84,1),(84,79,0),(85,85,1),(85,79,0),(93,93,1),(93,30,0),(94,94,0),(95,95,1),(95,94,0),(96,96,1),(96,94,0);
/*!40000 ALTER TABLE `oc_category_path` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_category_to_layout`
--

DROP TABLE IF EXISTS `oc_category_to_layout`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_category_to_layout` (
  `category_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  `layout_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_category_to_layout`
--

LOCK TABLES `oc_category_to_layout` WRITE;
/*!40000 ALTER TABLE `oc_category_to_layout` DISABLE KEYS */;
INSERT INTO `oc_category_to_layout` (`category_id`, `store_id`, `layout_id`) VALUES (3,0,0),(4,0,0),(10,0,0),(20,0,0),(24,0,0),(25,0,0),(28,0,0),(30,0,0),(31,0,0),(33,0,0),(35,0,0),(38,0,0),(44,0,0),(47,0,0),(48,0,0),(49,0,0),(55,0,0),(62,0,0),(64,0,0),(71,0,0),(72,0,0),(73,0,0),(74,0,0),(75,0,0),(76,0,0),(77,0,0),(78,0,0),(79,0,0),(80,0,0),(81,0,0),(82,0,0),(83,0,0),(84,0,0),(85,0,0),(93,0,0),(94,0,0),(95,0,0),(96,0,0);
/*!40000 ALTER TABLE `oc_category_to_layout` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_category_to_store`
--

DROP TABLE IF EXISTS `oc_category_to_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_category_to_store` (
  `category_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_category_to_store`
--

LOCK TABLES `oc_category_to_store` WRITE;
/*!40000 ALTER TABLE `oc_category_to_store` DISABLE KEYS */;
INSERT INTO `oc_category_to_store` (`category_id`, `store_id`) VALUES (3,0),(4,0),(10,0),(20,0),(24,0),(25,0),(28,0),(30,0),(31,0),(33,0),(35,0),(38,0),(44,0),(47,0),(48,0),(49,0),(55,0),(62,0),(64,0),(71,0),(72,0),(73,0),(74,0),(75,0),(76,0),(77,0),(78,0),(79,0),(80,0),(81,0),(82,0),(83,0),(84,0),(85,0),(93,0),(94,0),(95,0),(96,0);
/*!40000 ALTER TABLE `oc_category_to_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_country`
--

DROP TABLE IF EXISTS `oc_country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_country` (
  `country_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `iso_code_2` varchar(2) NOT NULL,
  `iso_code_3` varchar(3) NOT NULL,
  `address_format` text NOT NULL,
  `postcode_required` tinyint(1) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`country_id`)
) ENGINE=MyISAM AUTO_INCREMENT=258 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_country`
--

LOCK TABLES `oc_country` WRITE;
/*!40000 ALTER TABLE `oc_country` DISABLE KEYS */;
INSERT INTO `oc_country` (`country_id`, `name`, `iso_code_2`, `iso_code_3`, `address_format`, `postcode_required`, `status`) VALUES (1,'Afghanistan','AF','AFG','',0,1),(2,'Albania','AL','ALB','',0,1),(3,'Algeria','DZ','DZA','',0,1),(4,'American Samoa','AS','ASM','',0,1),(5,'Andorra','AD','AND','',0,1),(6,'Angola','AO','AGO','',0,1),(7,'Anguilla','AI','AIA','',0,1),(8,'Antarctica','AQ','ATA','',0,1),(9,'Antigua and Barbuda','AG','ATG','',0,1),(10,'Argentina','AR','ARG','',0,1),(11,'Armenia','AM','ARM','',0,1),(12,'Aruba','AW','ABW','',0,1),(13,'Australia','AU','AUS','',0,1),(14,'Austria','AT','AUT','',0,1),(15,'Azerbaijan','AZ','AZE','',0,1),(16,'Bahamas','BS','BHS','',0,1),(17,'Bahrain','BH','BHR','',0,1),(18,'Bangladesh','BD','BGD','',0,1),(19,'Barbados','BB','BRB','',0,1),(20,'Belarus','BY','BLR','',0,1),(21,'Belgium','BE','BEL','{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{postcode} {city}\r\n{country}',0,1),(22,'Belize','BZ','BLZ','',0,1),(23,'Benin','BJ','BEN','',0,1),(24,'Bermuda','BM','BMU','',0,1),(25,'Bhutan','BT','BTN','',0,1),(26,'Bolivia','BO','BOL','',0,1),(27,'Bosnia and Herzegovina','BA','BIH','',0,1),(28,'Botswana','BW','BWA','',0,1),(29,'Bouvet Island','BV','BVT','',0,1),(30,'Brazil','BR','BRA','',0,1),(31,'British Indian Ocean Territory','IO','IOT','',0,1),(32,'Brunei Darussalam','BN','BRN','',0,1),(33,'България','BG','BGR','',0,1),(34,'Burkina Faso','BF','BFA','',0,1),(35,'Burundi','BI','BDI','',0,1),(36,'Cambodia','KH','KHM','',0,1),(37,'Cameroon','CM','CMR','',0,1),(38,'Canada','CA','CAN','',0,1),(39,'Cape Verde','CV','CPV','',0,1),(40,'Cayman Islands','KY','CYM','',0,1),(41,'Central African Republic','CF','CAF','',0,1),(42,'Chad','TD','TCD','',0,1),(43,'Chile','CL','CHL','',0,1),(44,'China','CN','CHN','',0,1),(45,'Christmas Island','CX','CXR','',0,1),(46,'Cocos (Keeling) Islands','CC','CCK','',0,1),(47,'Colombia','CO','COL','',0,1),(48,'Comoros','KM','COM','',0,1),(49,'Congo','CG','COG','',0,1),(50,'Cook Islands','CK','COK','',0,1),(51,'Costa Rica','CR','CRI','',0,1),(52,'Cote D\'Ivoire','CI','CIV','',0,1),(53,'Croatia','HR','HRV','',0,1),(54,'Cuba','CU','CUB','',0,1),(55,'Cyprus','CY','CYP','',0,1),(56,'Czech Republic','CZ','CZE','',0,1),(57,'Denmark','DK','DNK','',0,1),(58,'Djibouti','DJ','DJI','',0,1),(59,'Dominica','DM','DMA','',0,1),(60,'Dominican Republic','DO','DOM','',0,1),(61,'East Timor','TL','TLS','',0,1),(62,'Ecuador','EC','ECU','',0,1),(63,'Egypt','EG','EGY','',0,1),(64,'El Salvador','SV','SLV','',0,1),(65,'Equatorial Guinea','GQ','GNQ','',0,1),(66,'Eritrea','ER','ERI','',0,1),(67,'Estonia','EE','EST','',0,1),(68,'Ethiopia','ET','ETH','',0,1),(69,'Falkland Islands (Malvinas)','FK','FLK','',0,1),(70,'Faroe Islands','FO','FRO','',0,1),(71,'Fiji','FJ','FJI','',0,1),(72,'Finland','FI','FIN','',0,1),(74,'France, Metropolitan','FR','FRA','{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{postcode} {city}\r\n{country}',1,1),(75,'French Guiana','GF','GUF','',0,1),(76,'French Polynesia','PF','PYF','',0,1),(77,'French Southern Territories','TF','ATF','',0,1),(78,'Gabon','GA','GAB','',0,1),(79,'Gambia','GM','GMB','',0,1),(80,'Georgia','GE','GEO','',0,1),(81,'Germany','DE','DEU','{company}\r\n{firstname} {lastname}\r\n{address_1}\r\n{address_2}\r\n{postcode} {city}\r\n{country}',1,1),(82,'Ghana','GH','GHA','',0,1),(83,'Gibraltar','GI','GIB','',0,1),(84,'Greece','GR','GRC','',0,1),(85,'Greenland','GL','GRL','',0,1),(86,'Grenada','GD','GRD','',0,1),(87,'Guadeloupe','GP','GLP','',0,1),(88,'Guam','GU','GUM','',0,1),(89,'Guatemala','GT','GTM','',0,1),(90,'Guinea','GN','GIN','',0,1),(91,'Guinea-Bissau','GW','GNB','',0,1),(92,'Guyana','GY','GUY','',0,1),(93,'Haiti','HT','HTI','',0,1),(94,'Heard and Mc Donald Islands','HM','HMD','',0,1),(95,'Honduras','HN','HND','',0,1),(96,'Hong Kong','HK','HKG','',0,1),(97,'Hungary','HU','HUN','',0,1),(98,'Iceland','IS','ISL','',0,1),(99,'India','IN','IND','',0,1),(100,'Indonesia','ID','IDN','',0,1),(101,'Iran (Islamic Republic of)','IR','IRN','',0,1),(102,'Iraq','IQ','IRQ','',0,1),(103,'Ireland','IE','IRL','',0,1),(104,'Israel','IL','ISR','',0,1),(105,'Italy','IT','ITA','',0,1),(106,'Jamaica','JM','JAM','',0,1),(107,'Japan','JP','JPN','',0,1),(108,'Jordan','JO','JOR','',0,1),(109,'Kazakhstan','KZ','KAZ','',0,1),(110,'Kenya','KE','KEN','',0,1),(111,'Kiribati','KI','KIR','',0,1),(112,'North Korea','KP','PRK','',0,1),(113,'South Korea','KR','KOR','',0,1),(114,'Kuwait','KW','KWT','',0,1),(115,'Kyrgyzstan','KG','KGZ','',0,1),(116,'Lao People\'s Democratic Republic','LA','LAO','',0,1),(117,'Latvia','LV','LVA','',0,1),(118,'Lebanon','LB','LBN','',0,1),(119,'Lesotho','LS','LSO','',0,1),(120,'Liberia','LR','LBR','',0,1),(121,'Libyan Arab Jamahiriya','LY','LBY','',0,1),(122,'Liechtenstein','LI','LIE','',0,1),(123,'Lithuania','LT','LTU','',0,1),(124,'Luxembourg','LU','LUX','',0,1),(125,'Macau','MO','MAC','',0,1),(126,'FYROM','MK','MKD','',0,1),(127,'Madagascar','MG','MDG','',0,1),(128,'Malawi','MW','MWI','',0,1),(129,'Malaysia','MY','MYS','',0,1),(130,'Maldives','MV','MDV','',0,1),(131,'Mali','ML','MLI','',0,1),(132,'Malta','MT','MLT','',0,1),(133,'Marshall Islands','MH','MHL','',0,1),(134,'Martinique','MQ','MTQ','',0,1),(135,'Mauritania','MR','MRT','',0,1),(136,'Mauritius','MU','MUS','',0,1),(137,'Mayotte','YT','MYT','',0,1),(138,'Mexico','MX','MEX','',0,1),(139,'Micronesia, Federated States of','FM','FSM','',0,1),(140,'Moldova, Republic of','MD','MDA','',0,1),(141,'Monaco','MC','MCO','',0,1),(142,'Mongolia','MN','MNG','',0,1),(143,'Montserrat','MS','MSR','',0,1),(144,'Morocco','MA','MAR','',0,1),(145,'Mozambique','MZ','MOZ','',0,1),(146,'Myanmar','MM','MMR','',0,1),(147,'Namibia','NA','NAM','',0,1),(148,'Nauru','NR','NRU','',0,1),(149,'Nepal','NP','NPL','',0,1),(150,'Netherlands','NL','NLD','',0,1),(151,'Netherlands Antilles','AN','ANT','',0,1),(152,'New Caledonia','NC','NCL','',0,1),(153,'New Zealand','NZ','NZL','',0,1),(154,'Nicaragua','NI','NIC','',0,1),(155,'Niger','NE','NER','',0,1),(156,'Nigeria','NG','NGA','',0,1),(157,'Niue','NU','NIU','',0,1),(158,'Norfolk Island','NF','NFK','',0,1),(159,'Northern Mariana Islands','MP','MNP','',0,1),(160,'Norway','NO','NOR','',0,1),(161,'Oman','OM','OMN','',0,1),(162,'Pakistan','PK','PAK','',0,1),(163,'Palau','PW','PLW','',0,1),(164,'Panama','PA','PAN','',0,1),(165,'Papua New Guinea','PG','PNG','',0,1),(166,'Paraguay','PY','PRY','',0,1),(167,'Peru','PE','PER','',0,1),(168,'Philippines','PH','PHL','',0,1),(169,'Pitcairn','PN','PCN','',0,1),(170,'Poland','PL','POL','',0,1),(171,'Portugal','PT','PRT','',0,1),(172,'Puerto Rico','PR','PRI','',0,1),(173,'Qatar','QA','QAT','',0,1),(174,'Reunion','RE','REU','',0,1),(175,'Romania','RO','ROM','',0,1),(176,'Russian Federation','RU','RUS','',0,1),(177,'Rwanda','RW','RWA','',0,1),(178,'Saint Kitts and Nevis','KN','KNA','',0,1),(179,'Saint Lucia','LC','LCA','',0,1),(180,'Saint Vincent and the Grenadines','VC','VCT','',0,1),(181,'Samoa','WS','WSM','',0,1),(182,'San Marino','SM','SMR','',0,1),(183,'Sao Tome and Principe','ST','STP','',0,1),(184,'Saudi Arabia','SA','SAU','',0,1),(185,'Senegal','SN','SEN','',0,1),(186,'Seychelles','SC','SYC','',0,1),(187,'Sierra Leone','SL','SLE','',0,1),(188,'Singapore','SG','SGP','',0,1),(189,'Slovak Republic','SK','SVK','{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city} {postcode}\r\n{zone}\r\n{country}',0,1),(190,'Slovenia','SI','SVN','',0,1),(191,'Solomon Islands','SB','SLB','',0,1),(192,'Somalia','SO','SOM','',0,1),(193,'South Africa','ZA','ZAF','',0,1),(194,'South Georgia &amp; South Sandwich Islands','GS','SGS','',0,1),(195,'Spain','ES','ESP','',0,1),(196,'Sri Lanka','LK','LKA','',0,1),(197,'St. Helena','SH','SHN','',0,1),(198,'St. Pierre and Miquelon','PM','SPM','',0,1),(199,'Sudan','SD','SDN','',0,1),(200,'Suriname','SR','SUR','',0,1),(201,'Svalbard and Jan Mayen Islands','SJ','SJM','',0,1),(202,'Swaziland','SZ','SWZ','',0,1),(203,'Sweden','SE','SWE','{company}\r\n{firstname} {lastname}\r\n{address_1}\r\n{address_2}\r\n{postcode} {city}\r\n{country}',1,1),(204,'Switzerland','CH','CHE','',0,1),(205,'Syrian Arab Republic','SY','SYR','',0,1),(206,'Taiwan','TW','TWN','',0,1),(207,'Tajikistan','TJ','TJK','',0,1),(208,'Tanzania, United Republic of','TZ','TZA','',0,1),(209,'Thailand','TH','THA','',0,1),(210,'Togo','TG','TGO','',0,1),(211,'Tokelau','TK','TKL','',0,1),(212,'Tonga','TO','TON','',0,1),(213,'Trinidad and Tobago','TT','TTO','',0,1),(214,'Tunisia','TN','TUN','',0,1),(215,'Turkey','TR','TUR','',0,1),(216,'Turkmenistan','TM','TKM','',0,1),(217,'Turks and Caicos Islands','TC','TCA','',0,1),(218,'Tuvalu','TV','TUV','',0,1),(219,'Uganda','UG','UGA','',0,1),(220,'Ukraine','UA','UKR','',0,1),(221,'United Arab Emirates','AE','ARE','',0,1),(222,'United Kingdom','GB','GBR','',1,1),(223,'United States','US','USA','{firstname} {lastname}\r\n{company}\r\n{address_1}\r\n{address_2}\r\n{city}, {zone} {postcode}\r\n{country}',0,1),(224,'United States Minor Outlying Islands','UM','UMI','',0,1),(225,'Uruguay','UY','URY','',0,1),(226,'Uzbekistan','UZ','UZB','',0,1),(227,'Vanuatu','VU','VUT','',0,1),(228,'Vatican City State (Holy See)','VA','VAT','',0,1),(229,'Venezuela','VE','VEN','',0,1),(230,'Viet Nam','VN','VNM','',0,1),(231,'Virgin Islands (British)','VG','VGB','',0,1),(232,'Virgin Islands (U.S.)','VI','VIR','',0,1),(233,'Wallis and Futuna Islands','WF','WLF','',0,1),(234,'Western Sahara','EH','ESH','',0,1),(235,'Yemen','YE','YEM','',0,1),(237,'Democratic Republic of Congo','CD','COD','',0,1),(238,'Zambia','ZM','ZMB','',0,1),(239,'Zimbabwe','ZW','ZWE','',0,1),(242,'Montenegro','ME','MNE','',0,1),(243,'Serbia','RS','SRB','',0,1),(244,'Aaland Islands','AX','ALA','',0,1),(245,'Bonaire, Sint Eustatius and Saba','BQ','BES','',0,1),(246,'Curacao','CW','CUW','',0,1),(247,'Palestinian Territory, Occupied','PS','PSE','',0,1),(248,'South Sudan','SS','SSD','',0,1),(249,'St. Barthelemy','BL','BLM','',0,1),(250,'St. Martin (French part)','MF','MAF','',0,1),(251,'Canary Islands','IC','ICA','',0,1),(252,'Ascension Island (British)','AC','ASC','',0,1),(253,'Kosovo, Republic of','XK','UNK','',0,1),(254,'Isle of Man','IM','IMN','',0,1),(255,'Tristan da Cunha','TA','SHN','',0,1),(256,'Guernsey','GG','GGY','',0,1),(257,'Jersey','JE','JEY','',0,1);
/*!40000 ALTER TABLE `oc_country` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_coupon`
--

DROP TABLE IF EXISTS `oc_coupon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_coupon` (
  `coupon_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `code` varchar(20) NOT NULL,
  `type` char(1) NOT NULL,
  `discount` decimal(15,4) NOT NULL,
  `logged` tinyint(1) NOT NULL,
  `shipping` tinyint(1) NOT NULL,
  `total` decimal(15,4) NOT NULL,
  `date_start` date NOT NULL DEFAULT '0000-00-00',
  `date_end` date NOT NULL DEFAULT '0000-00-00',
  `uses_total` int(11) NOT NULL,
  `uses_customer` varchar(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`coupon_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_coupon`
--

LOCK TABLES `oc_coupon` WRITE;
/*!40000 ALTER TABLE `oc_coupon` DISABLE KEYS */;
INSERT INTO `oc_coupon` (`coupon_id`, `name`, `code`, `type`, `discount`, `logged`, `shipping`, `total`, `date_start`, `date_end`, `uses_total`, `uses_customer`, `status`, `date_added`) VALUES (4,'-10% Discount','2222','P',10.0000,0,0,0.0000,'2014-01-01','2025-01-01',10,'10',1,'2009-01-27 13:55:03'),(5,'Free Shipping','3333','P',0.0000,0,1,100.0000,'2014-01-01','2014-02-01',10,'10',0,'2009-03-14 21:13:53'),(6,'-10.00 Discount','1111','F',10.0000,0,0,10.0000,'2014-01-01','2020-01-01',100000,'10000',0,'2009-03-14 21:15:18');
/*!40000 ALTER TABLE `oc_coupon` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_coupon_category`
--

DROP TABLE IF EXISTS `oc_coupon_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_coupon_category` (
  `coupon_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`coupon_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_coupon_category`
--

LOCK TABLES `oc_coupon_category` WRITE;
/*!40000 ALTER TABLE `oc_coupon_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_coupon_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_coupon_history`
--

DROP TABLE IF EXISTS `oc_coupon_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_coupon_history` (
  `coupon_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `amount` decimal(15,4) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`coupon_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_coupon_history`
--

LOCK TABLES `oc_coupon_history` WRITE;
/*!40000 ALTER TABLE `oc_coupon_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_coupon_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_coupon_product`
--

DROP TABLE IF EXISTS `oc_coupon_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_coupon_product` (
  `coupon_product_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  PRIMARY KEY (`coupon_product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_coupon_product`
--

LOCK TABLES `oc_coupon_product` WRITE;
/*!40000 ALTER TABLE `oc_coupon_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_coupon_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_currency`
--

DROP TABLE IF EXISTS `oc_currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_currency` (
  `currency_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `code` varchar(3) NOT NULL,
  `symbol_left` varchar(12) NOT NULL,
  `symbol_right` varchar(12) NOT NULL,
  `decimal_place` char(1) NOT NULL,
  `value` double(15,8) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`currency_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_currency`
--

LOCK TABLES `oc_currency` WRITE;
/*!40000 ALTER TABLE `oc_currency` DISABLE KEYS */;
INSERT INTO `oc_currency` (`currency_id`, `title`, `code`, `symbol_left`, `symbol_right`, `decimal_place`, `value`, `status`, `date_modified`) VALUES (2,'Bulgarian lev','BGN','','лв.','2',1.00000000,1,'2024-06-19 10:13:16');
/*!40000 ALTER TABLE `oc_currency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_custom_field`
--

DROP TABLE IF EXISTS `oc_custom_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_custom_field` (
  `custom_field_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(32) NOT NULL,
  `value` text NOT NULL,
  `validation` varchar(255) NOT NULL,
  `location` varchar(10) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`custom_field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_custom_field`
--

LOCK TABLES `oc_custom_field` WRITE;
/*!40000 ALTER TABLE `oc_custom_field` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_custom_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_custom_field_customer_group`
--

DROP TABLE IF EXISTS `oc_custom_field_customer_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_custom_field_customer_group` (
  `custom_field_id` int(11) NOT NULL,
  `customer_group_id` int(11) NOT NULL,
  `required` tinyint(1) NOT NULL,
  PRIMARY KEY (`custom_field_id`,`customer_group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_custom_field_customer_group`
--

LOCK TABLES `oc_custom_field_customer_group` WRITE;
/*!40000 ALTER TABLE `oc_custom_field_customer_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_custom_field_customer_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_custom_field_description`
--

DROP TABLE IF EXISTS `oc_custom_field_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_custom_field_description` (
  `custom_field_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`custom_field_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_custom_field_description`
--

LOCK TABLES `oc_custom_field_description` WRITE;
/*!40000 ALTER TABLE `oc_custom_field_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_custom_field_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_custom_field_value`
--

DROP TABLE IF EXISTS `oc_custom_field_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_custom_field_value` (
  `custom_field_value_id` int(11) NOT NULL AUTO_INCREMENT,
  `custom_field_id` int(11) NOT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`custom_field_value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_custom_field_value`
--

LOCK TABLES `oc_custom_field_value` WRITE;
/*!40000 ALTER TABLE `oc_custom_field_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_custom_field_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_custom_field_value_description`
--

DROP TABLE IF EXISTS `oc_custom_field_value_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_custom_field_value_description` (
  `custom_field_value_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `custom_field_id` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`custom_field_value_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_custom_field_value_description`
--

LOCK TABLES `oc_custom_field_value_description` WRITE;
/*!40000 ALTER TABLE `oc_custom_field_value_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_custom_field_value_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer`
--

DROP TABLE IF EXISTS `oc_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer` (
  `customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_group_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL,
  `firstname` varchar(32) NOT NULL,
  `lastname` varchar(32) NOT NULL,
  `email` varchar(96) NOT NULL,
  `telephone` varchar(32) NOT NULL,
  `fax` varchar(32) NOT NULL,
  `password` varchar(40) NOT NULL,
  `salt` varchar(9) NOT NULL,
  `cart` text,
  `wishlist` text,
  `newsletter` tinyint(1) NOT NULL DEFAULT '0',
  `address_id` int(11) NOT NULL DEFAULT '0',
  `custom_field` text NOT NULL,
  `ip` varchar(40) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `safe` tinyint(1) NOT NULL,
  `token` text NOT NULL,
  `code` varchar(40) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`customer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer`
--

LOCK TABLES `oc_customer` WRITE;
/*!40000 ALTER TABLE `oc_customer` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_activity`
--

DROP TABLE IF EXISTS `oc_customer_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_activity` (
  `customer_activity_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `key` varchar(64) NOT NULL,
  `data` text NOT NULL,
  `ip` varchar(40) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`customer_activity_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_activity`
--

LOCK TABLES `oc_customer_activity` WRITE;
/*!40000 ALTER TABLE `oc_customer_activity` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer_activity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_affiliate`
--

DROP TABLE IF EXISTS `oc_customer_affiliate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_affiliate` (
  `customer_id` int(11) NOT NULL,
  `company` varchar(40) NOT NULL,
  `website` varchar(255) NOT NULL,
  `tracking` varchar(64) NOT NULL,
  `commission` decimal(4,2) NOT NULL DEFAULT '0.00',
  `tax` varchar(64) NOT NULL,
  `payment` varchar(6) NOT NULL,
  `cheque` varchar(100) NOT NULL,
  `paypal` varchar(64) NOT NULL,
  `bank_name` varchar(64) NOT NULL,
  `bank_branch_number` varchar(64) NOT NULL,
  `bank_swift_code` varchar(64) NOT NULL,
  `bank_account_name` varchar(64) NOT NULL,
  `bank_account_number` varchar(64) NOT NULL,
  `custom_field` text NOT NULL,
  `status` tinyint(1) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_affiliate`
--

LOCK TABLES `oc_customer_affiliate` WRITE;
/*!40000 ALTER TABLE `oc_customer_affiliate` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer_affiliate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_approval`
--

DROP TABLE IF EXISTS `oc_customer_approval`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_approval` (
  `customer_approval_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `type` varchar(9) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`customer_approval_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_approval`
--

LOCK TABLES `oc_customer_approval` WRITE;
/*!40000 ALTER TABLE `oc_customer_approval` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer_approval` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_group`
--

DROP TABLE IF EXISTS `oc_customer_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_group` (
  `customer_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `approval` int(1) NOT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`customer_group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_group`
--

LOCK TABLES `oc_customer_group` WRITE;
/*!40000 ALTER TABLE `oc_customer_group` DISABLE KEYS */;
INSERT INTO `oc_customer_group` (`customer_group_id`, `approval`, `sort_order`) VALUES (1,0,1);
/*!40000 ALTER TABLE `oc_customer_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_group_description`
--

DROP TABLE IF EXISTS `oc_customer_group_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_group_description` (
  `customer_group_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`customer_group_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_group_description`
--

LOCK TABLES `oc_customer_group_description` WRITE;
/*!40000 ALTER TABLE `oc_customer_group_description` DISABLE KEYS */;
INSERT INTO `oc_customer_group_description` (`customer_group_id`, `language_id`, `name`, `description`) VALUES (1,1,'Default','test');
/*!40000 ALTER TABLE `oc_customer_group_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_history`
--

DROP TABLE IF EXISTS `oc_customer_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_history` (
  `customer_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `comment` text NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`customer_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_history`
--

LOCK TABLES `oc_customer_history` WRITE;
/*!40000 ALTER TABLE `oc_customer_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_ip`
--

DROP TABLE IF EXISTS `oc_customer_ip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_ip` (
  `customer_ip_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `ip` varchar(40) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`customer_ip_id`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_ip`
--

LOCK TABLES `oc_customer_ip` WRITE;
/*!40000 ALTER TABLE `oc_customer_ip` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer_ip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_login`
--

DROP TABLE IF EXISTS `oc_customer_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_login` (
  `customer_login_id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(96) NOT NULL,
  `ip` varchar(40) NOT NULL,
  `total` int(4) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`customer_login_id`),
  KEY `email` (`email`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM AUTO_INCREMENT=126 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_login`
--

LOCK TABLES `oc_customer_login` WRITE;
/*!40000 ALTER TABLE `oc_customer_login` DISABLE KEYS */;
INSERT INTO `oc_customer_login` (`customer_login_id`, `email`, `ip`, `total`, `date_added`, `date_modified`) VALUES (1,'svilen@dsi.bg','37.63.70.238',3,'2023-12-07 10:44:38','2023-12-07 10:44:49'),(2,'jqadmin','5.188.62.21',8,'2023-12-08 17:27:14','2024-01-25 20:44:22'),(3,'admin','5.188.62.21',116,'2023-12-08 17:27:22','2024-01-26 16:22:28'),(4,'jqkef4eto','5.188.62.21',5,'2023-12-08 17:29:41','2023-12-08 18:04:34'),(5,'kef4eto','5.188.62.21',8,'2023-12-08 17:29:50','2024-01-21 21:37:34'),(6,'jqalex','5.188.62.174',1,'2023-12-29 04:46:08','2023-12-29 04:46:08'),(7,'alex','5.188.62.174',1,'2023-12-29 04:46:16','2023-12-29 04:46:16'),(8,'jqdavid','5.188.62.174',1,'2023-12-29 05:55:00','2023-12-29 05:55:00'),(9,'david','5.188.62.174',1,'2023-12-29 05:55:08','2023-12-29 05:55:08'),(10,'jqchris','5.188.62.174',1,'2023-12-29 07:03:34','2023-12-29 07:03:34'),(11,'chris','5.188.62.174',1,'2023-12-29 07:03:42','2023-12-29 07:03:42'),(12,'jqdaniel','5.188.62.174',1,'2023-12-29 08:13:44','2023-12-29 08:13:44'),(13,'daniel','5.188.62.174',1,'2023-12-29 08:13:52','2023-12-29 08:13:52'),(14,'jqmichael','5.188.62.174',1,'2023-12-29 09:21:56','2023-12-29 09:21:56'),(15,'michael','5.188.62.174',1,'2023-12-29 09:22:04','2023-12-29 09:22:04'),(16,'jqjohn','5.188.62.174',1,'2023-12-29 10:30:17','2023-12-29 10:30:17'),(17,'john','5.188.62.174',1,'2023-12-29 10:30:25','2023-12-29 10:30:25'),(18,'jqmark','5.188.62.174',1,'2023-12-29 11:38:53','2023-12-29 11:38:53'),(19,'mark','5.188.62.174',1,'2023-12-29 11:39:01','2023-12-29 11:39:01'),(20,'jqmike','5.188.62.174',1,'2023-12-29 12:48:45','2023-12-29 12:48:45'),(21,'mike','5.188.62.174',1,'2023-12-29 12:48:53','2023-12-29 12:48:53'),(22,'jqhirai','5.188.62.174',1,'2023-12-29 13:56:57','2023-12-29 13:56:57'),(23,'hirai','5.188.62.174',1,'2023-12-29 13:57:06','2023-12-29 13:57:06'),(24,'jqmatt','5.188.62.174',1,'2023-12-29 15:05:11','2023-12-29 15:05:11'),(25,'matt','5.188.62.174',1,'2023-12-29 15:05:19','2023-12-29 15:05:19'),(26,'jqpeter','5.188.62.174',1,'2023-12-29 16:15:03','2023-12-29 16:15:03'),(27,'peter','5.188.62.174',1,'2023-12-29 16:15:12','2023-12-29 16:15:12'),(28,'jqmartin','5.188.62.174',1,'2023-12-29 17:23:45','2023-12-29 17:23:45'),(29,'martin','5.188.62.174',1,'2023-12-29 17:23:53','2023-12-29 17:23:53'),(30,'jqpaul','5.188.62.174',1,'2023-12-29 18:31:47','2023-12-29 18:31:47'),(31,'paul','5.188.62.174',1,'2023-12-29 18:31:55','2023-12-29 18:31:55'),(32,'jqthomas','5.188.62.174',1,'2023-12-29 19:40:09','2023-12-29 19:40:09'),(33,'thomas','5.188.62.174',1,'2023-12-29 19:40:17','2023-12-29 19:40:17'),(34,'jqjames','5.188.62.174',1,'2023-12-29 20:49:43','2023-12-29 20:49:43'),(35,'james','5.188.62.174',1,'2023-12-29 20:49:51','2023-12-29 20:49:51'),(36,'jqsarah','5.188.62.174',1,'2023-12-29 21:57:57','2023-12-29 21:57:57'),(37,'sarah','5.188.62.174',1,'2023-12-29 21:58:05','2023-12-29 21:58:05'),(38,'jqlaura','5.188.62.174',1,'2023-12-29 23:05:59','2023-12-29 23:05:59'),(39,'laura','5.188.62.174',1,'2023-12-29 23:06:07','2023-12-29 23:06:07'),(40,'jqanna','5.188.62.174',1,'2023-12-30 00:15:28','2023-12-30 00:15:28'),(41,'anna','5.188.62.174',1,'2023-12-30 00:15:36','2023-12-30 00:15:36'),(42,'jqadam','5.188.62.174',1,'2023-12-30 01:23:14','2023-12-30 01:23:14'),(43,'adam','5.188.62.174',1,'2023-12-30 01:23:22','2023-12-30 01:23:22'),(44,'jqkevin','5.188.62.174',1,'2023-12-30 02:31:34','2023-12-30 02:31:34'),(45,'kevin','5.188.62.174',1,'2023-12-30 02:31:43','2023-12-30 02:31:43'),(46,'jqsteve','5.188.62.174',1,'2023-12-30 03:39:24','2023-12-30 03:39:24'),(47,'steve','5.188.62.174',1,'2023-12-30 03:39:32','2023-12-30 03:39:32'),(48,'jqandrea','5.188.62.174',1,'2023-12-30 04:48:49','2023-12-30 04:48:49'),(49,'andrea','5.188.62.174',1,'2023-12-30 04:48:57','2023-12-30 04:48:57'),(50,'jqtom','5.188.62.174',1,'2023-12-30 05:56:37','2023-12-30 05:56:37'),(51,'tom','5.188.62.174',1,'2023-12-30 05:56:45','2023-12-30 05:56:45'),(52,'jqrobert','5.188.62.174',1,'2023-12-30 07:04:48','2023-12-30 07:04:48'),(53,'robert','5.188.62.174',1,'2023-12-30 07:04:56','2023-12-30 07:04:56'),(54,'jqandrew','5.188.62.174',1,'2023-12-30 08:14:32','2023-12-30 08:14:32'),(55,'andrew','5.188.62.174',1,'2023-12-30 08:14:41','2023-12-30 08:14:41'),(56,'jqjason','5.188.62.174',1,'2023-12-30 09:23:03','2023-12-30 09:23:03'),(57,'jason','5.188.62.174',1,'2023-12-30 09:23:11','2023-12-30 09:23:11'),(58,'jqchristian','5.188.62.174',1,'2023-12-30 10:31:11','2023-12-30 10:31:11'),(59,'christian','5.188.62.174',1,'2023-12-30 10:31:19','2023-12-30 10:31:19'),(60,'jqmaria','5.188.62.174',1,'2023-12-30 11:39:16','2023-12-30 11:39:16'),(61,'maria','5.188.62.174',1,'2023-12-30 11:39:24','2023-12-30 11:39:24'),(62,'jqsimon','5.188.62.174',1,'2023-12-30 12:48:40','2023-12-30 12:48:40'),(63,'simon','5.188.62.174',1,'2023-12-30 12:48:48','2023-12-30 12:48:48'),(64,'jqeric','5.188.62.174',1,'2023-12-30 13:56:34','2023-12-30 13:56:34'),(65,'eric','5.188.62.174',1,'2023-12-30 13:56:42','2023-12-30 13:56:42'),(66,'jqsam','5.188.62.174',1,'2023-12-30 15:04:31','2023-12-30 15:04:31'),(67,'sam','5.188.62.174',1,'2023-12-30 15:04:39','2023-12-30 15:04:39'),(68,'jqben','5.188.62.174',1,'2023-12-30 16:14:10','2023-12-30 16:14:10'),(69,'ben','5.188.62.174',1,'2023-12-30 16:14:18','2023-12-30 16:14:18'),(70,'jqnick','5.188.62.174',1,'2023-12-30 17:22:38','2023-12-30 17:22:38'),(71,'nick','5.188.62.174',1,'2023-12-30 17:22:46','2023-12-30 17:22:46'),(72,'jqtim','5.188.62.174',1,'2023-12-30 18:30:54','2023-12-30 18:30:54'),(73,'tim','5.188.62.174',1,'2023-12-30 18:31:02','2023-12-30 18:31:02'),(74,'jqmarco','5.188.62.174',1,'2023-12-30 19:39:12','2023-12-30 19:39:12'),(75,'marco','5.188.62.174',1,'2023-12-30 19:39:20','2023-12-30 19:39:20'),(76,'jqpatrick','5.188.62.174',1,'2023-12-30 20:48:38','2023-12-30 20:48:38'),(77,'patrick','5.188.62.174',1,'2023-12-30 20:48:46','2023-12-30 20:48:46'),(78,'jqdan','5.188.62.174',1,'2023-12-30 21:56:24','2023-12-30 21:56:24'),(79,'dan','5.188.62.174',1,'2023-12-30 21:56:32','2023-12-30 21:56:32'),(80,'jqryan','5.188.62.174',1,'2023-12-30 23:04:12','2023-12-30 23:04:12'),(81,'ryan','5.188.62.174',1,'2023-12-30 23:04:20','2023-12-30 23:04:20'),(82,'jqbrian','5.188.62.174',1,'2023-12-31 00:13:54','2023-12-31 00:13:54'),(83,'brian','5.188.62.174',1,'2023-12-31 00:14:03','2023-12-31 00:14:03'),(84,'jqrichard','5.188.62.174',1,'2023-12-31 01:21:54','2023-12-31 01:21:54'),(85,'richard','5.188.62.174',1,'2023-12-31 01:22:02','2023-12-31 01:22:02'),(86,'jqdave','5.188.62.174',1,'2023-12-31 02:30:15','2023-12-31 02:30:15'),(87,'dave','5.188.62.174',1,'2023-12-31 02:30:23','2023-12-31 02:30:23'),(88,'jqandy','5.188.62.174',1,'2023-12-31 03:38:32','2023-12-31 03:38:32'),(89,'andy','5.188.62.174',1,'2023-12-31 03:38:40','2023-12-31 03:38:40'),(90,'jqlisa','5.188.62.174',1,'2023-12-31 04:48:23','2023-12-31 04:48:23'),(91,'lisa','5.188.62.174',1,'2023-12-31 04:48:31','2023-12-31 04:48:31'),(92,'jqcarlos','5.188.62.174',1,'2023-12-31 05:56:50','2023-12-31 05:56:50'),(93,'carlos','5.188.62.174',1,'2023-12-31 05:56:59','2023-12-31 05:56:59'),(94,'jqstefan','5.188.62.174',1,'2023-12-31 07:05:20','2023-12-31 07:05:20'),(95,'stefan','5.188.62.174',1,'2023-12-31 07:05:28','2023-12-31 07:05:28'),(96,'jqjulia','5.188.62.174',1,'2023-12-31 08:15:15','2023-12-31 08:15:15'),(97,'julia','5.188.62.174',1,'2023-12-31 08:15:23','2023-12-31 08:15:23'),(98,'jqadmin123','5.188.62.174',1,'2024-01-05 16:26:12','2024-01-05 16:26:12'),(99,'admin123','5.188.62.174',6,'2024-01-05 16:26:21','2024-01-10 20:03:08'),(100,'jq123456','5.188.62.174',1,'2024-01-06 17:22:14','2024-01-06 17:22:14'),(101,'123456','5.188.62.174',1,'2024-01-06 17:22:22','2024-01-06 17:22:22'),(102,'jqtest','5.188.62.174',4,'2024-01-07 18:14:20','2024-01-21 02:27:35'),(103,'test','5.188.62.174',4,'2024-01-07 18:14:29','2024-01-21 02:27:43'),(104,'jq123123','5.188.62.174',1,'2024-01-08 19:12:09','2024-01-08 19:12:09'),(105,'123123','5.188.62.174',1,'2024-01-08 19:12:17','2024-01-08 19:12:17'),(106,'jqeditor','5.188.62.140',2,'2024-01-09 13:56:55','2024-01-24 17:11:47'),(107,'editor','5.188.62.140',2,'2024-01-09 13:57:03','2024-01-24 17:11:55'),(108,'kef4eto.com','178.176.85.97',6,'2024-01-09 14:28:44','2024-01-10 19:57:00'),(109,'administrator','178.176.85.97',6,'2024-01-09 14:29:15','2024-01-10 19:57:46'),(110,'system','178.176.85.97',6,'2024-01-09 14:31:43','2024-01-10 20:01:39'),(111,'opencart','178.176.85.97',6,'2024-01-09 14:32:13','2024-01-10 20:02:18'),(112,'123','178.176.85.97',6,'2024-01-09 14:33:14','2024-01-10 20:03:59'),(113,'admin1','178.176.85.97',6,'2024-01-09 14:33:45','2024-01-10 20:04:45'),(114,'admin2','178.176.85.97',7,'2024-01-09 14:34:14','2024-01-23 21:06:45'),(115,'jqadmin@kef4eto.com','5.188.62.140',4,'2024-01-10 09:17:53','2024-01-14 03:29:43'),(116,'admin@kef4eto.com','5.188.62.140',4,'2024-01-10 09:18:01','2024-01-14 03:29:51'),(117,'jqtesting','5.188.62.174',1,'2024-01-10 20:34:55','2024-01-10 20:34:55'),(118,'testing','5.188.62.174',1,'2024-01-10 20:35:03','2024-01-10 20:35:03'),(119,'jq1','5.188.62.174',1,'2024-01-11 21:09:50','2024-01-11 21:09:50'),(120,'1','5.188.62.174',1,'2024-01-11 21:09:58','2024-01-11 21:09:58'),(121,'jqmanager','5.188.62.140',1,'2024-01-12 02:19:40','2024-01-12 02:19:40'),(122,'manager','5.188.62.140',1,'2024-01-12 02:19:48','2024-01-12 02:19:48'),(123,'jqdev','5.188.62.140',2,'2024-01-15 14:18:15','2024-01-18 18:01:39'),(124,'dev','5.188.62.140',2,'2024-01-15 14:18:23','2024-01-18 18:01:47'),(125,'jqadmin2','5.188.62.140',1,'2024-01-23 21:06:37','2024-01-23 21:06:37');
/*!40000 ALTER TABLE `oc_customer_login` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_online`
--

DROP TABLE IF EXISTS `oc_customer_online`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_online` (
  `ip` varchar(40) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `url` text NOT NULL,
  `referer` text NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_online`
--

LOCK TABLES `oc_customer_online` WRITE;
/*!40000 ALTER TABLE `oc_customer_online` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer_online` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_reward`
--

DROP TABLE IF EXISTS `oc_customer_reward`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_reward` (
  `customer_reward_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `points` int(8) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`customer_reward_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_reward`
--

LOCK TABLES `oc_customer_reward` WRITE;
/*!40000 ALTER TABLE `oc_customer_reward` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer_reward` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_search`
--

DROP TABLE IF EXISTS `oc_customer_search`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_search` (
  `customer_search_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `sub_category` tinyint(1) NOT NULL,
  `description` tinyint(1) NOT NULL,
  `products` int(11) NOT NULL,
  `ip` varchar(40) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`customer_search_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_search`
--

LOCK TABLES `oc_customer_search` WRITE;
/*!40000 ALTER TABLE `oc_customer_search` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer_search` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_transaction`
--

DROP TABLE IF EXISTS `oc_customer_transaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_transaction` (
  `customer_transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `description` text NOT NULL,
  `amount` decimal(15,4) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`customer_transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_transaction`
--

LOCK TABLES `oc_customer_transaction` WRITE;
/*!40000 ALTER TABLE `oc_customer_transaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer_transaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_customer_wishlist`
--

DROP TABLE IF EXISTS `oc_customer_wishlist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_customer_wishlist` (
  `customer_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`customer_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_customer_wishlist`
--

LOCK TABLES `oc_customer_wishlist` WRITE;
/*!40000 ALTER TABLE `oc_customer_wishlist` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_customer_wishlist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_download`
--

DROP TABLE IF EXISTS `oc_download`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_download` (
  `download_id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(160) NOT NULL,
  `mask` varchar(128) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`download_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_download`
--

LOCK TABLES `oc_download` WRITE;
/*!40000 ALTER TABLE `oc_download` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_download` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_download_description`
--

DROP TABLE IF EXISTS `oc_download_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_download_description` (
  `download_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY (`download_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_download_description`
--

LOCK TABLES `oc_download_description` WRITE;
/*!40000 ALTER TABLE `oc_download_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_download_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_event`
--

DROP TABLE IF EXISTS `oc_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_event` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) NOT NULL,
  `trigger` text NOT NULL,
  `action` text NOT NULL,
  `status` tinyint(1) NOT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`event_id`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_event`
--

LOCK TABLES `oc_event` WRITE;
/*!40000 ALTER TABLE `oc_event` DISABLE KEYS */;
INSERT INTO `oc_event` (`event_id`, `code`, `trigger`, `action`, `status`, `sort_order`) VALUES (1,'activity_customer_add','catalog/model/account/customer/addCustomer/after','event/activity/addCustomer',1,0),(2,'activity_customer_edit','catalog/model/account/customer/editCustomer/after','event/activity/editCustomer',1,0),(3,'activity_customer_password','catalog/model/account/customer/editPassword/after','event/activity/editPassword',1,0),(4,'activity_customer_forgotten','catalog/model/account/customer/editCode/after','event/activity/forgotten',1,0),(5,'activity_transaction','catalog/model/account/customer/addTransaction/after','event/activity/addTransaction',1,0),(6,'activity_customer_login','catalog/model/account/customer/deleteLoginAttempts/after','event/activity/login',1,0),(7,'activity_address_add','catalog/model/account/address/addAddress/after','event/activity/addAddress',1,0),(8,'activity_address_edit','catalog/model/account/address/editAddress/after','event/activity/editAddress',1,0),(9,'activity_address_delete','catalog/model/account/address/deleteAddress/after','event/activity/deleteAddress',1,0),(10,'activity_affiliate_add','catalog/model/account/customer/addAffiliate/after','event/activity/addAffiliate',1,0),(11,'activity_affiliate_edit','catalog/model/account/customer/editAffiliate/after','event/activity/editAffiliate',1,0),(12,'activity_order_add','catalog/model/checkout/order/addOrderHistory/before','event/activity/addOrderHistory',1,0),(13,'activity_return_add','catalog/model/account/return/addReturn/after','event/activity/addReturn',1,0),(14,'mail_transaction','catalog/model/account/customer/addTransaction/after','mail/transaction',1,0),(15,'mail_forgotten','catalog/model/account/customer/editCode/after','mail/forgotten',1,0),(16,'mail_customer_add','catalog/model/account/customer/addCustomer/after','mail/register',1,0),(17,'mail_customer_alert','catalog/model/account/customer/addCustomer/after','mail/register/alert',1,0),(18,'mail_affiliate_add','catalog/model/account/customer/addAffiliate/after','mail/affiliate',1,0),(19,'mail_affiliate_alert','catalog/model/account/customer/addAffiliate/after','mail/affiliate/alert',1,0),(20,'mail_voucher','catalog/model/checkout/order/addOrderHistory/after','extension/total/voucher/send',1,0),(21,'mail_order_add','catalog/model/checkout/order/addOrderHistory/before','mail/order',1,0),(22,'mail_order_alert','catalog/model/checkout/order/addOrderHistory/before','mail/order/alert',1,0),(23,'statistics_review_add','catalog/model/catalog/review/addReview/after','event/statistics/addReview',1,0),(24,'statistics_return_add','catalog/model/account/return/addReturn/after','event/statistics/addReturn',1,0),(25,'statistics_order_history','catalog/model/checkout/order/addOrderHistory/after','event/statistics/addOrderHistory',1,0),(26,'admin_mail_affiliate_approve','admin/model/customer/customer_approval/approveAffiliate/after','mail/affiliate/approve',1,0),(27,'admin_mail_affiliate_deny','admin/model/customer/customer_approval/denyAffiliate/after','mail/affiliate/deny',1,0),(28,'admin_mail_customer_approve','admin/model/customer/customer_approval/approveCustomer/after','mail/customer/approve',1,0),(29,'admin_mail_customer_deny','admin/model/customer/customer_approval/denyCustomer/after','mail/customer/deny',1,0),(30,'admin_mail_reward','admin/model/customer/customer/addReward/after','mail/reward',1,0),(31,'admin_mail_transaction','admin/model/customer/customer/addTransaction/after','mail/transaction',1,0),(32,'admin_mail_return','admin/model/sale/return/addReturnHistory/after','mail/return',1,0),(33,'admin_mail_forgotten','admin/model/user/user/editCode/after','mail/forgotten',1,0),(34,'advertise_google','admin/model/catalog/product/deleteProduct/after','extension/advertise/google/deleteProduct',1,0),(35,'advertise_google','admin/model/catalog/product/copyProduct/after','extension/advertise/google/copyProduct',1,0),(36,'advertise_google','admin/view/common/column_left/before','extension/advertise/google/admin_link',1,0),(37,'advertise_google','admin/model/catalog/product/addProduct/after','extension/advertise/google/addProduct',1,0),(38,'advertise_google','catalog/controller/checkout/success/before','extension/advertise/google/before_checkout_success',1,0),(39,'advertise_google','catalog/view/common/header/after','extension/advertise/google/google_global_site_tag',1,0),(40,'advertise_google','catalog/view/common/success/after','extension/advertise/google/google_dynamic_remarketing_purchase',1,0),(41,'advertise_google','catalog/view/product/product/after','extension/advertise/google/google_dynamic_remarketing_product',1,0),(42,'advertise_google','catalog/view/product/search/after','extension/advertise/google/google_dynamic_remarketing_searchresults',1,0),(43,'advertise_google','catalog/view/product/category/after','extension/advertise/google/google_dynamic_remarketing_category',1,0),(44,'advertise_google','catalog/view/common/home/after','extension/advertise/google/google_dynamic_remarketing_home',1,0),(45,'advertise_google','catalog/view/checkout/cart/after','extension/advertise/google/google_dynamic_remarketing_cart',1,0);
/*!40000 ALTER TABLE `oc_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_extension`
--

DROP TABLE IF EXISTS `oc_extension`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_extension` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(32) NOT NULL,
  `code` varchar(32) NOT NULL,
  PRIMARY KEY (`extension_id`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_extension`
--

LOCK TABLES `oc_extension` WRITE;
/*!40000 ALTER TABLE `oc_extension` DISABLE KEYS */;
INSERT INTO `oc_extension` (`extension_id`, `type`, `code`) VALUES (1,'payment','cod'),(2,'total','shipping'),(3,'total','sub_total'),(4,'total','tax'),(5,'total','total'),(6,'module','banner'),(7,'module','carousel'),(8,'total','credit'),(9,'shipping','flat'),(10,'total','handling'),(11,'total','low_order_fee'),(12,'total','coupon'),(13,'module','category'),(14,'module','account'),(15,'total','reward'),(16,'total','voucher'),(59,'payment','stripe'),(18,'module','featured'),(19,'module','slideshow'),(20,'theme','default'),(21,'dashboard','activity'),(22,'dashboard','sale'),(23,'dashboard','recent'),(24,'dashboard','order'),(25,'dashboard','online'),(26,'dashboard','map'),(27,'dashboard','customer'),(28,'dashboard','chart'),(29,'report','sale_coupon'),(31,'report','customer_search'),(32,'report','customer_transaction'),(33,'report','product_purchased'),(34,'report','product_viewed'),(35,'report','sale_return'),(36,'report','sale_order'),(37,'report','sale_shipping'),(38,'report','sale_tax'),(39,'report','customer_activity'),(40,'report','customer_order'),(41,'report','customer_reward'),(42,'advertise','google'),(56,'module','latest_products_category'),(50,'module','marketshop'),(52,'module','special'),(54,'module','html'),(57,'payment','bank_transfer'),(58,'shipping','free');
/*!40000 ALTER TABLE `oc_extension` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_extension_install`
--

DROP TABLE IF EXISTS `oc_extension_install`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_extension_install` (
  `extension_install_id` int(11) NOT NULL AUTO_INCREMENT,
  `extension_download_id` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`extension_install_id`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_extension_install`
--

LOCK TABLES `oc_extension_install` WRITE;
/*!40000 ALTER TABLE `oc_extension_install` DISABLE KEYS */;
INSERT INTO `oc_extension_install` (`extension_install_id`, `extension_download_id`, `filename`, `date_added`) VALUES (48,0,'fixes_oc3_kef4eto.ocmod.zip','2024-05-09 15:44:53'),(49,0,'OpenCart 2.3-3.0 Versions.ocmod.zip','2024-05-09 18:46:40');
/*!40000 ALTER TABLE `oc_extension_install` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_extension_path`
--

DROP TABLE IF EXISTS `oc_extension_path`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_extension_path` (
  `extension_path_id` int(11) NOT NULL AUTO_INCREMENT,
  `extension_install_id` int(11) NOT NULL,
  `path` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`extension_path_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_extension_path`
--

LOCK TABLES `oc_extension_path` WRITE;
/*!40000 ALTER TABLE `oc_extension_path` DISABLE KEYS */;
INSERT INTO `oc_extension_path` (`extension_path_id`, `extension_install_id`, `path`, `date_added`) VALUES (1,49,'admin/controller/extension/payment/stripe.php','2024-05-09 18:46:40'),(2,49,'admin/language/en-gb/extension/payment/stripe.php','2024-05-09 18:46:40'),(3,49,'admin/view/template/extension/payment/stripe.twig','2024-05-09 18:46:40');
/*!40000 ALTER TABLE `oc_extension_path` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_filter`
--

DROP TABLE IF EXISTS `oc_filter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_filter` (
  `filter_id` int(11) NOT NULL AUTO_INCREMENT,
  `filter_group_id` int(11) NOT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`filter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_filter`
--

LOCK TABLES `oc_filter` WRITE;
/*!40000 ALTER TABLE `oc_filter` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_filter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_filter_description`
--

DROP TABLE IF EXISTS `oc_filter_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_filter_description` (
  `filter_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `filter_group_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY (`filter_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_filter_description`
--

LOCK TABLES `oc_filter_description` WRITE;
/*!40000 ALTER TABLE `oc_filter_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_filter_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_filter_group`
--

DROP TABLE IF EXISTS `oc_filter_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_filter_group` (
  `filter_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`filter_group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_filter_group`
--

LOCK TABLES `oc_filter_group` WRITE;
/*!40000 ALTER TABLE `oc_filter_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_filter_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_filter_group_description`
--

DROP TABLE IF EXISTS `oc_filter_group_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_filter_group_description` (
  `filter_group_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY (`filter_group_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_filter_group_description`
--

LOCK TABLES `oc_filter_group_description` WRITE;
/*!40000 ALTER TABLE `oc_filter_group_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_filter_group_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_geo_zone`
--

DROP TABLE IF EXISTS `oc_geo_zone`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_geo_zone` (
  `geo_zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `description` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`geo_zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_geo_zone`
--

LOCK TABLES `oc_geo_zone` WRITE;
/*!40000 ALTER TABLE `oc_geo_zone` DISABLE KEYS */;
INSERT INTO `oc_geo_zone` (`geo_zone_id`, `name`, `description`, `date_added`, `date_modified`) VALUES (3,'UK VAT Zone','UK VAT','2009-01-06 23:26:25','2010-02-26 22:33:24'),(4,'UK Shipping','UK Shipping Zones','2009-06-23 01:14:53','2010-12-15 15:18:13');
/*!40000 ALTER TABLE `oc_geo_zone` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_googleshopping_category`
--

DROP TABLE IF EXISTS `oc_googleshopping_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_googleshopping_category` (
  `google_product_category` varchar(10) NOT NULL,
  `store_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`google_product_category`,`store_id`),
  KEY `category_id_store_id` (`category_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_googleshopping_category`
--

LOCK TABLES `oc_googleshopping_category` WRITE;
/*!40000 ALTER TABLE `oc_googleshopping_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_googleshopping_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_googleshopping_product`
--

DROP TABLE IF EXISTS `oc_googleshopping_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_googleshopping_product` (
  `product_advertise_google_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `store_id` int(11) NOT NULL DEFAULT '0',
  `has_issues` tinyint(1) DEFAULT NULL,
  `destination_status` enum('pending','approved','disapproved') NOT NULL DEFAULT 'pending',
  `impressions` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `conversions` int(11) NOT NULL DEFAULT '0',
  `cost` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `conversion_value` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `google_product_category` varchar(10) DEFAULT NULL,
  `condition` enum('new','refurbished','used') DEFAULT NULL,
  `adult` tinyint(1) DEFAULT NULL,
  `multipack` int(11) DEFAULT NULL,
  `is_bundle` tinyint(1) DEFAULT NULL,
  `age_group` enum('newborn','infant','toddler','kids','adult') DEFAULT NULL,
  `color` int(11) DEFAULT NULL,
  `gender` enum('male','female','unisex') DEFAULT NULL,
  `size_type` enum('regular','petite','plus','big and tall','maternity') DEFAULT NULL,
  `size_system` enum('AU','BR','CN','DE','EU','FR','IT','JP','MEX','UK','US') DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `is_modified` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_advertise_google_id`),
  UNIQUE KEY `product_id_store_id` (`product_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_googleshopping_product`
--

LOCK TABLES `oc_googleshopping_product` WRITE;
/*!40000 ALTER TABLE `oc_googleshopping_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_googleshopping_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_googleshopping_product_status`
--

DROP TABLE IF EXISTS `oc_googleshopping_product_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_googleshopping_product_status` (
  `product_id` int(11) NOT NULL DEFAULT '0',
  `store_id` int(11) NOT NULL DEFAULT '0',
  `product_variation_id` varchar(64) NOT NULL DEFAULT '',
  `destination_statuses` text NOT NULL,
  `data_quality_issues` text NOT NULL,
  `item_level_issues` text NOT NULL,
  `google_expiration_date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`store_id`,`product_variation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_googleshopping_product_status`
--

LOCK TABLES `oc_googleshopping_product_status` WRITE;
/*!40000 ALTER TABLE `oc_googleshopping_product_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_googleshopping_product_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_googleshopping_product_target`
--

DROP TABLE IF EXISTS `oc_googleshopping_product_target`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_googleshopping_product_target` (
  `product_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL DEFAULT '0',
  `advertise_google_target_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`advertise_google_target_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_googleshopping_product_target`
--

LOCK TABLES `oc_googleshopping_product_target` WRITE;
/*!40000 ALTER TABLE `oc_googleshopping_product_target` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_googleshopping_product_target` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_googleshopping_target`
--

DROP TABLE IF EXISTS `oc_googleshopping_target`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_googleshopping_target` (
  `advertise_google_target_id` int(11) unsigned NOT NULL,
  `store_id` int(11) NOT NULL DEFAULT '0',
  `campaign_name` varchar(255) NOT NULL DEFAULT '',
  `country` varchar(2) NOT NULL DEFAULT '',
  `budget` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `feeds` text NOT NULL,
  `status` enum('paused','active') NOT NULL DEFAULT 'paused',
  `date_added` date DEFAULT NULL,
  `roas` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`advertise_google_target_id`),
  KEY `store_id` (`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_googleshopping_target`
--

LOCK TABLES `oc_googleshopping_target` WRITE;
/*!40000 ALTER TABLE `oc_googleshopping_target` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_googleshopping_target` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_information`
--

DROP TABLE IF EXISTS `oc_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_information` (
  `information_id` int(11) NOT NULL AUTO_INCREMENT,
  `bottom` int(1) NOT NULL DEFAULT '0',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`information_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_information`
--

LOCK TABLES `oc_information` WRITE;
/*!40000 ALTER TABLE `oc_information` DISABLE KEYS */;
INSERT INTO `oc_information` (`information_id`, `bottom`, `sort_order`, `status`) VALUES (3,1,3,1),(4,1,1,1),(5,1,4,1),(6,1,2,1),(7,1,4,1),(8,1,7,1);
/*!40000 ALTER TABLE `oc_information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_information_description`
--

DROP TABLE IF EXISTS `oc_information_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_information_description` (
  `information_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `title` varchar(64) NOT NULL,
  `description` mediumtext NOT NULL,
  `meta_title` varchar(255) NOT NULL,
  `meta_description` varchar(255) NOT NULL,
  `meta_keyword` varchar(255) NOT NULL,
  PRIMARY KEY (`information_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_information_description`
--

LOCK TABLES `oc_information_description` WRITE;
/*!40000 ALTER TABLE `oc_information_description` DISABLE KEYS */;
INSERT INTO `oc_information_description` (`information_id`, `language_id`, `title`, `description`, `meta_title`, `meta_description`, `meta_keyword`) VALUES (3,1,'Политика за поверителност','&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Настоящата Политика за поверителност има за цел да ви осведоми за това как С 601 ООД третира вашите лични данни като администратор, а също и за това как бихте могли да контролирате своите предпочитания и настройки във връзка с това третиране.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Какво регламентират тези Правила за поверителност и на какво законово основание От 25 май 2018 година в България започва да се прилага Общ регламент за защита на личните данни (GDPR). Той е приет от Европейския съюз и целта му е да уеднакви политиките на държавите-членки на ЕС, свързани със събирането и използването на лични данни. Друга негова цел е да гарантира правото ни на неприкосновеност, да защити личните ни данни, за да даде повече сигурност срещу злоупотреби с личната информация на всеки от нас. Новият регламент идва с редица изисквания, които С 601 ООД прилага и с които може да се запознаете тук. Сред тях са:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Да ви информираме какви данни използваме.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Да ви информираме защо ги използваме.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Да искаме вашето съгласие, за да ги използваме, когато на тяхна база предоставяме допълнителни услуги като таргетирана реклама, например.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Да ви дадем възможност да променяте съгласието си за различни цели през този сайт, за да имате повече свобода.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Да ви гарантираме правото да поискате коригиране на вашите данни, тяхното изтриване, както и да „бъдете забравени“. В допълнение, можем да ви предоставим данните за сваляне или да ги трансферираме, ако ни уведомите и се легитимирате по съответните начини.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Да посочваме всички трети лица/други компании, с които обменяме вашите данни. Имайте предвид, че интернет е глобална мрежа, ние често използваме стандартизирани услуги, които да регистрират влизане и да проследят поведение в анонимизиран вариант, например Google Analytics.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Всички данни, благодарение на които може да бъде идентифициран даден потребител, се считат за лични данни. Такива могат да бъдат имейл, имена, мобилен телефон, адрес на живеене, IP адрес.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Какви данни събираме ние от нашите регистрирани потребители? С 601 ООД събира от потребителите на уебсайтовете от портфолиото си специфични данни от осъществените от тях регистрации, за да анализира поведението на потребителите си, както и за да им предостави по-релевантно съдържание и реклами, а именно следните категории лични данни:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;От www.kozelat.com - имейл адрес за получаване на фактура и гаранционна карта, IP адрес, както и телефонен номер, адрес за получаване на пратката, както и други лични данни, които не са задължителни за предоставяне от страна на потребителя при регистрация,&amp;nbsp; имейл адрес за получаване на имейл маркетинг;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Данни, събирани за всички посетители на нашите уебсайтове: Във всички уебсайтове от нашето портфолио събираме данни за всички посетители – регистрирани потребители и посетители без регистрация, а именно следните категории данни:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;IP адрес;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Идентификатор на потребителя с висока степен на уникалност;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Идентификатор на устройство (device ID) за мобилни апликации, с висока степен на уникалност;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Идентификатор на браузъра, с висока степен на уникалност;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;История на посетените страници, включително и вторична обработка, с цел установяване на предпочитанията Ви към определени типове съдържание;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;История на направените от Вас търсения в нашите страници;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Някои типове поведение – напр. списък с прегледаните реклами според тяхната категория и взаимодействието Ви с тях – наличност на рекламата във видимата част на браузъра Ви; направени кликове и други.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Данни, събирани от прочитане на бисквитки: Когато потребителите използват нашите услуги и портфолио от уеб сайтове - четат новини, гледат видео, използват мейл и други, сред данните, които помагат да разберем как услугите ни работят по най-добрия начин и за да ги направим още по-добри за вас, са бисквитките. Те представляват малки текстови файлове, които се изпращат от уеб сървъра към използвания браузър и се съхраняват на устройството ви, за да може сайтът да го разпознава. Има два вида бисквитки – постоянни и временни или &quot;сесийни&quot; бисквитки. Постоянните бисквитки се съхраняват като файл на вашия компютър или мобилно устройство за по-дълъг период от време. Сесийните бисквитки се съхраняват временно в компютъра Ви, когато посещавате сайт от нашето портфолио, но се изтриват в момента, в който затворите страницата. Повечето бисквитки не съдържат чувствителна информация за Вас или лични данни, с които можем да ви идентифицираме пряко. Повече за бисквитките можете да научите тук. Целите, за които използваме бисквитките, са най-основно следене на поведението ви в следните направления:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Проследяване на секции в сайтовете, които посещавате;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Колко време отделяте в даден сайт;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Колко време гледате дадено видео;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Рекламите, които сте видели и/или с които сте си взаимодействали;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Кога посещавате наши сайтове и сайтове на наши партньори, сервиращи наши java скриптове и др.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;На кого споделяме и разкриваме вашите лични данни&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Понякога записваме част от информацията на наши сървъри или я изпращаме на трети страни. Това се налага, за да можем да осигурим най-доброто ви преживяване при използване на нашите услуги, а понякога - и изобщо за да можем да осигурим наличност и достъпност на използваната от вас услуга.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;С 601 ООД не дава право на използване, не продава, не разкрива и не споделя информация за вас (лични данни по смисъла на GDPR) с други лица или с несвързани компании, освен когато това се налага, за да ви предоставим заявени от вас услуги и когато вие сте предоставили вашето разрешение, или в някоя от следните хипотези:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:8pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Информацията се предоставя на доверени партньори, които работят по възлагане от страна на С 601 ООД въз основа на договорни отношения и по силата на конфиденциални споразумения. Въпреки това тези компании нямат правото самостоятелно да споделят тази информация. Тези компании са, без изброяването да е изчерпателно:&lt;/span&gt;&lt;/p&gt;&lt;ul style=&quot;margin-top:0;margin-bottom:0;padding-inline-start:48px;&quot;&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Google със съответните свои продукти: Google Analytics, Google Tag Manager, DoubleClick for Publishers, AdX, AdSense, Google Case, Google IMA, Google Plus: https://privacy.google.com/# ;&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Facebook със съответните продукти: Facebook Tracking Pixel, Facebook Tools – Plug-in “like” button, Sign in with Facebook profile и др.: https://www.facebook.com/privacy/explanation ;&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Mail Chimp: https://mailchimp.com/legal/privacy/ ;&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Twitter widgets: https://twitter.com/en/privacy ;&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Cloudflare CDN;&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Open Graph;&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Teads.tv ADS;&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Instagram: https://help.instagram.com/155833707900388;&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:8pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Pinterest: https://policy.pinterest.com/en/privacy-policy.&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Информацията е в изпълнение на законосъобразните предписания на съдебни разпореждания по легитимни заявки от оправомощени органи (по силата на Закона за електронните съобщения, Наказателно-процесуалния кодекс, Наказателния кодекс и др.).&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Ако не искате да изпращаме информацията към някои от нашите партньори, може да оттеглите Вашето съгласие тук.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Защита на информацията&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Когато съхраняваме информацията при нас, тя се запазва физически на собствени сървъри, колокирани в центрове за съхранение на данните на територията на Република България.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;При подбор на нашите партньори за сървърна колокация правим детайлна проверка на тяхната сертификация, като изискваме, например, покриване на следните индустриални стандарти:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;ISO/IEC 27001:2013 Information security certificate PCI DSS 3.2 compliance (chapter 9 and 12) ISO 9001:2008 ISO 27001:2013 BS OHSAS 18001:2007&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Покриването на посочените стандарти гарантира максимална сигурност на данните на нашите потребители.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Ние ограничаваме достъпа до информация за вас от страна на служители, действащи под ръководството на С 601 ООД, освен в случаите, в които са налице разумни основания да боравят с тази информация с цел да ви бъдат предоставяни услуги или във връзка с изпълняваните работни задължения от тези служители.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Разполагаме с физически, електронни и процедурни защитни средства, които съответстват на нашите законови задължения по отношение защитата на информацията за вас.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Прехвърляне на данни&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Някои от нашите партньори е възможно да прехвърлят данни извън рамките на ЕИП, когато е налице решение относно адекватното ниво на защита, например – в случая на Щита за личните данни в отношенията между ЕС и САЩ ( EU-U.S. Privacy Shield). За повече информация можете да разгледате политиките за поверителност на нашите партньори.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Колко време съхраняваме информацията&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Съхраняването на данните продължава, докато разполагаме с основание за тяхното съхранение. Например – наш потребител е дал съгласието си да събираме и обработваме информация за него.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Прилагаме следните срокове за съхраняване на различните типове лични данни според тяхната цел, а именно:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;За целите на измерване на потребителското поведение на сайтовете от нашето портфолио– според периода на валидност на записването на съответната бисквитка;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;За целите на поведенческото таргетиране – не повече от 1 (една) година.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;По отношение на трафичните данни се прилага Законът за електронните съобщения и данните се съхраняват в рамките на 6 месеца. Тези данни се предават на специализираните органи и институции само при спазени законови разпоредби и с надлежно основание.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Права на субектите на данни според GDPR&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Право на достъп до личните Ви данни: имате право да получите потвърждение от нас дали се обработват лични данни за Вас и, ако случаят е такъв, имате право на достъп до личните данни и информация.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Право на поправка на лични данни: ако откриете, че личните данни, които обработваме за Вас, са неточни, имате право да ни накарате да коригираме тези лични данни.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Право на изтриване на лични данни (правото да бъдете забравени): при определени обстоятелства, като например ако личните Ви данни са обработени незаконно или сте оттеглили съгласието си (ако обработката на личните данни е базирана на съгласие), имате право да поискате и да получите изтриване на личните Ви данни от наша страна.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Право на ограничаване на обработването: при определени обстоятелства, като например ако се съмнявате в точността на личните Ви данни или сте възразили на легитимната ни цел за обработка на личните Ви данни, имате право да поискате да ограничим обработката на Вашите лични данни, докато не бъде намерено решение.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Право на възражение срещу обработването: при определени обстоятелства, като например ако се съмнявате в легитимния ни интерес да обработваме Вашите лични данни, имате право да възразите по съображения, свързани с конкретната Ви ситуация, срещу подобно обработване.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Право на преносимост на данни: ако личните Ви данни се обработват с автоматични средства по Ваше съгласие или с цел изпълнение на нашите договорни отношения, имате право да поискате да Ви предоставим личните Ви данни в машинно четим формат за прехвърляне към друг контрольор на данни.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Право на подаване на жалба в контролен орган: имате право да подадете жалба по отношение на обработката на Вашите лични данни от нас в съответния контролен орган.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Контакти:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Администратор: С 601 ООД ЕИК 207158019, ж.к.”Възраждане” бл. 61, вх.2, ет.4, Варна 9000, България, тел. +359 879 40 88 78&amp;nbsp; Длъжностно лице по защита на данните/ Data Protection Officer: Живка Петкова; email: office@kef4eto.com&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span id=&quot;docs-internal-guid-d450e6aa-7fff-490c-a86b-951d466cfc65&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;\r\n','Политика за поверителност','',''),(4,1,'За нас','&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-indent: 36pt;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(0, 0, 0); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Магазин Кефчето 1 - Варна, Колхозен пазар отваря врати през декември месец 2017 година, а 5 години по-късно пак декември 2022 година отваря и вторият ни магазин Кефчето - Чаталджа на ул. Сава Радулов 10.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-indent: 36pt;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(0, 0, 0); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Над входовете и на двата ни магазина има реклама с логото “Усмихни се с Кефчето” и “Кефчето - магазин за усмивки” като това е нашето разбиране за обслужване и начин на работа с клиенти. Предлаганите стоки са в изключително голямо разнообразие като се започне от перилни, почистващи и всякакви препарати за домакинството и се стигне до почти всички съдове и пособия на домашните потреби. Броя на видовете&amp;nbsp; предлагани от нас артикули надхвърля 3500, което ни позволява почти напълно да посрещнем нуждите на клиентите - било то за дома или за градината.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-indent: 36pt;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(0, 0, 0); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Екипът, който работи и в двата обекта е много сплотен и най- важното, винаги усмихнат. През годините много хора ни се довериха и повярваха в качеството на предлаганите от нас продукти, което от само себе си доведе до необходимостта да отворим втори обект, а сега и интернет магазин. Надяваме се качеството на предлаганата от нас услуга да е на същото високо ниво и в глобалното интернет пространство както е в реалните ни търговски обекти.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-indent: 36pt;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Приятно пазаруване и всичко най-добро на посетителите на сайта!&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span id=&quot;docs-internal-guid-f8766d3b-7fff-7d5d-9430-a13256aa316d&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;\r\n','За нас','',''),(7,1,'Гаранция','&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Гаранционните условия&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt; за всеки един от предлаганите в настоящия електронен магазин артикули са посочени в техните описания. Всеки потребител, закупил продукт от сайта, се приема, че се е запознал с гаранционния срок на закупения продукт и/или услуга. Всяка стока, закупена от Kef4eto.com, се изпраща към Купувача с Гаранционна карта, в която са упоменати гаранционните условия за дадения продукт. Стандартният минимален гаранционен срок на обновените продукти в Kef4eto.com е 3 месеца.&amp;nbsp; За отделни конфигурации е определен гаранционен срок между 6 и 36 месеца, който е изрично указан. За всяка &lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;нова &lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;стока гаранционният срок е конкретизиран в описанието на продукта. Продукта се доставя с гаранция от производител и се обслужва само в оторизираните национални сервизи.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Гаранция няма да бъде признавана при наличие на някое от следните събития:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;1. Изгубена или фалшифицирана гаранционна карта.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;2. Повреди, причинени от неправилна експлоатация.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;3. Опит за ремонт от неоторизиран сервиз.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;4. Химическо, електрическо или друго въздействие върху продукта, което не е свързано с нормалната му експлоатация.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;5. Нарушена физическа цялост на изделието.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Гаранционните задължения на Kef4eto.com, спрямо продуктите и услугите, които се предлагат в този сайт, са обект на споразумения с вносителите и/или дистрибуторите на представяните продукти и нищо в този Сайт не може да ги промени.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: center;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Информация за правата на потребителите, произтичащи от законовата гаранция по чл. 112-115 от ЗЗП.&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Чл. 112.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;При несъответствие на потребителската стока с договора за продажба потребителят има право да предяви рекламация, като поиска от продавача да приведе стоката в съответствие с договора за продажба. В този случай потребителят може да избира между извършване на ремонт на стоката или замяната й с нова, освен ако това е невъзможно или избраният от него начин за обезщетение е непропорционален в сравнение с другия.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Смята се, че даден начин за обезщетяване на потребителя е непропорционален, ако неговото използване налага разходи на продавача, които в сравнение с другия начин на обезщетяване са неразумни, като се вземат предвид: 1. стойността на потребителската стока, ако нямаше липса на несъответствие; 2. значимостта на несъответствието;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;възможността да се предложи на потребителя друг начин на обезщетяване, който не е свързан със значителни неудобства за него.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Чл. 113.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Когато потребителската стока не съответства на договора за продажба, продавачът е длъжен да я приведе в съответствие с договора за продажба.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Привеждането на потребителската стока в съответствие с договора за продажба трябва да се извърши в рамките на един месец, считано от предявяването на рекламацията от потребителя.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;След изтичането на срока по ал. 2 потребителят има право да развали договора и да му бъде възстановена заплатената сума или да иска намаляване на цената на потребителската стока съгласно чл. 114.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Привеждането на потребителската стока в съответствие с договора за продажба е безплатно за потребителя. Той не дължи разходи за експедиране на потребителската стока или за материали и труд, свързани с ремонта й, и не трябва да понася значителни неудобства.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Потребителят може да иска и обезщетение за претърпените вследствие на несъответствието вреди.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Чл. 114.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;При несъответствие на потребителската стока с договора за продажба и когато потребителят не е удовлетворен от решаването на рекламацията по чл. 113, той има право на избор между една от следните възможности:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;разваляне на договора и възстановяване на заплатената от него сума;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;намаляване на цената.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Потребителят не може да претендира за възстановяване на заплатената сума или за намаляване цената на стоката, когато търговецът се съгласи да бъде извършена замяна на потребителската стока с нова или да се поправи стоката в рамките на един месец от предявяване на рекламацията от потребителя.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Търговецът е длъжен да удовлетвори искане за разваляне на договора и да възстанови заплатената от потребителя сума, когато след като е удовлетворил три рекламации на потребителя чрез извършване на ремонт на една и съща стока, в рамките на срока на гаранцията по чл. 115, е налице следваща поява на несъответствие на стоката с договора за продажба.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Потребителят не може да претендира за разваляне на договора, ако несъответствието на потребителската стока с договора е незначително.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Чл. 115.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Потребителят може да упражни правото си по този раздел в срок до две години, считано от доставянето на потребителската стока.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Срокът по ал. 1 спира да тече през времето, необходимо за поправката или замяната на потребителската стока или за постигане на споразумение между продавача и потребителя за решаване на спора.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Упражняването на правото на потребителя по ал. 1 не е обвързано с никакъв друг срок за предявяване на иск, различен от срока по ал. 1.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span id=&quot;docs-internal-guid-bd1c1db4-7fff-ee8d-6e8c-6756e37243a3&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;','Гаранция','',''),(5,1,'Правила','&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-indent: 36pt;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Внимателно се запознайте с условията и правилата за ползване на този уеб сайт. Ако използвате този уеб сайт, се счита, че приемате и сте съгласни с тези условия. Ако НЕ приемате&amp;nbsp; изброените по-долу условия, моля не използвайте този уеб сайт.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Настоящият документ съдържа Общите условия, съгласно които всеки потребител може да ползва Kef4eto.com&amp;nbsp; – електронен магазин за стоки и услуги.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-indent: 36pt;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Условията и правилата за ползване уреждат правата на всички потребители на електронния магазин. Закупувайки и използвайки продукти и/или услуги, разположени на Kef4eto.com,&amp;nbsp; Потребителят се съгласява, безрезервно приема и се задължава да спазва настоящите Общи условия и правила за ползване на сайта.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;1.&amp;nbsp; &amp;nbsp; Kef4eto.com&amp;nbsp; (наричан по-долу &quot;Доставчик&quot;)&amp;nbsp; ви дава право да ползвате и разглеждате всички материали, които са публикувани в този Web сайт (наричан по-долу &quot;Сайт&quot;) само за лична употреба с нетърговска цел при условие, че се спазват&amp;nbsp; всички авторски права и съответните означения. Забранени са промяната, копирането и разпространението на материалите от&amp;nbsp; Сайта.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;2.&amp;nbsp; &amp;nbsp; Характеристиките на продуктите и услугите, поместени в Сайта, са на база предоставената информация от доставчиците на съответната стока и/или услуга, спрямо влезлите в сила споразумения. Kef4eto.com си запазва правото да прави промени по описанията, техническите характеристики, цените и цялата продуктова информация, публикувана на сайта, по всяко време и без предупреждение с цел предоставяне на най-актуална информация.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;3.&amp;nbsp; &amp;nbsp; Отговорността на Kef4eto.com за предоставените стоки и/или услуги се ограничава до действията, свързани с тяхната доставка и упоменатите Гаранционни условия. Сайтът по никакъв начин не носи отговорност за щети от пропуснати ползи от ползване на закупен продукт от Сайта.&amp;nbsp;&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;4.&amp;nbsp; &amp;nbsp; Регистриране на Потребител &lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Потребителят следва да предостави пълна и вярна информация за себе си при попълване на регистрационната форма; &lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;При промяна на предоставените първоначално данни, потребителят следва да ги коригира с цел тяхната вярност и коректното им използване.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;5.&amp;nbsp; &amp;nbsp; Лични данни &lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Законът за защита на личните данни гарантира достъпа на Потребителя до въведените от него Лични данни. Потребителят има право по всяко време да променя предоставените от него Лични данни, използвани в Сайта за покупка и доставка на предоставените от Kef4eto.com продукти и/или услуги.&amp;nbsp; &lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Всички предоставени от Потребителя данни и други Данни, ползвани за неговата идентификация, при ползване на Сайта се съхраняват, обработват и използват единствено с цел предоставяне на продуктите и/или услугите, поместени в електронния магазин.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;6.&amp;nbsp; &amp;nbsp; Достъп до сайта и сигурност на потребителя&amp;nbsp; &lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Всеки Потребител получава уникално потребителско име и парола за достъп до предлаганите стоки и/или услуги след завършване на своята регистрация.&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Kef4eto.com по никакъв начин не предоставя информация за потребителските имена и пароли на своите потребители на трети лица, с изключение на тези, които имат законовото право за това и са изискали тази информация по съответния нормативен ред.&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Ползвателите на Сайта са отговорни за конфиденциалността на получените потребителско име и парола. Ползването им декларира, че те лично и от свое име са изцяло отговорни за всички дейности, извършени с техните потребителско име и парола. &lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Потребителят следва да уведоми Сайта при наличие на неоторизирано ползване на акаунта или нарушаване на сигурността.&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;При забравяне или загубване на паролата за достъп, потребителят следва да спази процедурата по нейното възстановяване, следвайки указания за „Забравена Парола“.&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;При неспазване на описаните в тази точка условия, Kef4eto.com не носи отговорност за щети от какъвто и да е характер.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;7.&amp;nbsp; &amp;nbsp; Публикуване на информация от Потребител&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Потребителите имат право да оставят мнение за закупените от тях продукти и за обслужването, което са получили, ползвайки възможностите на Kef4eto.com. Сайтът по никакъв начин не носи отговорност за публикуваната от Потребителя информация. Администраторите на Kef4eto.com имат право да изтрият коментари, които съдържат обидно или нецензурно съдържание.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;8.&amp;nbsp; &amp;nbsp; Линкове към други Web сайтове&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Всички препратки от Kef4eto.com към други сайтове са поместени единствено за удобство на потребителите. Kef4eto.com няма отношение и не носи отговорност за съдържанието, поместено в тях. &lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Препратки към Kef4eto.com могат да се правят единствено след изричното съгласуване на това с представител на електронния магазин чрез посочената контактна информация.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;9.&amp;nbsp; &amp;nbsp; Всички, публикувани на сайта цени, са в български лева с включен ДДС&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;10.&amp;nbsp; &amp;nbsp; Продуктовите характеристики за всеки продукт/услуга са упоменати в описанието на предлаганата стока. Снимките на продуктите са примерни и не изобразяват конкретна предлагана бройка.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;11.&amp;nbsp; &amp;nbsp; Цената на доставката се поема от Купувача спрямо използваната куриерска услуга във всички случаи, с изключение на изрично посочените, в които тя е безплатна.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;12.&amp;nbsp; &amp;nbsp; Kef4eto.com е електронен магазин, разработен, притежаван и поддържан от C 601 ООД, гр. Варна, ж.к.”Възраждане” бл. 61, вх.2, ет.4&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.92;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Всеки потребител на ел. магазин има правото да използва интернет платформата за решаване на потребителски спорове (&lt;/span&gt;&lt;a href=&quot;https://webgate.ec.europa.eu/odr/main/index.cfm?event=main.home.show&amp;amp;lng=BG&quot; style=&quot;text-decoration:none;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;ОРС&lt;/span&gt;&lt;/a&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;) на Европейската комисия (ЕК) или да се обърне към КЗП на адрес &lt;/span&gt;&lt;a href=&quot;https://www.kzp.bg/&quot; style=&quot;text-decoration:none;&quot;&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;kzp.bg&lt;/span&gt;&lt;/a&gt;&lt;span style=&quot;font-size:12pt;font-family:Comfortaa,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;.&lt;/span&gt;&lt;/p&gt;\r\n','Правила','',''),(6,1,'Безплатна доставка за 1 ден','&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;1.&amp;nbsp; Потребителят има право да поръчва стоки и услуги, представяни от &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;&amp;nbsp; като след избирането им те автоматично се добавят към електронната кошница на Потребителя. В процеса на поръчка, Потребителят&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;има право да избере стоките и количеството им, начинът и сроковете за доставка според предложените на Сайта варианти.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:8pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Актуални са следните начини за доставка. Посочените варианти са в сила от 01.01.2024:&lt;/span&gt;&lt;/p&gt;&lt;ul style=&quot;margin-top:0;margin-bottom:0;padding-inline-start:48px;&quot;&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:10pt;font-family:Comfortaa,sans-serif;color:#232323;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;При покупка на стойност над 100 лева, Потребителят&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;получава &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;безплатна доставка до офис на куриерска фирма &quot;Спиди&quot;.&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:10pt;font-family:Comfortaa,sans-serif;color:#232323;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;При покупка на стойност над 100 лева, Потребителят&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;може да получи стоката с &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;доставка до адрес с куриерска фирма &quot;Спиди&quot; на стойност 10 лева&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;.&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;li dir=&quot;ltr&quot; style=&quot;list-style-type:disc;font-size:10pt;font-family:Comfortaa,sans-serif;color:#232323;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;&quot; aria-level=&quot;1&quot;&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;background-color:#ffffff;margin-top:0pt;margin-bottom:8pt;&quot; role=&quot;presentation&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Потребителят&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;има възможност да избере &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;доставка с куриерска фирма &quot;Еконт&quot;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;, с което се начислява такса от 15 лева независимо от стойността на поръчката.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Поръчка направена до 15:00 в официален работен ден и след потвърждение от оператор на &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;, се доставя на следващия ден. Поръчка направена след 15:00 в официален работен ден, събота, неделя или на официален празник се изпълняват в първия работен ден.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;* &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; се стреми да спазва стриктно посочените по-горе срокове и уведомява Потребителя&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;с email при промяна на статус на поръчка.&amp;nbsp;&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;2.&amp;nbsp; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; има правото да променя цените на предлаганите стоки и/или услуги, по всяко време, без да е необходимо предварително да уведомява Потребителите. Потребителят е длъжен да заплати цената, която е била посочена на Сайта по време на потвърждаване на поръчката, независимо дали е по-ниска или по-висока от настоящата в момента.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;3.&amp;nbsp; &amp;nbsp; Преди потвърждаване на Поръчката&amp;nbsp; потребителят има право да прави промени в своята кошница на избраните от него стоки и услуги. &lt;/span&gt;&lt;span style=&quot;font-size:10pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;При потвърждаване на поръчка на Сайта потребителят влиза в договорни отношения с &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;, касаещи конкретната покупка и покрити от Общите условия, публикувани на Сайта.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:10pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;4.&amp;nbsp; &amp;nbsp;&lt;span style=&quot;font-size: 12pt;&quot;&gt; &lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; следи за навременното качване и актуализиране на цените и условията за покупка на всички публикувани стоки и услуги на Сайта. При допуснати технически грешки в публикуването на продуктите, &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; има правото да откаже изпълнението на поръчката като не дължи обезщетение по никакъв начин на Потребителя, освен за да възстанови сумите, платени и/или депозирани от потребителя в техния пълен размер, ако има такива.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;5.&amp;nbsp; &amp;nbsp; Доставката на поръчаните стоки се извършва единствено спрямо избрания от Потребителя&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;начин и съобразно посочените от него за дадения продукт или услуга срокове на доставка. При проблем с доставката и/или невъзможност за нейното осъществяване, &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; своевременно уведомява Потребителя&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;за това.&amp;nbsp;&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;6.&amp;nbsp; &amp;nbsp; Плащане на закупени стоки и услуги &lt;/span&gt;&lt;span style=&quot;font-size:10pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;При плащане по банков път, с кредитна или дебитна карта, Потребителят&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;превежда сума равна на стойността на направената поръчка. След потвърждаване на плащането се изпращат и доставят поръчаните стоки и услуги. Ако клиентът иска да върне частично или изцяло закупените от него стоки в определения от закона &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;14-дневен срок&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;, &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; се задължава да възстанови частично или изцяло преведената от Потребителя&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;сума.&amp;nbsp;&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: justify;background-color:#ffffff;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 8pt 0pt;&quot;&gt;&lt;span style=&quot;font-size:10pt;font-family:Comfortaa,sans-serif;color:#333333;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;7.&amp;nbsp; &amp;nbsp; &lt;span style=&quot;font-size: 12pt;&quot;&gt;При плащане с наложен платеж или в брой на заявените стоки и услуги Потребителят&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;се задължава да заплати в момента на доставката на &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; или на негов представител, извършващ доставката, пълната стойност на поръчката. Ако клиентът иска да върне частично или изцяло закупените от него стоки в определения от закона &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;14-дневен срок&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;, &lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 700; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt;Kef4eto.com&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa, sans-serif; color: rgb(51, 51, 51); background-color: transparent; font-weight: 400; font-style: normal; font-variant: normal; text-decoration: none; vertical-align: baseline; white-space: pre-wrap;&quot;&gt; се задължава да възстанови частично или изцяло преведената от Потребителя сума.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span id=&quot;docs-internal-guid-79af43be-7fff-d6f8-a258-d9faca83bf32&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;','Безплатна доставка за 1 ден','',''),(8,1,'Как да купя през сайта','&lt;p&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa;&quot;&gt;1. Разглеждане на категориите и продуктите: Открийте началната страница на магазина и използвайте менюто за навигация, за да разгледате различните категории продукти. Кликнете върху категорията, която ви интересува, за да видите всички налични продукти в нея.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa;&quot;&gt;2. Натискане на бутона &quot;Купи&quot;: Когато намерите желания от вас продукт, кликнете върху него за повече детайли. Ако сте готови да го купите, натиснете бутона &quot;Купи&quot;.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa;&quot;&gt;3. Добавяне в количката: След като натиснете бутона &quot;Купи&quot;, продуктът автоматично ще бъде добавен във вашата количка. Можете да продължите пазаруването или да преминете към количката си за да финализирате поръчката.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa;&quot;&gt;4. Попълване на данни за доставка: В количката ще видите опция за въвеждане на адреса за доставка. Попълнете необходимите данни за доставка, включително име, адрес и телефонен номер.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa;&quot;&gt;5. Избор на начин на плащане: След като попълните адреса за доставка, изберете желания от вас метод за плащане - кредитна карта, банков превод, плащане при доставка или друга налична опция.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa;&quot;&gt;6. Избор на метод на доставка: Изберете предпочитания от вас метод на доставка, като се има предвид предлаганите опции от магазина - куриерска фирма, лично вземане и други.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa;&quot;&gt;7. Преглед на данните: Преди завършване на поръчката ще имате възможност да прегледате всички детайли по нея, включително продуктите, адреса за доставка, метода на плащане и доставка. Уверете се, че всичко е коректно преди да продължите.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa;&quot;&gt;8. Завършване на поръчката: След като сте проверили и потвърдили всички детайли, кликнете бутона за финализиране на поръчката.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 12pt; font-family: Comfortaa;&quot;&gt;9. Получаване на имейл с данните за поръчката: След успешно завършване на поръчката, ще получите имейл потвърждение с всички детайли за вашата поръчка, включително номер на поръчката и информация за проследяване на доставката (ако е приложимо).&lt;/span&gt;&lt;/p&gt;','Как да купя през сайта','','');
/*!40000 ALTER TABLE `oc_information_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_information_to_layout`
--

DROP TABLE IF EXISTS `oc_information_to_layout`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_information_to_layout` (
  `information_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  `layout_id` int(11) NOT NULL,
  PRIMARY KEY (`information_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_information_to_layout`
--

LOCK TABLES `oc_information_to_layout` WRITE;
/*!40000 ALTER TABLE `oc_information_to_layout` DISABLE KEYS */;
INSERT INTO `oc_information_to_layout` (`information_id`, `store_id`, `layout_id`) VALUES (6,0,0),(4,0,0),(7,0,0),(3,0,0),(5,0,0),(8,0,0);
/*!40000 ALTER TABLE `oc_information_to_layout` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_information_to_store`
--

DROP TABLE IF EXISTS `oc_information_to_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_information_to_store` (
  `information_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  PRIMARY KEY (`information_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_information_to_store`
--

LOCK TABLES `oc_information_to_store` WRITE;
/*!40000 ALTER TABLE `oc_information_to_store` DISABLE KEYS */;
INSERT INTO `oc_information_to_store` (`information_id`, `store_id`) VALUES (3,0),(4,0),(5,0),(6,0),(7,0),(8,0);
/*!40000 ALTER TABLE `oc_information_to_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_language`
--

DROP TABLE IF EXISTS `oc_language`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_language` (
  `language_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `code` varchar(5) NOT NULL,
  `locale` varchar(255) NOT NULL,
  `image` varchar(64) NOT NULL,
  `directory` varchar(32) NOT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`language_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_language`
--

LOCK TABLES `oc_language` WRITE;
/*!40000 ALTER TABLE `oc_language` DISABLE KEYS */;
INSERT INTO `oc_language` (`language_id`, `name`, `code`, `locale`, `image`, `directory`, `sort_order`, `status`) VALUES (1,'Bulgarian','bg-bg','bg-BG,bg_BG.UTF-8,bg_BG,bg-BG,bulgarian','gb.png','english',1,1);
/*!40000 ALTER TABLE `oc_language` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_layout`
--

DROP TABLE IF EXISTS `oc_layout`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_layout` (
  `layout_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY (`layout_id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_layout`
--

LOCK TABLES `oc_layout` WRITE;
/*!40000 ALTER TABLE `oc_layout` DISABLE KEYS */;
INSERT INTO `oc_layout` (`layout_id`, `name`) VALUES (1,'Home'),(2,'Product'),(3,'Category'),(4,'Default'),(5,'Manufacturer'),(6,'Account'),(7,'Checkout'),(8,'Contact'),(9,'Sitemap'),(10,'Affiliate'),(11,'Information'),(12,'Compare'),(13,'Search');
/*!40000 ALTER TABLE `oc_layout` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_layout_module`
--

DROP TABLE IF EXISTS `oc_layout_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_layout_module` (
  `layout_module_id` int(11) NOT NULL AUTO_INCREMENT,
  `layout_id` int(11) NOT NULL,
  `code` varchar(64) NOT NULL,
  `position` varchar(14) NOT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`layout_module_id`)
) ENGINE=MyISAM AUTO_INCREMENT=230 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_layout_module`
--

LOCK TABLES `oc_layout_module` WRITE;
/*!40000 ALTER TABLE `oc_layout_module` DISABLE KEYS */;
INSERT INTO `oc_layout_module` (`layout_module_id`, `layout_id`, `code`, `position`, `sort_order`) VALUES (2,4,'0','content_top',0),(3,4,'0','content_top',1),(20,5,'0','column_left',2),(69,10,'account','column_right',1),(68,6,'account','column_right',1),(229,1,'carousel.29','content_bottom',0),(174,3,'category','column_left',1),(228,1,'latest_products_category.34','content_top',7),(227,1,'latest_products_category.37','content_top',6),(141,11,'carousel.29','content_bottom',0),(226,1,'latest_products_category.36','content_top',5),(225,1,'latest_products_category.40','content_top',4),(224,1,'latest_products_category.35','content_top',3),(223,1,'latest_products_category.39','content_top',2),(222,1,'html.33','content_top',1),(221,1,'slideshow.27','content_top',0);
/*!40000 ALTER TABLE `oc_layout_module` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_layout_route`
--

DROP TABLE IF EXISTS `oc_layout_route`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_layout_route` (
  `layout_route_id` int(11) NOT NULL AUTO_INCREMENT,
  `layout_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  `route` varchar(64) NOT NULL,
  PRIMARY KEY (`layout_route_id`)
) ENGINE=MyISAM AUTO_INCREMENT=87 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_layout_route`
--

LOCK TABLES `oc_layout_route` WRITE;
/*!40000 ALTER TABLE `oc_layout_route` DISABLE KEYS */;
INSERT INTO `oc_layout_route` (`layout_route_id`, `layout_id`, `store_id`, `route`) VALUES (38,6,0,'account/%'),(17,10,0,'affiliate/%'),(79,3,0,'product/category'),(86,1,0,'common/home'),(20,2,0,'product/product'),(72,11,0,'information/information'),(23,7,0,'checkout/%'),(31,8,0,'information/contact'),(32,9,0,'information/sitemap'),(34,4,0,''),(45,5,0,'product/manufacturer'),(52,12,0,'product/compare'),(53,13,0,'product/search');
/*!40000 ALTER TABLE `oc_layout_route` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_length_class`
--

DROP TABLE IF EXISTS `oc_length_class`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_length_class` (
  `length_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `value` decimal(15,8) NOT NULL,
  PRIMARY KEY (`length_class_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_length_class`
--

LOCK TABLES `oc_length_class` WRITE;
/*!40000 ALTER TABLE `oc_length_class` DISABLE KEYS */;
INSERT INTO `oc_length_class` (`length_class_id`, `value`) VALUES (1,1.00000000),(2,10.00000000),(3,0.39370000);
/*!40000 ALTER TABLE `oc_length_class` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_length_class_description`
--

DROP TABLE IF EXISTS `oc_length_class_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_length_class_description` (
  `length_class_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `title` varchar(32) NOT NULL,
  `unit` varchar(4) NOT NULL,
  PRIMARY KEY (`length_class_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_length_class_description`
--

LOCK TABLES `oc_length_class_description` WRITE;
/*!40000 ALTER TABLE `oc_length_class_description` DISABLE KEYS */;
INSERT INTO `oc_length_class_description` (`length_class_id`, `language_id`, `title`, `unit`) VALUES (1,1,'Centimeter','cm'),(2,1,'Millimeter','mm'),(3,1,'Inch','in');
/*!40000 ALTER TABLE `oc_length_class_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_location`
--

DROP TABLE IF EXISTS `oc_location`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_location` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `address` text NOT NULL,
  `telephone` varchar(32) NOT NULL,
  `fax` varchar(32) NOT NULL,
  `geocode` varchar(32) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `open` text NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_location`
--

LOCK TABLES `oc_location` WRITE;
/*!40000 ALTER TABLE `oc_location` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_location` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_manufacturer`
--

DROP TABLE IF EXISTS `oc_manufacturer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_manufacturer` (
  `manufacturer_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`manufacturer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_manufacturer`
--

LOCK TABLES `oc_manufacturer` WRITE;
/*!40000 ALTER TABLE `oc_manufacturer` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_manufacturer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_manufacturer_to_store`
--

DROP TABLE IF EXISTS `oc_manufacturer_to_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_manufacturer_to_store` (
  `manufacturer_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  PRIMARY KEY (`manufacturer_id`,`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_manufacturer_to_store`
--

LOCK TABLES `oc_manufacturer_to_store` WRITE;
/*!40000 ALTER TABLE `oc_manufacturer_to_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_manufacturer_to_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_marketing`
--

DROP TABLE IF EXISTS `oc_marketing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_marketing` (
  `marketing_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `description` text NOT NULL,
  `code` varchar(64) NOT NULL,
  `clicks` int(5) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`marketing_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_marketing`
--

LOCK TABLES `oc_marketing` WRITE;
/*!40000 ALTER TABLE `oc_marketing` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_marketing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_modification`
--

DROP TABLE IF EXISTS `oc_modification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_modification` (
  `modification_id` int(11) NOT NULL AUTO_INCREMENT,
  `extension_install_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `code` varchar(64) NOT NULL,
  `author` varchar(64) NOT NULL,
  `version` varchar(32) NOT NULL,
  `link` varchar(255) NOT NULL,
  `xml` mediumtext NOT NULL,
  `status` tinyint(1) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`modification_id`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_modification`
--

LOCK TABLES `oc_modification` WRITE;
/*!40000 ALTER TABLE `oc_modification` DISABLE KEYS */;
INSERT INTO `oc_modification` (`modification_id`, `extension_install_id`, `name`, `code`, `author`, `version`, `link`, `xml`, `status`, `date_added`) VALUES (44,48,'Fixes Kef4eto.com OC3','MarketShop Theme Fixes','Svilen Zhelev','1.0.0','https://kef4eto.com','<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<modification>\r\n    <name>Fixes Kef4eto.com OC3</name>\r\n    <code>MarketShop Theme Fixes</code>\r\n    <version>1.0.0</version>\r\n    <author>Svilen Zhelev</author>\r\n    <link>https://kef4eto.com</link>\r\n\r\n    <file path=\"catalog/view/theme/marketshop/template/common/header.twig\">\r\n        <operation>\r\n            <search><![CDATA[{% set font = marketshop_body_font|replace(\"+\", \" \") %}]]></search>\r\n            <add position=\"replace\"><![CDATA[{% set font = marketshop_body_font|replace({\"+\": \" \"}) %}]]></add>\r\n        </operation>\r\n        <operation>\r\n            <search><![CDATA[<li class=\"mobile\"><i class=\"fa fa-phone\"></i>{{ marketshop_top_bar_contact[lang] }}</li>]]></search>\r\n            <add position=\"replace\"><![CDATA[<li class=\"mobile\"><a href=\"tel:{{ marketshop_top_bar_contact[lang] }}\"><i class=\"fa fa-phone\"></i>{{ marketshop_top_bar_contact[lang] }}</a></li>]]></add>\r\n        </operation>\r\n        <operation>\r\n            <search><![CDATA[<li><a href=\"{{ marketshop_custom_link1_top_url }}\" target=\"{{ marketshop_target_link1_top }}\"> {{ marketshop_custom_link1_top_title[lang] }}</a></li>]]></search>\r\n            <add position=\"replace\"><![CDATA[<li><a href=\"{{ marketshop_custom_link1_top_url }}\" target=\"{{ marketshop_target_link1_top }}\"><i class=\"fa fa-facebook\"></i> {{ marketshop_custom_link1_top_title[lang] }}</a></li>]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/common/header.php\">\r\n        <operation>\r\n            <search><![CDATA[$data[\'home\'] = $this->url->link(\'common/home\');]]></search>\r\n            <add position=\"replace\"><![CDATA[\r\n            $data[\'home\'] = \'/\'; // Set the logo link to root\r\n            ]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/view/theme/marketshop/template/common/footer.twig\">\r\n            <operation>\r\n            <search><![CDATA[<li class=\"address\"><i class=\"fa fa-map-marker\"></i>{{ marketshop_address[lang] }}</li>]]></search>\r\n            <add position=\"after\"><![CDATA[\r\n            <li class=\"address\"><i class=\"fa fa-map-marker\"></i><a href=\"https://maps.app.goo.gl/vNTZP7bAucWBnwPM8\" target=\"_blank\">Магазин&nbsp;2:&nbsp;Варна,&nbsp;Чаталджа, ул.&nbsp;\"Сава&nbsp;Радулов\"&nbsp;10</a></li>\r\n            ]]></add>\r\n        </operation>\r\n        <operation>\r\n            <search><![CDATA[<li class=\"address\"><i class=\"fa fa-map-marker\"></i>{{ marketshop_address[lang] }}</li>]]></search>\r\n            <add position=\"replace\"><![CDATA[<li class=\"address\"><i class=\"fa fa-map-marker\"></i><a href=\"https://maps.app.goo.gl/FcHbH4EtCyoPavps6\" target=\"_blank\">Магазин&nbsp;1:&nbsp;Варна,&nbsp;Колхозен пазар, ул.&nbsp;„Ангел&nbsp;Кънчев“&nbsp;4</a></li>]]></add>\r\n        </operation>\r\n        <operation>\r\n            <search><![CDATA[<li class=\"mobile\"><i class=\"fa fa-phone\"></i>{{ marketshop_mobile[lang] }}</li>]]></search>\r\n            <add position=\"replace\"><![CDATA[<li class=\"mobile\"><i class=\"fa fa-phone\"></i><a href=\"tel:{{ marketshop_mobile[lang] }}\">{{ marketshop_mobile[lang] }}</a></li>]]></add>\r\n        </operation>\r\n        <operation>\r\n            <search><![CDATA[<li class=\"email\"><i class=\"fa fa-envelope\"></i>{{ marketshop_email[lang] }} <a href=\"{{ contact }}\">{{ text_contact }}</a></li>]]></search>\r\n            <add position=\"replace\"><![CDATA[<li class=\"email\"><i class=\"fa fa-envelope\"></i><a href=\"mailto:{{ marketshop_email[lang] }}\">{{ marketshop_email[lang] }}</a></li>]]></add>\r\n        </operation>\r\n         <operation>\r\n            <search><![CDATA[<img src=\"{{ path_image ~ marketshop_custom_payment_image }}\" alt=\"Payment\" title=\"Payment\">]]></search>\r\n            <add position=\"after\">\r\n            <![CDATA[<img data-toggle=\"tooltip\" src=\"image/catalog/payments/bankwire.png\" alt=\"bank\" title=\"\" data-original-title=\"По сметка\">]]>\r\n            </add>\r\n        </operation>\r\n        <operation>\r\n            <search><![CDATA[<img src=\"{{ path_image ~ marketshop_custom_payment_image }}\" alt=\"Payment\" title=\"Payment\">]]></search>\r\n            <add position=\"replace\">\r\n            <![CDATA[<img data-toggle=\"tooltip\" src=\"{{ path_image ~ marketshop_custom_payment_image }}\" alt=\"cash\" title=\"\" data-original-title=\"В брой\">]]>\r\n            </add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/product/category.php\">\r\n        <operation>\r\n            <search><![CDATA[$order = \'ASC\';]]></search>\r\n            <add position=\"replace\"><![CDATA[$order = \'DESC\';]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/model/catalog/product.php\">\r\n        <operation>\r\n            <search><![CDATA[\'p.sort_order\',]]></search>\r\n            <add position=\"replace\"><![CDATA[\'p.image\',]]></add>\r\n        </operation>\r\n        <operation>\r\n            <search><![CDATA[$sql .= \" ORDER BY p.sort_order\";]]></search>\r\n            <add position=\"replace\"><![CDATA[$sql .= \" ORDER BY p.image\";]]></add>\r\n        </operation>\r\n        <operation>\r\n            <search><![CDATA[$sql .= \" LEFT JOIN \" . DB_PREFIX . \"product_description pd ON (p.product_id = pd.product_id) LEFT JOIN \" . DB_PREFIX . \"product_to_store p2s ON (p.product_id = p2s.product_id) WHERE pd.language_id = \'\" . (int)$this->config->get(\'config_language_id\') . \"\' AND p.status = \'1\' AND p.date_available <= NOW() AND p2s.store_id = \'\" . (int)$this->config->get(\'config_store_id\') . \"\'\";]]></search>\r\n            <add position=\"after\"><![CDATA[$sql .= \" AND p.quantity > 0\";]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/extension/module/latest_products_category.php\">\r\n        <operation>\r\n            <search><![CDATA[\'sort\'  => \'p.date_added\',]]></search>\r\n            <add position=\"replace\"><![CDATA[\'sort\'  => \'p.image\',]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/view/theme/marketshop/template/product/category.twig\">\r\n        <operation>\r\n            <search><![CDATA[<h4><a href=\"{{ product.href }}\">{{ product.name }}</a></h4>]]></search>\r\n            <add position=\"replace\"><![CDATA[<h4><a href=\"{{ product.href }}\">{{ product.name|length > 35 ? product.name|slice(0, 35) ~ \'...\' : product.name }}</a></h4>]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/view/theme/marketshop/template/product/product.twig\">\r\n        <operation>\r\n            <search><![CDATA[{{ description }}]]></search>\r\n            <add position=\"replace\"><![CDATA[\r\n            {{ description ? description : \'<div class=\"description-placeholder\">Продуктите предлагани от Kef4eto.com са селектирани след дългогодишна работа с проверени доставчици и постоянна обратна връзка с нашите клиенти.<br>Идеалният баланс цена/качество е основна цел при подбора на предлаганите продукти.</div>\' }}\r\n            ]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/product/product.php\">\r\n        <operation>\r\n            <search><![CDATA[$data[\'thumb\'] = \'\';]]></search>\r\n            <add position=\"replace\"><![CDATA[$data[\'thumb\'] = \'image/placeholder.png\';]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/checkout/guest.php\">\r\n        <operation>\r\n            <search><![CDATA[if ((utf8_strlen(trim($this->request->post[\'lastname\'])) < 1) || (utf8_strlen(trim($this->request->post[\'lastname\'])) > 32)) {]]></search>\r\n            <add position=\"replace\"><![CDATA[if (1>2) {]]></add>\r\n        </operation>\r\n        <operation>\r\n            <search><![CDATA[if ($country_info && $country_info[\'postcode_required\'] && (utf8_strlen(trim($this->request->post[\'postcode\'])) < 2 || utf8_strlen(trim($this->request->post[\'postcode\'])) > 10)) {]]></search>\r\n            <add position=\"replace\"><![CDATA[if (1>2) {]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/checkout/guest_shipping.php\">\r\n        <operation>\r\n            <search><![CDATA[if ((utf8_strlen(trim($this->request->post[\'lastname\'])) < 1) || (utf8_strlen(trim($this->request->post[\'lastname\'])) > 32)) {]]></search>\r\n            <add position=\"replace\"><![CDATA[if (1>2) {]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/checkout/register.php\">\r\n        <operation>\r\n            <search><![CDATA[if ((utf8_strlen(trim($this->request->post[\'lastname\'])) < 1) || (utf8_strlen(trim($this->request->post[\'lastname\'])) > 32)) {]]></search>\r\n            <add position=\"replace\"><![CDATA[if (1>2) {]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/checkout/payment_address.php\">\r\n        <operation>\r\n            <search><![CDATA[if ((utf8_strlen(trim($this->request->post[\'lastname\'])) < 1) || (utf8_strlen(trim($this->request->post[\'lastname\'])) > 32)) {]]></search>\r\n            <add position=\"replace\"><![CDATA[if (1>2) {]]></add>\r\n        </operation>\r\n    </file> \r\n    <file path=\"catalog/controller/checkout/shipping_address.php\">\r\n        <operation>\r\n            <search><![CDATA[if ((utf8_strlen(trim($this->request->post[\'lastname\'])) < 1) || (utf8_strlen(trim($this->request->post[\'lastname\'])) > 32)) {]]></search>\r\n            <add position=\"replace\"><![CDATA[if (1>2) {]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/account/register.php\">\r\n        <operation>\r\n            <search><![CDATA[if ((utf8_strlen(trim($this->request->post[\'lastname\'])) < 1) || (utf8_strlen(trim($this->request->post[\'lastname\'])) > 32)) {]]></search>\r\n            <add position=\"replace\"><![CDATA[if (1>2) {]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/account/edit.php\">\r\n        <operation>\r\n            <search><![CDATA[if ((utf8_strlen(trim($this->request->post[\'lastname\'])) < 1) || (utf8_strlen(trim($this->request->post[\'lastname\'])) > 32)) {]]></search>\r\n            <add position=\"replace\"><![CDATA[if (1>2) {]]></add>\r\n        </operation>\r\n    </file>\r\n    <file path=\"catalog/controller/account/address.php\">\r\n        <operation>\r\n            <search><![CDATA[if ((utf8_strlen(trim($this->request->post[\'lastname\'])) < 1) || (utf8_strlen(trim($this->request->post[\'lastname\'])) > 32)) {]]></search>\r\n            <add position=\"replace\"><![CDATA[if (1>2) {]]></add>\r\n        </operation>\r\n    </file>\r\n    \r\n</modification>\r\n                \r\n                \r\n\r\n            ',1,'2024-05-09 15:44:53');
/*!40000 ALTER TABLE `oc_modification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_module`
--

DROP TABLE IF EXISTS `oc_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_module` (
  `module_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `code` varchar(32) NOT NULL,
  `setting` text NOT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_module`
--

LOCK TABLES `oc_module` WRITE;
/*!40000 ALTER TABLE `oc_module` DISABLE KEYS */;
INSERT INTO `oc_module` (`module_id`, `name`, `code`, `setting`) VALUES (30,'Category','banner','{\"name\":\"Category\",\"banner_id\":\"6\",\"width\":\"182\",\"height\":\"182\",\"status\":\"1\"}'),(29,'Manufactirers logo carousel','carousel','{\"name\":\"Manufactirers logo carousel\",\"banner_id\":\"8\",\"width\":\"130\",\"height\":\"100\",\"status\":\"1\"}'),(28,'Home Page','featured','{\"name\":\"Home Page\",\"product_name\":\"\",\"product\":[\"43\",\"40\",\"42\",\"30\"],\"limit\":\"4\",\"width\":\"200\",\"height\":\"200\",\"status\":\"0\"}'),(27,'Home Page Slideshow','slideshow','{\"name\":\"Home Page Slideshow\",\"banner_id\":\"7\",\"width\":\"1140\",\"height\":\"380\",\"status\":\"1\"}'),(31,'Banner 1','banner','{\"name\":\"Banner 1\",\"banner_id\":\"6\",\"width\":\"182\",\"height\":\"182\",\"status\":\"1\"}'),(32,'Промоции','special','{\"name\":\"\\u041f\\u0440\\u043e\\u043c\\u043e\\u0446\\u0438\\u0438\",\"limit\":\"5\",\"width\":\"200\",\"height\":\"200\",\"status\":\"1\"}'),(33,'Custom categories section','html','{\"name\":\"Custom categories section\",\"module_description\":{\"1\":{\"title\":\"\",\"description\":\"&lt;link rel=&quot;stylesheet&quot; href=&quot;https:\\/\\/cdnjs.cloudflare.com\\/ajax\\/libs\\/font-awesome\\/6.0.0-beta3\\/css\\/all.min.css&quot;&gt;\\r\\n&lt;style&gt;\\r\\n    .home-page-cat-container {\\r\\n        display: flex;\\r\\n        flex-wrap: wrap;\\r\\n        justify-content: center;\\r\\n        padding: 20px 0 50px 0;\\r\\n    }\\r\\n    .home-page-cat-button {\\r\\n        display: flex;\\r\\n        flex-direction: column;\\r\\n        align-items: center;\\r\\n        justify-content: center;\\r\\n        width: 140px;\\r\\n        height: 140px;\\r\\n        margin: 10px;\\r\\n        background-color: #f7f7f7;\\r\\n        border: none;\\r\\n        border-radius: 1px;\\r\\n        box-shadow: 0 4px 8px rgba(0,0,0,0.1);\\r\\n        cursor: pointer;\\r\\n        transition: all 0.3s ease;\\r\\n        text-decoration: none; \\/* Removes underline from links *\\/\\r\\n        color: inherit; \\/* Ensures text color is not affected by link color *\\/\\r\\n    }\\r\\n    .home-page-cat-button:hover {\\r\\n        background-color: #e0e0e0;\\r\\n        box-shadow: 0 6px 12px rgba(0,0,0,0.15);\\r\\n    }\\r\\n    .home-page-cat-button i {\\r\\n        font-size: 36px; \\/* larger icon size *\\/\\r\\n        margin-bottom: 8px;\\r\\n    }\\r\\n    .home-page-cat-button p {\\r\\n        margin: 0;\\r\\n        font-size: 16px; \\/* larger text size *\\/\\r\\n        text-align: center; \\/* center the text *\\/\\r\\n    }\\r\\n    \\/* Icon color styles *\\/\\r\\n    .fa-bath { color: #5e9cd3; }\\r\\n    .fa-utensils { color: #f4a261; }\\r\\n    .fa-box-open { color: #3aa7a3; }\\r\\n    .fa-blender { color: #71797e; }\\r\\n    .fa-clipboard-list { color: #ffd700; }\\r\\n    .fa-soap { color: #98d9c2; }\\r\\n    .fa-glass-martini-alt { color: #ff6b6b; }\\r\\n&lt;\\/style&gt;\\r\\n\\r\\n&lt;div class=&quot;home-page-cat-container&quot;&gt;\\r\\n    &lt;a href=&quot;\\/preparati&quot; class=&quot;home-page-cat-button&quot;&gt;\\r\\n        &lt;i class=&quot;fas fa-soap&quot;&gt;&lt;\\/i&gt;\\r\\n        &lt;p&gt;\\u041f\\u0440\\u0435\\u043f\\u0430\\u0440\\u0430\\u0442\\u0438&lt;\\/p&gt;\\r\\n    &lt;\\/a&gt;\\r\\n    &lt;a href=&quot;\\/gotvene&quot; class=&quot;home-page-cat-button&quot;&gt;\\r\\n        &lt;i class=&quot;fas fa-utensils&quot;&gt;&lt;\\/i&gt;\\r\\n        &lt;p&gt;\\u0413\\u043e\\u0442\\u0432\\u0435\\u043d\\u0435&lt;\\/p&gt;\\r\\n    &lt;\\/a&gt;\\r\\n    &lt;a href=&quot;\\/servirane&quot; class=&quot;home-page-cat-button&quot;&gt;\\r\\n        &lt;i class=&quot;fas fa-glass-martini-alt&quot;&gt;&lt;\\/i&gt;\\r\\n        &lt;p&gt;\\u0421\\u0435\\u0440\\u0432\\u0438\\u0440\\u0430\\u043d\\u0435&lt;\\/p&gt;\\r\\n    &lt;\\/a&gt;\\r\\n    &lt;a href=&quot;\\/domashni-potrebi&quot; class=&quot;home-page-cat-button&quot;&gt;\\r\\n        &lt;i class=&quot;fas fa-box-open&quot;&gt;&lt;\\/i&gt;\\r\\n        &lt;p&gt;\\u0414\\u043e\\u043c\\u0430\\u0448\\u043d\\u0438 \\u043f\\u043e\\u0442\\u0440\\u0435\\u0431\\u0438&lt;\\/p&gt;\\r\\n    &lt;\\/a&gt;\\r\\n    &lt;a href=&quot;\\/elektricheski-uredi-i-materiali&quot; class=&quot;home-page-cat-button&quot;&gt;\\r\\n        &lt;i class=&quot;fas fa-blender&quot;&gt;&lt;\\/i&gt;\\r\\n        &lt;p&gt;\\u0415\\u043b. \\u0443\\u0440\\u0435\\u0434\\u0438 \\u0438 \\u043c\\u0430\\u0442\\u0435\\u0440\\u0438\\u0430\\u043b\\u0438&lt;\\/p&gt;\\r\\n    &lt;\\/a&gt;\\r\\n&lt;!--    \\r\\n\\t&lt;a href=&quot;\\/konsumativi&quot; class=&quot;home-page-cat-button&quot;&gt;\\r\\n        &lt;i class=&quot;fas fa-clipboard-list&quot;&gt;&lt;\\/i&gt;\\r\\n        &lt;p&gt;\\u041a\\u043e\\u043d\\u0441\\u0443\\u043c\\u0430\\u0442\\u0438\\u0432\\u0438&lt;\\/p&gt;\\r\\n    &lt;\\/a&gt;\\r\\n--&gt;\\r\\n    &lt;a href=&quot;\\/banya-pochistvane-i-toaletna&quot; class=&quot;home-page-cat-button&quot;&gt;\\r\\n        &lt;i class=&quot;fas fa-bath&quot;&gt;&lt;\\/i&gt;\\r\\n        &lt;p&gt;\\u0411\\u0430\\u043d\\u044f \\u0438 \\u0442\\u043e\\u0430\\u043b\\u0435\\u0442\\u043d\\u0430&lt;\\/p&gt;\\r\\n    &lt;\\/a&gt;\\r\\n&lt;\\/div&gt;\\r\\n\"}},\"status\":\"1\"}'),(34,'Bath cat home page row','latest_products_category','{\"name\":\"Bath cat home page row\",\"category_id\":\"44\",\"subcats\":\"filtering\",\"pmin\":\"1\",\"limit\":\"12\",\"width\":\"200\",\"height\":\"200\",\"status\":\"1\"}'),(35,'Cooking cat home page row','latest_products_category','{\"name\":\"Cooking cat home page row\",\"category_id\":\"79\",\"subcats\":\"filtering\",\"pmin\":\"1\",\"limit\":\"12\",\"width\":\"200\",\"height\":\"200\",\"status\":\"1\"}'),(36,'Household goods cat home page row','latest_products_category','{\"name\":\"Household goods cat home page row\",\"category_id\":\"94\",\"subcats\":\"filtering\",\"pmin\":\"1\",\"limit\":\"12\",\"width\":\"200\",\"height\":\"200\",\"status\":\"1\"}'),(37,'Appliances cat home page row','latest_products_category','{\"name\":\"Appliances cat home page row\",\"category_id\":\"48\",\"subcats\":\"filtering\",\"pmin\":\"1\",\"limit\":\"12\",\"width\":\"200\",\"height\":\"200\",\"status\":\"1\"}'),(38,'Consumables cat home page row','latest_products_category','{\"name\":\"Consumables cat home page row\",\"category_id\":\"20\",\"subcats\":\"none\",\"pmin\":\"1\",\"limit\":\"12\",\"width\":\"200\",\"height\":\"200\",\"status\":\"1\"}'),(39,'Cleaning agents cat home page row','latest_products_category','{\"name\":\"Cleaning agents cat home page row\",\"category_id\":\"71\",\"subcats\":\"filtering\",\"pmin\":\"1\",\"limit\":\"12\",\"width\":\"200\",\"height\":\"200\",\"status\":\"1\"}'),(40,'Serving cat home page row','latest_products_category','{\"name\":\"Serving cat home page row\",\"category_id\":\"30\",\"subcats\":\"filtering\",\"pmin\":\"1\",\"limit\":\"12\",\"width\":\"200\",\"height\":\"200\",\"status\":\"1\"}');
/*!40000 ALTER TABLE `oc_module` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_option`
--

DROP TABLE IF EXISTS `oc_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_option` (
  `option_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(32) NOT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`option_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_option`
--

LOCK TABLES `oc_option` WRITE;
/*!40000 ALTER TABLE `oc_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_option_description`
--

DROP TABLE IF EXISTS `oc_option_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_option_description` (
  `option_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`option_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_option_description`
--

LOCK TABLES `oc_option_description` WRITE;
/*!40000 ALTER TABLE `oc_option_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_option_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_option_value`
--

DROP TABLE IF EXISTS `oc_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_option_value` (
  `option_value_id` int(11) NOT NULL AUTO_INCREMENT,
  `option_id` int(11) NOT NULL,
  `image` varchar(255) NOT NULL,
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`option_value_id`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_option_value`
--

LOCK TABLES `oc_option_value` WRITE;
/*!40000 ALTER TABLE `oc_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_option_value_description`
--

DROP TABLE IF EXISTS `oc_option_value_description`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_option_value_description` (
  `option_value_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `option_id` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`option_value_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_option_value_description`
--

LOCK TABLES `oc_option_value_description` WRITE;
/*!40000 ALTER TABLE `oc_option_value_description` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_option_value_description` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_order`
--

DROP TABLE IF EXISTS `oc_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_order` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_no` int(11) NOT NULL DEFAULT '0',
  `invoice_prefix` varchar(26) NOT NULL,
  `store_id` int(11) NOT NULL DEFAULT '0',
  `store_name` varchar(64) NOT NULL,
  `store_url` varchar(255) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `customer_group_id` int(11) NOT NULL DEFAULT '0',
  `firstname` varchar(32) NOT NULL,
  `lastname` varchar(32) NOT NULL,
  `email` varchar(96) NOT NULL,
  `telephone` varchar(32) NOT NULL,
  `fax` varchar(32) NOT NULL,
  `custom_field` text NOT NULL,
  `payment_firstname` varchar(32) NOT NULL,
  `payment_lastname` varchar(32) NOT NULL,
  `payment_company` varchar(60) NOT NULL,
  `payment_address_1` varchar(128) NOT NULL,
  `payment_address_2` varchar(128) NOT NULL,
  `payment_city` varchar(128) NOT NULL,
  `payment_postcode` varchar(10) NOT NULL,
  `payment_country` varchar(128) NOT NULL,
  `payment_country_id` int(11) NOT NULL,
  `payment_zone` varchar(128) NOT NULL,
  `payment_zone_id` int(11) NOT NULL,
  `payment_address_format` text NOT NULL,
  `payment_custom_field` text NOT NULL,
  `payment_method` varchar(128) NOT NULL,
  `payment_code` varchar(128) NOT NULL,
  `shipping_firstname` varchar(32) NOT NULL,
  `shipping_lastname` varchar(32) NOT NULL,
  `shipping_company` varchar(40) NOT NULL,
  `shipping_address_1` varchar(128) NOT NULL,
  `shipping_address_2` varchar(128) NOT NULL,
  `shipping_city` varchar(128) NOT NULL,
  `shipping_postcode` varchar(10) NOT NULL,
  `shipping_country` varchar(128) NOT NULL,
  `shipping_country_id` int(11) NOT NULL,
  `shipping_zone` varchar(128) NOT NULL,
  `shipping_zone_id` int(11) NOT NULL,
  `shipping_address_format` text NOT NULL,
  `shipping_custom_field` text NOT NULL,
  `shipping_method` varchar(128) NOT NULL,
  `shipping_code` varchar(128) NOT NULL,
  `comment` text NOT NULL,
  `total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `order_status_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_id` int(11) NOT NULL,
  `commission` decimal(15,4) NOT NULL,
  `marketing_id` int(11) NOT NULL,
  `tracking` varchar(64) NOT NULL,
  `language_id` int(11) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `currency_code` varchar(3) NOT NULL,
  `currency_value` decimal(15,8) NOT NULL DEFAULT '1.00000000',
  `ip` varchar(40) NOT NULL,
  `forwarded_ip` varchar(40) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  `accept_language` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_order`
--

LOCK TABLES `oc_order` WRITE;
/*!40000 ALTER TABLE `oc_order` DISABLE KEYS */;
INSERT INTO `oc_order` (`order_id`, `invoice_no`, `invoice_prefix`, `store_id`, `store_name`, `store_url`, `customer_id`, `customer_group_id`, `firstname`, `lastname`, `email`, `telephone`, `fax`, `custom_field`, `payment_firstname`, `payment_lastname`, `payment_company`, `payment_address_1`, `payment_address_2`, `payment_city`, `payment_postcode`, `payment_country`, `payment_country_id`, `payment_zone`, `payment_zone_id`, `payment_address_format`, `payment_custom_field`, `payment_method`, `payment_code`, `shipping_firstname`, `shipping_lastname`, `shipping_company`, `shipping_address_1`, `shipping_address_2`, `shipping_city`, `shipping_postcode`, `shipping_country`, `shipping_country_id`, `shipping_zone`, `shipping_zone_id`, `shipping_address_format`, `shipping_custom_field`, `shipping_method`, `shipping_code`, `comment`, `total`, `order_status_id`, `affiliate_id`, `commission`, `marketing_id`, `tracking`, `language_id`, `currency_id`, `currency_code`, `currency_value`, `ip`, `forwarded_ip`, `user_agent`, `accept_language`, `date_added`, `date_modified`) VALUES (1,0,'INV-2024-00',0,'Кефчето','https://debug.kef4eto.com/',0,1,'дасдас','','asdasd@dsadsd.bg','23123123','','[]','дасдас','','','садасдасд','','adasdasd','','България',33,'Пазарджик',488,'','[]','Плащане при доставка','cod','дасдас','','','садасдасд','','adasdasd','','България',33,'Пазарджик',488,'','[]','Фиксирана цена за доставка','flat.flat','',8.0000,0,0,0.0000,0,'',1,2,'BGN',1.00000000,'37.63.70.238','37.63.70.238','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36','en-US,en;q=0.9,bg;q=0.8,fr;q=0.7','2024-05-09 11:47:23','2024-05-09 11:47:23'),(2,0,'INV-2024-00',0,'Кефчето','https://debug.kef4eto.com/',13,1,'asdasd@sdsdf.bg','','asdasd@sdsdf.bg','1234567','','','asdasd@sdsdf.bg','','','asdasd@sdsdf.bg','','asdasd@sdsdf.bg','','България',33,'Велико Търново',502,'','[]','Плащане при доставка','cod','ngdbvdsdsg','','','sdfgsdfgsdg','','sfgsdfgsdfg','','България',33,'Ловеч',486,'','[]','Фиксирана цена за доставка','flat.flat','',32.9000,0,0,0.0000,0,'',1,2,'BGN',1.00000000,'37.63.70.238','37.63.70.238','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36','en-US,en;q=0.9,bg;q=0.8,fr;q=0.7','2024-05-09 13:51:03','2024-05-09 13:51:03'),(3,0,'INV-2024-00',0,'Кефчето','https://debug.kef4eto.com/',0,1,'Свилен Желев','','zhelev@gmail.com','0887249244','','[]','Свилен Желев','','','ул. Подвис 9Б','','Варна','','България',33,'Варна',501,'','[]','Плащане при доставка','cod','Деян Петков','','','ул. Любляна 34','','София','','България',33,'София - град',498,'','[]','Фиксирана цена за доставка','flat.flat','',9.5000,1,0,0.0000,0,'',1,2,'BGN',1.00000000,'37.63.70.238','37.63.70.238','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36','en-US,en;q=0.9,bg;q=0.8,fr;q=0.7','2024-05-09 15:56:35','2024-05-09 15:56:44'),(4,0,'INV-2024-00',0,'Кефчето','https://debug.kef4eto.com/',0,1,'асдасд','','zhelev@gmail.com','2345678','','[]','асдасд','','','ул. Подвис 9Б','','Варна','','България',33,'Варна',501,'','[]','Плащане при доставка','cod','асдасд','','','ул. Подвис 9Б','','Варна','','България',33,'Варна',501,'','[]','Фиксирана цена за доставка','flat.flat','',12.6000,1,0,0.0000,0,'',1,2,'BGN',1.00000000,'37.63.70.238','37.63.70.238','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36','en-US,en;q=0.9,bg;q=0.8,fr;q=0.7','2024-05-09 16:15:20','2024-05-09 16:15:25'),(5,0,'INV-2024-00',0,'Kef4eto.com','https://debug.kef4eto.com/',0,1,'асдасд','','zhelev@gmail.com','2345678','','[]','асдасд','','','ул. Подвис 9Б','','Варна','','България',33,'Варна',501,'','[]','Плащане при доставка','cod','асдасд','','','ул. Подвис 9Б','','Варна','','България',33,'Варна',501,'','[]','Фиксирана цена за доставка','flat.flat','',32.9000,1,0,0.0000,0,'',1,2,'BGN',1.00000000,'37.63.70.238','37.63.70.238','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36','en-US,en;q=0.9,bg;q=0.8,fr;q=0.7','2024-05-09 16:30:29','2024-05-09 16:30:35');
/*!40000 ALTER TABLE `oc_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_order_history`
--

DROP TABLE IF EXISTS `oc_order_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_order_history` (
  `order_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `order_status_id` int(11) NOT NULL,
  `notify` tinyint(1) NOT NULL DEFAULT '0',
  `comment` text NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`order_history_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_order_history`
--

LOCK TABLES `oc_order_history` WRITE;
/*!40000 ALTER TABLE `oc_order_history` DISABLE KEYS */;
INSERT INTO `oc_order_history` (`order_history_id`, `order_id`, `order_status_id`, `notify`, `comment`, `date_added`) VALUES (1,3,1,0,'','2024-05-09 15:56:44'),(2,4,1,0,'','2024-05-09 16:15:25'),(3,5,1,0,'','2024-05-09 16:30:35');
/*!40000 ALTER TABLE `oc_order_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_order_option`
--

DROP TABLE IF EXISTS `oc_order_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_order_option` (
  `order_option_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `order_product_id` int(11) NOT NULL,
  `product_option_id` int(11) NOT NULL,
  `product_option_value_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `type` varchar(32) NOT NULL,
  PRIMARY KEY (`order_option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_order_option`
--

LOCK TABLES `oc_order_option` WRITE;
/*!40000 ALTER TABLE `oc_order_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_order_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_order_product`
--

DROP TABLE IF EXISTS `oc_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_order_product` (
  `order_product_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `model` varchar(64) NOT NULL,
  `quantity` int(4) NOT NULL,
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `tax` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `reward` int(8) NOT NULL,
  PRIMARY KEY (`order_product_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_order_product`
--

LOCK TABLES `oc_order_product` WRITE;
/*!40000 ALTER TABLE `oc_order_product` DISABLE KEYS */;
INSERT INTO `oc_order_product` (`order_product_id`, `order_id`, `product_id`, `name`, `model`, `quantity`, `price`, `total`, `tax`, `reward`) VALUES (1,1,306,'НОЖ ЗА КАШКАВАЛ','306',1,3.0000,3.0000,0.0000,0),(2,2,3042,'ЧАЙНИК 3.0Л HAUS ROLAND ','3042',1,27.9000,27.9000,0.0000,0),(3,3,365,'СТЪКЛОЧИСТАЧ ГОЛЯМ 55СМ','365',1,4.5000,4.5000,0.0000,0),(4,4,2538,'ФИЛТЪР ШИРОК МГ 6БР','2538',1,7.6000,7.6000,0.0000,0),(5,5,3042,'ЧАЙНИК 3.0Л HAUS ROLAND ','3042',1,27.9000,27.9000,0.0000,0);
/*!40000 ALTER TABLE `oc_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_order_recurring`
--

DROP TABLE IF EXISTS `oc_order_recurring`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_order_recurring` (
  `order_recurring_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `reference` varchar(255) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `product_quantity` int(11) NOT NULL,
  `recurring_id` int(11) NOT NULL,
  `recurring_name` varchar(255) NOT NULL,
  `recurring_description` varchar(255) NOT NULL,
  `recurring_frequency` varchar(25) NOT NULL,
  `recurring_cycle` smallint(6) NOT NULL,
  `recurring_duration` smallint(6) NOT NULL,
  `recurring_price` decimal(10,4) NOT NULL,
  `trial` tinyint(1) NOT NULL,
  `trial_frequency` varchar(25) NOT NULL,
  `trial_cycle` smallint(6) NOT NULL,
  `trial_duration` smallint(6) NOT NULL,
  `trial_price` decimal(10,4) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`order_recurring_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_order_recurring`
--

LOCK TABLES `oc_order_recurring` WRITE;
/*!40000 ALTER TABLE `oc_order_recurring` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_order_recurring` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_order_recurring_transaction`
--

DROP TABLE IF EXISTS `oc_order_recurring_transaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_order_recurring_transaction` (
  `order_recurring_transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_recurring_id` int(11) NOT NULL,
  `reference` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `amount` decimal(10,4) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`order_recurring_transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_order_recurring_transaction`
--

LOCK TABLES `oc_order_recurring_transaction` WRITE;
/*!40000 ALTER TABLE `oc_order_recurring_transaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_order_recurring_transaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_order_shipment`
--

DROP TABLE IF EXISTS `oc_order_shipment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_order_shipment` (
  `order_shipment_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  `shipping_courier_id` varchar(255) NOT NULL DEFAULT '',
  `tracking_number` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`order_shipment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_order_shipment`
--

LOCK TABLES `oc_order_shipment` WRITE;
/*!40000 ALTER TABLE `oc_order_shipment` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_order_shipment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_order_status`
--

DROP TABLE IF EXISTS `oc_order_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_order_status` (
  `order_status_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  PRIMARY KEY (`order_status_id`,`language_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_order_status`
--

LOCK TABLES `oc_order_status` WRITE;
/*!40000 ALTER TABLE `oc_order_status` DISABLE KEYS */;
INSERT INTO `oc_order_status` (`order_status_id`, `language_id`, `name`) VALUES (2,1,'Processing'),(3,1,'Shipped'),(7,1,'Canceled'),(5,1,'Complete'),(8,1,'Denied'),(9,1,'Canceled Reversal'),(10,1,'Failed'),(11,1,'Refunded'),(12,1,'Reversed'),(13,1,'Chargeback'),(1,1,'Pending'),(16,1,'Voided'),(15,1,'Processed'),(14,1,'Expired');
/*!40000 ALTER TABLE `oc_order_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_order_total`
--

DROP TABLE IF EXISTS `oc_order_total`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_order_total` (
  `order_total_id` int(10) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `code` varchar(32) NOT NULL,
  `title` varchar(255) NOT NULL,
  `value` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `sort_order` int(3) NOT NULL,
  PRIMARY KEY (`order_total_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_order_total`
--

LOCK TABLES `oc_order_total` WRITE;
/*!40000 ALTER TABLE `oc_order_total` DISABLE KEYS */;
INSERT INTO `oc_order_total` (`order_total_id`, `order_id`, `code`, `title`, `value`, `sort_order`) VALUES (1,1,'sub_total','Междинна сума',3.0000,1),(2,1,'shipping','Фиксирана цена за доставка',5.0000,3),(3,1,'total','Общо',8.0000,9),(4,2,'sub_total','Междинна сума',27.9000,1),(5,2,'shipping','Фиксирана цена за доставка',5.0000,3),(6,2,'total','Общо',32.9000,9),(7,3,'sub_total','Междинна сума',4.5000,1),(8,3,'shipping','Фиксирана цена за доставка',5.0000,3),(9,3,'total','Общо',9.5000,9),(10,4,'sub_total','Междинна сума',7.6000,1),(11,4,'shipping','Фиксирана цена за доставка',5.0000,3),(12,4,'total','Общо',12.6000,9),(13,5,'sub_total','Междинна сума',27.9000,1),(14,5,'shipping','Фиксирана цена за доставка',5.0000,3),(15,5,'total','Общо',32.9000,9);
/*!40000 ALTER TABLE `oc_order_total` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_order_voucher`
--

DROP TABLE IF EXISTS `oc_order_voucher`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_order_voucher` (
  `order_voucher_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `voucher_id` int(11) NOT NULL,
  `description` varchar(255) NOT NULL,
  `code` varchar(10) NOT NULL,
  `from_name` varchar(64) NOT NULL,
  `from_email` varchar(96) NOT NULL,
  `to_name` varchar(64) NOT NULL,
  `to_email` varchar(96) NOT NULL,
  `voucher_theme_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `amount` decimal(15,4) NOT NULL,
  PRIMARY KEY (`order_voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_order_voucher`
--

LOCK TABLES `oc_order_voucher` WRITE;
/*!40000 ALTER TABLE `oc_order_voucher` DISABLE KEYS */;
/*!40000 ALTER TABLE `oc_order_voucher` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oc_product`
--

DROP TABLE IF EXISTS `oc_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oc_product` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `model` varchar(64) NOT NULL,
  `sku` varchar(64) NOT NULL,
  `upc` varchar(64) NOT NULL,
  `ean` varchar(14) NOT NULL,
  `jan` varchar(13) NOT NULL,
  `isbn` varchar(17) NOT NULL,
  `mpn` varchar(64) NOT NULL,
  `location` varchar(128) NOT NULL,
  `quantity` int(4) NOT NULL DEFAULT '0',
  `stock_status_id` int(11) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `manufacturer_id` int(11) NOT NULL,
  `shipping` tinyint(1) NOT NULL DEFAULT '1',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `points` int(8) NOT NULL DEFAULT '0',
  `tax_class_id` int(11) NOT NULL,
  `date_available` date NOT NULL DEFAULT '0000-00-00',
  `weight` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `weight_class_id` int(11) NOT NULL DEFAULT '0',
  `length` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `width` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `height` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `length_class_id` int(11) NOT NULL DEFAULT '0',
  `subtract` tinyint(1) NOT NULL DEFAULT '1',
  `minimum` int(11) NOT NULL DEFAULT '1',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `viewed` int(5) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3938 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oc_product`
--

LOCK TABLES `oc_product` WRITE;
/*!40000 ALTER TABLE `oc_product` DISABLE KEYS */;
INSERT INTO `oc_product` (`product_id`, `model`, `sku`, `upc`, `ean`, `jan`, `isbn`, `mpn`, `location`, `quantity`, `stock_status_id`, `image`, `manufacturer_id`, `shipping`, `price`, `points`, `tax_class_id`, `date_available`, `weight`, `weight_class_id`, `length`, `width`, `height`, `length_class_id`, `subtract`, `minimum`, `sort_order`, `status`, `viewed`, `date_added`, `date_modified`) VALUES (1078,'1078','11114','3800131560049','','','','','',9,7,'/catalog/imported-images/product-11114.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2238,'2238','4744131015743','4744131016504','','','','','',10,7,'/catalog/imported-images/product-4744131015743.jpg',0,1,26.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2239,'2239','4744131013039','4744131014890','','','','','',1,7,'/catalog/imported-images/product-4744131013039.jpg',0,1,12.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2240,'2240','4744131014555','4744131014579','','','','','',2,7,'/catalog/imported-images/product-4744131014555.jpg',0,1,22.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2241,'2241','4744131017006','4744131017020','','','','','',0,5,NULL,0,1,36.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2242,'2242','4744131015491','4744131014258','','','','','',0,5,'/catalog/imported-images/product-4744131015491.jpg',0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2243,'2243','4744131012605','','','','','','',0,5,'/catalog/imported-images/product-4744131012605.jpg',0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2244,'2244','4744131016498','4744131014265','','','','','',2,7,'/catalog/imported-images/product-4744131016498.jpg',0,1,22.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2245,'2245','4744131015958','','','','','','',1,7,'/catalog/imported-images/product-4744131015958.jpg',0,1,18.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2246,'2246','4744131013961','4744131014272','','','','','',0,5,'/catalog/imported-images/product-4744131013961.jpg',0,1,25.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2247,'2247','4744131013459','','','','','','',0,5,NULL,0,1,22.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2248,'2248','4744131014135','','','','','','',0,5,'/catalog/imported-images/product-4744131014135.jpg',0,1,35.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2249,'2249','4744131015170','','','','','','',0,5,'/catalog/imported-images/product-4744131015170.jpg',0,1,38.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2250,'2250','4744131012599','4744131012582','','','','','',0,5,NULL,0,1,17.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2303,'2303','1214','','','','','','',12,7,'/catalog/imported-images/product-1214.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2537,'2537','4744131010151','','','','','','',12,7,'/catalog/imported-images/product-4744131010151.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2538,'2538','4744131017129','','','','','','',12,7,'/catalog/imported-images/product-4744131014258.jpg',0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2539,'2539','4744131017099','','','','','','',1,7,'/catalog/imported-images/product-4744131017099.jpg',0,1,39.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2542,'2542','4008033259590','','','','','','',5,7,'/catalog/imported-images/product-4008033259590.jpg',0,1,9.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2543,'2543','4008033419444','','','','','','',2,7,'/catalog/imported-images/product-4008033419444.jpg',0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2544,'2544','4008033497411','','','','','','',6,7,'/catalog/imported-images/product-4008033497411.jpg',0,1,10.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2545,'2545','4008033420419','','','','','','',7,7,'/catalog/imported-images/product-4008033420419.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2546,'2546','4008033610179','','','','','','',0,5,NULL,0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2547,'2547','4008033453417','','','','','','',3,7,'/catalog/imported-images/product-4008033453417.jpg',0,1,14.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2548,'2548','4008033259569','','','','','','',2,7,'/catalog/imported-images/product-4008033259569.jpg',0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2549,'2549','4008033421218','','','','','','',12,7,'/catalog/imported-images/product-4008033421218.jpg',0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2550,'2550','4008033453912','','','','','','',2,7,'/catalog/imported-images/product-4008033453912.jpg',0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2551,'2551','4008033637510','','','','','','',2,7,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(2853,'2853','4744131013046','','','','','','',6,7,'/catalog/imported-images/product-4744131013046.jpg',0,1,11.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(3047,'3047','4744131010137','','','','','','',2,7,'/catalog/imported-images/product-4744131010137.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(3163,'3163','4744131013732','','','','','','',1,7,'/catalog/imported-images/product-4744131013732.jpg',0,1,38.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(3164,'3164','4744131013305','','','','','','',0,5,'/catalog/imported-images/product-4744131013305.jpg',0,1,23.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(1,'1','8697633821090','1049','','','','','',0,5,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,0,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3,'3','8697633821106','','','','','','',0,5,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(4,'4','8697633821113','','','','','','',2,7,'/catalog/imported-images/product-8697633821113.jpg',0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(5,'5','8697633822431','102104','','','','','',0,5,NULL,0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(6,'6','8697633822424','102103','','','','','',1,7,'/catalog/imported-images/product-8697633822424.jpg',0,1,14.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(7,'7','8697633822448','102105','','','','','',1,7,'/catalog/imported-images/product-8697633822448.jpg',0,1,24.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(9,'9','8697633820291','1027','','','','','',2,7,'/catalog/imported-images/product-8697633820291.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(10,'10','8697633820307','1028','','','','','',0,5,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(11,'11','8697633820932','1895','','','','','',2,7,'/catalog/imported-images/product-8697633820932.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(13,'13','8697633821076','102030/1','','','','','',0,5,NULL,0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(15,'15','2090009123945','102029/1','','','','','',0,5,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(18,'18','2090009124027','102031/1','','','','','',0,5,NULL,0,1,14.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(19,'19','8697633820895','101550','','','','','',0,5,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(20,'20','8697633823384','102044','','','','','',3,7,'/catalog/imported-images/product-8697633823384.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(23,'23','8697633823391','102045','','','','','',2,7,'/catalog/imported-images/product-8697633823391.jpg',0,1,12.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(24,'24','2090009123891','102026/3','','','','','',0,5,'/catalog/imported-images/product-2090009123891.jpg',0,1,12.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(25,'25','2090009123884','','','','','','',0,5,'/catalog/imported-images/product-2090009123884.jpg',0,1,12.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(26,'26','8697633822394','102100','','','','','',0,5,'/catalog/imported-images/product-8697633822394.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(27,'27','8697633822073','102107','','','','','',0,5,NULL,0,1,32.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(28,'28','8697633822097','','','','','','',0,5,NULL,0,1,42.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(29,'29','8697633821304','102032','','','','','',0,5,NULL,0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(30,'30','8697633822035','102005','','','','','',0,5,NULL,0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(31,'31','2090009123754','102001/5','','','','','',0,5,NULL,0,1,8.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(32,'32','4001','','','','','','',3,7,'/catalog/imported-images/product-4001.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(33,'33','2090009123716','102001/1','','','','','',0,5,NULL,0,1,8.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(34,'34','8697633823575','','','','','','',0,5,'/catalog/imported-images/product-8697633823575.jpg',0,1,17.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(35,'35','8697633821403','','','','','','',1,7,'/catalog/imported-images/product-8697633821403.jpg',0,1,13.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(36,'36','8697633821410','','','','','','',2,7,'/catalog/imported-images/product-8697633821410.jpg',0,1,19.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(37,'37','8697633823582','','','','','','',0,5,NULL,0,1,25.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(38,'38','8697633822615','','','','','','',0,5,NULL,0,1,31.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(39,'39','8697633822561','','','','','','',1,7,'/catalog/imported-images/product-8697633822561.jpg',0,1,19.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(40,'40','2090009125482','','','','','','',0,5,NULL,0,1,8.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(41,'41','2090009125529','','','','','','',0,5,NULL,0,1,13.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(42,'42','8697633822417','','','','','','',2,7,'/catalog/imported-images/product-8697633822417.jpg',0,1,10.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,21,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(43,'43','8697633822400','','','','','','',0,5,NULL,0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(44,'44','8697633822028','','','','','','',1,7,'/catalog/imported-images/product-8697633822028.jpg',0,1,22.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(45,'45','2090009124362','','','','','','',1,7,'/catalog/imported-images/product-2090009124362.jpg',0,1,26.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(47,'47','2090009124379','8693135045330','','','','','',1,7,'/catalog/imported-images/product-2090009124379.jpg',0,1,18.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(48,'48','8697633820536','','','','','','',0,5,NULL,0,1,10.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(50,'50','2090009127905','','','','','','',0,5,NULL,0,1,24.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(51,'51','2090009127882','','','','','','',0,5,NULL,0,1,24.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(52,'52','2090009127899','','','','','','',0,5,NULL,0,1,24.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(53,'53','2090009127936','','','','','','',1,7,'/catalog/imported-images/product-2090009127936.jpg',0,1,36.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(54,'54','2090009127912','','','','','','',1,7,'/catalog/imported-images/product-2090009127912.jpg',0,1,36.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(55,'55','2090009127851','','','','','','',1,7,'/catalog/imported-images/product-2090009127851.jpg',0,1,16.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(56,'56','2090009127868','','','','','','',0,5,NULL,0,1,16.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(57,'57','2090009127875','','','','','','',0,5,NULL,0,1,16.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(58,'58','2090009127820','','','','','','',0,5,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(59,'59','2090009127837','','','','','','',0,5,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(60,'60','2090009127844','','','','','','',0,5,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(61,'61','2090009127790','','','','','','',0,5,NULL,0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(62,'62','2090009127813','8693135041752','','','','','',12,7,'/catalog/imported-images/product-2090009127813.jpg',0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(63,'63','2090009127806','','','','','','',0,5,NULL,0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(64,'64','2090009127769','','','','','','',0,5,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(65,'65','2090009127776','','','','','','',0,5,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(66,'66','2090009127783','','','','','','',0,5,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(67,'67','8697633820529','','','','','','',0,5,NULL,0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(68,'68','8697633820901','','','','','','',3,7,'/catalog/imported-images/product-8697633820901.jpg',0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(69,'69','8697633822912','2090009128674','','','','','',0,5,NULL,0,1,45.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(70,'70','8697633822905','','','','','','',1,7,'/catalog/imported-images/product-8697633822905.jpg',0,1,35.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,13,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(71,'71','8697633822899','','','','','','',0,5,NULL,0,1,23.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(72,'72','8697633822929','2090009128704','','','','','',1,7,'/catalog/imported-images/product-8697633822929.jpg',0,1,66.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(73,'73','2090009136655','','','','','','',0,5,NULL,0,1,26.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(74,'74','2090009136662','','','','','','',1,7,'/catalog/imported-images/product-2090009136662.jpg',0,1,26.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(75,'75','2090009155298','','','','','','',1,7,'/catalog/imported-images/product-2090009155298.jpg',0,1,26.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(76,'76','2090009152648','','','','','','',1,7,'/catalog/imported-images/product-2090009152648.jpg',0,1,23.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(77,'77','2090009141765','','','','','','',1,7,'/catalog/imported-images/product-2090009141765.jpg',0,1,23.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(78,'78','2090009136709','','','','','','',1,7,'/catalog/imported-images/product-2090009136709.jpg',0,1,23.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(79,'79','2090009162197','','','','','','',2,7,'/catalog/imported-images/product-2090009162197.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(80,'80','8694917007607','','','','','','',4,7,'/catalog/imported-images/product-8694917007607.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(81,'81','8694917007539','','','','','','',0,5,NULL,0,1,22.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(82,'82','8000600103585','','','','','','',0,5,NULL,0,1,40.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(83,'83','8000300103588','3800836150279','','','','','',1,7,NULL,0,1,45.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(84,'84','2090009176002','','','','','','',0,5,NULL,0,1,40.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(85,'85','8680845009905','','','','','','',1,7,'/catalog/imported-images/product-8680845009905.jpg',0,1,40.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(86,'86','8694917006419','','','','','','',1,7,'/catalog/imported-images/product-8694917006419.jpg',0,1,26.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(87,'87','8694917005856','','','','','','',0,5,'/catalog/imported-images/product-8694917005856.jpg',0,1,23.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(88,'88','8694917005832','','','','','','',0,5,'/catalog/imported-images/product-8694917005832.jpg',0,1,16.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(89,'89','8694917006853','','','','','','',2,7,'/catalog/imported-images/product-8694917006853.jpg',0,1,17.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(90,'90','8681690005067','','','','','','',0,5,NULL,0,1,14.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(91,'91','2090009132879','','','','','','',2,7,'/catalog/imported-images/product-2090009132879.jpg',0,1,15.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(92,'92','2090009132862','','','','','','',2,7,'/catalog/imported-images/product-2090009132862.jpg',0,1,15.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(93,'93','2090009132886','','','','','','',0,5,NULL,0,1,15.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(94,'94','2090009133586','','','','','','',0,5,NULL,0,1,24.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(95,'95','2090009133579','','','','','','',0,5,NULL,0,1,24.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(96,'96','2090009152068','','','','','','',0,5,NULL,0,1,18.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(97,'97','2090009133609','','','','','','',1,7,'/catalog/imported-images/product-2090009133609.jpg',0,1,18.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(98,'98','8697480570196','','','','','','',0,5,NULL,0,1,18.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(99,'99','2090009147736','','','','','','',1,7,'/catalog/imported-images/product-2090009147736.jpg',0,1,30.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(100,'100','2090009147743','','','','','','',0,5,NULL,0,1,30.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(101,'101','2090009149501','','','','','','',1,7,'/catalog/imported-images/product-2090009149501.jpg',0,1,18.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(102,'102','8697480522164','8697422301888','','','','','',1,7,'/catalog/imported-images/product-8697480522164.jpg',0,1,12.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(103,'103','8697480522171','10618','','','','','',0,5,'/catalog/imported-images/product-8697480522171.jpg',0,1,19.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(104,'104','8697480522188','','','','','','',0,5,'/catalog/imported-images/product-8697480522188.jpg',0,1,26.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,3,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(105,'105','2090009153867','','','','','','',0,5,NULL,0,1,29.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(106,'106','2090009153904','2090009153881','','','','','',0,5,NULL,0,1,22.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(107,'107','8681690535380','8681690505383','','','','','',2,7,'/catalog/imported-images/product-8681690535380.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(108,'108','2090009162265','2090009162258','','','','','',0,5,NULL,0,1,45.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(109,'109','2090009138635','','','','','','',0,5,NULL,0,1,23.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(110,'110','2090009138857','2090009138871','','','','','',0,5,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(111,'111','2090009143271','2090009143295','','','','','',0,5,NULL,0,1,45.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(112,'112','2090009138338','2090009138345','','','','','',0,5,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(113,'113','8697422301871','','','','','','',2,7,NULL,0,1,18.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(114,'114','2090009138215','2090009138222','','','','','',0,5,NULL,0,1,25.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(115,'115','8681690516013','8681690536011','','','','','',1,7,NULL,0,1,23.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(116,'116','3800163900424','3800163900431','','','','','',30,7,'/catalog/imported-images/product-3800163900424.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(117,'117','3800163900523','3800163900530','','','','','',26,7,'/catalog/imported-images/product-3800163900523.jpg',0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(118,'118','3800163900585','3800163900578','','','','','',26,7,'/catalog/imported-images/product-3800163900585.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(119,'119','3800163900691','3800163900684','','','','','',15,7,'/catalog/imported-images/product-3800163900691.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(120,'120','3800163900677','3800163900660','','','','','',13,7,'/catalog/imported-images/product-3800163900677.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(121,'121','3800163900653','3800163900608','','','','','',29,7,'/catalog/imported-images/product-3800163900653.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(122,'122','3800163900899','3800163900882','','','','','',10,7,'/catalog/imported-images/product-3800163900882.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,6,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(123,'123','3800163900769','','','','','','',9,7,'/catalog/imported-images/product-3800163900769.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(124,'124','8694917006334','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(125,'125','8694917005658','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(126,'126','2090009137027','2090009137010','','','','','',4,7,NULL,0,1,13.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(127,'127','2090009137256','2090009175364','','','','','',1,7,'/catalog/imported-images/product-2090009137256.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(128,'128','2090009175388','2090009137218','','','','','',0,5,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(129,'129','2090009137232','2090009175371','','','','','',0,5,NULL,0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(131,'131','8694917007799','2090009180795','','','','','',2,7,'/catalog/imported-images/product-8694917007799.jpg',0,1,5.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(132,'132','2090009180832','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(133,'133','2090009180849','','','','','','',2,7,'/catalog/imported-images/product-2090009180849.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(134,'134','2090009182546','8694917007546','','','','','',1,7,NULL,0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(135,'135','4602807277669','','','','','','',0,5,NULL,0,1,39.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(136,'136','4602807277645','4602807239117','','','','','',0,5,NULL,0,1,35.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(137,'137','4602807925997','4602807926017','','','','','',0,5,NULL,0,1,28.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(138,'138','4602807926055','4602807947579','','','','','',0,5,NULL,0,1,34.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(139,'139','2090009177740','','','','','','',1,7,'/catalog/imported-images/product-2090009177740.jpg',0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(140,'140','2090009177757','','','','','','',0,5,NULL,0,1,11.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(141,'141','4602807020012','','','','','','',0,5,NULL,0,1,22.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(142,'142','4602807808801','','','','','','',0,5,NULL,0,1,21.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(143,'143','4602807806937','','','','','','',0,5,NULL,0,1,28.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(144,'144','4602807984383','','','','','','',0,5,NULL,0,1,33.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(145,'145','2090009175449','2090009175432','','','','','',0,5,NULL,0,1,39.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(146,'146','4602807374351','4602807374368','','','','','',0,5,NULL,0,1,39.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(147,'147','2090009175678','','','','','','',0,5,NULL,0,1,18.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(148,'148','2090009175791','','','','','','',0,5,NULL,0,1,13.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(149,'149','4602807277621','4602807310571','','','','','',0,5,NULL,0,1,30.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(150,'150','8697853095158','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(151,'151','8697853095165','','','','','','',0,5,NULL,0,1,5.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(152,'152','8697853095172','','','','','','',1,7,'/catalog/imported-images/product-8697853095172.jpg',0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(153,'153','8697853095479','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(154,'154','8697853095486','','','','','','',0,5,NULL,0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(155,'155','8697853095493','','','','','','',0,5,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(156,'156','8697853095509','','','','','','',0,5,NULL,0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(157,'157','8697853095011','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(158,'158','8697853095028','','','','','','',0,5,NULL,0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(159,'159','8697853095035','','','','','','',0,5,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(160,'160','8697853095424','','','','','','',0,5,NULL,0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(161,'161','8697853095820','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(162,'162','8697853095837','','','','','','',0,5,NULL,0,1,7.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(163,'163','8697853096087','','','','','','',1,7,'/catalog/imported-images/product-8697853096087.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(164,'164','8697853096070','','','','','','',0,5,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(165,'165','8697853096094','','','','','','',0,5,NULL,0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(166,'166','8697853096100','','','','','','',1,7,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(167,'167','6933961560259','6910176078564','','','','','',10,7,'/catalog/imported-images/product-6933961560259.jpg',0,1,0.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(168,'168','6955692607188','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(169,'169','8697853096209','','','','','','',0,5,NULL,0,1,2.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(170,'170','8697853096216','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(171,'171','8697853096223','','','','','','',1,7,NULL,0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(172,'172','8697853096308','','','','','','',0,5,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(173,'173','8697853096315','','','','','','',0,5,NULL,0,1,1.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(174,'174','8697853096322','','','','','','',1,7,NULL,0,1,2.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(175,'175','8697853092904','','','','','','',12,7,'/catalog/imported-images/product-8697853092904.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(176,'176','8699401096037','','','','','','',0,5,NULL,0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(177,'177','8682511171268','','','','','','',0,5,NULL,0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:00:00'),(178,'178','8699401093531','','','','','','',1,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(179,'179','8683262547067','','','','','','',0,5,NULL,0,1,12.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(180,'180','8683262547098','','','','','','',0,5,NULL,0,1,22.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(181,'181','2090009171731','','','','','','',2,7,'/catalog/imported-images/product-2090009171731.jpg',0,1,19.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(182,'182','8695122001282','','','','','','',0,5,NULL,0,1,3.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(183,'183','8697409845282','','','','','','',0,5,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(184,'184','8695122003347','','','','','','',0,5,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(185,'185','8695122003316','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(189,'189','8695122003408','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(190,'190','8695122003323','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(191,'191','8695122003040','','','','','','',0,5,NULL,0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(192,'192','8695122001497','','','','','','',0,5,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(193,'193','8698532590926','','','','','','',2,7,'/catalog/imported-images/product-8698532590926.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(194,'194','8698532590919','','','','','','',0,5,NULL,0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(195,'195','8698532590902','','','','','','',1,7,'/catalog/imported-images/product-8698532590902.jpg',0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(196,'196','8698532591817','','','','','','',0,5,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,2,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(197,'197','8695122002531','','','','','','',4,7,'/catalog/imported-images/product-8695122002531.jpg',0,1,3.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(198,'198','8695122002524','','','','','','',0,5,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(199,'199','8680858303908','','','','','','',0,5,NULL,0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(200,'200','8695122001930','','','','','','',2,7,NULL,0,1,10.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(201,'201','8695122006539','','','','','','',2,7,'/catalog/imported-images/product-8695122006539.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(202,'202','8695122001114','','','','','','',0,5,NULL,0,1,1.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(203,'203','8695122006867','','','','','','',2,7,NULL,0,1,5.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(204,'204','8695122006850','','','','','','',1,7,'/catalog/imported-images/product-8695122006850.jpg',0,1,5.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(205,'205','8695122005907','','','','','','',2,7,NULL,0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(206,'206','2000000005317','','','','','','',0,5,NULL,0,1,23.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(207,'207','2000000005331','','','','','','',0,5,NULL,0,1,22.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(208,'208','2000000005348','','','','','','',0,5,NULL,0,1,18.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(209,'209','2000000125527','','','','','','',0,5,NULL,0,1,23.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(210,'210','2000000005577','','','','','','',1,7,'/catalog/imported-images/product-2000000005577.jpg',0,1,50.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(211,'211','2000000031880','','','','','','',1,7,'/catalog/imported-images/product-2000000031880.jpg',0,1,31.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(212,'212','2000000006055','','','','','','',2,7,'/catalog/imported-images/product-2000000006055.jpg',0,1,44.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(213,'213','2000000005492','','','','','','',2,7,'/catalog/imported-images/product-2000000005492.jpg',0,1,38.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(214,'214','2000000006031','','','','','','',0,5,'/catalog/imported-images/product-2000000006031.jpg',0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(215,'215','2000000006048','','','','','','',1,7,'/catalog/imported-images/product-2000000006048.jpg',0,1,37.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(216,'216','2000000005461','','','','','','',0,5,'/catalog/imported-images/product-2000000005461.jpg',0,1,26.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(217,'217','2000000005478','308626','','','','','',3,7,'/catalog/imported-images/product-2000000005478.jpg',0,1,33.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(218,'218','2000000005294','','','','','','',0,5,NULL,0,1,22.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(219,'219','2000000005560','','','','','','',1,7,'/catalog/imported-images/product-2000000005560.jpg',0,1,45.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(220,'220','2000000005195','','','','','','',2,7,'/catalog/imported-images/product-2000000005195.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(221,'221','2000000005201','','','','','','',0,5,'/catalog/imported-images/product-2000000005201.jpg',0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(222,'222','2000000005218','','','','','','',0,5,'/catalog/imported-images/product-2000000005218.jpg',0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(223,'223','2000000005270','','','','','','',0,5,NULL,0,1,13.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(224,'224','2000000005287','10577','','','','','',0,5,NULL,0,1,17.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(225,'225','2000000005249','','','','','','',0,5,NULL,0,1,16.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(226,'226','2000000005263','','','','','','',2,7,'/catalog/imported-images/product-2000000005263.jpg',0,1,19.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(227,'227','8695122001701','','','','','','',0,5,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(228,'228','8695122002548','','','','','','',3,7,'/catalog/imported-images/product-8695122002548.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(229,'229','8695122001992','','','','','','',10,7,'/catalog/imported-images/product-8695122001992.jpg',0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(230,'230','8695122001138','6426509000435','','','','','',4,7,'/catalog/imported-images/product-8695122001138.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(231,'231','8697633820284','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(232,'232','8697633820130','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(233,'233','8697633822042','','','','','','',0,5,NULL,0,1,8.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(234,'234','8697633820857','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(235,'235','8697633820116','','','','','','',1,7,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(236,'236','8697633820123','','','','','','',0,5,NULL,0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(237,'237','8697633820147','','','','','','',0,5,NULL,0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(238,'238','2090009175890','','','','','','',0,5,NULL,0,1,41.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(239,'239','2090009175906','','','','','','',0,5,NULL,0,1,45.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(240,'240','8697435181217','','','','','','',0,5,NULL,0,1,25.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(241,'241','8682397002939','','','','','','',0,5,'/catalog/imported-images/product-8682397002939.jpg',0,1,12.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(242,'242','2090009147361','','','','','','',0,5,NULL,0,1,4.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(243,'243','2090009164009','','','','','','',0,5,NULL,0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(244,'244','8697480521334','','','','','','',3,7,'/catalog/imported-images/product-8697480521334.jpg',0,1,7.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(245,'245','8681690004305','8691857001252','','','','','',3,7,'/catalog/imported-images/product-8681690004305.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(246,'246','8681690004312','8691857001283','','','','','',9,7,'/catalog/imported-images/product-8681690004312.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(247,'247','8681690004916','','','','','','',0,5,NULL,0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(248,'248','8681690004800','','','','','','',3,7,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(249,'249','8681690004817','','','','','','',3,7,NULL,0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(250,'250','8681690004824','','','','','','',3,7,NULL,0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(251,'251','8681690004954','','','','','','',2,7,'/catalog/imported-images/product-8681690004954.jpg',0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(252,'252','2090009138031','2090009138062','','','','','',0,5,NULL,0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(253,'253','2090009138598','2090009138574','','','','','',0,5,NULL,0,1,7.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(254,'254','2090009138505','2090009138512','','','','','',0,5,NULL,0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(255,'255','2090009138697','','','','','','',0,5,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(256,'256','2081737060268','','','','','','',0,5,NULL,0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(257,'257','2090009143004','2090009143028','','','','','',0,5,NULL,0,1,15.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(258,'258','8699401094064','8699401094071','','','','','',6,7,'/catalog/imported-images/product-8699401094064.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(259,'259','8699401094224','','','','','','',1,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(260,'260','8699401094248','54288','','','','','',0,5,NULL,0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(261,'261','2090009158855','','','','','','',1,7,'/catalog/imported-images/product-2090009158855.jpg',0,1,53.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(262,'262','2090009158565','','','','','','',0,5,NULL,0,1,27.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(263,'263','2090009158596','','','','','','',0,5,NULL,0,1,33.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(264,'264','1040000202157','','','','','','',0,5,NULL,0,1,12.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(265,'265','8682511170957','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(266,'266','8682511171404','','','','','','',0,5,NULL,0,1,8.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(267,'267','2090009181778','8680550261148','','','','','',0,5,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(268,'268','6901212103616','6901212103609','','','','','',8,7,'/catalog/imported-images/product-6901212103616.jpg',0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(269,'269','6930079581220','','','','','','',0,5,NULL,0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(270,'270','3261888916372','','','','','','',2,7,'/catalog/imported-images/product-3261888916372.jpg',0,1,18.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(271,'271','4893335003459','2000000089607','','','','','',4,7,'/catalog/imported-images/product-4893335003459.jpg',0,1,5.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(272,'272','6930079581473','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(273,'273','6985276822324','073287614536','','','','','',1,7,'/catalog/imported-images/product-6985276822324.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(274,'274','6807011131440','','','','','','',1,7,'/catalog/imported-images/product-6807011131440.jpg',0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(275,'275','8418656112282','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(276,'276','6036073103878','','','','','','',1,7,'/catalog/imported-images/product-6036073103878.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(277,'277','6036073103861','','','','','','',0,5,NULL,0,1,10.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(278,'278','6892021104539','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(279,'279','6995679104521','','','','','','',0,5,NULL,0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(280,'280','6920190654866','','','','','','',1,7,'/catalog/imported-images/product-6920190654866.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(281,'281','6901004109796','53701','','','','','',0,5,NULL,0,1,14.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(282,'282','6930070105371','3800151717027','','','','','',0,5,NULL,0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(283,'283','6930070105395','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(284,'284','6930070105357','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(285,'285','6789000116075','','','','','','',2,7,'/catalog/imported-images/product-6789000116075.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(286,'286','6930070105333','','','','','','',1,7,'/catalog/imported-images/product-6930070105333.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(287,'287','6598421579594','2090000152937','','','','','',13,7,'/catalog/imported-images/product-6598421579594.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(288,'288','6020200113212','','','','','','',0,5,NULL,0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(289,'289','6988875113794','','','','','','',2,7,'/catalog/imported-images/product-6988875113794.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(290,'290','6924393318099','6930642400699','','','','','',0,5,'/catalog/imported-images/product-6924393318099.jpg',0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(291,'291','6924393318075','','','','','','',0,5,NULL,0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(292,'292','6902540122676','','','','','','',1,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(293,'293','6922616122775','','','','','','',0,5,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(294,'294','6921070122888','2090000155204','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(295,'295','6902540123017','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(296,'296','6724000116984','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(297,'297','2090009143721','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(298,'298','8000798024334','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(299,'299','8000798000765','','','','','','',4,7,'/catalog/imported-images/product-8000798000765.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(300,'300','8000798002035','','','','','','',3,7,'/catalog/imported-images/product-8000798002035.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(301,'301','8000798092319','','','','','','',0,5,NULL,0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(303,'303','8000798001144','','','','','','',4,7,'/catalog/imported-images/product-8000798001144.jpg',0,1,1.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(304,'304','8431250711309','10167','','','','','',4,7,'/catalog/imported-images/product-8431250711309.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(305,'305','8697950724067','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(306,'306','8697950724074','','','','','','',1,7,'/catalog/imported-images/product-8697950724074.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(307,'307','8697950731232','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(308,'308','8697950731249','','','','','','',3,7,'/catalog/imported-images/product-8697950731249.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(309,'309','8697950728041','8697950728034','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(310,'310','8697950728003','','','','','','',1,7,'/catalog/imported-images/product-8697950728003.jpg',0,1,26.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(311,'311','8697950732048','','','','','','',0,5,'/catalog/imported-images/product-8697950732048.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(312,'312','8697950723558','','','','','','',2,7,'/catalog/imported-images/product-8697950723558.jpg',0,1,16.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(313,'313','8697410470138','','','','','','',0,5,'/catalog/imported-images/product-8697410470138.jpg',0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(314,'314','8697950741613','','','','','','',0,5,'/catalog/imported-images/product-8697950741613.jpg',0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(315,'315','8697512626860','','','','','','',0,5,'/catalog/imported-images/product-8697512626860.jpg',0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(316,'316','8697512626303','','','','','','',2,7,'/catalog/imported-images/product-8697512626303.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(317,'317','8697512626181','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(319,'319','8695162613148','','','','','','',3,7,'/catalog/imported-images/product-8695162613148.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(320,'320','8695162613179','','','','','','',1,7,'/catalog/imported-images/product-8695162613179.jpg',0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(322,'322','3800131581785','3800131581761','','','','','',6,7,'/catalog/imported-images/product-3800131581785.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(323,'323','8697950711043','','','','','','',0,5,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(324,'324','8697950711050','','','','','','',1,7,'/catalog/imported-images/product-8697950711050.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(325,'325','8697950711012','','','','','','',2,7,'/catalog/imported-images/product-8697950711012.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(326,'326','8695162613087','','','','','','',2,7,'/catalog/imported-images/product-8695162613087.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(327,'327','8695162613254','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(328,'328','8697512622596','','','','','','',1,7,'/catalog/imported-images/product-8697512622596.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(329,'329','8697512622541','','','','','','',0,5,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(330,'330','8697512627478','','','','','','',0,5,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(331,'331','8697512627638','','','','','','',1,7,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(332,'332','8697950727044','','','','','','',0,5,NULL,0,1,7.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(333,'333','8693395017887','','','','','','',8,7,'/catalog/imported-images/product-8693395017887.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(334,'334','8693395016385','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(335,'335','8693395017177','','','','','','',0,5,NULL,0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(336,'336','8693395016668','211781','','','','','',4,7,'/catalog/imported-images/product-8693395016668.jpg',0,1,1.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(337,'337','8693395043725','','','','','','',2,7,'/catalog/imported-images/product-8693395043725.jpg',0,1,10.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(338,'338','8693395043633','','','','','','',0,5,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(339,'339','8963395008575','','','','','','',0,5,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(340,'340','8693395001114','','','','','','',6,7,'/catalog/imported-images/product-8693395001114.jpg',0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(341,'341','7898650116546','','','','','','',0,5,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(342,'342','8697465008249','','','','','','',0,5,NULL,0,1,16.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(343,'343','6789000116174','','','','','','',2,7,'/catalog/imported-images/product-6789000116174.jpg',0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(344,'344','8699303354877','','','','','','',1,7,'/catalog/imported-images/product-8699303354877.jpg',0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(345,'345','8699303353191','','','','','','',1,7,'/catalog/imported-images/product-8699303353191.jpg',0,1,9.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(346,'346','8699303351487','','','','','','',0,5,NULL,0,1,2.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(347,'347','8697465005637','','','','','','',1,7,'/catalog/imported-images/product-8697465005637.jpg',0,1,12.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(348,'348','8693395042797','','','','','','',0,5,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(349,'349','2090009154314','2090009154307','','','','','',2,7,'/catalog/imported-images/product-2090009154314.jpg',0,1,12.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(350,'350','2090009154468','','','','','','',0,5,NULL,0,1,11.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(351,'351','2090009154475','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(352,'352','2090009154444','','','','','','',0,5,'/catalog/imported-images/product-2090009154444.jpg',0,1,9.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(353,'353','2090009154451','','','','','','',0,5,'/catalog/imported-images/product-2090009154451.jpg',0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(354,'354','2090009154413','','','','','','',0,5,'/catalog/imported-images/product-2090009154413.jpg',0,1,21.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(355,'355','2090009154406','','','','','','',0,5,'/catalog/imported-images/product-2090009154406.jpg',0,1,21.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(356,'356','2090009154338','2090009154321','','','','','',4,7,'/catalog/imported-images/product-2090009154338.jpg',0,1,12.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(357,'357','883314192964','883314613261','','','','','',2,7,NULL,0,1,64.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(358,'358','8699303352217','','','','','','',2,7,'/catalog/imported-images/product-8699303352217.jpg',0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,2,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(359,'359','8699303352200','','','','','','',2,7,'/catalog/imported-images/product-8699303352200.jpg',0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(360,'360','8699303351234','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(361,'361','8691857001337','','','','','','',0,5,NULL,0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(362,'362','8699303352309','','','','','','',0,5,NULL,0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(363,'363','8699303352293','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(364,'364','8699303350312','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(365,'365','8699303352231','8697409840638','','','','','',1,7,'/catalog/imported-images/product-8699303352231.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,23,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(366,'366','8699303352248','','','','','','',0,5,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(367,'367','8693395015319','','','','','','',0,5,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(368,'368','8699303353580','','','','','','',0,5,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(369,'369','8693395018259','','','','','','',0,5,NULL,0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(370,'370','8693395008021','','','','','','',0,5,NULL,0,1,5.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(371,'371','8693395002104','','','','','','',0,5,NULL,0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(372,'372','8693395016804','','','','','','',0,5,NULL,0,1,11.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(373,'373','8693395016798','','','','','','',0,5,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(374,'374','8697633821328','','','','','','',11,7,'/catalog/imported-images/product-8697633821328.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(375,'375','8000798001304','','','','','','',0,5,NULL,0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(376,'376','5903355000518','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(377,'377','5903355008378','','','','','','',7,7,'/catalog/imported-images/product-5903355008378.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(378,'378','5903355004301','','','','','','',0,5,'/catalog/imported-images/product-5903355004301.jpg',0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(379,'379','5903355000174','','','','','','',4,7,'/catalog/imported-images/product-5903355000174.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(380,'380','5903355003854','','','','','','',13,7,'/catalog/imported-images/product-5903355003854.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(381,'381','5903355001195','','','','','','',1,7,'/catalog/imported-images/product-5903355001195.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(382,'382','5903355000983','','','','','','',2,7,'/catalog/imported-images/product-5903355000983.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(383,'383','5903355009290','','','','','','',0,5,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:01:00'),(384,'384','5903355000129','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(385,'385','5903355000525','','','','','','',0,5,'/catalog/imported-images/product-5903355000525.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(386,'386','5903355003885','','','','','','',1,7,'/catalog/imported-images/product-5903355003885.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(387,'387','5903355086871','','','','','','',0,5,NULL,0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(388,'388','5903355000594','','','','','','',0,5,NULL,0,1,15.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(389,'389','5903355000877','','','','','','',9,7,'/catalog/imported-images/product-5903355000877.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(390,'390','5903355000891','5903355002772','','','','','',1,7,'/catalog/imported-images/product-5903355000891.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(391,'391','5903355000822','','','','','','',4,7,'/catalog/imported-images/product-5903355000822.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(392,'392','5903355001126','95561','','','','','',3,7,'/catalog/imported-images/product-5903355001126.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(393,'393','5903355000808','','','','','','',3,7,'/catalog/imported-images/product-5903355000808.jpg',0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(394,'394','5903355002604','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(395,'395','5903355007593','','','','','','',2,7,'/catalog/imported-images/product-5903355007593.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(396,'396','5903355001553','','','','','','',0,5,'/catalog/imported-images/product-5903355001553.jpg',0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(397,'397','5903355000488','','','','','','',1,7,'/catalog/imported-images/product-5903355000488.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(398,'398','5903355000501','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(399,'399','5903355000372','','','','','','',3,7,'/catalog/imported-images/product-5903355000372.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(400,'400','5903355000921','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(401,'401','5903355000266','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(402,'402','5903355004158','','','','','','',9,7,'/catalog/imported-images/product-5903355004158.jpg',0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(403,'403','8681942503372','','','','','','',1,7,'/catalog/imported-images/product-8681942503372.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(404,'404','8699243467552','','','','','','',0,5,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(405,'405','8699243468764','','','','','','',0,5,NULL,0,1,18.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(406,'406','8681942503907','','','','','','',9,7,'/catalog/imported-images/product-8681942503907.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(407,'407','8681942500654','','','','','','',13,7,'/catalog/imported-images/product-8681942500654.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(408,'408','8699243463424','44399','','','','','',9,7,'/catalog/imported-images/product-8699243463424.jpg',0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(409,'409','8693357361300','680678360509','','','','','',1,7,'/catalog/imported-images/product-8693357361300.jpg',0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(410,'410','8693357093003','680678093001','','','','','',9,7,'/catalog/imported-images/product-8693357093003.jpg',0,1,14.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(411,'411','8693357086692','680678086690','','','','','',5,7,'/catalog/imported-images/product-8693357086692.jpg',0,1,10.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(412,'412','8693357111752','680678111750','','','','','',3,7,'/catalog/imported-images/product-8693357111752.jpg',0,1,19.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(413,'413','8693357507210','680678505900','','','','','',3,7,'/catalog/imported-images/product-8693357507210.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(414,'414','8693357192485','','','','','','',2,7,'/catalog/imported-images/product-8693357192485.jpg',0,1,16.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(415,'415','8693357077096','680678077094','','','','','',10,7,'/catalog/imported-images/product-8693357077096.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(416,'416','8693357254596','680678253894','','','','','',4,7,'/catalog/imported-images/product-8693357254596.jpg',0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(417,'417','8693357177659','680678177954','','','','','',0,5,'/catalog/imported-images/product-8693357177659.jpg',0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(418,'418','8693357015432','680678015430','','','','','',2,7,'/catalog/imported-images/product-8693357015432.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(419,'419','100146','','','','','','',12,7,'/catalog/imported-images/product-100146.jpg',0,1,7.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(420,'420','8693357242715','680678242119','','','','','',3,7,'/catalog/imported-images/product-8693357242715.jpg',0,1,12.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(421,'421','8693357303706','680678302905','','','','','',7,7,'/catalog/imported-images/product-8693357303706.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(422,'422','8693357303713','680678302912','','','','','',10,7,'/catalog/imported-images/product-8693357303713.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(425,'425','1111','','','','','','',0,5,NULL,0,1,0.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(426,'426','21746','','','','','','',2,7,'/catalog/imported-images/product-21746.jpg',0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(427,'427','21747','','','','','','',3,7,'/catalog/imported-images/product-21747.jpg',0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(428,'428','21748','','','','','','',2,7,'/catalog/imported-images/product-21748.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(429,'429','21178','','','','','','',2,7,'/catalog/imported-images/product-21178.jpg',0,1,12.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(430,'430','40508','','','','','','',4,7,'/catalog/imported-images/product-40508.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(431,'431','40505','','','','','','',3,7,'/catalog/imported-images/product-40505.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(432,'432','40512','','','','','','',4,7,'/catalog/imported-images/product-40512.jpg',0,1,14.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(433,'433','40507','','','','','','',4,7,'/catalog/imported-images/product-3800226801354.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(434,'434','22233','','','','','','',3,7,'/catalog/imported-images/product-22233.jpg',0,1,12.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(435,'435','22232','','','','','','',3,7,'/catalog/imported-images/product-22232.jpg',0,1,12.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(436,'436','21745','','','','','','',4,7,'/catalog/imported-images/product-21745.jpg',0,1,11.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(437,'437','3800226801200','','','','','','',3,7,'/catalog/imported-images/product-3800226801200.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(438,'438','10311','','','','','','',2,7,'/catalog/imported-images/product-10311.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(439,'439','3800226801194','','','','','','',4,7,'/catalog/imported-images/product-3800226801194.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(440,'440','3800226801071','','','','','','',2,7,'/catalog/imported-images/product-3800226801071.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(441,'441','3800226801248','','','','','','',3,7,'/catalog/imported-images/product-3800226801248.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(442,'442','3800226801132','3800131573285','','','','','',5,7,'/catalog/imported-images/product-3800226801132.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(443,'443','3800226801217','','','','','','',9,7,'/catalog/imported-images/product-3800226801217.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(444,'444','8699300960033','8697440660141','','','','','',8,7,'/catalog/imported-images/product-8699300960033.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(445,'445','8691411165505','','','','','','',-1,5,NULL,0,1,26.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(446,'446','8680872017171','8680872011193','','','','','',2,7,'/catalog/imported-images/product-8680872017171.jpg',0,1,27.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(447,'447','3800208722813','10101','','','','','',2,7,'/catalog/imported-images/product-3800208722813.jpg',0,1,33.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(448,'448','3800208723513','','','','','','',2,7,'/catalog/imported-images/product-3800208723513.jpg',0,1,22.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(449,'449','3800208723414','','','','','','',2,7,'/catalog/imported-images/product-3800208723414.jpg',0,1,31.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(450,'450','3800208723117','','','','','','',0,5,'/catalog/imported-images/product-3800208723117.jpg',0,1,45.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(451,'451','69811','','','','','','',0,5,'/catalog/imported-images/product-69811.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(452,'452','69812','','','','','','',0,5,'/catalog/imported-images/product-69812.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(453,'453','69813','','','','','','',0,5,'/catalog/imported-images/product-69813.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(454,'454','69801','','','','','','',2,7,'/catalog/imported-images/product-69801.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(455,'455','69802','','','','','','',2,7,'/catalog/imported-images/product-69802.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(456,'456','69803','','','','','','',3,7,'/catalog/imported-images/product-69803.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(457,'457','1561/8','','','','','','',0,5,NULL,0,1,12.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(458,'458','3800208724343','','','','','','',2,7,'/catalog/imported-images/product-3800208724343.jpg',0,1,28.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(459,'459','3800208724244','','','','','','',3,7,'/catalog/imported-images/product-3800208724244.jpg',0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(460,'460','10283','','','','','','',1,7,'/catalog/imported-images/product-10283.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(461,'461','10284','71442','','','','','',3,7,'/catalog/imported-images/product-10284.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(462,'462','6972534409991','6972534470014','','','','','',6,7,'/catalog/imported-images/product-6972534409991.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(463,'463','3800226800012','','','','','','',22,7,'/catalog/imported-images/product-3800226800012.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(464,'464','3800226800029','','','','','','',15,7,'/catalog/imported-images/product-3800226800029.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(465,'465','3800226800036','','','','','','',10,7,'/catalog/imported-images/product-3800226800036.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(466,'466','3800226800043','','','','','','',9,7,'/catalog/imported-images/product-3800226800043.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(467,'467','8000798002011','','','','','','',4,7,'/catalog/imported-images/product-8000798002011.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(468,'468','3800226800531','','','','','','',4,7,'/catalog/imported-images/product-3800226800531.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(469,'469','3800226800128','','','','','','',12,7,'/catalog/imported-images/product-3800226800128.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(470,'470','21522','','','','','','',3,7,'/catalog/imported-images/product-21522.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(471,'471','60182','','','','','','',3,7,'/catalog/imported-images/product-60182.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,3,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(472,'472','3800226800616','','','','','','',8,7,'/catalog/imported-images/product-3800226800616.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(473,'473','8000798055956','8000798399302','','','','','',17,7,'/catalog/imported-images/product-8000798055956.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(474,'474','3800226800449','','','','','','',7,7,'/catalog/imported-images/product-3800226800449.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(475,'475','30669','3800226801903','','','','','',6,7,'/catalog/imported-images/product-30669.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(476,'476','60331','3800226801880','','','','','',2,7,'/catalog/imported-images/product-60331.jpg',0,1,22.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(477,'477','43439','','','','','','',0,5,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(478,'478','3800226800104','','','','','','',12,7,'/catalog/imported-images/product-3800226800104.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(479,'479','3800226800081','','','','','','',21,7,'/catalog/imported-images/product-3800226800081.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(480,'480','41499','','','','','','',1,7,NULL,0,1,35.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(481,'481','30316','','','','','','',2,7,'/catalog/imported-images/product-30316.jpg',0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(482,'482','10606','','','','','','',4,7,'/catalog/imported-images/product-10606.jpg',0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(483,'483','3800208726460','','','','','','',3,7,'/catalog/imported-images/product-3800208726460.jpg',0,1,19.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(484,'484','8697950366540','8697950367899','','','','','',2,7,'/catalog/imported-images/product-8697950366540.jpg',0,1,13.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(485,'485','20251','','','','','','',3,7,'/catalog/imported-images/product-20251.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(487,'487','3800208726552','','','','','','',0,5,'/catalog/imported-images/product-3800208726552.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(488,'488','8697477240279','8694313002701','','','','','',3,7,'/catalog/imported-images/product-8697477240279.jpg',0,1,17.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(489,'489','8697477240286','8681144501466','','','','','',1,7,'/catalog/imported-images/product-8697477240286.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(490,'490','8697477240293','8694313002725','','','','','',3,7,'/catalog/imported-images/product-8697477240293.jpg',0,1,11.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(491,'491','30848','','','','','','',1,7,'/catalog/imported-images/product-30848.jpg',0,1,27.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(492,'492','30683','','','','','','',0,5,'/catalog/imported-images/product-30683.jpg',0,1,31.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(493,'493','3800134816662','','','','','','',3,7,'/catalog/imported-images/product-3800134816662.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(494,'494','3800864000072','','','','','','',0,5,'/catalog/imported-images/product-3800864000072.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(495,'495','3800864000157','3800134816679','','','','','',6,7,'/catalog/imported-images/product-3800864000157.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(496,'496','3800134816686','','','','','','',7,7,'/catalog/imported-images/product-3800134816686.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(497,'497','40874','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(498,'498','6934177787478','2000000077505','','','','','',13,7,'/catalog/imported-images/product-6934177787478.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,2,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(499,'499','6934177787461','3800226801804','','','','','',3,7,'/catalog/imported-images/product-6934177787461.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(500,'500','6998000079925','','','','','','',2,7,'/catalog/imported-images/product-6998000079925.jpg',0,1,24.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(501,'501','6998000079918','','','','','','',2,7,'/catalog/imported-images/product-6998000079918.jpg',0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(502,'502','6998000069773','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(503,'503','6998000069780','','','','','','',1,7,'/catalog/imported-images/product-6998000069780.jpg',0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(504,'504','6930079581244','','','','','','',1,7,'/catalog/imported-images/product-6930079581244.jpg',0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(505,'505','8680131900091','','','','','','',1,7,'/catalog/imported-images/product-8680131900091.jpg',0,1,28.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(506,'506','6916432081057','','','','','','',0,5,NULL,0,1,8.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(507,'507','8680131900503','8680131900336','','','','','',2,7,'/catalog/imported-images/product-8680131900503.jpg',0,1,25.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(508,'508','8680131900510','','','','','','',1,7,'/catalog/imported-images/product-8680131900510.jpg',0,1,20.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,2,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(509,'509','8697853093239','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(510,'510','2090009165143','2090009165174','','','','','',0,5,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(511,'511','2090009165105','2090009165075','','','','','',0,5,NULL,0,1,8.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(512,'512','2090009165006','2090009165013','','','','','',0,5,NULL,0,1,8.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(513,'513','6988146047070','2090000200058','','','','','',8,7,'/catalog/imported-images/product-6988146047070.jpg',0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(514,'514','2090009181921','2000000080055','','','','','',3,7,'/catalog/imported-images/product-2090009181921.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(515,'515','3800158160048','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(516,'516','3800158160024','','','','','','',3,7,'/catalog/imported-images/product-3800158160024.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(517,'517','3800158160031','','','','','','',0,5,'/catalog/imported-images/product-3800158160031.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(518,'518','3800158160017','','','','','','',0,5,'/catalog/imported-images/product-3800158160017.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(519,'519','3800158118445','','','','','','',0,5,'/catalog/imported-images/product-3800158118445.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(520,'520','3800158125320','','','','','','',3,7,'/catalog/imported-images/product-3800158125320.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(521,'521','3800158125337','','','','','','',2,7,'/catalog/imported-images/product-3800158125337.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(522,'522','3800158118650','','','','','','',2,7,'/catalog/imported-images/product-3800158118650.jpg',0,1,24.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(523,'523','3800158118919','','','','','','',0,5,'/catalog/imported-images/product-3800158118919.jpg',0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(524,'524','3800158118421','','','','','','',1,7,'/catalog/imported-images/product-3800158118421.jpg',0,1,6.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(525,'525','LH15','','','','','','',3,7,'/catalog/imported-images/product-LH15.jpg',0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(526,'526','3800158118865','','','','','','',0,5,NULL,0,1,7.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(527,'527','3800158114973','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(528,'528','3800158114966','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(529,'529','3800158112757','','','','','','',0,5,'/catalog/imported-images/product-3800158112757.jpg',0,1,11.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(530,'530','3800158112764','','','','','','',2,7,'/catalog/imported-images/product-3800158112764.jpg',0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(531,'531','3800158112771','','','','','','',1,7,'/catalog/imported-images/product-3800158112771.jpg',0,1,14.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(532,'532','3800158115215','','','','','','',1,7,'/catalog/imported-images/product-3800158115215.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(533,'533','3800158115222','','','','','','',3,7,'/catalog/imported-images/product-3800158115222.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(534,'534','3800158115239','','','','','','',3,7,'/catalog/imported-images/product-3800158115239.jpg',0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(535,'535','3800158115246','','','','','','',4,7,'/catalog/imported-images/product-3800158115246.jpg',0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(536,'536','3800158114560','','','','','','',2,7,'/catalog/imported-images/product-3800158114560.jpg',0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(537,'537','3800158114713','','','','','','',0,5,NULL,0,1,10.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(538,'538','3800158111859','','','','','','',0,5,NULL,0,1,10.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(539,'539','7500','','','','','','',3,7,'/catalog/imported-images/product-7500.jpg',0,1,7.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(540,'540','3800158123395','','','','','','',2,7,'/catalog/imported-images/product-3800158123395.jpg',0,1,13.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(541,'541','3800158123388','','','','','','',0,5,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(542,'542','3800158123432','','','','','','',0,5,NULL,0,1,11.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(543,'543','3800158123333','','','','','','',5,7,'/catalog/imported-images/product-3800158123333.jpg',0,1,10.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(544,'544','3800158123357','','','','','','',3,7,'/catalog/imported-images/product-3800158123357.jpg',0,1,11.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(545,'545','3800158123203','','','','','','',0,5,'/catalog/imported-images/product-3800158123203.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(546,'546','23203','','','','','','',0,5,'/catalog/imported-images/product-23203.jpg',0,1,9.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(547,'547','23204','','','','','','',1,7,'/catalog/imported-images/product-23204.jpg',0,1,11.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(548,'548','3800158114935','','','','','','',1,7,'/catalog/imported-images/product-3800158114935.jpg',0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(549,'549','3800158111736','','','','','','',0,5,'/catalog/imported-images/product-3800158111736.jpg',0,1,50.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(550,'550','3800158111743','','','','','','',1,7,'/catalog/imported-images/product-3800158111743.jpg',0,1,53.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(551,'551','3800158109221','','','','','','',0,5,NULL,0,1,19.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(552,'552','3800158109092','','','','','','',0,5,NULL,0,1,19.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(553,'553','3800158114584','','','','','','',3,7,'/catalog/imported-images/product-3800158114584.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(554,'554','3800158114591','','','','','','',11,7,'/catalog/imported-images/product-3800158114591.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(555,'555','3800158114621','','','','','','',0,5,'/catalog/imported-images/product-3800158114621.jpg',0,1,4.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(556,'556','3800158114638','','','','','','',4,7,'/catalog/imported-images/product-3800158114638.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(557,'557','3800158114645','','','','','','',5,7,'/catalog/imported-images/product-3800158114645.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(558,'558','3800158114652','','','','','','',1,7,'/catalog/imported-images/product-3800158114652.jpg',0,1,8.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(559,'559','3800158123289','','','','','','',2,7,'/catalog/imported-images/product-3800158123289.jpg',0,1,24.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(560,'560','3800158117974','','','','','','',2,7,'/catalog/imported-images/product-3800158117974.jpg',0,1,26.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(561,'561','3800158117981','','','','','','',1,7,'/catalog/imported-images/product-3800158117981.jpg',0,1,29.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(562,'562','3800158117998','','','','','','',2,7,'/catalog/imported-images/product-3800158117998.jpg',0,1,32.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(563,'563','3800158116007','','','','','','',0,5,NULL,0,1,48.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(564,'564','3800158112009','','','','','','',0,5,NULL,0,1,110.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(565,'565','0910','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(566,'566','3800158155211','','','','','','',0,5,NULL,0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(567,'567','1008','','','','','','',3,7,'/catalog/imported-images/product-1008.jpg',0,1,26.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(568,'568','1006','','','','','','',3,7,'/catalog/imported-images/product-1006.jpg',0,1,22.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(569,'569','1004','','','','','','',0,5,'/catalog/imported-images/product-1004.jpg',0,1,18.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(570,'570','3800069406891','','','','','','',0,5,'/catalog/imported-images/product-3800069406891.jpg',0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(571,'571','3800069404545','','','','','','',5,7,'/catalog/imported-images/product-3800069404545.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(572,'572','3800069405016','','','','','','',3,7,'/catalog/imported-images/product-3800069405016.jpg',0,1,3.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(573,'573','3800069405054','','','','','','',2,7,'/catalog/imported-images/product-3800069405054.jpg',0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(574,'574','3800069405061','','','','','','',2,7,'/catalog/imported-images/product-3800069405061.jpg',0,1,3.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(575,'575','3800069405078','','','','','','',3,7,'/catalog/imported-images/product-3800069405078.jpg',0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(576,'576','3800069406211','','','','','','',3,7,'/catalog/imported-images/product-3800069406211.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(577,'577','3801003001219','','','','','','',3,7,'/catalog/imported-images/product-3801003001219.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(578,'578','3801003000403','3800069405887','','','','','',2,7,'/catalog/imported-images/product-3801003000403.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(579,'579','3800069406099','','','','','','',6,7,'/catalog/imported-images/product-3800069406099.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(580,'580','3800069406013','','','','','','',7,7,'/catalog/imported-images/product-3800069406013.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(581,'581','3800069406532','','','','','','',3,7,'/catalog/imported-images/product-3800069406532.jpg',0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(582,'582','3800069406860','','','','','','',2,7,'/catalog/imported-images/product-3800069406860.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(583,'583','8697427789285','','','','','','',5,7,'/catalog/imported-images/product-8697427789285.jpg',0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(584,'584','8697427784624','','','','','','',3,7,'/catalog/imported-images/product-8697427784624.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(585,'585','8697427784501','','','','','','',3,7,'/catalog/imported-images/product-8697427784501.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(586,'586','8697427784471','','','','','','',3,7,'/catalog/imported-images/product-8697427784471.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:02:00'),(587,'587','8697427784778','','','','','','',0,5,'/catalog/imported-images/product-8697427784778.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(588,'588','8697427790359','','','','','','',4,7,'/catalog/imported-images/product-8697427790359.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(589,'589','8697427781920','','','','','','',2,7,'/catalog/imported-images/product-8697427781920.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(590,'590','8697427782217','','','','','','',2,7,'/catalog/imported-images/product-8697427782217.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(591,'591','8697427789209','8697427789216','','','','','',0,5,'/catalog/imported-images/product-8697427789209.jpg',0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(592,'592','8697427788066','8697427788059','','','','','',10,7,'/catalog/imported-images/product-8697427788066.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(593,'593','3800071501157','','','','','','',14,7,'/catalog/imported-images/product-3800071501157.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(594,'594','3800214410391','','','','','','',15,7,'/catalog/imported-images/product-3800214410391.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(595,'595','3800144800026','','','','','','',1,7,'/catalog/imported-images/product-3800144800026.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(596,'596','3800144800002','','','','','','',1,7,'/catalog/imported-images/product-3800144800002.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(597,'597','3800215700019','3800215700026','','','','','',4,7,'/catalog/imported-images/product-3800215700019.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(598,'598','3800215700118','','','','','','',11,7,'/catalog/imported-images/product-3800215700118.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(599,'599','3800085102340','','','','','','',14,7,'/catalog/imported-images/product-3800085102340.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(600,'600','8697427798010','8697427797976','','','','','',1,7,'/catalog/imported-images/product-8697427798010.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(601,'601','3800144804895','','','','','','',6,7,'/catalog/imported-images/product-3800144804895.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(602,'602','8697427783382','8697427783375','','','','','',3,7,'/catalog/imported-images/product-8697427783382.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(603,'603','9000100625227','','','','','','',2,7,'/catalog/imported-images/product-9000100625227.jpg',0,1,3.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(604,'604','5949031309100','5949031309001','','','','','',6,7,'/catalog/imported-images/product-5949031309001.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(605,'605','5949031309025','','','','','','',5,7,'/catalog/imported-images/product-5949031309025.jpg',0,1,10.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(606,'606','8993379259464','','','','','','',5,7,'/catalog/imported-images/product-8993379259464.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(607,'607','3800226590227','','','','','','',3,7,'/catalog/imported-images/product-3800226590227.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(608,'608','3800226590104','','','','','','',6,7,'/catalog/imported-images/product-3800226590104.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(609,'609','3800226590012','','','','','','',7,7,'/catalog/imported-images/product-3800226590012.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(610,'610','3800226590098','','','','','','',4,7,'/catalog/imported-images/product-3800226590098.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(611,'611','3800226590074','','','','','','',9,7,'/catalog/imported-images/product-3800226590074.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(612,'612','3800226590029','','','','','','',1,7,'/catalog/imported-images/product-3800226590029.jpg',0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(613,'613','3800097701203','','','','','','',6,7,'/catalog/imported-images/product-3800097701203.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(614,'614','3800069407584','3801003001738','','','','','',3,7,'/catalog/imported-images/product-3800069407584.jpg',0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(615,'615','3801003001752','','','','','','',1,7,'/catalog/imported-images/product-3801003001752.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(616,'616','4061746504111','4061746504081','','','','','',0,5,'/catalog/imported-images/product-4061746504111.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(617,'617','4061746503664','4061746503879','','','','','',2,7,'/catalog/imported-images/product-4061746503664.jpg',0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(618,'618','3800218841511','','','','','','',7,7,'/catalog/imported-images/product-3800218841511.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(619,'619','3800218841528','','','','','','',6,7,'/catalog/imported-images/product-3800218841528.jpg',0,1,1.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(620,'620','3800214410179','','','','','','',8,7,'/catalog/imported-images/product-3800214410179.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(621,'621','8690536240401','4823019000757','','','','','',1,7,'/catalog/imported-images/product-8690536240401.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(622,'622','8690536240203','4823019000733','','','','','',3,7,'/catalog/imported-images/product-8690536240203.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(623,'623','5200103560080','','','','','','',6,7,'/catalog/imported-images/product-5200103560080.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(624,'624','8692624146299','','','','','','',2,7,'/catalog/imported-images/product-8692624146299.jpg',0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(625,'625','16106','','','','','','',12,7,'/catalog/imported-images/product-16106.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(626,'626','16107','','','','','','',18,7,'/catalog/imported-images/product-16107.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(627,'627','8690536016532','','','','','','',2,7,'/catalog/imported-images/product-8690536016532.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(628,'628','3800090304524','','','','','','',10,7,'/catalog/imported-images/product-3800090304524.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(629,'629','8006540208854','5000174645675','','','','','',11,7,'/catalog/imported-images/product-8006540208854.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(630,'630','8000700000005','8720182262417','','','','','',40,7,'/catalog/imported-images/product-8000700000005.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(631,'631','8697427793947','','','','','','',3,7,'/catalog/imported-images/product-8697427793947.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(632,'632','8690511005469','8690511005476','','','','','',0,5,'/catalog/imported-images/product-8690511005469.jpg',0,1,19.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(633,'633','8690511171409','8690511161615','','','','','',3,7,'/catalog/imported-images/product-8690511171409.jpg',0,1,11.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(634,'634','8683130018644','8683130018675','','','','','',0,5,'/catalog/imported-images/product-8683130018644.jpg',0,1,18.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(635,'635','8015194520090','','','','','','',10,7,'/catalog/imported-images/product-8015194520090.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(636,'636','8015194522278','8015194522261','','','','','',0,5,NULL,0,1,7.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(637,'637','8680731426502','8680731426472','','','','','',0,5,NULL,0,1,24.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(638,'638','8001841247700','','','','','','',0,5,'/catalog/imported-images/product-8001841247700.jpg',0,1,41.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(639,'639','8006540465127','','','','','','',0,5,NULL,0,1,27.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(640,'640','9000100886093','','','','','','',0,5,NULL,0,1,23.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(641,'641','9000101538441','','','','','','',0,5,NULL,0,1,29.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(642,'642','8006540453872','8006540447703','','','','','',0,5,NULL,0,1,26.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(643,'643','9000100683920','90004438','','','','','',0,5,NULL,0,1,15.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(644,'644','9000101426182','','','','','','',0,5,NULL,0,1,19.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(645,'645','8001280409592','8001280409578','','','','','',0,5,NULL,0,1,13.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(646,'646','8001090318428','','','','','','',0,5,NULL,0,1,31.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(647,'647','8006540100882','','','','','','',0,5,NULL,0,1,9.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(648,'648','7610300027336','','','','','','',0,5,'/catalog/imported-images/product-7610300027336.jpg',0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(649,'649','9000101537499','','','','','','',0,5,NULL,0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(650,'650','9000101537345','','','','','','',0,5,NULL,0,1,26.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(653,'653','8001090554673','8001090559081','','','','','',0,5,'/catalog/imported-images/product-8001090554673.jpg',0,1,35.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(654,'654','8690802039845','','','','','','',0,5,NULL,0,1,7.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(655,'655','8710908677335','','','','','','',0,5,NULL,0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(656,'656','8710447283226','8710447283219','','','','','',0,5,NULL,0,1,9.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(657,'657','8001090124654','8001090124791','','','','','',1,7,'/catalog/imported-images/product-8001090124654.jpg',0,1,8.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(658,'658','8001280030871','8001280030956','','','','','',0,5,NULL,0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(659,'659','8008970055213','','','','','','',10,7,'/catalog/imported-images/product-8008970055213.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(660,'660','8693495034180','8714789700052','','','','','',3,7,'/catalog/imported-images/product-8693495034180.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(661,'661','8054633831168','','','','','','',0,5,'/catalog/imported-images/product-8054633831168.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(662,'662','8054633839263','','','','','','',0,5,NULL,0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(663,'663','8698848001888','','','','','','',0,5,NULL,0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(664,'664','8698848002908','','','','','','',0,5,NULL,0,1,5.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(665,'665','8698848000546','','','','','','',-1,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(666,'666','8001841748412','','','','','','',0,5,'/catalog/imported-images/product-8001841748412.jpg',0,1,33.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(667,'667','8001841949277','','','','','','',0,5,NULL,0,1,31.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(668,'668','8697432094015','8680512628408','','','','','',11,7,'/catalog/imported-images/product-8697432094015.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(669,'669','8680512629597','','','','','','',1,7,'/catalog/imported-images/product-8680512629597.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(670,'670','8033993194069','','','','','','',3,7,'/catalog/imported-images/product-8033993194069.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(671,'671','8008260002828','8008260102825','','','','','',4,7,'/catalog/imported-images/product-8008260002828.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(672,'672','8007541015465','','','','','','',9,7,'/catalog/imported-images/product-8007541015465.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(673,'673','8008260001081','','','','','','',3,7,'/catalog/imported-images/product-8008260001081.jpg',0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(674,'674','8690802038022','','','','','','',0,5,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(675,'675','8006540336670','8006540336731','','','','','',8,7,'/catalog/imported-images/product-8006540336670.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(676,'676','8001090581310','','','','','','',0,5,'/catalog/imported-images/product-8001090581310.jpg',0,1,8.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(677,'677','8001480023222','8001480023208','','','','','',0,5,NULL,0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(678,'678','8015100566778','8015100564507','','','','','',4,7,'/catalog/imported-images/product-8015100566778.jpg',0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(679,'679','8690637895159','8690637895173','','','','','',1,7,'/catalog/imported-images/product-5996037079797.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(680,'680','8001480021822','8001480020412','','','','','',1,7,'/catalog/imported-images/product-8001480021822.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(681,'681','5000186735012','5000186735036','','','','','',2,7,'/catalog/imported-images/product-5000186735012.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(682,'682','8690802038015','','','','','','',0,5,NULL,0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(683,'683','8690802028528','','','','','','',0,5,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(684,'684','8001280001765','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(685,'685','8001280001727','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(686,'686','8594005390225','','','','','','',8,7,'/catalog/imported-images/product-8594005390225.jpg',0,1,13.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(687,'687','3059943021181','','','','','','',0,5,'/catalog/imported-images/product-3059943021181.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(688,'688','8410104882891','8410104882730','','','','','',0,5,NULL,0,1,17.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(690,'690','8697425880199','','','','','','',0,5,'/catalog/imported-images/product-8697425880199.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(691,'691','2000000065205','','','','','','',50,7,'/catalog/imported-images/product-2000000065205.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(692,'692','2090000183078','','','','','','',58,7,'/catalog/imported-images/product-2090000183078.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(693,'693','2000000090412','','','','','','',66,7,'/catalog/imported-images/product-2000000090412.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(694,'694','2000000063348','','','','','','',48,7,'/catalog/imported-images/product-2000000063348.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(695,'695','2000000064680','','','','','','',33,7,'/catalog/imported-images/product-2000000064680.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(696,'696','2000000064376','','','','','','',60,7,'/catalog/imported-images/product-2000000064376.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(697,'697','2000000064451','','','','','','',47,7,'/catalog/imported-images/product-2000000064451.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(698,'698','2000000064581','','','','','','',32,7,'/catalog/imported-images/product-2000000064581.jpg',0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(699,'699','2000000095653','','','','','','',3,7,'/catalog/imported-images/product-2000000095653.jpg',0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(700,'700','2000000065991','6956591014824','','','','','',1,7,'/catalog/imported-images/product-2000000065991.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(701,'701','2090000197402','','','','','','',0,5,NULL,0,1,47.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(702,'702','2000000063911','','','','','','',0,5,NULL,0,1,56.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(703,'703','2090000168709','','','','','','',6,7,'/catalog/imported-images/product-2090000168709.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(704,'704','2090000186581','3800131594792','','','','','',17,7,'/catalog/imported-images/product-2090000186581.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(705,'705','2090000149791','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(706,'706','2090000149807','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(707,'707','2090000195446','','','','','','',0,5,'/catalog/imported-images/product-2090000195446.jpg',0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(708,'708','2090000195453','','','','','','',0,5,'/catalog/imported-images/product-2090000195453.jpg',0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(709,'709','2090000195460','','','','','','',0,5,NULL,0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(710,'710','6946002300172','','','','','','',3,7,NULL,0,1,3.3830,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(711,'711','2090000193169','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(712,'712','2090000193152','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(713,'713','2090000193176','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(714,'714','3800151501541','','','','','','',0,5,'/catalog/imported-images/product-3800151501541.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(715,'715','2090000196764','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(716,'716','2090000147056','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(717,'717','2090000193183','','','','','','',1,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(718,'718','2090000196702','','','','','','',3,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(719,'719','2000000066998','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(720,'720','2090000159547','59547','','','','','',7,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(721,'721','2090000186079','','','','','','',2,7,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(722,'722','2090000153323','8692745503001','','','','','',8,7,'/catalog/imported-images/product-2090000153323.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(723,'723','2000000058757','','','','','','',4,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(724,'724','8699300961139','8699300960606','','','','','',12,7,'/catalog/imported-images/product-8699300961139.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(725,'725','2090000198577','','','','','','',1,7,'/catalog/imported-images/product-2090000198577.jpg',0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(726,'726','2000000095523','','','','','','',1,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(727,'727','2000000088679','695344050280','','','','','',2,7,NULL,0,1,9.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(728,'728','2000000056012','','','','','','',1,7,NULL,0,1,17.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(729,'729','2000000094038','','','','','','',1,7,'/catalog/imported-images/product-2000000094038.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(730,'730','2090000193954','','','','','','',2,7,'/catalog/imported-images/product-2090000193954.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(731,'731','2090000157697','','','','','','',2,7,'/catalog/imported-images/product-2090000157697.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(732,'732','2000000093154','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(733,'733','3800134834499','','','','','','',0,5,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(734,'734','6261686502583','','','','','','',0,5,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(735,'735','2000000080888','','','','','','',0,5,NULL,0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(736,'736','2000000056388','10609','','','','','',1,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(737,'737','2000000076478','76478','','','','','',1,7,NULL,0,1,0.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(738,'738','8697957252006','52006','','','','','',0,5,NULL,0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(739,'739','8697975030884','','','','','','',2,7,'/catalog/imported-images/product-8697975030884.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(740,'740','2090000178395','78395','','','','','',2,7,'/catalog/imported-images/product-2090000178395.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(741,'741','2000000072814','','','','','','',2,7,'/catalog/imported-images/product-2000000072814.jpg',0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(742,'742','8979775035919','35919','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(743,'743','3800131599094','','','','','','',1,7,'/catalog/imported-images/product-3800131599094.jpg',0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(744,'744','8697975031195','','','','','','',4,7,'/catalog/imported-images/product-8697975031195.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(745,'745','8692745020409','','','','','','',0,5,NULL,0,1,5.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(746,'746','6260140871937','6261686507274','','','','','',2,7,'/catalog/imported-images/product-6260140871937.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(747,'747','2090000195606','','','','','','',5,7,'/catalog/imported-images/product-2090000195606.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(748,'748','646546544706','6465465445713','','','','','',5,7,'/catalog/imported-images/product-646546544706.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(749,'749','2000000088006','','','','','','',0,5,NULL,0,1,27.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(750,'750','2090000155624','','','','','','',1,7,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(751,'751','2090000148831','48831','','','','','',2,7,NULL,0,1,16.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(752,'752','8681183020768','6773505560792','','','','','',6,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(753,'753','2090000184518','','','','','','',4,7,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(754,'754','2090000184549','','','','','','',2,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(755,'755','2000000062631','','','','','','',9,7,'/catalog/imported-images/product-2000000062631.jpg',0,1,11.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(756,'756','2090000192278','','','','','','',3,7,'/catalog/imported-images/product-2090000192278.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(757,'757','2090000192285','','','','','','',5,7,'/catalog/imported-images/product-2090000192285.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(758,'758','2090000192261','','','','','','',2,7,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(759,'759','2000000060316','','','','','','',1,7,'/catalog/imported-images/product-2000000060316.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(760,'760','8431250711095','2000000060026','','','','','',17,7,'/catalog/imported-images/product-8431250711095.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(761,'761','3800226800661','полиестер','','','','','',10,7,'/catalog/imported-images/product-3800226800661.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(762,'762','2090000147735','8695162613230','','','','','',8,7,'/catalog/imported-images/product-2090000147735.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(763,'763','8695162613155','','','','','','',5,7,'/catalog/imported-images/product-8695162613155.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(764,'764','8692531000820','2000000078113','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(765,'765','6931693203161','','','','','','',6,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(766,'766','2090000172300','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(767,'767','2000000069074','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(768,'768','2090000180817','','','','','','',4,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(769,'769','2090000196610','','','','','','',3,7,NULL,0,1,8.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(770,'770','2090000167009','','','','','','',0,5,'/catalog/imported-images/product-2090000167009.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(771,'771','2090000167016','','','','','','',2,7,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(772,'772','2090000167030','','','','','','',1,7,'/catalog/imported-images/product-2090000167030.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(773,'773','2090000166996','','','','','','',1,7,'/catalog/imported-images/product-2090000166996.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(774,'774','2090000167023','','','','','','',0,5,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(775,'775','2000000068817','','','','','','',5,7,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,2,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(776,'776','2000000073385','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(777,'777','2000000070988','','','','','','',2,7,'/catalog/imported-images/product-2000000070988.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(778,'778','2000000071824','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(779,'779','2000000073224','6945497808125','','','','','',4,7,'/catalog/imported-images/product-2000000073224.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(780,'780','2090000195828','53762','','','','','',6,7,'/catalog/imported-images/product-2090000195828.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(781,'781','2090000195804','53760','','','','','',-1,5,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(782,'782','2090000195811','53761','','','','','',0,5,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(783,'783','2090000166798','','','','','','',2,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(784,'784','2090000166804','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(785,'785','2000000077635','77635','','','','','',12,7,'/catalog/imported-images/product-2000000077635.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(786,'786','2000000057323','57323','','','','','',4,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(787,'787','2090000147483','47483','','','','','',4,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(788,'788','2000000078489','','','','','','',1,7,NULL,0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(789,'789','2090000167696','','','','','','',6,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(790,'790','2090000185966','','','','','','',12,7,'/catalog/imported-images/product-2090000185966.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(791,'791','2000000096063','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(792,'792','2000000064352','','','','','','',2,7,'/catalog/imported-images/product-2000000064352.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(793,'793','2000000089072','','','','','','',4,7,'/catalog/imported-images/product-2000000089072.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(794,'794','2000000059419','','','','','','',0,5,NULL,0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(795,'795','2090000156645','6900101688234','','','','','',2,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(796,'796','2000000078830','','','','','','',1,7,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(797,'797','2090000166613','','','','','','',4,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(798,'798','2000000080321','6944128609322','','','','','',7,7,'/catalog/imported-images/product-2000000080321.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(799,'799','6943956400026','2000000079837','','','','','',2,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(800,'800','2000000079622','79622','','','','','',2,7,'/catalog/imported-images/product-2000000079622.jpg',0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(801,'801','2000000079639','79639','','','','','',0,5,'/catalog/imported-images/product-2000000079639.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(802,'802','2000000080307','80307','','','','','',0,5,'/catalog/imported-images/product-2000000080307.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(803,'803','2000000080314','80314','','','','','',0,5,'/catalog/imported-images/product-2000000080314.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(804,'804','8699421200414','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(805,'805','2000000071558','8699421200421','','','','','',11,7,'/catalog/imported-images/product-2000000071558.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(806,'806','8699421200438','40471','','','','','',13,7,'/catalog/imported-images/product-8699421200438.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(807,'807','3800131573209','','','','','','',2,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(808,'808','3800131573216','','','','','','',1,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(809,'809','3800131573193','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(810,'810','2090000172027','','','','','','',2,7,'/catalog/imported-images/product-2090000172027.jpg',0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(811,'811','6938655040055','','','','','','',7,7,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(812,'812','2090000172072','','','','','','',3,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(813,'813','2090000149883','','','','','','',3,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(814,'814','2000000073798','','','','','','',5,7,'/catalog/imported-images/product-2000000073798.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(815,'815','8697443290093','','','','','','',3,7,'/catalog/imported-images/product-8697443290093.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(816,'816','8697443290024','0000000300414','','','','','',2,7,'/catalog/imported-images/product-8697443290024.jpg',0,1,6.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(817,'817','8697443290420','','','','','','',2,7,'/catalog/imported-images/product-8697443290420.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(818,'818','8697443290314','0000000300438','','','','','',4,7,'/catalog/imported-images/product-8697443290314.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(819,'819','2090000174854','','','','','','',3,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(820,'820','2000000079394','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(821,'821','2000000078052','78052','','','','','',4,7,'/catalog/imported-images/product-2000000078052.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(822,'822','2000000059433','','','','','','',4,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(823,'823','2090000189599','52705','','','','','',0,5,NULL,0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(824,'824','2000000096124','','','','','','',6,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(825,'825','2000000079592','79592','','','','','',0,5,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(826,'826','2000000096087','96087','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(827,'827','2090000188660','88660','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(828,'828','2090000182897','10942','','','','','',13,7,'/catalog/imported-images/product-2090000182897.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(829,'829','2000000079509','79509','','','','','',2,7,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(830,'830','2000000069678','69678','','','','','',1,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(831,'831','2000000079516','79516','','','','','',3,7,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(832,'832','46445','','','','','','',6,7,'/catalog/imported-images/product-46445.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(833,'833','2000000062198','62198','','','','','',0,5,'/catalog/imported-images/product-2000000062198.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(834,'834','2000000062204','62204','','','','','',0,5,NULL,0,1,5.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(835,'835','2000000062310','62310','','','','','',0,5,NULL,0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(836,'836','2000000062426','62426','','','','','',3,7,'/catalog/imported-images/product-2000000062426.jpg',0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(837,'837','2090000145236','45236','','','','','',214,7,NULL,0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(838,'838','0000000320924','','','','','','',14,7,'/catalog/imported-images/product-0000000320924.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(839,'839','2000000077963','77963','','','','','',0,5,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(840,'840','2000000077970','77970','','','','','',3,7,NULL,0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(841,'841','2090000149906','49906','','','','','',1,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(842,'842','8007626235016','','','','','','',3,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(843,'843','2090000144888','44888','','','','','',2,7,NULL,0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(844,'844','2090000170047','3800131554154','','','','','',0,5,NULL,0,1,15.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(845,'845','2000000090566','','','','','','',1,7,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(846,'846','8697439146014','8698734217034','','','','','',5,7,'/catalog/imported-images/product-8697439146014.jpg',0,1,5.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(847,'847','8606003590399','','','','','','',2,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(848,'848','8606003591549','','','','','','',3,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(849,'849','8606003590412','','','','','','',1,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(850,'850','8606003590252','3800163902176','','','','','',4,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(851,'851','8606003590054','','','','','','',5,7,'/catalog/imported-images/product-8606003590054.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(852,'852','2000000080413','80413','','','','','',0,5,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(853,'853','2000000080420','80420','','','','','',0,5,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(854,'854','2000000073286','','','','','','',4,7,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(855,'855','4823052319670','','','','','','',0,5,NULL,0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(856,'856','4823052319656','','','','','','',0,5,NULL,0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(857,'857','8697439146557','','','','','','',3,7,NULL,0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(858,'858','2090000171525','','','','','','',3,7,NULL,0,1,13.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(859,'859','3800131568168','3800139275907','','','','','',2,7,NULL,0,1,23.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(860,'860','3800131502759','','','','','','',0,5,NULL,0,1,38.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(861,'861','3800131546616','','','','','','',0,5,NULL,0,1,27.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(862,'862','2090000145014','45014','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(863,'863','2000000079530','79530','','','','','',1,7,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(864,'864','2090000193275','93275','','','','','',9,7,'/catalog/imported-images/product-2090000193275.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(865,'865','2000000054827','','','','','','',8,7,'/catalog/imported-images/product-2000000054827.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(866,'866','2000000067049','','','','','','',3,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(867,'867','8680845009479','','','','','','',3,7,'/catalog/imported-images/product-8680845009479.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(868,'868','2000000056630','56630','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(869,'869','2000000055794','3800836400213','','','','','',1,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(870,'870','2000000082318','','','','','','',0,5,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(871,'871','2090000180855','','','','','','',1,7,'/catalog/imported-images/product-2090000180855.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(872,'872','2000000082431','72006','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(873,'873','2090000180862','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(874,'874','8694064012943','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(875,'875','8694064012844','','','','','','',3,7,'/catalog/imported-images/product-8694064012844.jpg',0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(876,'876','8694064005518','','','','','','',0,5,NULL,0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(877,'877','8694064005303','','','','','','',0,5,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(878,'878','8694064007321','','','','','','',0,5,NULL,0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(879,'879','8694064005754','','','','','','',3,7,'/catalog/imported-images/product-8694064005754.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(880,'880','2090000147902','47902','','','','','',0,5,NULL,0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(881,'881','4823044307548','4823052325527','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(882,'882','8606003595370','','','','','','',1,7,NULL,0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(883,'883','3800134823325','','','','','','',0,5,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(884,'884','8699300060092','','','','','','',3,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(885,'885','2000000078199','3800215496516','','','','','',0,5,NULL,0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(886,'886','2000000082684','','','','','','',3,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(887,'887','2000000082417','72458','','','','','',1,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(888,'888','2090000156669','073117800001','','','','','',10,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(889,'889','2090000156676','','','','','','',8,7,NULL,0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:03:00'),(890,'890','2090000156706','','','','','','',2,7,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(891,'891','8693135045040','','','','','','',0,5,NULL,0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(892,'892','2090000174724','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(893,'893','2090000174731','','','','','','',7,7,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(894,'894','71952','','','','','','',5,7,'/catalog/imported-images/product-71952.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(895,'895','2000000071800','71800','','','','','',1,7,NULL,0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(896,'896','2000000074917','3800077002597','','','','','',2,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(897,'897','2000000077055','3800163901995','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(898,'898','2000000086897','3800163902008','','','','','',5,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(899,'899','2000000077062','3800163901988','','','','','',1,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(900,'900','2090000170825','3800163902015','','','','','',1,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(901,'901','2000000077079','3800163902022','','','','','',1,7,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(902,'902','2000000073668','8693135014008','','','','','',4,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(903,'903','2000000073675','8693135014817','','','','','',5,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(904,'904','2000000073682','8693135014824','','','','','',1,7,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(905,'905','2000000073699','8693135014831','','','','','',4,7,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(906,'906','8696287303099','','','','','','',2,7,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(907,'907','8696587303051','8696287303051','','','','','',1,7,NULL,0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(908,'908','8696287303068','','','','','','',2,7,NULL,0,1,9.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(909,'909','8699863050011','142705','','','','','',10,7,'/catalog/imported-images/product-8699863050011.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(910,'910','3800226800364','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(911,'911','2000000082141','','','','','','',5,7,'/catalog/imported-images/product-2000000082141.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(912,'912','2090000182804','','','','','','',0,5,NULL,0,1,5.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(913,'913','2000000073217','','','','','','',1,7,'/catalog/imported-images/product-2000000073217.jpg',0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(914,'914','2000000080987','30527','','','','','',5,7,'/catalog/imported-images/product-2000000080987.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(915,'915','2000000077512','','','','','','',8,7,'/catalog/imported-images/product-2000000077512.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(916,'916','2090000166385','6956702522248','','','','','',6,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(917,'917','2090000166378','6956702522231','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(918,'918','2090000166361','6956702522224','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(919,'919','5906927331300','','','','','','',14,7,'/catalog/imported-images/product-5906927331300.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(920,'920','5906927020907','5906927371382','','','','','',0,5,NULL,0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(921,'921','2090000190526','90526','','','','','',2,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(922,'922','2090000188899','88899','','','','','',2,7,NULL,0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(923,'923','2090000165814','','','','','','',8,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(924,'924','48832','','','','','','',1,7,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(925,'925','48833','','','','','','',2,7,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(926,'926','55625','','','','','','',0,5,NULL,0,1,10.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(927,'927','55626','','','','','','',2,7,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(928,'928','680678000016','680678000016680678000016','','','','','',3,7,'/catalog/imported-images/product-680678000016.jpg',0,1,5.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(929,'929','8693357019706','680678019704','','','','','',6,7,'/catalog/imported-images/product-8693357019706.jpg',0,1,6.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(930,'930','3800144806219','','','','','','',2,7,'/catalog/imported-images/product-3800144806219.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(931,'931','8594158378224','','','','','','',9,7,'/catalog/imported-images/product-8594158378224.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(932,'932','3800216970015','','','','','','',8,7,'/catalog/imported-images/product-3800216970015.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(933,'933','8594158377845','','','','','','',6,7,'/catalog/imported-images/product-8594158377845.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(934,'934','8594158377968','','','','','','',5,7,'/catalog/imported-images/product-8594158377968.jpg',0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(935,'935','8594158378859','','','','','','',15,7,'/catalog/imported-images/product-8594158378859.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(936,'936','8594158378835','','','','','','',5,7,'/catalog/imported-images/product-8594158378835.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(937,'937','8594158378675','','','','','','',6,7,'/catalog/imported-images/product-8594158378675.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(938,'938','5319904412396','','','','','','',13,7,'/catalog/imported-images/product-5319904412396.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(939,'939','5319904412365','','','','','','',7,7,'/catalog/imported-images/product-5319904412365.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(940,'940','5319904412389','','','','','','',8,7,'/catalog/imported-images/product-5319904412389.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(941,'941','5319904412006','','','','','','',20,7,'/catalog/imported-images/product-5319904412006.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(942,'942','3800214423629','3800214423612','','','','','',0,5,'/catalog/imported-images/product-3800214423629.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(943,'943','3800214423605','5999860406341','','','','','',6,7,'/catalog/imported-images/product-3800214423605.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(944,'944','3800213140077','','','','','','',7,7,'/catalog/imported-images/product-3800213140077.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(945,'945','6928971002011','6164001128003','','','','','',10,7,'/catalog/imported-images/product-6928971002011.jpg',0,1,0.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(946,'946','8693357015449','','','','','','',0,5,'/catalog/imported-images/product-8693357015449.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(947,'947','8693357192409','680678192476','','','','','',3,7,'/catalog/imported-images/product-8693357192409.jpg',0,1,22.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(948,'948','8693357192683','680678192759','','','','','',3,7,'/catalog/imported-images/product-8693357192683.jpg',0,1,22.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(949,'949','8693357148796','680678149272','','','','','',3,7,'/catalog/imported-images/product-8693357148796.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(950,'950','8693357192461','680678192537','','','','','',3,7,'/catalog/imported-images/product-8693357192461.jpg',0,1,24.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(951,'951','8693357469280','680678467987','','','','','',2,7,'/catalog/imported-images/product-8693357469280.jpg',0,1,17.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(952,'952','8693357203242','680678202908','','','','','',0,5,'/catalog/imported-images/product-8693357203242.jpg',0,1,45.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(953,'953','8693357090415','680678090413','','','','','',3,7,'/catalog/imported-images/product-8693357090415.jpg',0,1,18.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(954,'954','8693357091948','680678091946','','','','','',6,7,'/catalog/imported-images/product-8693357091948.jpg',0,1,13.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(955,'955','7290012116377','','','','','','',1,7,'/catalog/imported-images/product-7290012116377.jpg',0,1,47.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(956,'956','7290005425943','','','','','','',2,7,'/catalog/imported-images/product-7290005425943.jpg',0,1,27.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(957,'957','7290102992188','','','','','','',0,5,'/catalog/imported-images/product-7290102992188.jpg',0,1,38.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(958,'958','7290102992218','','','','','','',2,7,'/catalog/imported-images/product-7290102992218.jpg',0,1,14.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(959,'959','7290102990313','','','','','','',2,7,'/catalog/imported-images/product-7290102990313.jpg',0,1,14.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(960,'960','7290107280570','','','','','','',2,7,'/catalog/imported-images/product-7290107280570.jpg',0,1,38.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(961,'961','7290108357189','','','','','','',2,7,'/catalog/imported-images/product-7290108357189.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(962,'962','7290102992713','','','','','','',3,7,'/catalog/imported-images/product-7290102992713.jpg',0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(963,'963','7290000286921','','','','','','',2,7,'/catalog/imported-images/product-7290000286921.jpg',0,1,9.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(964,'964','7290010935260','','','','','','',3,7,'/catalog/imported-images/product-7290010935260.jpg',0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(965,'965','7290005430602','','','','','','',2,7,'/catalog/imported-images/product-7290005430602.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(966,'966','7290000286297','','','','','','',4,7,'/catalog/imported-images/product-7290000286297.jpg',0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(967,'967','7290000293943','','','','','','',0,5,'/catalog/imported-images/product-7290000293943.jpg',0,1,11.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(968,'968','7290000287621','','','','','','',4,7,'/catalog/imported-images/product-7290000287621.jpg',0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(969,'969','7290000289748','','','','','','',3,7,'/catalog/imported-images/product-7290000289748.jpg',0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(970,'970','7290005423482','','','','','','',3,7,'/catalog/imported-images/product-7290005423482.jpg',0,1,9.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(971,'971','7290108350555','','','','','','',1,7,'/catalog/imported-images/product-7290108350555.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(972,'972','7290001791592','','','','','','',2,7,'/catalog/imported-images/product-7290001791592.jpg',0,1,10.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(973,'973','7290102991051','','','','','','',2,7,'/catalog/imported-images/product-7290102991051.jpg',0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(974,'974','7290000286945','','','','','','',3,7,'/catalog/imported-images/product-7290000286945.jpg',0,1,14.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(975,'975','7290000292137','','','','','','',2,7,'/catalog/imported-images/product-7290000292137.jpg',0,1,13.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(976,'976','7290000286983','','','','','','',2,7,'/catalog/imported-images/product-7290000286983.jpg',0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(977,'977','7290005425646','7290102990603','','','','','',2,7,'/catalog/imported-images/product-7290005425646.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(978,'978','7290102991785','7290102991778','','','','','',3,7,'/catalog/imported-images/product-7290102991785.jpg',0,1,7.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(979,'979','3800209550590','','','','','','',23,7,'/catalog/imported-images/product-3800209550590.jpg',0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(980,'980','3800209558022','','','','','','',0,5,NULL,0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(981,'981','3800209551153','','','','','','',0,5,NULL,0,1,10.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(982,'982','3800209551375','','','','','','',1,7,'/catalog/imported-images/product-3800209551375.jpg',0,1,9.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(983,'983','8693357158658','680678159073','','','','','',6,7,'/catalog/imported-images/product-8693357158658.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(984,'984','8693357093461','680678093469','','','','','',4,7,'/catalog/imported-images/product-8693357093461.jpg',0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(985,'985','8693357146341','680678146851','','','','','',3,7,'/catalog/imported-images/product-8693357146341.jpg',0,1,12.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(986,'986','8693357288508','680678287721','','','','','',6,7,'/catalog/imported-images/product-8693357288508.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(987,'987','8693357034167','680678034165','','','','','',7,7,'/catalog/imported-images/product-8693357034167.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(988,'988','8693357469433','680678468137','','','','','',3,7,'/catalog/imported-images/product-8693357469433.jpg',0,1,20.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(989,'989','8693357178038','680678178333','','','','','',20,7,'/catalog/imported-images/product-8693357178038.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(990,'990','8693357156098','680678156492','','','','','',3,7,'/catalog/imported-images/product-8693357156098.jpg',0,1,12.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(991,'991','8693357257269','680678256581','','','','','',7,7,'/catalog/imported-images/product-8693357257269.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(992,'992','8693357192324','680678192391','','','','','',2,7,'/catalog/imported-images/product-8693357192324.jpg',0,1,18.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(993,'993','8693357111738','680678111736','','','','','',4,7,'/catalog/imported-images/product-8693357111738.jpg',0,1,19.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(994,'994','8693357076990','680678076998','','','','','',1,7,'/catalog/imported-images/product-8693357076990.jpg',0,1,12.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(995,'995','45068','','','','','','',1,7,'/catalog/imported-images/product-45068.jpg',0,1,12.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(996,'996','8693357093041','680678093049','','','','','',5,7,'/catalog/imported-images/product-8693357093041.jpg',0,1,14.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(998,'998','8690510115206','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(999,'999','3800139262280','','','','','','',0,5,NULL,0,1,34.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1000,'1000','3800139262297','','','','','','',3,7,'/catalog/imported-images/product-3800139262297.jpg',0,1,39.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1001,'1001','3800139282189','','','','','','',0,5,NULL,0,1,14.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1002,'1002','3800139292799','','','','','','',0,5,NULL,0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1003,'1003','8803733070201','','','','','','',2,7,NULL,0,1,14.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1004,'1004','3800139291990','','','','','','',1,7,'/catalog/imported-images/product-3800139291990.jpg',0,1,19.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1005,'1005','3800139291976','','','','','','',1,7,'/catalog/imported-images/product-3800139291976.jpg',0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1006,'1006','3800139292027','','','','','','',0,5,'/catalog/imported-images/product-3800139292027.jpg',0,1,19.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1007,'1007','3800139291983','','','','','','',2,7,'/catalog/imported-images/product-3800139291983.jpg',0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1008,'1008','3800139291952','','','','','','',0,5,'/catalog/imported-images/product-3800139291952.jpg',0,1,11.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1009,'1009','3800139292010','','','','','','',1,7,'/catalog/imported-images/product-3800139292010.jpg',0,1,15.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1010,'1010','3800139289560','','','','','','',2,7,NULL,0,1,40.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1011,'1011','3800139290689','','','','','','',2,7,NULL,0,1,37.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1012,'1012','3800139270452','','','','','','',0,5,NULL,0,1,18.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1013,'1013','3800139284008','','','','','','',1,7,NULL,0,1,63.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1014,'1014','8850222169953','','','','','','',1,7,NULL,0,1,7.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1015,'1015','883314388725','','','','','','',0,5,NULL,0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1016,'1016','3800139290641','','','','','','',2,7,NULL,0,1,25.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1017,'1017','3800139277895','','','','','','',0,5,NULL,0,1,13.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1018,'1018','3800139277918','ВВВ.РЕНО.БГ/1003143','','','','','',1,7,'/catalog/imported-images/product-3800139277918.jpg',0,1,13.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1019,'1019','3800139288815','','','','','','',0,5,NULL,0,1,33.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1020,'1020','3800139262242','','','','','','',0,5,NULL,0,1,16.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1021,'1021','3800139262303','','','','','','',0,5,NULL,0,1,47.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1022,'1022','3800139290665','','','','','','',0,5,NULL,0,1,15.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1023,'1023','3800139290627','','','','','','',2,7,NULL,0,1,20.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1024,'1024','3800139290702','','','','','','',1,7,NULL,0,1,31.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1025,'1025','3800139231750','3800139231767','','','','','',0,5,NULL,0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1026,'1026','3800139268930','','','','','','',0,5,NULL,0,1,37.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1027,'1027','3800139208455','','','','','','',5,7,'/catalog/imported-images/product-3800139208455.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1028,'1028','8595028411010','','','','','','',3,7,NULL,0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1029,'1029','8833143931182','','','','','','',0,5,NULL,0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1030,'1030','883314393071','','','','','','',30,7,'/catalog/imported-images/product-883314393071.jpg',0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1031,'1031','883314393095','','','','','','',1,7,'/catalog/imported-images/product-883314393095.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1032,'1032','3800139275860','','','','','','',0,5,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1033,'1033','3800139275877','','','','','','',0,5,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1034,'1034','3800139262372','','','','','','',3,7,'/catalog/imported-images/product-3800139262372.jpg',0,1,25.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1035,'1035','3800139262396','','','','','','',2,7,'/catalog/imported-images/product-3800139262396.jpg',0,1,32.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1036,'1036','3800139268572','','','','','','',3,7,'/catalog/imported-images/product-3800139268572.jpg',0,1,35.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1037,'1037','3800139262310','','','','','','',1,7,'/catalog/imported-images/product-3800139262310.jpg',0,1,51.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1038,'1038','3800139262259','3800139262358','','','','','',2,7,'/catalog/imported-images/product-3800139262259.jpg',0,1,20.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1039,'1039','3800139262273','','','','','','',0,5,NULL,0,1,23.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1040,'1040','3800139262266','145068','','','','','',1,7,'/catalog/imported-images/product-3800139262266.jpg',0,1,22.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1041,'1041','3800139262327','','','','','','',0,5,NULL,0,1,25.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1042,'1042','3800139277932','','','','','','',0,5,NULL,0,1,14.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1043,'1043','3800139262365','','','','','','',1,7,'/catalog/imported-images/product-3800139262365.jpg',0,1,22.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1044,'1044','3800139268565','','','','','','',1,7,'/catalog/imported-images/product-3800139268565.jpg',0,1,34.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1045,'1045','3800139262389','','','','','','',3,7,'/catalog/imported-images/product-3800139262389.jpg',0,1,28.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1046,'1046','3800139258825','','','','','','',0,5,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1047,'1047','4895139236620','','','','','','',0,5,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1048,'1048','4895139236637','','','','','','',0,5,NULL,0,1,15.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1049,'1049','4895139238747','','','','','','',1,7,'/catalog/imported-images/product-4895139238747.jpg',0,1,16.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1050,'1050','4895139242942','','','','','','',0,5,'/catalog/imported-images/product-4895139242942.jpg',0,1,26.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1051,'1051','4895139242959','','','','','','',0,5,NULL,0,1,29.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1052,'1052','5908287211254','','','','','','',0,5,'/catalog/imported-images/product-5908287211254.jpg',0,1,27.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1053,'1053','5908287211261','','','','','','',0,5,'/catalog/imported-images/product-5908287211261.jpg',0,1,28.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1054,'1054','4895139242966','','','','','','',0,5,NULL,0,1,32.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1055,'1055','4895139209167','','','','','','',2,7,'/catalog/imported-images/product-4895139209167.jpg',0,1,37.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1056,'1056','4895139242980','','','','','','',1,7,'/catalog/imported-images/product-4895139242980.jpg',0,1,45.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1057,'1057','4895139242973','','','','','','',2,7,'/catalog/imported-images/product-4895139242973.jpg',0,1,39.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1058,'1058','5908287214682','','','','','','',0,5,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1059,'1059','4895139208528','4895139206463','','','','','',0,5,NULL,0,1,19.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1060,'1060','4895139229219','','','','','','',0,5,NULL,0,1,28.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1061,'1061','4895139233155','','','','','','',1,7,'/catalog/imported-images/product-4895139233155.jpg',0,1,32.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1062,'1062','4895139223415','','','','','','',2,7,'/catalog/imported-images/product-4895139223415.jpg',0,1,48.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1063,'1063','4895139201093','','','','','','',1,7,'/catalog/imported-images/product-4895139201093.jpg',0,1,32.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1064,'1064','4895139236507','','','','','','',1,7,'/catalog/imported-images/product-4895139236507.jpg',0,1,33.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1065,'1065','4895139238778','','','','','','',0,5,NULL,0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1066,'1066','4895139238785','','','','','','',0,5,NULL,0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1067,'1067','4895139238792','','','','','','',0,5,NULL,0,1,13.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1068,'1068','4895139238754','','','','','','',1,7,'/catalog/imported-images/product-4895139238754.jpg',0,1,17.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1069,'1069','4897011588032','','','','','','',3,7,'/catalog/imported-images/product-4897011588032.jpg',0,1,27.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1070,'1070','4895139235937','','','','','','',0,5,NULL,0,1,35.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1071,'1071','4895139210293','4895139210347','','','','','',1,7,'/catalog/imported-images/product-4895139210293.jpg',0,1,19.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1072,'1072','4895139236316','4895139235678','','','','','',1,7,'/catalog/imported-images/product-4895139236316.jpg',0,1,32.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1073,'1073','4895139241471','4895139210309','','','','','',1,7,'/catalog/imported-images/product-4895139241471.jpg',0,1,23.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1074,'1074','4895139236453','','','','','','',0,5,'/catalog/imported-images/product-4895139236453.jpg',0,1,48.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1075,'1075','2000000060347','','','','','','',3,7,NULL,0,1,26.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1076,'1076','8696033288977','8696033288960','','','','','',10,7,'/catalog/imported-images/product-8696033288977.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1077,'1077','8696033306589','8696033284283','','','','','',11,7,'/catalog/imported-images/product-8696033306589.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1079,'1079','60197','','','','','','',2,7,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1080,'1080','7638900437324','','','','','','',5,7,'/catalog/imported-images/product-7638900437324.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1081,'1081','7638900437485','','','','','','',4,7,'/catalog/imported-images/product-7638900437485.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1082,'1082','7638900437744','','','','','','',0,5,NULL,0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1083,'1083','7638900438215','','','','','','',0,5,NULL,0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1084,'1084','7638900083057','','','','','','',2,7,NULL,0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1085,'1085','7638900083002','','','','','','',5,7,'/catalog/imported-images/product-7638900083002.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1086,'1086','7638900083026','','','','','','',1,7,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1087,'1087','7638900083040','','','','','','',6,7,'/catalog/imported-images/product-7638900083040.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1088,'1088','7638900393330','','','','','','',4,7,NULL,0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1089,'1089','887930411706','','','','','','',31,7,'/catalog/imported-images/product-887930411706.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1090,'1090','887930411713','','','','','','',27,7,'/catalog/imported-images/product-887930411713.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1091,'1091','887930410389','','','','','','',13,7,'/catalog/imported-images/product-887930410389.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:04:00'),(1092,'1092','887930410396','','','','','','',4,7,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1093,'1093','887930412789','','','','','','',6,7,'/catalog/imported-images/product-887930412789.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1096,'1096','887930413915','887930413908','','','','','',7,7,'/catalog/imported-images/product-887930413915.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1097,'1097','887930413861','','','','','','',2,7,NULL,0,1,18.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1098,'1098','887930419207','','','','','','',2,7,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1099,'1099','5907618328234','','','','','','',10,7,'/catalog/imported-images/product-5907618328234.jpg',0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1100,'1100','5907618328531','','','','','','',7,7,'/catalog/imported-images/product-5907618328531.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1101,'1101','85062','','','','','','',0,5,NULL,0,1,5.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1102,'1102','5907618374101','','','','','','',4,7,'/catalog/imported-images/product-5907618374101.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1103,'1103','5907618337229','','','','','','',4,7,'/catalog/imported-images/product-5907618337229.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1104,'1104','3803014400005','','','','','','',2,7,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1105,'1105','3803010700000','','','','','','',4,7,NULL,0,1,24.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1106,'1106','3803012000009','','','','','','',3,7,'/catalog/imported-images/product-3803012000009.jpg',0,1,18.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1107,'1107','3803014100004','','','','','','',1,7,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1109,'1109','9000100225014','','','','','','',5,7,'/catalog/imported-images/product-9000100225014.jpg',0,1,3.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1110,'1110','5903649056443','','','','','','',1,7,'/catalog/imported-images/product-5903649056443.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1111,'1111','5903649056580','','','','','','',1,7,NULL,0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1112,'1112','5903649056146','','','','','','',2,7,NULL,0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1113,'1113','5903649061249','','','','','','',0,5,NULL,0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1114,'1114','5994100031185','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1115,'1115','5994100030737','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1116,'1116','5994100093152','','','','','','',4,7,'/catalog/imported-images/product-5994100093152.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1117,'1117','5994100092919','','','','','','',0,5,'/catalog/imported-images/product-5994100092919.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1118,'1118','5994100093039','','','','','','',2,7,'/catalog/imported-images/product-5994100093039.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1119,'1119','5994100092957','','','','','','',0,5,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1120,'1120','5994100093077','6923933821402','','','','','',4,7,'/catalog/imported-images/product-5994100093077.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1121,'1121','5994100092995','','','','','','',0,5,'/catalog/imported-images/product-5994100092995.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1122,'1122','5994100085768','','','','','','',4,7,'/catalog/imported-images/product-5994100085768.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1123,'1123','5994100085737','','','','','','',4,7,'/catalog/imported-images/product-5994100085737.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1124,'1124','5994100100133','','','','','','',0,5,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1125,'1125','5994100100140','','','','','','',5,7,'/catalog/imported-images/product-5994100100140.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1126,'1126','85031','','','','','','',5,7,'/catalog/imported-images/product-85031.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1127,'1127','8022446019202','8022446200204','','','','','',11,7,'/catalog/imported-images/product-8022446019202.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1128,'1128','8022446019301','','','','','','',7,7,'/catalog/imported-images/product-8022446019301.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1129,'1129','8022446019400','','','','','','',3,7,'/catalog/imported-images/product-8022446019400.jpg',0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1130,'1130','8022446019509','','','','','','',3,7,'/catalog/imported-images/product-8022446019509.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1131,'1131','8022446019608','','','','','','',5,7,'/catalog/imported-images/product-8022446019608.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1132,'1132','8022446019707','','','','','','',5,7,'/catalog/imported-images/product-8022446019707.jpg',0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1133,'1133','8022446190802','','','','','','',11,7,'/catalog/imported-images/product-8022446190802.jpg',0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1134,'1134','8022446191007','','','','','','',12,7,'/catalog/imported-images/product-8022446191007.jpg',0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1135,'1135','609','','','','','','',5,7,'/catalog/imported-images/product-609.jpg',0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1136,'1136','8022446130105','','','','','','',3,7,NULL,0,1,6.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1137,'1137','8022446130150','','','','','','',3,7,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1138,'1138','8022446130204','','','','','','',2,7,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1139,'1139','8022446130259','','','','','','',3,7,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1140,'1140','8022446132109','','','','','','',2,7,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1141,'1141','8022446132154','','','','','','',3,7,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1142,'1142','8022446132208','','','','','','',3,7,NULL,0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1143,'1143','8022446132253','','','','','','',3,7,NULL,0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1144,'1144','8022446176257','','','','','','',2,7,NULL,0,1,10.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1145,'1145','8022446580016','','','','','','',3,7,NULL,0,1,10.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1146,'1146','8022446580023','','','','','','',2,7,NULL,0,1,11.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1147,'1147','8022446162205','','','','','','',2,7,NULL,0,1,10.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1148,'1148','8022446162236','','','','','','',2,7,NULL,0,1,11.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1149,'1149','680','','','','','','',3,7,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1150,'1150','681','','','','','','',1,7,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1151,'1151','682','','','','','','',2,7,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1152,'1152','683','','','','','','',1,7,NULL,0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1153,'1153','684','','','','','','',3,7,NULL,0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1154,'1154','685','','','','','','',2,7,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1155,'1155','686','','','','','','',1,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1156,'1156','687','','','','','','',0,5,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1157,'1157','8022446176202','','','','','','',3,7,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1158,'1158','661','','','','','','',3,7,NULL,0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1159,'1159','662','','','','','','',3,7,NULL,0,1,7.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1160,'1160','663','','','','','','',2,7,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1161,'1161','664','','','','','','',3,7,NULL,0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1162,'1162','665','','','','','','',3,7,NULL,0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1163,'1163','8022446200068','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1164,'1164','8022446201119','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1165,'1165','8022446230065','','','','','','',0,5,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1166,'1166','8022446231116','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1167,'1167','8022446002204','','','','','','',0,5,NULL,0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1168,'1168','8022446002211','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1169,'1169','8022446173331','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1170,'1170','8022446001740','','','','','','',0,5,NULL,0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1171,'1171','3800158117646','','','','','','',0,5,NULL,0,1,17.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1172,'1172','3800158117653','','','','','','',0,5,NULL,0,1,19.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1173,'1173','3800158117660','','','','','','',0,5,NULL,0,1,21.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1174,'1174','3800158117677','','','','','','',2,7,'/catalog/imported-images/product-3800158117677.jpg',0,1,23.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1175,'1175','3800158117684','','','','','','',0,5,NULL,0,1,25.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1176,'1176','3800158155242','','','','','','',0,5,'/catalog/imported-images/product-3800158155242.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1177,'1177','40014340181179','','','','','','',2,7,'/catalog/imported-images/product-40014340181179.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1178,'1178','2208','80412016200169','','','','','',0,5,NULL,0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1179,'1179','15747','50097995157479','','','','','',287,7,'/catalog/imported-images/product-15747.jpg',0,1,0.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1180,'1180','3800002310384','','','','','','',6,7,'/catalog/imported-images/product-3800002310384.jpg',0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1181,'1181','501700301249','','','','','','',14,7,'/catalog/imported-images/product-501700301249.jpg',0,1,0.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1182,'1182','8718951291010','8718951288881','','','','','',0,5,'/catalog/imported-images/product-8718951291010.jpg',0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1183,'1183','5054563034830','5054563109958','','','','','',1,7,'/catalog/imported-images/product-5054563034830.jpg',0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1184,'1184','5054563039774','','','','','','',0,5,'/catalog/imported-images/product-5054563039774.jpg',0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1185,'1185','8692641007214','','','','','','',6,7,'/catalog/imported-images/product-8692641007214.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1186,'1186','3800222890499','','','','','','',5,7,'/catalog/imported-images/product-3800222890499.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1187,'1187','3800222890482','','','','','','',6,7,'/catalog/imported-images/product-3800222890482.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1188,'1188','3800226800302','40203','','','','','',6,7,'/catalog/imported-images/product-3800226800302.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1190,'1190','30564','30704','','','','','',2,7,'/catalog/imported-images/product-30564.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1191,'1191','3800134836035','','','','','','',3,7,'/catalog/imported-images/product-3800134836035.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1192,'1192','3800134836004','','','','','','',1,7,'/catalog/imported-images/product-3800134836004.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1193,'1193','3800134835977','','','','','','',3,7,'/catalog/imported-images/product-3800134835977.jpg',0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1194,'1194','3800134835991','','','','','','',2,7,'/catalog/imported-images/product-3800134835991.jpg',0,1,7.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1195,'1195','3800134835960','','','','','','',4,7,'/catalog/imported-images/product-3800134835960.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1196,'1196','4895139206753','','','','','','',5,7,'/catalog/imported-images/product-4895139206753.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1197,'1197','4895139241396','','','','','','',1,7,'/catalog/imported-images/product-4895139241396.jpg',0,1,22.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1198,'1198','4895139233360','','','','','','',0,5,NULL,0,1,59.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1199,'1199','4895139207934','','','','','','',0,5,'/catalog/imported-images/product-4895139207934.jpg',0,1,46.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1200,'1200','5902934836319','','','','','','',2,7,'/catalog/imported-images/product-5902934836319.jpg',0,1,17.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1201,'1201','4895139209136','4895139209129','','','','','',1,7,'/catalog/imported-images/product-4895139209136.jpg',0,1,15.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1202,'1202','4895139237290','','','','','','',0,5,NULL,0,1,36.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1203,'1203','4895139206890','','','','','','',1,7,'/catalog/imported-images/product-4895139206890.jpg',0,1,78.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1204,'1204','4895139206937','','','','','','',1,7,'/catalog/imported-images/product-4895139206937.jpg',0,1,81.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1205,'1205','4895139209143','','','','','','',3,7,'/catalog/imported-images/product-4895139209143.jpg',0,1,29.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1206,'1206','4895139209150','','','','','','',1,7,'/catalog/imported-images/product-4895139209150.jpg',0,1,32.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1207,'1207','4895139209174','','','','','','',1,7,'/catalog/imported-images/product-4895139209174.jpg',0,1,42.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1208,'1208','4895170324263','158681','','','','','',3,7,'/catalog/imported-images/product-4895170324263.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1209,'1209','158662','158682','','','','','',2,7,'/catalog/imported-images/product-158662.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1210,'1210','158663','158683','','','','','',2,7,'/catalog/imported-images/product-158663.jpg',0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1211,'1211','38013133','','','','','','',2,7,NULL,0,1,40.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1212,'1212','3800138241804','','','','','','',0,5,NULL,0,1,58.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1213,'1213','9003898042511','','','','','','',1,7,NULL,0,1,43.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1215,'1215','6944217227338','','','','','','',0,5,NULL,0,1,48.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1216,'1216','3800138247103','','','','','','',0,5,NULL,0,1,69.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1217,'1217','8696033296927','8696033189144','','','','','',15,7,'/catalog/imported-images/product-8696033296927.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1218,'1218','8696033278282','8696033189106','','','','','',6,7,'/catalog/imported-images/product-8696033278282.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1219,'1219','8003650018397','','','','','','',1,7,'/catalog/imported-images/product-8003650018397.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1220,'1220','5413149799035','5413149798854','','','','','',0,5,NULL,0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1221,'1221','86900652','','','','','','',0,5,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1222,'1222','8718951270251','','','','','','',2,7,'/catalog/imported-images/product-8718951270251.jpg',0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1223,'1223','8720181047091','8720181047053','','','','','',2,7,'/catalog/imported-images/product-8720182482129.jpg',0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1224,'1224','8003650018359','','','','','','',0,5,'/catalog/imported-images/product-8003650018359.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1225,'1225','8003650018410','','','','','','',9,7,'/catalog/imported-images/product-8003650018410.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1226,'1226','8015194522964','8015194522957','','','','','',7,7,'/catalog/imported-images/product-8015194522933.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1227,'1227','8001841485706','8001841485737','','','','','',4,7,'/catalog/imported-images/product-8001841485706.jpg',0,1,10.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1228,'1228','5601059934275','5000174896169','','','','','',1,7,'/catalog/imported-images/product-5601059934275.jpg',0,1,5.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1229,'1229','8006540340387','','','','','','',0,5,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1230,'1230','8006540340417','','','','','','',0,5,NULL,0,1,9.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1231,'1231','8606003591037','','','','','','',0,5,'/catalog/imported-images/product-8606003591037.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1232,'1232','5202351200404','6923244506531','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1233,'1233','8606006864558','','','','','','',3,7,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1234,'1234','8606003592645','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1236,'1236','3800131573261','3800226801101','','','','','',2,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1237,'1237','6261686802010','301021','','','','','',3,7,'/catalog/imported-images/product-6261686802010.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1238,'1238','301022','','','','','','',3,7,'/catalog/imported-images/product-301022.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1239,'1239','301023','','','','','','',4,7,'/catalog/imported-images/product-301023.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1240,'1240','2090000186024','','','','','','',0,5,NULL,0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1241,'1241','2000000068961','','','','','','',0,5,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1242,'1242','6972530820011','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1243,'1243','3661075117535','','','','','','',2,7,'/catalog/imported-images/product-3661075117535.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1244,'1244','10402','','','','','','',1,7,NULL,0,1,14.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1245,'1245','10403','','','','','','',2,7,NULL,0,1,28.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1246,'1246','10405','','','','','','',2,7,NULL,0,1,34.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1247,'1247','539100','3800208726576','','','','','',0,5,NULL,0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1248,'1248','8692531002343','','','','','','',0,5,NULL,0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1249,'1249','8680853073066','','','','','','',0,5,NULL,0,1,14.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1250,'1250','8681422352506','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1251,'1251','539380','','','','','','',2,7,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1252,'1252','552070','','','','','','',0,5,'/catalog/imported-images/product-552070.jpg',0,1,7.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1253,'1253','8682887100176','','','','','','',2,7,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1254,'1254','8682887100220','','','','','','',1,7,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1255,'1255','553940','','','','','','',0,5,NULL,0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1256,'1256','536080','','','','','','',0,5,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1257,'1257','725140','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1258,'1258','550060','','','','','','',5,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1259,'1259','8699421201909','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1260,'1260','545930','8692414788746','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1261,'1261','8697405606566','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1262,'1262','111130','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1263,'1263','8697950733403','8697950733427','','','','','',2,7,'/catalog/imported-images/product-8697950733403.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1264,'1264','8680550324294','8680550251842','','','','','',0,5,NULL,0,1,36.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1265,'1265','8699375821987','','','','','','',1,7,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1266,'1266','8681317007252','','','','','','',0,5,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1267,'1267','2090009145978','','','','','','',0,5,NULL,0,1,54.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1268,'1268','2090009166546','222022','','','','','',0,5,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1269,'1269','2090009129114','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1270,'1270','6598421579525','','','','','','',1,7,NULL,0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1271,'1271','6598421589548','7954','','','','','',0,5,NULL,0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1272,'1272','6951245179584','7958','','','','','',3,7,NULL,0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1273,'1273','44329','2081737068462','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1274,'1274','8681982061412','','','','','','',2,7,NULL,0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1275,'1275','8681982060064','','','','','','',0,5,NULL,0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1276,'1276','8697410472354','','','','','','',5,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1277,'1277','8697512624422','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1278,'1278','8697512624439','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1279,'1279','3800202402094','','','','','','',6,7,'/catalog/imported-images/product-3800202402094.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,3,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1280,'1280','6135415484146','20795','','','','','',2,7,'/catalog/imported-images/product-6135415484146.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1281,'1281','3800208726521','','','','','','',0,5,'/catalog/imported-images/product-3800208726521.jpg',0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1282,'1282','8697633822882','2090009128575','','','','','',0,5,NULL,0,1,15.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1283,'1283','2090009138895','','','','','','',0,5,NULL,0,1,31.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1284,'1284','3800158114522','','','','','','',4,7,'/catalog/imported-images/product-3800158114522.jpg',0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1285,'1285','3800002310674','3800002311039','','','','','',0,5,'/catalog/imported-images/product-3800002306615.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1286,'1286','3800071501324','','','','','','',2,7,'/catalog/imported-images/product-3800071501324.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1287,'1287','3800144800514','','','','','','',4,7,'/catalog/imported-images/product-3800144800514.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1288,'1288','3800979625412','','','','','','',3,7,'/catalog/imported-images/product-3800979625412.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1289,'1289','3800024045271','3800024045257','','','','','',2,7,'/catalog/imported-images/product-3800024045271.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1290,'1290','3800002309838','3800002300170','','','','','',3,7,'/catalog/imported-images/product-3800002309838.jpg',0,1,1.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1291,'1291','3800222890475','','','','','','',8,7,'/catalog/imported-images/product-3800222890475.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1292,'1292','3800222890505','','','','','','',7,7,'/catalog/imported-images/product-3800222890505.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1293,'1293','3800024045295','3800024045318','','','','','',2,7,'/catalog/imported-images/product-3800024045295.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1294,'1294','3800002300521','3800002310469','','','','','',1,7,'/catalog/imported-images/product-3800002300521.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1295,'1295','3800002307810','','','','','','',1,7,'/catalog/imported-images/product-3800002307810.jpg',0,1,14.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1296,'1296','3800024045035','3800024045042','','','','','',0,5,'/catalog/imported-images/product-3800024045035.jpg',0,1,13.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1297,'1297','8055348992472','180911','','','','','',61,7,'/catalog/imported-images/product-8055348992472.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:05:00'),(1298,'1298','8055348990492','180910','','','','','',31,7,'/catalog/imported-images/product-8055348990492.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1299,'1299','8055348990331','181520','','','','','',105,7,'/catalog/imported-images/product-8055348990331.jpg',0,1,0.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1300,'1300','3800206206735','','','','','','',0,5,NULL,0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1301,'1301','3800206201419','','','','','','',0,5,NULL,0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1302,'1302','3800206207275','391107','','','','','',0,5,'/catalog/imported-images/product-3800206207275.jpg',0,1,5.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1303,'1303','3800206201075','390730','','','','','',2,7,'/catalog/imported-images/product-3800206201075.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1304,'1304','3800206202331','391266','','','','','',0,5,'/catalog/imported-images/product-3800206202331.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1305,'1305','3800206200351','20761','','','','','',4,7,'/catalog/imported-images/product-3800206200351.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1306,'1306','3800206206049','293639','','','','','',0,5,'/catalog/imported-images/product-3800206206049.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1307,'1307','3800206202355','3800206206032','','','','','',0,5,'/catalog/imported-images/product-3800206202355.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1308,'1308','3800206201945','3800206206025','','','','','',4,7,'/catalog/imported-images/product-3800206201945.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1309,'1309','3800206207282','','','','','','',2,7,'/catalog/imported-images/product-3800206207282.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1310,'1310','3800206208241','','','','','','',0,5,NULL,0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1311,'1311','3800206208289','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1312,'1312','650','','','','','','',2,7,NULL,0,1,9.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1313,'1313','610','','','','','','',4,7,'/catalog/imported-images/product-610.jpg',0,1,12.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1314,'1314','887930419474','','','','','','',2,7,NULL,0,1,28.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1315,'1315','6906683020868','','','','','','',2,7,'/catalog/imported-images/product-6906683020868.jpg',0,1,14.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1316,'1316','5994100031246','','','','','','',0,5,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1317,'1317','3803014300008','','','','','','',1,7,NULL,0,1,28.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1318,'1318','3803014500002','','','','','','',1,7,NULL,0,1,34.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1319,'1319','5994100092896','','','','','','',0,5,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1320,'1320','5994100092933','','','','','','',0,5,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1321,'1321','5994100092971','6923933821396','','','','','',6,7,'/catalog/imported-images/product-5994100092971.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1322,'1322','3800151754770','','','','','','',16,7,'/catalog/imported-images/product-3800151754770.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1323,'1323','3800151789765','','','','','','',1,7,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1324,'1324','8697410471715','','','','','','',0,5,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1326,'1326','70310','108','','','','','',0,5,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1327,'1327','124','','','','','','',5,7,'/catalog/imported-images/product-124.jpg',0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1328,'1328','1371','','','','','','',26,7,'/catalog/imported-images/product-1371.jpg',0,1,0.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1329,'1329','1372','','','','','','',14,7,'/catalog/imported-images/product-1372.jpg',0,1,0.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1330,'1330','1373','','','','','','',9,7,'/catalog/imported-images/product-1373.jpg',0,1,0.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1331,'1331','1374','','','','','','',13,7,'/catalog/imported-images/product-1374.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1332,'1332','1375','','','','','','',7,7,'/catalog/imported-images/product-1375.jpg',0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1333,'1333','1376','','','','','','',9,7,'/catalog/imported-images/product-1376.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1334,'1334','1377','','','','','','',3,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1335,'1335','8691857001115','','','','','','',0,5,NULL,0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1336,'1336','8691857001153','','','','','','',0,5,NULL,0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1337,'1337','4337182147176','4337182147060','','','','','',25,7,'/catalog/imported-images/product-4337182147176.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1338,'1338','4337182147169','4337182147053','','','','','',10,7,'/catalog/imported-images/product-4337182147169.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1339,'1339','4337182147152','4337182147046','','','','','',27,7,'/catalog/imported-images/product-4337182147152.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1340,'1340','4337182147190','4337182147084','','','','','',11,7,'/catalog/imported-images/product-4337182147190.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1341,'1341','3800131531117','','','','','','',0,5,NULL,0,1,25.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1342,'1342','3800131536990','','','','','','',0,5,NULL,0,1,21.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1343,'1343','8696287052072','','','','','','',3,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1344,'1344','10035218','','','','','','',0,5,'/catalog/imported-images/product-10035218.jpg',0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1345,'1345','10035219','','','','','','',2,7,'/catalog/imported-images/product-10035219.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1346,'1346','10035217','','','','','','',0,5,'/catalog/imported-images/product-10035217.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1347,'1347','10035216','','','','','','',1,7,'/catalog/imported-images/product-10035216.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1348,'1348','10035215','','','','','','',2,7,'/catalog/imported-images/product-10035215.jpg',0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1349,'1349','10035214','','','','','','',0,5,'/catalog/imported-images/product-10035214.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1350,'1350','6986936959633','6901234567892','','','','','',0,5,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1352,'1352','3800107362110','','','','','','',4,7,'/catalog/imported-images/product-3800107362110.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1353,'1353','3800151730439','','','','','','',5,7,'/catalog/imported-images/product-3800151730439.jpg',0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1354,'1354','3800144800460','','','','','','',2,7,'/catalog/imported-images/product-3800144800460.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1355,'1355','3800090303824','','','','','','',3,7,'/catalog/imported-images/product-3800090303824.jpg',0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1356,'1356','4895139231182','','','','','','',1,7,'/catalog/imported-images/product-4895139231182.jpg',0,1,49.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1357,'1357','4316090001000','','','','','','',0,5,NULL,0,1,35.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1358,'1358','4897011589497','','','','','','',0,5,'/catalog/imported-images/product-4897011589497.jpg',0,1,14.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1359,'1359','5908287240087','','','','','','',0,5,NULL,0,1,43.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1360,'1360','4897011581767','','','','','','',1,7,'/catalog/imported-images/product-4897011581767.jpg',0,1,8.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1361,'1361','8697465003183','','','','','','',1,7,NULL,0,1,20.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1362,'1362','8697465007143','','','','','','',0,5,NULL,0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1363,'1363','8697465009598','','','','','','',0,5,NULL,0,1,23.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1364,'1364','8697465007150','','','','','','',0,5,NULL,0,1,38.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1365,'1365','8697465007167','','','','','','',0,5,NULL,0,1,35.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1366,'1366','4895139241662','','','','','','',2,7,'/catalog/imported-images/product-4895139241662.jpg',0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1367,'1367','4895139241679','','','','','','',2,7,'/catalog/imported-images/product-4895139241679.jpg',0,1,24.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1368,'1368','4895139237917','','','','','','',0,5,'/catalog/imported-images/product-4895139237917.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1369,'1369','5908287275744','','','','','','',1,7,'/catalog/imported-images/product-5908287275744.jpg',0,1,64.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1370,'1370','4895139228212','','','','','','',0,5,NULL,0,1,12.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1371,'1371','8693135053151','','','','','','',1,7,NULL,0,1,21.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1372,'1372','75102','','','','','','',0,5,NULL,0,1,14.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1373,'1373','30908','','','','','','',10,7,'/catalog/imported-images/product-30908.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1375,'1375','2090000171877','','','','','','',1,7,NULL,0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1376,'1376','8696287160142','','','','','','',0,5,NULL,0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1377,'1377','8696287102005','','','','','','',2,7,'/catalog/imported-images/product-8696287102005.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1379,'1379','11059','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1380,'1380','2090000196672','','','','','','',12,7,'/catalog/imported-images/product-2090000196672.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1381,'1381','2090000196665','','','','','','',0,5,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1382,'1382','3800836113151','','','','','','',0,5,NULL,0,1,38.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1383,'1383','3800151740018','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1384,'1384','3800151739586','','','','','','',1,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1385,'1385','3800836146074','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1386,'1386','40064702198959','','','','','','',3,7,NULL,0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1387,'1387','10149029102839','','','','','','',0,5,NULL,0,1,11.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1388,'1388','20439392183149','','','','','','',2,7,'/catalog/imported-images/product-20439392183149.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1389,'1389','3014260287047','3014260427863','','','','','',10,7,'/catalog/imported-images/product-3014260287047.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1390,'1390','3800097701234','','','','','','',-2,5,'/catalog/imported-images/product-3800097701234.jpg',0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1391,'1391','3800038966944','','','','','','',3,7,'/catalog/imported-images/product-3800038966944.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1392,'1392','7891024132074','','','','','','',0,5,'/catalog/imported-images/product-7891024132074.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1393,'1393','3800500461533','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1394,'1394','3800069404859','3800069404866','','','','','',0,5,NULL,0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1395,'1395','7702018926879','3014260252144','','','','','',5,7,'/catalog/imported-images/product-7702018926879.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1396,'1396','7702018467372','','','','','','',2,7,'/catalog/imported-images/product-7702018467372.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1397,'1397','6951990908125','','','','','','',9,7,'/catalog/imported-images/product-6951990908125.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1398,'1398','3800163900455','3800163900479','','','','','',11,7,'/catalog/imported-images/product-3800163900455.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1399,'1399','10441','3800226801873','','','','','',6,7,'/catalog/imported-images/product-10441.jpg',0,1,22.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,20,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1400,'1400','30705','','','','','','',0,5,NULL,0,1,39.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1401,'1401','20691','','','','','','',4,7,'/catalog/imported-images/product-20691.jpg',0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1402,'1402','10458','3800226801897','','','','','',7,7,'/catalog/imported-images/product-10458.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1403,'1403','8606110850522','','','','','','',4,7,'/catalog/imported-images/product-8606110850522.jpg',0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1405,'1405','8606102287770','8606102287787','','','','','',0,5,NULL,0,1,6.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1407,'1407','532570','','','','','','',9,7,'/catalog/imported-images/product-532570.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1408,'1408','151230','','','','','','',2,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1409,'1409','5','','','','','','',10,7,'/catalog/imported-images/product-5.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1410,'1410','10','','','','','','',11,7,'/catalog/imported-images/product-10.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1411,'1411','25','','','','','','',16,7,'/catalog/imported-images/product-25.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1412,'1412','5903355000235','','','','','','',12,7,'/catalog/imported-images/product-5903355000235.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1413,'1413','680678302899','8693357303690','','','','','',1,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1414,'1414','5903355000563','','','','','','',8,7,'/catalog/imported-images/product-5903355000563.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1415,'1415','8693357002876','680678002874','','','','','',3,7,'/catalog/imported-images/product-8693357002876.jpg',0,1,26.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,2,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1416,'1416','3800220330232','','','','','','',9,7,'/catalog/imported-images/product-3800220330232.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1417,'1417','3800203774107','','','','','','',0,5,'/catalog/imported-images/product-3800203774107.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1418,'1418','43230','','','','','','',0,5,NULL,0,1,16.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1419,'1419','3800134822984','','','','','','',0,5,NULL,0,1,39.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1420,'1420','3800134831368','','','','','','',0,5,NULL,0,1,62.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1421,'1421','8000798095051','8000798000949','','','','','',0,5,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1422,'1422','20106','','','','','','',0,5,NULL,0,1,28.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1423,'1423','10530','','','','','','',0,5,NULL,0,1,13.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1424,'1424','10580','','','','','','',1,7,'/catalog/imported-images/product-10580.jpg',0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1425,'1425','22294','','','','','','',3,7,'/catalog/imported-images/product-22294.jpg',0,1,11.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1426,'1426','40961','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1427,'1427','41874','','','','','','',0,5,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1428,'1428','41871','','','','','','',1,7,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1429,'1429','41869','','','','','','',0,5,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1430,'1430','41367','','','','','','',0,5,NULL,0,1,5.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1431,'1431','41628','','','','','','',0,5,NULL,0,1,27.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1432,'1432','8681223003102','','','','','','',0,5,NULL,0,1,27.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1433,'1433','8681223002105','','','','','','',0,5,NULL,0,1,39.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1434,'1434','6016412771753','','','','','','',0,5,NULL,0,1,19.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1435,'1435','8694917000219','','','','','','',0,5,NULL,0,1,25.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1436,'1436','3800208727054','3800208727047','','','','','',1,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1437,'1437','3800208727733','','','','','','',1,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1438,'1438','43472','','','','','','',0,5,NULL,0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1439,'1439','60545','','','','','','',3,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1440,'1440','8697633824213','','','','','','',0,5,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1441,'1441','41226','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1442,'1442','8693135050853','','','','','','',1,7,NULL,0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1443,'1443','8694732008025','','','','','','',3,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1444,'1444','8681425070544','','','','','','',2,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1445,'1445','8693395003194','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1446,'1446','8682397002922','','','','','','',0,5,NULL,0,1,5.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1447,'1447','8697439141729','','','','','','',0,5,NULL,0,1,7.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1448,'1448','43274','','','','','','',3,7,'/catalog/imported-images/product-43274.jpg',0,1,19.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1449,'1449','8697633823735','','','','','','',3,7,'/catalog/imported-images/product-8697633823735.jpg',0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1450,'1450','8697633823728','','','','','','',3,7,'/catalog/imported-images/product-8697633823728.jpg',0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1451,'1451','8697633823711','','','','','','',4,7,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1452,'1452','8694917005023','20131','','','','','',0,5,NULL,0,1,1.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1453,'1453','8683229208079','8683229208062','','','','','',0,5,NULL,0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1454,'1454','8606003591723','','','','','','',0,5,NULL,0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1455,'1455','8695122004917','','','','','','',3,7,'/catalog/imported-images/product-8695122004917.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1456,'1456','8698885353018','42412','','','','','',2,7,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1457,'1457','43259','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1458,'1458','40155','71654','','','','','',3,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1459,'1459','3800226801378','3800226801361','','','','','',4,7,'/catalog/imported-images/product-3800226801378.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1460,'1460','6958523657468','','','','','','',1,7,'/catalog/imported-images/product-6958523657468.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1461,'1461','6973010390192','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1462,'1462','8680042225306','8699436219555','','','','','',2,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1463,'1463','41883','','','','','','',2,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1464,'1464','2018010182225','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1465,'1465','6900101688227','','','','','','',1,7,'/catalog/imported-images/product-6900101688227.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1466,'1466','3800226801149','3800131573872','','','','','',5,7,'/catalog/imported-images/product-3800226801149.jpg',0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1467,'1467','3800226801156','3800131573889','','','','','',3,7,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1468,'1468','10548','','','','','','',1,7,'/catalog/imported-images/product-10548.jpg',0,1,69.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1469,'1469','10546','','','','','','',0,5,NULL,0,1,54.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1470,'1470','10547','','','','','','',0,5,NULL,0,1,47.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1471,'1471','43736','','','','','','',4,7,'/catalog/imported-images/product-43736.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1472,'1472','21258','','','','','','',5,7,'/catalog/imported-images/product-21258.jpg',0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1473,'1473','6957951700586','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1474,'1474','40171','','','','','','',3,7,'/catalog/imported-images/product-40171.jpg',0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1475,'1475','21421','','','','','','',3,7,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1476,'1476','6938383203012','','','','','','',5,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1477,'1477','3800163902169','','','','','','',9,7,'/catalog/imported-images/product-3800163902169.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1478,'1478','21923','','','','','','',4,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1479,'1479','042515000168','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1480,'1480','41278','2090000174465','','','','','',8,7,'/catalog/imported-images/product-41278.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1481,'1481','6948223001050','','','','','','',5,7,'/catalog/imported-images/product-6948223001050.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1482,'1482','41798','','','','','','',0,5,NULL,0,1,16.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1483,'1483','44018','','','','','','',0,5,NULL,0,1,15.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1484,'1484','50749','','','','','','',2,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1485,'1485','42033','','','','','','',0,5,NULL,0,1,9.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1486,'1486','8699243464841','','','','','','',2,7,'/catalog/imported-images/product-8699243464841.jpg',0,1,11.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1488,'1488','8699243469570','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1489,'1489','5902814351369','','','','','','',2,7,NULL,0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1490,'1490','5906190102874','5902814359341','','','','','',12,7,NULL,0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1491,'1491','8693357208728','680678208283','','','','','',0,5,NULL,0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1492,'1492','5903355047070','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1493,'1493','5902814359358','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1494,'1494','5902814359365','','','','','','',5,7,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1495,'1495','5902814359372','','','','','','',5,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1496,'1496','4895139234091','4895139234107','','','','','',2,7,'/catalog/imported-images/product-4895139234091.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1497,'1497','4895139234114','4895139234121','','','','','',3,7,'/catalog/imported-images/product-4895139234114.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1498,'1498','4895139207316','','','','','','',2,7,'/catalog/imported-images/product-4895139207316.jpg',0,1,31.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1499,'1499','7290005426193','','','','','','',3,7,'/catalog/imported-images/product-7290005426193.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1500,'1500','7290004731564','','','','','','',2,7,'/catalog/imported-images/product-7290004731564.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1501,'1501','4895139209990','4895139210033','','','','','',2,7,'/catalog/imported-images/product-4895139209990.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1502,'1502','2000000095646','','','','','','',2,7,NULL,0,1,10.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1503,'1503','2000000080338','','','','','','',0,5,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1504,'1504','3800131525413','52275','','','','','',8,7,'/catalog/imported-images/product-3800131525413.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:06:00'),(1505,'1505','6942197351845','','','','','','',3,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1506,'1506','5903784077013','','','','','','',0,5,NULL,0,1,22.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1507,'1507','5903784077020','','','','','','',1,7,'/catalog/imported-images/product-5903784077020.jpg',0,1,25.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1508,'1508','5903784077037','','','','','','',0,5,NULL,0,1,28.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,3,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1509,'1509','4701904206012','','','','','','',0,5,NULL,0,1,19.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1510,'1510','4895139209877','','','','','','',2,7,'/catalog/imported-images/product-4895139209877.jpg',0,1,39.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1511,'1511','5000394077164','','','','','','',3,7,'/catalog/imported-images/product-5000394077164.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1512,'1512','5000394076952','','','','','','',2,7,'/catalog/imported-images/product-5000394076952.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1513,'1513','5994100091011','5994100043492','','','','','',4,7,'/catalog/imported-images/product-5994100091011.jpg',0,1,5.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1514,'1514','5903649056405','','','','','','',2,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1515,'1515','6421937060198','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1516,'1516','6421937070036','','','','','','',2,7,'/catalog/imported-images/product-6421937070036.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1517,'1517','6421937070203','','','','','','',3,7,'/catalog/imported-images/product-6421937070203.jpg',0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1518,'1518','6421937050069','','','','','','',13,7,'/catalog/imported-images/product-6421937050069.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1519,'1519','6421937090041','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1520,'1520','6421937050076','','','','','','',3,7,'/catalog/imported-images/product-6421937050076.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1521,'1521','6421937000255','','','','','','',3,7,'/catalog/imported-images/product-6421937000255.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1522,'1522','6421937000309','','','','','','',2,7,'/catalog/imported-images/product-6421937000309.jpg',0,1,8.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1523,'1523','6421937000033','','','','','','',3,7,'/catalog/imported-images/product-6421937000033.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1524,'1524','6421937000040','','','','','','',3,7,'/catalog/imported-images/product-6421937000040.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1525,'1525','6421937030146','','','','','','',4,7,'/catalog/imported-images/product-6421937030146.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1526,'1526','6421937031204','','','','','','',0,5,NULL,0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1527,'1527','6421937030078','','','','','','',0,5,NULL,0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1528,'1528','6421937000026','','','','','','',3,7,'/catalog/imported-images/product-6421937000026.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1529,'1529','6421937000231','','','','','','',0,5,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1530,'1530','6421937000200','','','','','','',5,7,'/catalog/imported-images/product-6421937000200.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1531,'1531','6421937000521','','','','','','',4,7,'/catalog/imported-images/product-6421937000521.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1532,'1532','6421937000514','','','','','','',8,7,'/catalog/imported-images/product-6421937000514.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1533,'1533','6421937000088','','','','','','',5,7,'/catalog/imported-images/product-6421937000088.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1534,'1534','6421937000132','','','','','','',2,7,'/catalog/imported-images/product-6421937000132.jpg',0,1,14.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1535,'1535','6421937000125','','','','','','',2,7,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1536,'1536','6421937000194','','','','','','',7,7,'/catalog/imported-images/product-6421937000194.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1537,'1537','6421937000057','','','','','','',5,7,'/catalog/imported-images/product-6421937000057.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1538,'1538','6421937000149','','','','','','',2,7,'/catalog/imported-images/product-6421937000149.jpg',0,1,19.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1539,'1539','6421937000156','','','','','','',1,7,'/catalog/imported-images/product-6421937000156.jpg',0,1,21.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1540,'1540','6421937000095','','','','','','',6,7,'/catalog/imported-images/product-6421937000095.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1541,'1541','6421937000101','','','','','','',7,7,'/catalog/imported-images/product-6421937000101.jpg',0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1542,'1542','6421937000118','','','','','','',4,7,'/catalog/imported-images/product-6421937000118.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1543,'1543','6421937010520','','','','','','',3,7,NULL,0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1544,'1544','6421937010414','','','','','','',4,7,'/catalog/imported-images/product-6421937010414.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1545,'1545','6421937010247','','','','','','',3,7,'/catalog/imported-images/product-6421937010247.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1546,'1546','6421937010216','','','','','','',5,7,'/catalog/imported-images/product-6421937010216.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1547,'1547','6421937010360','','','','','','',3,7,'/catalog/imported-images/product-6421937010360.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1548,'1548','6421937010223','','','','','','',3,7,'/catalog/imported-images/product-6421937010223.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1549,'1549','6421937010551','','','','','','',3,7,'/catalog/imported-images/product-6421937010551.jpg',0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1550,'1550','6421937010230','','','','','','',2,7,'/catalog/imported-images/product-6421937010230.jpg',0,1,12.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1551,'1551','6421937010186','','','','','','',1,7,'/catalog/imported-images/product-6421937010186.jpg',0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1552,'1552','6421937090027','','','','','','',0,5,'/catalog/imported-images/product-6421937090027.jpg',0,1,10.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1553,'1553','6421937090010','320345','','','','','',0,5,NULL,0,1,0.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1554,'1554','320347','','','','','','',1,7,'/catalog/imported-images/product-320347.jpg',0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1555,'1555','6421937060181','','','','','','',7,7,'/catalog/imported-images/product-6421937060181.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1556,'1556','6421937060624','','','','','','',6,7,'/catalog/imported-images/product-6421937060624.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1557,'1557','6421937070227','','','','','','',1,7,'/catalog/imported-images/product-6421937070227.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1558,'1558','6421937070234','','','','','','',1,7,'/catalog/imported-images/product-6421937070234.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1559,'1559','6421937070241','','','','','','',0,5,'/catalog/imported-images/product-6421937070241.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1560,'1560','6421937050052','','','','','','',0,5,NULL,0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1561,'1561','6421937030184','','','','','','',0,5,NULL,0,1,0.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1562,'1562','6421937030023','','','','','','',0,5,'/catalog/imported-images/product-6421937030023.jpg',0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1563,'1563','6421937030030','','','','','','',5,7,NULL,0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1564,'1564','70399','70398','','','','','',2,7,NULL,0,1,13.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1565,'1565','3800158118414','','','','','','',2,7,'/catalog/imported-images/product-3800158118414.jpg',0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1566,'1566','3800158118087','','','','','','',5,7,'/catalog/imported-images/product-3800158118087.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1567,'1567','812820021581','','','','','','',0,5,NULL,0,1,20.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1568,'1568','5944570021476','6422295001380','','','','','',0,5,NULL,0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1569,'1569','8001090473318','','','','','','',0,5,NULL,0,1,30.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1570,'1570','8002910061784','','','','','','',0,5,NULL,0,1,30.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1571,'1571','5060033821114','','','','','','',0,5,'/catalog/imported-images/product-5060033821114.jpg',0,1,10.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1572,'1572','4008455019017','','','','','','',1,7,'/catalog/imported-images/product-4008455019017.jpg',0,1,16.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1573,'1573','4008455076614','4008455076416','','','','','',3,7,'/catalog/imported-images/product-4008455076614.jpg',0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1574,'1574','8001280068010','8001280068027','','','','','',0,5,'/catalog/imported-images/product-8001280068010.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1576,'1576','3800034102032','3800218426503','','','','','',8,7,'/catalog/imported-images/product-3800034102032.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1577,'1577','3800034102018','','','','','','',11,7,'/catalog/imported-images/product-3800034102018.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1578,'1578','5903784070878','','','','','','',0,5,'/catalog/imported-images/product-5903784070878.jpg',0,1,52.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1579,'1579','8697465007112','','','','','','',0,5,NULL,0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1580,'1580','8697465000939','','','','','','',1,7,'/catalog/imported-images/product-8697465000939.jpg',0,1,17.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1581,'1581','7290005424700','','','','','','',0,5,'/catalog/imported-images/product-7290005424700.jpg',0,1,11.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1582,'1582','7290000286907','','','','','','',2,7,'/catalog/imported-images/product-7290000286907.jpg',0,1,11.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1583,'1583','3800500461021','','','','','','',4,7,'/catalog/imported-images/product-3800500461021.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1584,'1584','50531','','','','','','',3,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1585,'1585','8696287111076','62815','','','','','',0,5,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1587,'1587','3800153026899','','','','','','',4,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1588,'1588','2000000055909','','','','','','',0,5,'/catalog/imported-images/product-2000000055909.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1589,'1589','2090000147421','','','','','','',1,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1590,'1590','8699401094231','54287','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1591,'1591','2090000184402','22366','','','','','',3,7,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1592,'1592','8697413710019','','','','','','',4,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1593,'1593','8697413710026','','','','','','',3,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1594,'1594','22096','','','','','','',0,5,NULL,0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1595,'1595','2090000197426','54036','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1596,'1596','8606006460620','70102','','','','','',1,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1597,'1597','8606009780152','','','','','','',2,7,NULL,0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1598,'1598','2090000200010','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1599,'1599','95558','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1600,'1600','95559','','','','','','',1,7,'/catalog/imported-images/product-95559.jpg',0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1601,'1601','8697425883596','','','','','','',0,5,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1602,'1602','2090000180886','','','','','','',0,5,NULL,0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1603,'1603','2000000097046','','','','','','',2,7,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1604,'1604','6948130508086','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1605,'1605','2000000057644','10906','','','','','',5,7,'/catalog/imported-images/product-2000000057644.jpg',0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1606,'1606','8697409840447','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1607,'1607','2090000188448','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1608,'1608','2090000149814','2090000149821','','','','','',2,7,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1609,'1609','5906927470023','5906927470016','','','','','',2,7,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1610,'1610','5906927348308','5906927490007','','','','','',3,7,NULL,0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1611,'1611','3800167602256','','','','','','',0,5,NULL,0,1,21.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1612,'1612','4895139228632','','','','','','',0,5,NULL,0,1,18.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1613,'1613','4895139236767','','','','','','',0,5,NULL,0,1,11.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1614,'1614','5902666613301','','','','','','',0,5,'/catalog/imported-images/product-5902666613301.jpg',0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1615,'1615','5994100083122','','','','','','',0,5,NULL,0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1616,'1616','5994100030911','','','','','','',0,5,NULL,0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1617,'1617','6923933821433','','','','','','',4,7,'/catalog/imported-images/product-6923933821433.jpg',0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1618,'1618','8606003591693','','','','','','',3,7,NULL,0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1619,'1619','6962668652127','2000000090238','','','','','',7,7,'/catalog/imported-images/product-6962668652127.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1620,'1620','2000000082639','','','','','','',2,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1621,'1621','8606003594892','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1623,'1623','4833008410368','4833008410313','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1624,'1624','8682416565605','','','','','','',1,7,NULL,0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1625,'1625','8683143870338','5350151766429','','','','','',7,7,NULL,0,1,2.4900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1626,'1626','212550','','','','','','',3,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1627,'1627','8683666100394','','','','','','',0,5,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1628,'1628','8683143870208','','','','','','',1,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1629,'1629','8698532510580','','','','','','',0,5,NULL,0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1630,'1630','8681873430013','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1631,'1631','8681873430051','','','','','','',3,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1632,'1632','8681909005208','549500','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1633,'1633','538020','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1634,'1634','8681909005024','538000','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1635,'1635','8681909005055','325320','','','','','',4,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1636,'1636','7702018024612','3014260246693','','','','','',5,7,'/catalog/imported-images/product-7702018024612.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1637,'1637','6001067157182','6001067004943','','','','','',4,7,'/catalog/imported-images/product-6001067157182.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1638,'1638','40225','','','','','','',0,5,NULL,0,1,32.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1639,'1639','2090000165982','','','','','','',0,5,NULL,0,1,14.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1640,'1640','2090000149166','','','','','','',0,5,NULL,0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1641,'1641','2000000083636','','','','','','',2,7,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1642,'1642','4008717501205','','','','','','',0,5,'/catalog/imported-images/product-4008717501205.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1643,'1643','8699621630325','','','','','','',3,7,'/catalog/imported-images/product-8699621630325.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1644,'1644','3800090303831','','','','','','',9,7,'/catalog/imported-images/product-3800090303831.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1645,'1645','42682','','','','','','',-1,5,NULL,0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1646,'1646','8680853073653','8699947921879','','','','','',0,5,NULL,0,1,12.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1647,'1647','8680853073660','8699947921886','','','','','',1,7,NULL,0,1,18.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1648,'1648','8680853073677','8699947921893','','','','','',1,7,NULL,0,1,25.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1649,'1649','8681198060162','21932','','','','','',2,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1651,'1651','3800163900752','','','','','','',5,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1652,'1652','3800163900745','','','','','','',14,7,'/catalog/imported-images/product-3800163900745.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1653,'1653','4895139228984','','','','','','',0,5,NULL,0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1654,'1654','8680731412482','','','','','','',0,5,NULL,0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1655,'1655','8693357009158','680678009156','','','','','',4,7,'/catalog/imported-images/product-8693357009158.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1656,'1656','8693357036659','44995','','','','','',14,7,'/catalog/imported-images/product-8693357036659.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1657,'1657','51068','','','','','','',4,7,'/catalog/imported-images/product-51068.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1658,'1658','8693357090460','41016','','','','','',0,5,NULL,0,1,20.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1659,'1659','680678111774','8693357111776','','','','','',3,7,'/catalog/imported-images/product-680678111774.jpg',0,1,17.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1660,'1660','600681','','','','','','',8,7,'/catalog/imported-images/product-600681.jpg',0,1,16.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1661,'1661','03050','','','','','','',0,5,NULL,0,1,15.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1662,'1662','04020','','','','','','',0,5,NULL,0,1,15.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1663,'1663','08040','','','','','','',0,5,NULL,0,1,15.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1664,'1664','600630','','','','','','',7,7,'/catalog/imported-images/product-600630.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1665,'1665','06080','','','','','','',7,7,'/catalog/imported-images/product-06080.jpg',0,1,10.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1666,'1666','06679','20000271','','','','','',17,7,'/catalog/imported-images/product-06679.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1667,'1667','8606003591839','','','','','','',6,7,'/catalog/imported-images/product-8606003591839.jpg',0,1,23.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1668,'1668','8606003592928','','','','','','',3,7,NULL,0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1669,'1669','8606003591464','','','','','','',29,7,'/catalog/imported-images/product-8606003591464.jpg',0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1670,'1670','8606003591471','','','','','','',0,5,'/catalog/imported-images/product-8606003591471.jpg',0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1671,'1671','8606003591488','','','','','','',2,7,'/catalog/imported-images/product-8606003591488.jpg',0,1,7.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1672,'1672','8606003591457','','','','','','',15,7,'/catalog/imported-images/product-8606003591457.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1673,'1673','8606003591440','','','','','','',16,7,'/catalog/imported-images/product-8606003591440.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1675,'1675','8606003591433','','','','','','',13,7,'/catalog/imported-images/product-8606003591433.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1676,'1676','8606003593925','','','','','','',4,7,NULL,0,1,9.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1677,'1677','8606003594373','','','','','','',6,7,NULL,0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1678,'1678','8606003592935','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1679,'1679','8606003591006','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1680,'1680','8606003590993','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1681,'1681','8606003590986','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1682,'1682','8606003591389','','','','','','',0,5,'/catalog/imported-images/product-8606003591389.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1683,'1683','8606003591198','','','','','','',0,5,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1684,'1684','8606003592881','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1685,'1685','8606011405791','','','','','','',1,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1686,'1686','8606003594281','','','','','','',0,5,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1687,'1687','8606003594274','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1688,'1688','8606006864879','','','','','','',4,7,'/catalog/imported-images/product-8606006864879.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1689,'1689','8606003594939','','','','','','',0,5,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1690,'1690','8112','','','','','','',2,7,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1691,'1691','8606003591501','','','','','','',6,7,'/catalog/imported-images/product-8606003591501.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1692,'1692','8606003592119','','','','','','',7,7,'/catalog/imported-images/product-8606003592119.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1693,'1693','8606003591778','','','','','','',8,7,'/catalog/imported-images/product-8606003591778.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1694,'1694','8606003594557','','','','','','',0,5,NULL,0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1695,'1695','8606003593093','','','','','','',1,7,'/catalog/imported-images/product-8606003593093.jpg',0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1696,'1696','8606003593086','','','','','','',4,7,NULL,0,1,16.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1697,'1697','8606006862363','','','','','','',4,7,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1698,'1698','3040092716004','','','','','','',3,7,NULL,0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1699,'1699','8606003592904','','','','','','',0,5,'/catalog/imported-images/product-8606003592904.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1700,'1700','8682472140389','','','','','','',1,7,NULL,0,1,38.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1701,'1701','5945420003062','','','','','','',0,5,NULL,0,1,16.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1702,'1702','5945420001259','','','','','','',0,5,NULL,0,1,18.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1703,'1703','5945420003079','','','','','','',0,5,NULL,0,1,23.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1704,'1704','5945420002577','','','','','','',0,5,NULL,0,1,25.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1705,'1705','5945420000207','','','','','','',0,5,NULL,0,1,26.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1706,'1706','5945420002584','','','','','','',0,5,NULL,0,1,29.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1707,'1707','5779','5997','','','','','',0,5,NULL,0,1,7.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1708,'1708','8606003591082','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1709,'1709','4113','','','','','','',0,5,NULL,0,1,13.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1710,'1710','1178','','','','','','',0,5,NULL,0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1711,'1711','4878','','','','','','',3,7,'/catalog/imported-images/product-4878.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1712,'1712','8699947920162','','','','','','',1,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1713,'1713','8606006860765','60102','','','','','',5,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1714,'1714','3986','','','','','','',11,7,'/catalog/imported-images/product-3986.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1715,'1715','8699316932758','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1716,'1716','8606003594724','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1717,'1717','8681982235455','2090000178494','','','','','',6,7,NULL,0,1,10.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1718,'1718','8697633820079','','','','','','',0,5,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1719,'1719','8606003592898','','','','','','',0,5,'/catalog/imported-images/product-8606003592898.jpg',0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1720,'1720','8606003591235','3911','','','','','',1,7,'/catalog/imported-images/product-8606003591235.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1721,'1721','3912','','','','','','',0,5,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1722,'1722','3913','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1723,'1723','8606003594670','','','','','','',0,5,NULL,0,1,3.4900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1724,'1724','8606006864190','','','','','','',0,5,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1725,'1725','8606003592447','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1726,'1726','8606006861090','','','','','','',0,5,NULL,0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1727,'1727','8606006861045','','','','','','',0,5,NULL,0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1728,'1728','5319909610131','','','','','','',9,7,'/catalog/imported-images/product-5319909610131.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1729,'1729','8600101745224','8600101745217','','','','','',15,7,'/catalog/imported-images/product-8600101745224.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1730,'1730','4895139210286','','','','','','',3,7,'/catalog/imported-images/product-4895139210286.jpg',0,1,18.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1731,'1731','2090000178234','','','','','','',1,7,NULL,0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1732,'1732','2000000075297','','','','','','',2,7,NULL,0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1733,'1733','2000000094267','','','','','','',0,5,NULL,0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1734,'1734','8699863050028','10360','','','','','',8,7,'/catalog/imported-images/product-8699863050028.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1735,'1735','4823052319717','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1736,'1736','2090000166583','','','','','','',2,7,NULL,0,1,11.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1737,'1737','2000000078298','71231','','','','','',2,7,NULL,0,1,11.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1738,'1738','51652','','','','','','',1,7,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1739,'1739','51651','','','','','','',1,7,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1740,'1740','8004120909498','8004120040948','','','','','',0,5,'/catalog/imported-images/product-8004120909498.jpg',0,1,8.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1741,'1741','8001841496498','','','','','','',0,5,NULL,0,1,32.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1742,'1742','8690973369284','','','','','','',2,7,'/catalog/imported-images/product-8690973369284.jpg',0,1,6.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1743,'1743','5201395011830','','','','','','',0,5,NULL,0,1,11.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1744,'1744','8008970008783','8008970005591','','','','','',0,5,'/catalog/imported-images/product-8008970005591.jpg',0,1,10.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1745,'1745','8008970054049','','','','','','',0,5,NULL,0,1,17.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1746,'1746','4895139241976','','','','','','',0,5,NULL,0,1,14.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,2,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1747,'1747','4701804114226','','','','','','',0,5,NULL,0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1748,'1748','4701905035246','','','','','','',0,5,NULL,0,1,23.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1749,'1749','8697853093659','','','','','','',1,7,NULL,0,1,19.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1750,'1750','3800131598394','','','','','','',0,5,NULL,0,1,13.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1751,'1751','8697410470374','','','','','','',0,5,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1752,'1752','2090000171013','','','','','','',1,7,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1753,'1753','6980489211323','','','','','','',1,7,NULL,0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1754,'1754','3800134840940','','','','','','',3,7,'/catalog/imported-images/product-3800134840940.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1755,'1755','21678','','','','','','',2,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1757,'1757','60295438173129','40295439173129','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1758,'1758','20159522191979','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1759,'1759','30213552232419','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1760,'1760','7290010935437','','','','','','',-1,5,'/catalog/imported-images/product-7290010935437.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1761,'1761','7290010935420','7290010935512','','','','','',6,7,'/catalog/imported-images/product-7290010935420.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1762,'1762','8001090701824','','','','','','',0,5,NULL,0,1,24.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1763,'1763','3800090303800','','','','','','',0,5,NULL,0,1,11.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1764,'1764','3801003000830','','','','','','',2,7,'/catalog/imported-images/product-3801003000830.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1765,'1765','4895139241969','','','','','','',1,7,'/catalog/imported-images/product-4895139241969.jpg',0,1,10.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1766,'1766','4895139242935','2400000000099','','','','','',0,5,NULL,0,1,28.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1767,'1767','6923933821334','','','','','','',4,7,'/catalog/imported-images/product-6923933821334.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1768,'1768','5994100112938','','','','','','',0,5,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1770,'1770','3800217592094','','','','','','',3,7,'/catalog/imported-images/product-3800217592094.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1771,'1771','3800217594128','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1772,'1772','3800217594210','','','','','','',0,5,NULL,0,1,2.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1773,'1773','3800217594159','','','','','','',0,5,NULL,0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1774,'1774','8006540412688','','','','','','',1,7,'/catalog/imported-images/product-8006540412688.jpg',0,1,14.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1775,'1775','8001090691989','','','','','','',0,5,'/catalog/imported-images/product-8001090691989.jpg',0,1,20.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1776,'1776','8719497839414','','','','','','',9,7,'/catalog/imported-images/product-8719497839414.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1777,'1777','8719497839438','','','','','','',7,7,'/catalog/imported-images/product-8719497839438.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1778,'1778','5900627090215','','','','','','',0,5,NULL,0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1779,'1779','8718692410466','','','','','','',0,5,NULL,0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1780,'1780','8712561804615','','','','','','',0,5,'/catalog/imported-images/product-8712561804615.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1781,'1781','8001090902238','8001090902276','','','','','',0,5,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1782,'1782','90005657','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1783,'1783','8008970010366','8008970005621','','','','','',0,5,'/catalog/imported-images/product-8008970039190.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1784,'1784','8594002683023','','','','','','',3,7,'/catalog/imported-images/product-8594002683023.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1785,'1785','8001090747723','','','','','','',0,5,'/catalog/imported-images/product-8001090747723.jpg',0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1786,'1786','3800216970237','','','','','','',0,5,NULL,0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1787,'1787','3014260228743','','','','','','',0,5,'/catalog/imported-images/product-3014260228743.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1788,'1788','5201314064916','5201314051657','','','','','',3,7,'/catalog/imported-images/product-5201314064916.jpg',0,1,2.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1789,'1789','5900627061390','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1790,'1790','3800226750010','','','','','','',0,5,NULL,0,1,2.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1791,'1791','4005808363698','','','','','','',0,5,'/catalog/imported-images/product-4005808363698.jpg',0,1,13.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1792,'1792','4005808362349','','','','','','',2,7,'/catalog/imported-images/product-4005808362349.jpg',0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1793,'1793','7702018404551','','','','','','',0,5,'/catalog/imported-images/product-7702018404551.jpg',0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1794,'1794','8720701034624','','','','','','',3,7,'/catalog/imported-images/product-8720701034624.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1795,'1795','5701092114433','','','','','','',0,5,'/catalog/imported-images/product-5701092114433.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1796,'1796','5201314932031','','','','','','',4,7,'/catalog/imported-images/product-5201314932031.jpg',0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1797,'1797','5201314578031','','','','','','',2,7,'/catalog/imported-images/product-5201314578031.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1798,'1798','5201314579038','','','','','','',6,7,'/catalog/imported-images/product-5201314579038.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1799,'1799','5201314580034','','','','','','',5,7,'/catalog/imported-images/product-5201314580034.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1800,'1800','70436','','','','','','',3,7,NULL,0,1,14.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1802,'1802','70437','','','','','','',4,7,NULL,0,1,16.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1803,'1803','70439','','','','','','',2,7,NULL,0,1,20.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1804,'1804','70446','','','','','','',2,7,NULL,0,1,20.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1805,'1805','70452','','','','','','',0,5,NULL,0,1,23.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1806,'1806','70438','','','','','','',5,7,NULL,0,1,18.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1807,'1807','70449','','','','','','',4,7,NULL,0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1808,'1808','70450','','','','','','',4,7,NULL,0,1,17.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1809,'1809','70471','','','','','','',3,7,NULL,0,1,17.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1810,'1810','70472','','','','','','',2,7,NULL,0,1,22.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1811,'1811','70469','','','','','','',0,5,NULL,0,1,16.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1812,'1812','3086125705416','','','','','','',2,7,'/catalog/imported-images/product-3086125705416.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:08:00'),(1814,'1814','8681909000050','','','','','','',2,7,'/catalog/imported-images/product-8681909000050.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1815,'1815','8683020901049','561320','','','','','',3,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1816,'1816','8683020901025','561340','','','','','',1,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1817,'1817','561350','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1818,'1818','8683666100387','','','','','','',2,7,'/catalog/imported-images/product-8683666100387.jpg',0,1,9.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1819,'1819','3800134816655','41198','','','','','',0,5,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1820,'1820','3800134811841','','','','','','',3,7,'/catalog/imported-images/product-3800134811841.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1821,'1821','8008260001494','','','','','','',0,5,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1822,'1822','5900935001514','','','','','','',0,5,NULL,0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1823,'1823','8001090772497','','','','','','',0,5,NULL,0,1,12.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1824,'1824','8001090494641','8001090493996','','','','','',0,5,NULL,0,1,9.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1825,'1825','8001841658773','','','','','','',0,5,NULL,0,1,11.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1826,'1826','2090000182552','21969','','','','','',4,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1827,'1827','2090000200041','54376','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1828,'1828','2090000183054','22246','','','','','',2,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1829,'1829','3800134840919','','','','','','',1,7,'/catalog/imported-images/product-3800134840919.jpg',0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1830,'1830','2000000078601','','','','','','',0,5,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1831,'1831','2000000079738','','','','','','',2,7,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1832,'1832','2090000200355','','','','','','',4,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1833,'1833','2090000180879','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1834,'1834','2000000056050','','','','','','',2,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1835,'1835','2000000070018','','','','','','',8,7,'/catalog/imported-images/product-2000000070018.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1836,'1836','2090000193008','','','','','','',3,7,NULL,0,1,13.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1837,'1837','2090000177688','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1838,'1838','2090000196184','53833','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1839,'1839','2090000147506','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1840,'1840','2000000081571','','','','','','',4,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1841,'1841','8696287304737','53703','','','','','',0,5,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1842,'1842','304731','537031','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1843,'1843','304732','537032','','','','','',1,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1844,'1844','8696287305512','30551','','','','','',2,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1845,'1845','305511','','','','','','',0,5,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1846,'1846','305512','','','','','','',0,5,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1847,'1847','8696287305611','30561','','','','','',5,7,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1848,'1848','305611','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1849,'1849','305612','','','','','','',0,5,NULL,0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1850,'1850','8696287304638','30463','','','','','',0,5,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1852,'1852','304631','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1853,'1853','304632','','','','','','',0,5,NULL,0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1854,'1854','8432583620399','','','','','','',3,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1855,'1855','2090000192629','','','','','','',0,5,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1856,'1856','54474','','','','','','',0,5,'/catalog/imported-images/product-54474.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1857,'1857','2090000195613','','','','','','',5,7,NULL,0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1858,'1858','53064','','','','','','',1,7,NULL,0,1,0.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1859,'1859','2090000195774','','','','','','',0,5,NULL,0,1,0.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1860,'1860','2090000168877','2090000168860','','','','','',0,5,NULL,0,1,1.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1861,'1861','2090000196719','53959','','','','','',0,5,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1862,'1862','2090000188523','11117','','','','','',5,7,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1863,'1863','2090000186154','22427','','','','','',13,7,'/catalog/imported-images/product-2090000186154.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1864,'1864','8680518406390','','','','','','',2,7,'/catalog/imported-images/product-8680518406390.jpg',0,1,15.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1865,'1865','6920354824845','','','','','','',0,5,'/catalog/imported-images/product-6920354824845.jpg',0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1866,'1866','8691297101024','','','','','','',0,5,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1867,'1867','8691297101093','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1868,'1868','4895139210408','','','','','','',0,5,'/catalog/imported-images/product-4895139210408.jpg',0,1,27.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1869,'1869','4895139239195','','','','','','',0,5,NULL,0,1,52.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1870,'1870','4895139243406','','','','','','',2,7,'/catalog/imported-images/product-4895139243406.jpg',0,1,59.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1871,'1871','40663','','','','','','',1,7,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1872,'1872','2000000090955','','','','','','',1,7,NULL,0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1873,'1873','2000000097695','','','','','','',3,7,NULL,0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1874,'1874','8696287303020','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1875,'1875','72585','','','','','','',1,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1876,'1876','2000000068916','40631','','','','','',5,7,'/catalog/imported-images/product-2000000068916.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1877,'1877','8696643109211','','','','','','',4,7,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1879,'1879','8699401090509','','','','','','',2,7,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1880,'1880','70420','72330','','','','','',48,7,'/catalog/imported-images/product-70420.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1881,'1881','8712561884068','','','','','','',0,5,'/catalog/imported-images/product-8712561884068.jpg',0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1882,'1882','442019','','','','','','',0,5,'/catalog/imported-images/product-442019.jpg',0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1883,'1883','7702018504138','','','','','','',0,5,NULL,0,1,36.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1884,'1884','8008970051796','8008970039138','','','','','',0,5,NULL,0,1,19.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1885,'1885','4012400501656','','','','','','',3,7,'/catalog/imported-images/product-4012400501656.jpg',0,1,10.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1886,'1886','5900627069273','','','','','','',0,5,NULL,0,1,39.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1887,'1887','5201314999935','','','','','','',2,7,'/catalog/imported-images/product-5201314999935.jpg',0,1,1.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1888,'1888','5201314932024','','','','','','',3,7,'/catalog/imported-images/product-5201314932024.jpg',0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1889,'1889','5201314932048','','','','','','',1,7,'/catalog/imported-images/product-5201314932048.jpg',0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1890,'1890','5201314413943','','','','','','',3,7,'/catalog/imported-images/product-5201314413943.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1891,'1891','5452003860320','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1892,'1892','8718114614250','','','','','','',0,5,'/catalog/imported-images/product-8718114614250.jpg',0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1893,'1893','8001280030840','','','','','','',0,5,NULL,0,1,11.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1894,'1894','6982109602863','','','','','','',10,7,'/catalog/imported-images/product-6982109602863.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1895,'1895','12430','','','','','','',0,5,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1896,'1896','12411','','','','','','',1,7,'/catalog/imported-images/product-12411.jpg',0,1,4.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1897,'1897','3800097700800','','','','','','',3,7,'/catalog/imported-images/product-3800097700800.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1898,'1898','6949900660362','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1899,'1899','6951906100032','','','','','','',4,7,'/catalog/imported-images/product-6951906100032.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1900,'1900','21051','','','','','','',10,7,'/catalog/imported-images/product-21051.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1901,'1901','20934','','','','','','',3,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1902,'1902','20936','','','','','','',4,7,NULL,0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1903,'1903','8693135041806','','','','','','',6,7,'/catalog/imported-images/product-8693135041806.jpg',0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1904,'1904','8697409840676','','','','','','',2,7,'/catalog/imported-images/product-8697409840676.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1905,'1905','8004360023107','','','','','','',1,7,NULL,0,1,12.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1906,'1906','8004360023114','','','','','','',1,7,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1907,'1907','21298','','','','','','',15,7,'/catalog/imported-images/product-21298.jpg',0,1,4.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1908,'1908','7638900083071','','','','','','',2,7,'/catalog/imported-images/product-7638900083071.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1909,'1909','7638900083088','','','','','','',3,7,NULL,0,1,3.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1910,'1910','8017079004244','','','','','','',1,7,'/catalog/imported-images/product-8017079004244.jpg',0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1911,'1911','3800002302679','3800002302662','','','','','',1,7,'/catalog/imported-images/product-3800002302679.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1912,'1912','5201314995838','','','','','','',0,5,NULL,0,1,30.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1913,'1913','3141360050001','','','','','','',2,7,'/catalog/imported-images/product-3141360050001.jpg',0,1,11.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1914,'1914','8001090554161','','','','','','',0,5,'/catalog/imported-images/product-8001090554161.jpg',0,1,14.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1915,'1915','8718924878996','','','','','','',0,5,NULL,0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1916,'1916','8015194522513','','','','','','',7,7,'/catalog/imported-images/product-8015194522513.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1917,'1917','5999109580603','','','','','','',0,5,NULL,0,1,16.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1918,'1918','8697950365055','','','','','','',0,5,NULL,0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1919,'1919','536170','','','','','','',0,5,NULL,0,1,59.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1920,'1920','8691857001399','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1921,'1921','8697422303370','','','','','','',2,7,NULL,0,1,26.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1922,'1922','8682655101213','','','','','','',0,5,NULL,0,1,10.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1923,'1923','8691857001382','','','','','','',1,7,'/catalog/imported-images/product-8691857001382.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1924,'1924','535340','','','','','','',2,7,'/catalog/imported-images/product-535340.jpg',0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1925,'1925','8683666100417','','','','','','',0,5,NULL,0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1926,'1926','8697512622367','6928685822691','','','','','',6,7,'/catalog/imported-images/product-8697512622367.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1927,'1927','8681734168420','','','','','','',1,7,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1928,'1928','8692531005504','','','','','','',0,5,NULL,0,1,5.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1929,'1929','560440','','','','','','',0,5,NULL,0,1,21.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1930,'1930','560441','','','','','','',0,5,NULL,0,1,23.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1931,'1931','560442','','','','','','',0,5,NULL,0,1,24.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1932,'1932','560443','','','','','','',0,5,NULL,0,1,27.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1934,'1934','2090000156577','56577','','','','','',5,7,'/catalog/imported-images/product-2090000156577.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1935,'1935','4823052319687','4823052319694','','','','','',4,7,NULL,0,1,13.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1936,'1936','52925','','','','','','',2,7,'/catalog/imported-images/product-52925.jpg',0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1937,'1937','2090000185959','','','','','','',3,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1938,'1938','2000000053523','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1939,'1939','54269','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1940,'1940','8680972432638','54271','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1941,'1941','3800131581716','','','','','','',3,7,'/catalog/imported-images/product-3800131581716.jpg',0,1,9.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1942,'1942','2090000200317','','','','','','',3,7,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1943,'1943','2090000175110','','','','','','',0,5,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1945,'1945','54870','','','','','','',2,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1946,'1946','3800134808797','2000000082493','','','','','',0,5,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1947,'1947','54444','','','','','','',2,7,'/catalog/imported-images/product-54444.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1948,'1948','2090000199017','','','','','','',4,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1949,'1949','2090000150346','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1951,'1951','8694064015166','','','','','','',2,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1952,'1952','6512345673022','','','','','','',1,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1954,'1954','5202781022805','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1955,'1955','50253','','','','','','',1,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1956,'1956','8696033215140','8696033215126','','','','','',10,7,'/catalog/imported-images/product-8696033215140.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1957,'1957','8696033383214','8696033371853','','','','','',4,7,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1958,'1958','4895139207323','','','','','','',0,5,'/catalog/imported-images/product-4895139207323.jpg',0,1,32.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1959,'1959','4895139207224','','','','','','',0,5,NULL,0,1,38.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1960,'1960','20817','','','','','','',0,5,NULL,0,1,35.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1961,'1961','2090000177978','','','','','','',3,7,'/catalog/imported-images/product-2090000177978.jpg',0,1,11.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1962,'1962','71782','','','','','','',2,7,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1963,'1963','4690228004087','','','','','','',4,7,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1964,'1964','5319909610827','3800217594418','','','','','',5,7,'/catalog/imported-images/product-5319909610827.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1965,'1965','8693357000162','','','','','','',1,7,'/catalog/imported-images/product-8693357000162.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1966,'1966','8695122002005','','','','','','',1,7,'/catalog/imported-images/product-8695122002005.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1967,'1967','8695122002081','','','','','','',1,7,'/catalog/imported-images/product-8695122002081.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1968,'1968','8699243460201','','','','','','',3,7,'/catalog/imported-images/product-8699243460201.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,3,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1969,'1969','5903355070603','','','','','','',0,5,'/catalog/imported-images/product-5903355070603.jpg',0,1,19.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1970,'1970','8007413733497','','','','','','',4,7,'/catalog/imported-images/product-8007413733497.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1971,'1971','8007413719392','','','','','','',3,7,'/catalog/imported-images/product-8007413719392.jpg',0,1,7.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1972,'1972','44469','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1973,'1973','20527','','','','','','',1,7,'/catalog/imported-images/product-20527.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1974,'1974','40162','','','','','','',5,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1975,'1975','43717','','','','','','',7,7,'/catalog/imported-images/product-43717.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1976,'1976','5430003244043','','','','','','',1,7,'/catalog/imported-images/product-5430003244043.jpg',0,1,59.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1977,'1977','5430003244036','','','','','','',0,5,NULL,0,1,61.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1978,'1978','8682572003355','','','','','','',1,7,NULL,0,1,14.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1979,'1979','8682572000040','','','','','','',1,7,NULL,0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1980,'1980','30461','','','','','','',0,5,NULL,0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1981,'1981','44265','','','','','','',0,5,NULL,0,1,20.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1982,'1982','3800134811902','','','','','','',2,7,'/catalog/imported-images/product-3800134811902.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1984,'1984','3800134811889','','','','','','',3,7,'/catalog/imported-images/product-3800134811889.jpg',0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1985,'1985','3800134811865','','','','','','',5,7,'/catalog/imported-images/product-3800134811865.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1986,'1986','8682665330153','','','','','','',2,7,'/catalog/imported-images/product-8682665330153.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1987,'1987','8680853078795','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1988,'1988','8682397003226','','','','','','',0,5,NULL,0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1989,'1989','8682397003202','','','','','','',0,5,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1990,'1990','8699080152239','','','','','','',0,5,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1991,'1991','8697456761542','','','','','','',1,7,NULL,0,1,10.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1992,'1992','8698734214026','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1993,'1993','44224','','','','','','',0,5,NULL,0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1994,'1994','6392770582690','','','','','','',1,7,NULL,0,1,7.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1996,'1996','8683771270074','','','','','','',3,7,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1997,'1997','8682397002946','','','','','','',2,7,NULL,0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1998,'1998','8680530191236','8694563698617','','','','','',1,7,NULL,0,1,8.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(1999,'1999','41803','','','','','','',2,7,NULL,0,1,16.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2000,'2000','42180','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2001,'2001','42363','','','','','','',10,7,NULL,0,1,9.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2002,'2002','42012','','','','','','',0,5,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2003,'2003','43122','','','','','','',0,5,NULL,0,1,8.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2004,'2004','44540','6940928800051','','','','','',3,7,'/catalog/imported-images/product-44540.jpg',0,1,9.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2005,'2005','21260','','','','','','',3,7,'/catalog/imported-images/product-21260.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2006,'2006','212258','','','','','','',3,7,'/catalog/imported-images/product-212258.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2007,'2007','41261','','','','','','',2,7,'/catalog/imported-images/product-41261.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2008,'2008','3800144802730','','','','','','',0,5,NULL,0,1,2.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2009,'2009','3800134829358','','','','','','',0,5,NULL,0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2011,'2011','8697410472408','','','','','','',2,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2012,'2012','8682013108816','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2013,'2013','41917','35684','','','','','',1,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2014,'2014','44289','','','','','','',4,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2015,'2015','42329','','','','','','',2,7,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2016,'2016','42332','','','','','','',0,5,NULL,0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2017,'2017','5052464565415','','','','','','',3,7,'/catalog/imported-images/product-5052464565415.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2019,'2019','42832','','','','','','',3,7,'/catalog/imported-images/product-42832.jpg',0,1,9.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2020,'2020','5708048037877','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2021,'2021','8680398794174','','','','','','',4,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2022,'2022','8680398794181','','','','','','',5,7,'/catalog/imported-images/product-8680398794181.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2023,'2023','10179','','','','','','',1,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:09:00'),(2024,'2024','44308','','','','','','',0,5,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2025,'2025','22235','','','','','','',4,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2026,'2026','6920191071471','','','','','','',2,7,'/catalog/imported-images/product-6920191071471.jpg',0,1,28.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2027,'2027','41529','','','','','','',1,7,NULL,0,1,21.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2028,'2028','41180','6999021716059','','','','','',1,7,NULL,0,1,25.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2029,'2029','6941158600046','','','','','','',0,5,NULL,0,1,18.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2030,'2030','6941158600039','','','','','','',2,7,NULL,0,1,18.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2031,'2031','4895139237610','','','','','','',0,5,'/catalog/imported-images/product-4895139237610.jpg',0,1,79.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2032,'2032','2333','2223','','','','','',4,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2033,'2033','2335','','','','','','',0,5,NULL,0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2034,'2034','1301','8606006461511','','','','','',1,7,NULL,0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2035,'2035','13828','','','','','','',10,7,'/catalog/imported-images/product-13828.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2036,'2036','8006218002333','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2037,'2037','8606005501324','','','','','','',6,7,NULL,0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2038,'2038','8606005501348','','','','','','',1,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2039,'2039','8690570546989','','','','','','',0,5,NULL,0,1,11.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2040,'2040','5908311862360','5054563114549','','','','','',0,5,NULL,0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,0,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(2041,'2041','5904517047310','','','','','','',1,7,'/catalog/imported-images/product-5904517047310.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2042,'2042','5904517027589','','','','','','',0,5,'/catalog/imported-images/product-5904517027589.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2043,'2043','5904517027572','','','','','','',0,5,'/catalog/imported-images/product-5904517027572.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2044,'2044','5904517027626','','','','','','',5,7,'/catalog/imported-images/product-5904517027626.jpg',0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2045,'2045','5904517027749','','','','','','',6,7,'/catalog/imported-images/product-5904517027749.jpg',0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2046,'2046','5904517027602','','','','','','',6,7,'/catalog/imported-images/product-5904517027602.jpg',0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2047,'2047','5904517026575','','','','','','',2,7,'/catalog/imported-images/product-5904517026575.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2048,'2048','5904517341142','','','','','','',1,7,'/catalog/imported-images/product-5904517341142.jpg',0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2049,'2049','5904517288355','','','','','','',2,7,'/catalog/imported-images/product-5904517288355.jpg',0,1,21.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2050,'2050','5904517026421','','','','','','',6,7,'/catalog/imported-images/product-5904517026421.jpg',0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2051,'2051','5904517346604','','','','','','',2,7,'/catalog/imported-images/product-5904517346604.jpg',0,1,14.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2052,'2052','5904517269347','','','','','','',0,5,'/catalog/imported-images/product-5904517269347.jpg',0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2053,'2053','5904517302259','','','','','','',3,7,'/catalog/imported-images/product-5904517302259.jpg',0,1,11.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2054,'2054','5904517269514','','','','','','',6,7,'/catalog/imported-images/product-5904517269514.jpg',0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2055,'2055','5904517026261','','','','','','',2,7,'/catalog/imported-images/product-5904517026261.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2056,'2056','5904517282629','','','','','','',20,7,'/catalog/imported-images/product-5904517282629.jpg',0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2057,'2057','5904517281233','','','','','','',13,7,'/catalog/imported-images/product-5904517281233.jpg',0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2058,'2058','5904517086722','','','','','','',0,5,'/catalog/imported-images/product-5904517086722.jpg',0,1,13.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2059,'2059','5904517067325','','','','','','',0,5,'/catalog/imported-images/product-5904517067325.jpg',0,1,21.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2060,'2060','5904517067332','','','','','','',0,5,'/catalog/imported-images/product-5904517067332.jpg',0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2061,'2061','5904517343528','','','','','','',0,5,'/catalog/imported-images/product-5904517343528.jpg',0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2062,'2062','5997272385476','','','','','','',2,7,NULL,0,1,4.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2063,'2063','5904517289611','','','','','','',2,7,'/catalog/imported-images/product-5904517289611.jpg',0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2064,'2064','5904517246614','','','','','','',2,7,'/catalog/imported-images/product-5904517246614.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2065,'2065','5904517302266','','','','','','',3,7,'/catalog/imported-images/product-5904517302266.jpg',0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2066,'2066','5904517246225','','','','','','',3,7,'/catalog/imported-images/product-5904517246225.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2067,'2067','5904517289598','5904517381353','','','','','',0,5,'/catalog/imported-images/product-5904517289598.jpg',0,1,10.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2068,'2068','5904517321250','','','','','','',0,5,'/catalog/imported-images/product-5904517321250.jpg',0,1,10.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2069,'2069','5904517344655','','','','','','',0,5,'/catalog/imported-images/product-5904517344655.jpg',0,1,7.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2070,'2070','3800200010178','','','','','','',1,7,NULL,0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2071,'2071','3800151724612','27170','','','','','',3,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2072,'2072','2090000182651','','','','','','',2,7,NULL,0,1,11.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2074,'2074','21961','2090000182361','','','','','',0,5,NULL,0,1,14.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2075,'2075','2090000200720','2090000200737','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2076,'2076','883314734157','','','','','','',0,5,NULL,0,1,11.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2077,'2077','883314899344','','','','','','',2,7,'/catalog/imported-images/product-883314899344.jpg',0,1,15.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2078,'2078','6956759260322','','','','','','',3,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2079,'2079','2000000057996','','','','','','',10,7,'/catalog/imported-images/product-2000000057996.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2080,'2080','2090000177947','','','','','','',2,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2081,'2081','4012400500475','','','','','','',3,7,'/catalog/imported-images/product-4012400500475.jpg',0,1,20.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2082,'2082','5714970002913','','','','','','',0,5,NULL,0,1,27.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2083,'2083','8054633839560','8054633839515','','','','','',7,7,'/catalog/imported-images/product-8054633839560.jpg',0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2084,'2084','2090000174540','','','','','','',1,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2085,'2085','6853562665125','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2086,'2086','8693135041745','','','','','','',9,7,'/catalog/imported-images/product-8693135041745.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2087,'2087','71596','','','','','','',1,7,NULL,0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2088,'2088','8692440001048','','','','','','',4,7,'/catalog/imported-images/product-8692440001048.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2089,'2089','5206970056404','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2090,'2090','3800097701005','','','','','','',4,7,'/catalog/imported-images/product-3800097701005.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2092,'2092','3800016861407','','','','','','',19,7,'/catalog/imported-images/product-3800016861407.jpg',0,1,0.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2093,'2093','4897011580753','','','','','','',2,7,'/catalog/imported-images/product-4897011580753.jpg',0,1,10.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2094,'2094','4897011580722','','','','','','',1,7,'/catalog/imported-images/product-4897011580722.jpg',0,1,16.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2095,'2095','4897011580715','','','','','','',0,5,'/catalog/imported-images/product-4897011580715.jpg',0,1,20.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2096,'2096','3800226800135','1428','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,3,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2097,'2097','15410','5350151707118','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2098,'2098','3800151746577','','','','','','',0,5,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2099,'2099','3800151723394','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2100,'2100','8695122001176','','','','','','',4,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2101,'2101','2000000087788','','','','','','',2,7,'/catalog/imported-images/product-2000000087788.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2102,'2102','40168','','','','','','',3,7,NULL,0,1,4.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2103,'2103','6938258854882','6948223000701','','','','','',4,7,NULL,0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2104,'2104','10105','','','','','','',3,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2105,'2105','3800085107734','','','','','','',33,7,'/catalog/imported-images/product-3800085107734.jpg',0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2107,'2107','3800085106058','','','','','','',5,7,NULL,0,1,2.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2108,'2108','3800085106355','','','','','','',2,7,NULL,0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2109,'2109','3800085102418','','','','','','',15,7,'/catalog/imported-images/product-3800085102418.jpg',0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2110,'2110','3800085105860','','','','','','',3,7,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2111,'2111','3800085106942','','','','','','',3,7,NULL,0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2112,'2112','3800085105822','','','','','','',2,7,NULL,0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2113,'2113','3800085105709','','','','','','',3,7,NULL,0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2114,'2114','3800085109431','','','','','','',3,7,NULL,0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2115,'2115','3800085107833','','','','','','',4,7,'/catalog/imported-images/product-3800085107833.jpg',0,1,1.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2116,'2116','3800085100124','','','','','','',5,7,'/catalog/imported-images/product-3800085100124.jpg',0,1,1.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2117,'2117','3800085113179','','','','','','',2,7,'/catalog/imported-images/product-3800085113179.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2118,'2118','3800085113186','','','','','','',5,7,'/catalog/imported-images/product-3800085113186.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2119,'2119','3800085115197','','','','','','',3,7,'/catalog/imported-images/product-3800085115197.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2120,'2120','3800085126391','','','','','','',3,7,'/catalog/imported-images/product-3800085126391.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2121,'2121','3800085124298','3800085124281','','','','','',2,7,'/catalog/imported-images/product-3800085124281.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2122,'2122','3800085125950','','','','','','',2,7,'/catalog/imported-images/product-3800085125950.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2123,'2123','3800085126193','3800085126209','','','','','',3,7,'/catalog/imported-images/product-3800085126193.jpg',0,1,5.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2124,'2124','3800085124274','','','','','','',2,7,'/catalog/imported-images/product-3800085124274.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2125,'2125','3800085109714','','','','','','',3,7,'/catalog/imported-images/product-3800085109714.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2126,'2126','3800085125882','3800085125875','','','','','',11,7,'/catalog/imported-images/product-3800085125882.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2127,'2127','3800085122416','','','','','','',3,7,'/catalog/imported-images/product-3800085122416.jpg',0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2128,'2128','3800085123451','','','','','','',0,5,'/catalog/imported-images/product-3800085123451.jpg',0,1,5.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2129,'2129','3800085123468','','','','','','',3,7,'/catalog/imported-images/product-3800085123468.jpg',0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2130,'2130','8712561844703','','','','','','',4,7,'/catalog/imported-images/product-8712561844703.jpg',0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2131,'2131','8717644320396','8717644644362','','','','','',3,7,'/catalog/imported-images/product-8717644320396.jpg',0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2132,'2132','96086230','','','','','','',0,5,'/catalog/imported-images/product-96086230.jpg',0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2133,'2133','50120772','','','','','','',3,7,'/catalog/imported-images/product-50120772.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2134,'2134','3800085110864','','','','','','',9,7,'/catalog/imported-images/product-3800085110864.jpg',0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2135,'2135','8410436429221','','','','','','',0,5,NULL,0,1,29.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2136,'2136','5011417565117','','','','','','',1,7,'/catalog/imported-images/product-5011417565117.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2137,'2137','5900536279213','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2138,'2138','9999','','','','','','',0,5,NULL,0,1,11.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2139,'2139','3800139257019','','','','','','',0,5,NULL,0,1,22.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2140,'2140','15164433','','','','','','',1,7,NULL,0,1,98.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2141,'2141','8000798000574','','','','','','',4,7,'/catalog/imported-images/product-8000798000574.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2142,'2142','5608579028637','','','','','','',4,7,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2143,'2143','5608579028675','','','','','','',4,7,'/catalog/imported-images/product-5608579028675.jpg',0,1,8.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2144,'2144','3800864001048','','','','','','',2,7,'/catalog/imported-images/product-3800864001048.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2145,'2145','41240','','','','','','',0,5,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2146,'2146','41245','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2148,'2148','8015194520816','','','','','','',0,5,NULL,0,1,9.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2149,'2149','4895139210262','','','','','','',1,7,'/catalog/imported-images/product-4895139210262.jpg',0,1,15.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2150,'2150','6923933821365','','','','','','',8,7,'/catalog/imported-images/product-6923933821365.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2151,'2151','6923933821419','','','','','','',4,7,'/catalog/imported-images/product-6923933821419.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2152,'2152','3800144804987','','','','','','',7,7,'/catalog/imported-images/product-3800144804987.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2153,'2153','2090000139778','','','','','','',7,7,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2154,'2154','3800211010228','','','','','','',0,5,'/catalog/imported-images/product-3800211010228.jpg',0,1,1.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2155,'2155','3800211019023','','','','','','',0,5,'/catalog/imported-images/product-3800211019023.jpg',0,1,1.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2156,'2156','3800211010044','','','','','','',0,5,'/catalog/imported-images/product-3800211010044.jpg',0,1,1.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2157,'2157','3800211019047','','','','','','',0,5,'/catalog/imported-images/product-3800211019047.jpg',0,1,1.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2158,'2158','026092','','','','','','',1,7,NULL,0,1,69.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2159,'2159','3800218261227','','','','','','',1,7,NULL,0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2160,'2160','3800218260664','3800218261326','','','','','',0,5,NULL,0,1,15.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2161,'2161','3800218261623','032036','','','','','',2,7,NULL,0,1,14.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2162,'2162','3800218261722','','','','','','',3,7,NULL,0,1,17.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2163,'2163','032074','','','','','','',0,5,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2164,'2164','КТ036045Л','','','','','','',0,5,NULL,0,1,23.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2165,'2165','036047','633133','','','','','',1,7,NULL,0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2166,'2166','КТ036055Л','','','','','','',1,7,NULL,0,1,17.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2167,'2167','КТ036087Л','','','','','','',2,7,NULL,0,1,32.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2168,'2168','КТ036089Л','','','','','','',2,7,NULL,0,1,55.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2169,'2169','КТ036116Л','13055','','','','','',2,7,NULL,0,1,23.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2170,'2170','036124','7313','','','','','',2,7,NULL,0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2171,'2171','КТ036137Л','','','','','','',0,5,NULL,0,1,20.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2172,'2172','КТ0360142Л','','','','','','',4,7,NULL,0,1,11.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2173,'2173','КТ036143Л','','','','','','',4,7,NULL,0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2174,'2174','КТ036144Л','','','','','','',3,7,NULL,0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2175,'2175','КТ036145Л','','','','','','',0,5,NULL,0,1,25.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2176,'2176','КТ036149Л','КТ036102Л','','','','','',0,5,NULL,0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2177,'2177','КТ036225Л','036181','','','','','',3,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2178,'2178','КТ036205Л','','','','','','',3,7,NULL,0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2179,'2179','КТ036234Л','','','','','','',0,5,NULL,0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2180,'2180','036252','','','','','','',2,7,NULL,0,1,21.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2181,'2181','2036258000002','036258','','','','','',2,7,NULL,0,1,12.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2182,'2182','2036339000006','036339','','','','','',1,7,NULL,0,1,12.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2183,'2183','2039128000003','','','','','','',3,7,NULL,0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2184,'2184','2039133000005','','','','','','',3,7,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2185,'2185','3800222591341','','','','','','',2,7,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2186,'2186','7290102992591','','','','','','',2,7,'/catalog/imported-images/product-7290102992591.jpg',0,1,22.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2187,'2187','036204','КТ036204Л','','','','','',1,7,NULL,0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2188,'2188','3800202405019','','','','','','',0,5,NULL,0,1,45.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2189,'2189','8606110287090','','','','','','',0,5,NULL,0,1,35.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2190,'2190','5699','3800212021261','','','','','',2,7,NULL,0,1,6.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2191,'2191','8683672507330','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2192,'2192','3800151736226','','','','','','',0,5,NULL,0,1,20.4900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2193,'2193','3800151743484','','','','','','',5,7,NULL,0,1,3.4900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2194,'2194','8606006865296','','','','','','',0,5,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2195,'2195','324766','','','','','','',0,5,NULL,0,1,12.6900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2196,'2196','5350151738266','','','','','','',1,7,'/catalog/imported-images/product-5350151738266.jpg',0,1,8.7900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2197,'2197','5350151707477','','','','','','',0,5,NULL,0,1,2.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2198,'2198','5204846821941','','','','','','',2,7,NULL,0,1,17.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2199,'2199','9397','','','','','','',0,5,NULL,0,1,3.4900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2200,'2200','3800151713753','','','','','','',5,7,'/catalog/imported-images/product-3800151713753.jpg',0,1,3.4900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2201,'2201','3800151713692','','','','','','',4,7,'/catalog/imported-images/product-3800151713692.jpg',0,1,3.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2202,'2202','3800151774945','3800151776376','','','','','',7,7,'/catalog/imported-images/product-3800151774945.jpg',0,1,1.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2203,'2203','8606102736223','','','','','','',0,5,NULL,0,1,0.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2204,'2204','3800215494635','','','','','','',8,7,'/catalog/imported-images/product-3800215494635.jpg',0,1,1.6900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2205,'2205','337264','','','','','','',0,5,NULL,0,1,3.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2206,'2206','5350151703615','','','','','','',4,7,NULL,0,1,2.4900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2207,'2207','6986323270013','6976843582499','','','','','',2,7,'/catalog/imported-images/product-6986323270013.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2208,'2208','3800151752042','','','','','','',0,5,NULL,0,1,6.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2209,'2209','6971681200703','','','','','','',0,5,NULL,0,1,2.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2210,'2210','17834','','','','','','',0,5,NULL,0,1,2.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2211,'2211','5350151701598','','','','','','',2,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2212,'2212','3800151717324','','','','','','',2,7,NULL,0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2213,'2213','5350151702915','','','','','','',1,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2214,'2214','3441','','','','','','',5,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2215,'2215','8697404116967','','','','','','',0,5,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2216,'2216','6934179000049','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2217,'2217','8697410472149','','','','','','',1,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2218,'2218','8697404117018','','','','','','',1,7,NULL,0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2219,'2219','5350151736460','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2220,'2220','5350151705817','','','','','','',5,7,'/catalog/imported-images/product-5350151705817.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2221,'2221','8697410470381','','','','','','',1,7,'/catalog/imported-images/product-8697410470381.jpg',0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2222,'2222','3800085104474','','','','','','',5,7,'/catalog/imported-images/product-3800085104474.jpg',0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2223,'2223','3800085112950','3800085112981','','','','','',2,7,'/catalog/imported-images/product-3800085112950.jpg',0,1,4.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2224,'2224','3800085102302','','','','','','',1,7,'/catalog/imported-images/product-3800085102302.jpg',0,1,10.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2225,'2225','14476','2000000056005','','','','','',22,7,'/catalog/imported-images/product-14476.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2226,'2226','15049','','','','','','',15,7,'/catalog/imported-images/product-15049.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2227,'2227','3800002302440','3800002310483','','','','','',1,7,'/catalog/imported-images/product-3800002302440.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2228,'2228','3800069404385','','','','','','',0,5,'/catalog/imported-images/product-3800069404385.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2229,'2229','40791','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2230,'2230','5904517046290','','','','','','',8,7,'/catalog/imported-images/product-5904517046290.jpg',0,1,9.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2232,'2232','5903936039708','','','','','','',3,7,'/catalog/imported-images/product-5903936039708.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2233,'2233','5903936042364','','','','','','',12,7,'/catalog/imported-images/product-5903936042364.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2234,'2234','4895139228649','','','','','','',0,5,NULL,0,1,14.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2236,'2236','4895139239751','','','','','','',0,5,NULL,0,1,33.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2237,'2237','4895139239768','','','','','','',1,7,'/catalog/imported-images/product-4895139239768.jpg',0,1,38.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2251,'2251','4015600949310','','','','','','',0,5,NULL,0,1,13.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2252,'2252','4012400500925','4012400500987','','','','','',2,7,'/catalog/imported-images/product-4012400500925.jpg',0,1,10.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2253,'2253','8001841791357','','','','','','',0,5,'/catalog/imported-images/product-8001841791357.jpg',0,1,28.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2255,'2255','5000204826760','','','','','','',0,5,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2256,'2256','8710522828359','8710908790027','','','','','',0,5,NULL,0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2257,'2257','9000100526760','','','','','','',0,5,NULL,0,1,3.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2258,'2258','8435495816263','','','','','','',2,7,'/catalog/imported-images/product-8435495816263.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2259,'2259','8008731003484','','','','','','',0,5,'/catalog/imported-images/product-8008731003484.jpg',0,1,11.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2260,'2260','9000101536591','','','','','','',0,5,NULL,0,1,45.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2261,'2261','8008731003507','','','','','','',0,5,'/catalog/imported-images/product-8008731003507.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2262,'2262','8008731003514','','','','','','',0,5,'/catalog/imported-images/product-8008731003514.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2263,'2263','2090000184501','','','','','','',8,7,'/catalog/imported-images/product-2090000184501.jpg',0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2264,'2264','2000000076270','','','','','','',7,7,'/catalog/imported-images/product-2000000076270.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2265,'2265','8711252989327','8698734213647','','','','','',2,7,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2266,'2266','3800500461137','','','','','','',2,7,'/catalog/imported-images/product-3800500461137.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2267,'2267','7290108351613','','','','','','',1,7,'/catalog/imported-images/product-7290108351613.jpg',0,1,16.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2268,'2268','7290014006638','','','','','','',0,5,'/catalog/imported-images/product-7290014006638.jpg',0,1,21.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2269,'2269','7290102991570','','','','','','',3,7,'/catalog/imported-images/product-7290102991570.jpg',0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2270,'2270','7638900381795','','','','','','',4,7,'/catalog/imported-images/product-7638900381795.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2272,'2272','6923933821617','','','','','','',5,7,'/catalog/imported-images/product-6923933821617.jpg',0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2273,'2273','6923933821600','','','','','','',5,7,'/catalog/imported-images/product-6923933821600.jpg',0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2274,'2274','4895139241730','','','','','','',0,5,NULL,0,1,11.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2275,'2275','4895139230895','','','','','','',3,7,'/catalog/imported-images/product-4895139230895.jpg',0,1,32.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2276,'2276','4895139236378','','','','','','',1,7,'/catalog/imported-images/product-4895139236378.jpg',0,1,34.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2277,'2277','4895139237153','','','','','','',0,5,NULL,0,1,44.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2278,'2278','4895139237320','','','','','','',1,7,'/catalog/imported-images/product-4895139237320.jpg',0,1,37.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2279,'2279','4895139237337','','','','','','',1,7,'/catalog/imported-images/product-4895139237337.jpg',0,1,38.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2280,'2280','4895139237740','','','','','','',1,7,'/catalog/imported-images/product-4895139237740.jpg',0,1,44.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2281,'2281','1322090004000','','','','','','',0,5,NULL,0,1,26.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2282,'2282','5903784070298','','','','','','',0,5,NULL,0,1,59.9900,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2283,'2283','8003350549252','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2284,'2284','5060060211148','','','','','','',7,7,'/catalog/imported-images/product-5060060211148.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2285,'2285','5060060211087','','','','','','',3,7,'/catalog/imported-images/product-5060060211087.jpg',0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2286,'2286','5060060212794','','','','','','',0,5,NULL,0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2287,'2287','5060060211223','','','','','','',1,7,'/catalog/imported-images/product-5060060211223.jpg',0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2289,'2289','8002100241682','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2290,'2290','8693959662935','8693959662928','','','','','',0,5,'/catalog/imported-images/product-8693959662935.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2292,'2292','8027906006105','8027906000622','','','','','',2,7,'/catalog/imported-images/product-8027906006105.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2293,'2293','4895139239201','','','','','','',0,5,NULL,0,1,65.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2294,'2294','4895139239218','','','','','','',0,5,NULL,0,1,85.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2295,'2295','4895139208467','','','','','','',1,7,'/catalog/imported-images/product-4895139208467.jpg',0,1,46.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2296,'2296','4895139223989','','','','','','',0,5,NULL,0,1,54.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2297,'2297','3800034982122','','','','','','',0,5,'/catalog/imported-images/product-3800034982122.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2298,'2298','3800034981040','3800034981033','','','','','',3,7,'/catalog/imported-images/product-3800034981040.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2299,'2299','3800034979856','','','','','','',1,7,'/catalog/imported-images/product-3800034979856.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2300,'2300','3800034976398','','','','','','',1,7,'/catalog/imported-images/product-3800034976398.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2301,'2301','3800034960335','','','','','','',3,7,'/catalog/imported-images/product-3800034960335.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2302,'2302','3800202405088','','','','','','',0,5,NULL,0,1,40.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2304,'2304','2090000152869','','','','','','',1,7,NULL,0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2305,'2305','5906927015699','5906927046372','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2306,'2306','3304140878848','','','','','','',8,7,'/catalog/imported-images/product-3304140878848.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2307,'2307','3800065302548','3800065302708','','','','','',17,7,'/catalog/imported-images/product-3800065302548.jpg',0,1,0.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2308,'2308','3800163900714','3800163900707','','','','','',7,7,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2309,'2309','6724135460358','','','','','','',5,7,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2310,'2310','20327','','','','','','',2,7,NULL,0,1,23.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2312,'2312','8001841912721','','','','','','',0,5,NULL,0,1,14.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2313,'2313','3800002306905','','','','','','',2,7,'/catalog/imported-images/product-3800002306905.jpg',0,1,4.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2314,'2314','8718692416017','8718692416055','','','','','',2,7,'/catalog/imported-images/product-8718692416017.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2315,'2315','6261686801952','529151','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2316,'2316','529152','','','','','','',1,7,'/catalog/imported-images/product-529152.jpg',0,1,6.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2317,'2317','529153','','','','','','',0,5,NULL,0,1,8.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2318,'2318','8697409846050','','','','','','',12,7,'/catalog/imported-images/product-8697409846050.jpg',0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2319,'2319','5903936035663','','','','','','',0,5,NULL,0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2320,'2320','5903936033584','','','','','','',0,5,NULL,0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2321,'2321','5903936041329','','','','','','',0,5,NULL,0,1,9.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2322,'2322','5903936041350','','','','','','',0,5,NULL,0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2323,'2323','9000101546231','','','','','','',0,5,'/catalog/imported-images/product-9000101546231.jpg',0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2324,'2324','8720181278709','8720181278716','','','','','',0,5,NULL,0,1,11.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2325,'2325','8683130018651','','','','','','',0,5,NULL,0,1,18.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2326,'2326','8693609193826','3800167603826','','','','','',1,7,NULL,0,1,27.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2327,'2327','8694313000530','','','','','','',2,7,NULL,0,1,15.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2328,'2328','10178','','','','','','',0,5,NULL,0,1,1.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2329,'2329','71151','','','','','','',1,7,'/catalog/imported-images/product-71151.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2330,'2330','20236','','','','','','',0,5,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2331,'2331','3800138228638','3800165504064','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2332,'2332','8680853073332','8680853073882','','','','','',1,7,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2333,'2333','6009802809358','70116','','','','','',0,5,NULL,0,1,40.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2334,'2334','70819','70840','','','','','',0,5,NULL,0,1,44.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2335,'2335','44762','44863','','','','','',7,7,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2336,'2336','3800226801125','','','','','','',2,7,'/catalog/imported-images/product-3800226801125.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2337,'2337','8697422301864','','','','','','',0,5,NULL,0,1,26.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2338,'2338','7290102991013','','','','','','',0,5,'/catalog/imported-images/product-7290102991013.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2339,'2339','8001090221759','','','','','','',1,7,'/catalog/imported-images/product-8001090221759.jpg',0,1,7.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2340,'2340','8006540209929','','','','','','',0,5,NULL,0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2341,'2341','8006540103470','','','','','','',0,5,NULL,0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2342,'2342','8006540101766','','','','','','',0,5,NULL,0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2343,'2343','4251758412393','','','','','','',0,5,'/catalog/imported-images/product-4251758412393.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2344,'2344','7702018980819','','','','','','',0,5,'/catalog/imported-images/product-7702018980819.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2345,'2345','8001090781987','','','','','','',0,5,'/catalog/imported-images/product-8001090781987.jpg',0,1,10.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2346,'2346','7702018620241','','','','','','',1,7,'/catalog/imported-images/product-7702018620241.jpg',0,1,12.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2347,'2347','8003520012906','8003520013040','','','','','',0,5,NULL,0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2348,'2348','8002295016409','8002295000057','','','','','',5,7,'/catalog/imported-images/product-8002295016409.jpg',0,1,6.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2349,'2349','8717163783740','8717163783757','','','','','',3,7,'/catalog/imported-images/product-8717163783740.jpg',0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:10:00'),(2350,'2350','8006540133378','','','','','','',0,5,NULL,0,1,16.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2351,'2351','8006540447352','','','','','','',0,5,NULL,0,1,17.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2352,'2352','8001841618777','','','','','','',0,5,'/catalog/imported-images/product-8001841618777.jpg',0,1,13.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2353,'2353','21356','20314','','','','','',4,7,NULL,0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2354,'2354','3800002301917','3800002301924','','','','','',4,7,'/catalog/imported-images/product-3800002301917.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2355,'2355','5903936035069','','','','','','',16,7,'/catalog/imported-images/product-5903936035069.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2356,'2356','5903936035076','','','','','','',7,7,'/catalog/imported-images/product-5903936035076.jpg',0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2357,'2357','8710522939734','','','','','','',1,7,'/catalog/imported-images/product-8710522939734.jpg',0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2358,'2358','8886467074424','','','','','','',10,7,'/catalog/imported-images/product-8886467074424.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2360,'2360','5000204025323','','','','','','',0,5,NULL,0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2361,'2361','5000204227611','','','','','','',2,7,'/catalog/imported-images/product-5000204227611.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2362,'2362','2090000185935','','','','','','',0,5,NULL,0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2363,'2363','8697409802247','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2364,'2364','10332','','','','','','',2,7,NULL,0,1,21.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2365,'2365','10300','','','','','','',1,7,NULL,0,1,33.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2366,'2366','40419','','','','','','',0,5,NULL,0,1,45.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2367,'2367','3800206201495','8691397540419','','','','','',1,7,'/catalog/imported-images/product-3800206201495.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2368,'2368','5903887801072','','','','','','',0,5,NULL,0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2369,'2369','4895139228816','','','','','','',2,7,'/catalog/imported-images/product-4895139228816.jpg',0,1,12.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2370,'2370','4895139228823','','','','','','',0,5,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2371,'2371','4895139228793','','','','','','',0,5,NULL,0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2372,'2372','4895139232912','','','','','','',0,5,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2373,'2373','4895139232929','','','','','','',0,5,NULL,0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2374,'2374','4895139232882','','','','','','',1,7,'/catalog/imported-images/product-4895139232882.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2375,'2375','4895139241570','','','','','','',0,5,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2376,'2376','4895139232875','','','','','','',2,7,'/catalog/imported-images/product-4895139232875.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2377,'2377','70555','','','','','','',1,7,'/catalog/imported-images/product-70555.jpg',0,1,24.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2378,'2378','8720181151156','','','','','','',0,5,NULL,0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2379,'2379','8003510009299','8003510017386','','','','','',4,7,'/catalog/imported-images/product-8003510009299.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2380,'2380','3800203961521','','','','','','',11,7,NULL,0,1,0.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2381,'2381','8001090566317','8001841790794','','','','','',0,5,NULL,0,1,19.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2382,'2382','4251758413864','4251758413314','','','','','',0,5,NULL,0,1,26.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2383,'2383','8017412004016','','','','','','',1,7,'/catalog/imported-images/product-8017412004016.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2384,'2384','8698848003660','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2385,'2385','8690637712111','8683130013694','','','','','',3,7,'/catalog/imported-images/product-8683130013694.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2386,'2386','7290000293530','','','','','','',0,5,'/catalog/imported-images/product-7290000293530.jpg',0,1,9.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2387,'2387','2090000201246','','','','','','',5,7,'/catalog/imported-images/product-2090000201246.jpg',0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2388,'2388','71139','8693135041851','','','','','',6,7,'/catalog/imported-images/product-71139.jpg',0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2389,'2389','3800038932369','','','','','','',0,5,'/catalog/imported-images/product-3800038932369.jpg',0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2390,'2390','3800038902942','','','','','','',1,7,'/catalog/imported-images/product-3800038902942.jpg',0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2391,'2391','3800038931843','','','','','','',3,7,'/catalog/imported-images/product-3800038931843.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2392,'2392','8690511004264','','','','','','',0,5,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2393,'2393','6923933821358','','','','','','',10,7,'/catalog/imported-images/product-6923933821358.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2394,'2394','77081','','','','','','',6,7,'/catalog/imported-images/product-77081.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2395,'2395','6923933821693','','','','','','',6,7,'/catalog/imported-images/product-6923933821693.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2398,'2398','887930425949','','','','','','',1,7,NULL,0,1,33.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2399,'2399','8022446313331','','','','','','',1,7,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2400,'2400','8022446003126','','','','','','',2,7,NULL,0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2401,'2401','8717163605776','','','','','','',0,5,'/catalog/imported-images/product-8717163605776.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2402,'2402','8008970042350','','','','','','',0,5,'/catalog/imported-images/product-8008970042350.jpg',0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2403,'2403','3838824086736','3838824138923','','','','','',4,7,'/catalog/imported-images/product-3838824086736.jpg',0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2404,'2404','8697666627874','','','','','','',0,5,NULL,0,1,22.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2405,'2405','8697666627881','','','','','','',1,7,NULL,0,1,26.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2406,'2406','8581782089435','','','','','','',2,7,'/catalog/imported-images/product-8581782089435.jpg',0,1,38.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2407,'2407','3800139225421','3800139225414','','','','','',3,7,NULL,0,1,10.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2409,'2409','3800139275532','','','','','','',2,7,NULL,0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2410,'2410','8581782324208','','','','','','',0,5,NULL,0,1,35.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2413,'2413','8581782324215','','','','','','',1,7,NULL,0,1,38.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2414,'2414','3800139259129','','','','','','',0,5,'/catalog/imported-images/product-3800139259129.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2415,'2415','3800139275518','','','','','','',3,7,NULL,0,1,8.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2416,'2416','3800139275525','','','','','','',3,7,NULL,0,1,17.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2417,'2417','8002936016911','','','','','','',6,7,'/catalog/imported-images/product-8002936016911.jpg',0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2418,'2418','3800139296100','','','','','','',-1,5,'/catalog/imported-images/product-3800139296100.jpg',0,1,19.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2419,'2419','3800139280475','','','','','','',6,7,'/catalog/imported-images/product-3800139280475.jpg',0,1,3.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2420,'2420','3800139280482','','','','','','',7,7,'/catalog/imported-images/product-3800139280482.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2421,'2421','3800139280499','','','','','','',1,7,NULL,0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2422,'2422','883314512946','','','','','','',4,7,'/catalog/imported-images/product-883314512946.jpg',0,1,13.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2423,'2423','3800139289508','','','','','','',4,7,'/catalog/imported-images/product-3800139289508.jpg',0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2425,'2425','708911','','','','','','',1,7,'/catalog/imported-images/product-708911.jpg',0,1,5.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2426,'2426','708912','','','','','','',0,5,NULL,0,1,7.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2427,'2427','708913','','','','','','',0,5,NULL,0,1,9.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2428,'2428','708914','','','','','','',2,7,'/catalog/imported-images/product-708914.jpg',0,1,13.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2429,'2429','5902365004035','','','','','','',0,5,NULL,0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2430,'2430','11717','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2432,'2432','13020','','','','','','',2,7,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2433,'2433','8606006460576','','','','','','',0,5,NULL,0,1,1.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2434,'2434','40960','','','','','','',3,7,'/catalog/imported-images/product-40960.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2435,'2435','6954899562559','','','','','','',5,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2436,'2436','10425','','','','','','',3,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2437,'2437','41571','','','','','','',3,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2438,'2438','30509','','','','','','',6,7,'/catalog/imported-images/product-30509.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2439,'2439','21641','','','','','','',3,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2440,'2440','44830','','','','','','',3,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2441,'2441','44858','','','','','','',2,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2442,'2442','6914887445295','','','','','','',0,5,'/catalog/imported-images/product-6914887445295.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2443,'2443','44865','','','','','','',2,7,'/catalog/imported-images/product-44865.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2444,'2444','44836','','','','','','',3,7,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2445,'2445','44115','','','','','','',3,7,NULL,0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2447,'2447','44690','6988202242210','','','','','',3,7,'/catalog/imported-images/product-44690.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2448,'2448','3800158118667','','','','','','',0,5,NULL,0,1,15.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2449,'2449','5904517366770','','','','','','',1,7,'/catalog/imported-images/product-5904517366770.jpg',0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2450,'2450','4260117830662','','','','','','',1,7,'/catalog/imported-images/product-4260117830662.jpg',0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2451,'2451','4260117830105','','','','','','',6,7,'/catalog/imported-images/product-4260117830105.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2452,'2452','3800230213211','','','','','','',3,7,'/catalog/imported-images/product-3800230213211.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2453,'2453','3800230213136','','','','','','',11,7,'/catalog/imported-images/product-3800230213136.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2454,'2454','3800139203009','','','','','','',3,7,'/catalog/imported-images/product-3800139203009.jpg',0,1,12.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2455,'2455','3800139203016','','','','','','',0,5,NULL,0,1,16.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2456,'2456','8436532860010','','','','','','',1,7,NULL,0,1,38.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2457,'2457','8006540470244','','','','','','',0,5,NULL,0,1,10.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2458,'2458','8696287072018','','','','','','',0,5,NULL,0,1,15.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:11:00'),(2459,'2459','4012400500376','','','','','','',1,7,'/catalog/imported-images/product-4012400500376.jpg',0,1,20.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2460,'2460','8886467018206','8886467018237','','','','','',1,7,'/catalog/imported-images/product-8886467018206.jpg',0,1,34.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2461,'2461','4251758412997','','','','','','',1,7,'/catalog/imported-images/product-4251758412997.jpg',0,1,13.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2462,'2462','8410104899868','','','','','','',1,7,'/catalog/imported-images/product-8410104899868.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2463,'2463','8006540754016','','','','','','',0,5,NULL,0,1,23.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2464,'2464','7290102991129','','','','','','',0,5,'/catalog/imported-images/product-7290102991129.jpg',0,1,21.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2465,'2465','7290000288352','','','','','','',1,7,'/catalog/imported-images/product-7290000288352.jpg',0,1,19.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2466,'2466','7290000287478','7290102992256','','','','','',0,5,'/catalog/imported-images/product-7290005426971.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2467,'2467','3800067600314','','','','','','',0,5,NULL,0,1,1.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2468,'2468','5903355007609','','','','','','',2,7,'/catalog/imported-images/product-5903355007609.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2469,'2469','6421937060013','','','','','','',0,5,'/catalog/imported-images/product-6421937060013.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2470,'2470','680678221428','','','','','','',4,7,'/catalog/imported-images/product-680678221428.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2472,'2472','680678290028','','','','','','',0,5,NULL,0,1,26.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2473,'2473','680678289985','','','','','','',0,5,NULL,0,1,29.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2474,'2474','680678051506','680678052589','','','','','',0,5,NULL,0,1,9.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2475,'2475','6421937000019','','','','','','',3,7,'/catalog/imported-images/product-6421937000019.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2476,'2476','8699243467491','','','','','','',0,5,NULL,0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2477,'2477','4895139241860','','','','','','',1,7,'/catalog/imported-images/product-4895139241860.jpg',0,1,17.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2478,'2478','8697447471016','','','','','','',0,5,NULL,0,1,40.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2479,'2479','8697762460023','','','','','','',0,5,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2480,'2480','8697762460702','','','','','','',0,5,NULL,0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2481,'2481','8699401091315','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2482,'2482','8699401091322','','','','','','',2,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2483,'2483','8699401091339','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2484,'2484','8699401090516','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2485,'2485','4823052324063','4823052324070','','','','','',0,5,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2486,'2486','2000000080703','11547','','','','','',2,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2487,'2487','8680771723920','','','','','','',2,7,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2488,'2488','8699878654129','','','','','','',0,5,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2489,'2489','8699878654136','','','','','','',0,5,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2490,'2490','8680771723906','','','','','','',0,5,NULL,0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2491,'2491','8680771723913','','','','','','',0,5,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2492,'2492','8681982238999','','','','','','',2,7,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2493,'2493','8683143871472','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2494,'2494','2090000199024','','','','','','',8,7,'/catalog/imported-images/product-2090000199024.jpg',0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2495,'2495','2090000149876','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2496,'2496','2090000189469','','','','','','',3,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2497,'2497','8697410470350','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2498,'2498','2090000200140','2090000200133','','','','','',2,7,NULL,0,1,14.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2499,'2499','8681469497222','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2500,'2500','8681469497239','','','','','','',1,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2501,'2501','8682013208820','','','','','','',5,7,NULL,0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2502,'2502','8682013508821','','','','','','',2,7,NULL,0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2503,'2503','8681982231013','','','','','','',1,7,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2504,'2504','2090000200843','','','','','','',0,5,NULL,0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2505,'2505','2090000200836','54527','','','','','',8,7,'/catalog/imported-images/product-2090000200836.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2506,'2506','2090000198522','','','','','','',3,7,NULL,0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2507,'2507','5949067501387','','','','','','',-1,5,'/catalog/imported-images/product-5949067501387.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2508,'2508','8003350547173','','','','','','',0,5,NULL,0,1,21.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2509,'2509','5060060212527','','','','','','',1,7,'/catalog/imported-images/product-5060060212527.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2510,'2510','3800217597082','','','','','','',0,5,NULL,0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2511,'2511','3800144800316','','','','','','',3,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2512,'2512','8006540446843','','','','','','',0,5,'/catalog/imported-images/product-8006540446843.jpg',0,1,31.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2514,'2514','680678151169','100216','','','','','',5,7,'/catalog/imported-images/product-680678151169.jpg',0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2515,'2515','680678385328','','','','','','',11,7,'/catalog/imported-images/product-680678385328.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2516,'2516','8004360023084','','','','','','',2,7,'/catalog/imported-images/product-8004360023084.jpg',0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2517,'2517','8004360023091','','','','','','',0,5,'/catalog/imported-images/product-8004360023091.jpg',0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2518,'2518','40128','','','','','','',3,7,NULL,0,1,6.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2519,'2519','8680801602133','','','','','','',0,5,NULL,0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2520,'2520','2000000082394','','','','','','',0,5,NULL,0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2521,'2521','2000000059969','','','','','','',2,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2522,'2522','8690511191858','','','','','','',2,7,'/catalog/imported-images/product-8690511191858.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2523,'2523','8006540997000','','','','','','',0,5,NULL,0,1,17.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2524,'2524','8001841006680','','','','','','',0,5,NULL,0,1,9.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2525,'2525','6923933821556','6923933821549','','','','','',9,7,'/catalog/imported-images/product-6923933821556.jpg',0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2527,'2527','00081534181179','','','','','','',1,7,NULL,0,1,11.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2528,'2528','8697409843226','','','','','','',6,7,'/catalog/imported-images/product-8697409843226.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2529,'2529','3800217597136','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2530,'2530','7290108351569','','','','','','',2,7,'/catalog/imported-images/product-7290108351569.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2531,'2531','7290000293516','','','','','','',2,7,'/catalog/imported-images/product-7290000293516.jpg',0,1,17.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2532,'2532','7290000286877','','','','','','',2,7,'/catalog/imported-images/product-7290000286877.jpg',0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2533,'2533','7290005423499','','','','','','',2,7,'/catalog/imported-images/product-7290005423499.jpg',0,1,14.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2534,'2534','7290102990627','','','','','','',0,5,'/catalog/imported-images/product-7290102990627.jpg',0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2535,'2535','7290107280389','','','','','','',0,5,'/catalog/imported-images/product-7290107280389.jpg',0,1,9.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2536,'2536','7290108352153','','','','','','',0,5,'/catalog/imported-images/product-7290108352153.jpg',0,1,7.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2540,'2540','8711600511989','','','','','','',6,7,'/catalog/imported-images/product-8711600511989.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2541,'2541','3800097701807','','','','','','',2,7,'/catalog/imported-images/product-3800097701807.jpg',0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2552,'2552','8006540484166','','','','','','',0,5,'/catalog/imported-images/product-8006540484166.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2554,'2554','6923933821372','','','','','','',2,7,'/catalog/imported-images/product-6923933821372.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2555,'2555','3801402240158','','','','','','',1,7,NULL,0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2556,'2556','8681503001255','','','','','','',0,5,NULL,0,1,39.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2557,'2557','8681503004171','','','','','','',2,7,NULL,0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2558,'2558','8681503004188','','','','','','',3,7,NULL,0,1,8.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2559,'2559','8698532591435','','','','','','',2,7,NULL,0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2560,'2560','8680834620401','','','','','','',1,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2561,'2561','8697404111504','','','','','','',4,7,NULL,0,1,19.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2562,'2562','8697404111498','','','','','','',4,7,NULL,0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2563,'2563','8697404111511','','','','','','',4,7,NULL,0,1,27.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2564,'2564','5903936013906','','','','','','',12,7,'/catalog/imported-images/product-5903936013906.jpg',0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2565,'2565','957002','','','','','','',0,5,NULL,0,1,0.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2566,'2566','8594002682736','','','','','','',2,7,'/catalog/imported-images/product-8594002682736.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2567,'2567','4251758414458','','','','','','',0,5,NULL,0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2568,'2568','8710447275276','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2569,'2569','3600523971718','','','','','','',0,5,NULL,0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2570,'2570','3800013531969','','','','','','',2,7,'/catalog/imported-images/product-3800013531969.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2571,'2571','4005900756152','','','','','','',2,7,'/catalog/imported-images/product-4005900756152.jpg',0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2572,'2572','9005800313252','4005808753475','','','','','',2,7,'/catalog/imported-images/product-9005800313252.jpg',0,1,14.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2573,'2573','3800034953597','','','','','','',15,7,'/catalog/imported-images/product-3800034953597.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2574,'2574','3800034952330','','','','','','',9,7,'/catalog/imported-images/product-3800034952330.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2575,'2575','3800034967785','3800034962636','','','','','',15,7,'/catalog/imported-images/product-3800034967785.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2576,'2576','3800220333295','','','','','','',4,7,'/catalog/imported-images/product-3800220333295.jpg',0,1,10.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2577,'2577','8697409841321','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2578,'2578','2000000079875','','','','','','',3,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2579,'2579','2000000079868','','','','','','',6,7,'/catalog/imported-images/product-2000000079868.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2580,'2580','2000000084176','','','','','','',3,7,NULL,0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2581,'2581','883314809756','','','','','','',2,7,'/catalog/imported-images/product-883314809756.jpg',0,1,15.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2582,'2582','8881003008017','','','','','','',0,5,NULL,0,1,15.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2583,'2583','4701904105124','','','','','','',1,7,'/catalog/imported-images/product-4701904105124.jpg',0,1,34.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2584,'2584','4895139207262','','','','','','',0,5,NULL,0,1,21.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2585,'2585','4895139230888','','','','','','',0,5,'/catalog/imported-images/product-4895139230888.jpg',0,1,29.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2586,'2586','4895139230901','','','','','','',2,7,'/catalog/imported-images/product-4895139230901.jpg',0,1,33.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2587,'2587','4895139230918','','','','','','',1,7,'/catalog/imported-images/product-4895139230918.jpg',0,1,39.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2588,'2588','4895139235913','','','','','','',1,7,'/catalog/imported-images/product-4895139235913.jpg',0,1,37.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2589,'2589','4895139227741','','','','','','',1,7,'/catalog/imported-images/product-4895139227741.jpg',0,1,67.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2590,'2590','4895139207903','','','','','','',1,7,'/catalog/imported-images/product-4895139207903.jpg',0,1,35.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2591,'2591','4895139230994','','','','','','',0,5,NULL,0,1,31.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2592,'2592','4895139231007','','','','','','',2,7,'/catalog/imported-images/product-4895139231007.jpg',0,1,34.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2593,'2593','4897011580760','','','','','','',2,7,'/catalog/imported-images/product-4897011580760.jpg',0,1,19.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2594,'2594','4701811024228','','','','','','',1,7,'/catalog/imported-images/product-4701811024228.jpg',0,1,43.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2595,'2595','4895139207231','','','','','','',0,5,'/catalog/imported-images/product-4895139207231.jpg',0,1,31.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2596,'2596','8710447460603','','','','','','',0,5,NULL,0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2597,'2597','8710522423929','','','','','','',0,5,'/catalog/imported-images/product-8710522423929.jpg',0,1,14.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2598,'2598','8711106026437','','','','','','',3,7,'/catalog/imported-images/product-8711106026437.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2599,'2599','5201314051701','','','','','','',0,5,'/catalog/imported-images/product-5201314051701.jpg',0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2600,'2600','3800202401134','','','','','','',1,7,NULL,0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2601,'2601','8015194525705','','','','','','',0,5,NULL,0,1,14.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2602,'2602','8001841604121','','','','','','',0,5,NULL,0,1,10.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2603,'2603','8015194518424','','','','','','',0,5,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2604,'2604','5000394145818','','','','','','',1,7,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2605,'2605','3800024046988','','','','','','',3,7,'/catalog/imported-images/product-3800024046988.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2606,'2606','8693135041998','8693135041905','','','','','',4,7,'/catalog/imported-images/product-8693135041998.jpg',0,1,21.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2607,'2607','44998','','','','','','',2,7,NULL,0,1,5.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2608,'2608','8008260002286','','','','','','',0,5,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2609,'2609','3800085115494','','','','','','',2,7,'/catalog/imported-images/product-3800085115494.jpg',0,1,7.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2610,'2610','5949031307359','','','','','','',0,5,'/catalog/imported-images/product-5949031307359.jpg',0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2612,'2612','11171','','','','','','',7,7,'/catalog/imported-images/product-11171.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2613,'2613','2090000152838','','','','','','',1,7,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2614,'2614','53520','','','','','','',80,7,'/catalog/imported-images/product-53520.jpg',0,1,0.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2615,'2615','7290014005792','','','','','','',10,7,'/catalog/imported-images/product-7290014005792.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2616,'2616','048256297164','','','','','','',8,7,'/catalog/imported-images/product-048256297164.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2617,'2617','5060060211124','','','','','','',0,5,'/catalog/imported-images/product-5060060211124.jpg',0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2618,'2618','КТ036140Л','','','','','','',0,5,NULL,0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2619,'2619','3800089510011','','','','','','',2,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2620,'2620','3800089510028','','','','','','',3,7,NULL,0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2621,'2621','3800089506014','','','','','','',2,7,NULL,0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2622,'2622','3800089506021','','','','','','',3,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2623,'2623','3800089506038','','','','','','',4,7,NULL,0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2624,'2624','3800089506045','','','','','','',0,5,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2625,'2625','3800089506052','','','','','','',4,7,NULL,0,1,11.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2626,'2626','3800089506069','','','','','','',2,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2627,'2627','3800089506076','','','','','','',4,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2628,'2628','3800089506090','','','','','','',2,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2629,'2629','3800089506113','','','','','','',3,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2630,'2630','3800089506120','','','','','','',3,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2631,'2631','3800089506144','','','','','','',3,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2632,'2632','3800089506151','','','','','','',3,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2633,'2633','3800089506168','','','','','','',3,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2634,'2634','3800089506175','','','','','','',2,7,NULL,0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2635,'2635','3800089506199','','','','','','',3,7,NULL,0,1,8.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2636,'2636','3800089506229','','','','','','',3,7,NULL,0,1,7.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2637,'2637','3800089506243','','','','','','',2,7,NULL,0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2638,'2638','3800089506274','','','','','','',4,7,NULL,0,1,10.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2639,'2639','3800089510103','','','','','','',2,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2640,'2640','3800089510110','','','','','','',3,7,NULL,0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2641,'2641','3800089509572','','','','','','',2,7,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2642,'2642','3800089509589','','','','','','',0,5,NULL,0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2643,'2643','3800024022135','','','','','','',3,7,'/catalog/imported-images/product-3800024022135.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2644,'2644','8690536922116','','','','','','',3,7,'/catalog/imported-images/product-8690536922116.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2645,'2645','8697409840492','','','','','','',1,7,NULL,0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2646,'2646','8697409840485','','','','','','',1,7,NULL,0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2647,'2647','8680853074209','','','','','','',0,5,NULL,0,1,6.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2648,'2648','8680853074216','','','','','','',0,5,NULL,0,1,8.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2649,'2649','10487','','','','','','',1,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2650,'2650','82855','','','','','','',3,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2651,'2651','4895139213638','','','','','','',1,7,'/catalog/imported-images/product-4895139213638.jpg',0,1,79.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2652,'2652','4895139207484','','','','','','',1,7,'/catalog/imported-images/product-4895139207484.jpg',0,1,99.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2653,'2653','887930421897','','','','','','',2,7,'/catalog/imported-images/product-887930421897.jpg',0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2654,'2654','8001090866783','','','','','','',0,5,'/catalog/imported-images/product-8001090866783.jpg',0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2655,'2655','8720065003953','','','','','','',0,5,NULL,0,1,9.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2656,'2656','5900536273723','','','','','','',3,7,'/catalog/imported-images/product-5900536273723.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2657,'2657','5201314909040','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2658,'2658','5201314333333','','','','','','',2,7,'/catalog/imported-images/product-5201314333333.jpg',0,1,2.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2659,'2659','5900536269894','','','','','','',1,7,'/catalog/imported-images/product-5900536269894.jpg',0,1,4.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2660,'2660','4251758413154','','','','','','',0,5,NULL,0,1,37.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2661,'2661','8017079001502','','','','','','',3,7,NULL,0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2662,'2662','8017079002820','','','','','','',3,7,NULL,0,1,12.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2663,'2663','8017079003476','','','','','','',3,7,NULL,0,1,7.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2664,'2664','8017079003452','','','','','','',3,7,NULL,0,1,7.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2665,'2665','8017079003445','','','','','','',3,7,NULL,0,1,7.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2666,'2666','8017079003506','','','','','','',3,7,NULL,0,1,7.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2667,'2667','8017079003490','','','','','','',2,7,NULL,0,1,7.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2668,'2668','8682022655820','','','','','','',0,5,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2669,'2669','8682022656513','','','','','','',0,5,NULL,0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2670,'2670','3800222850707','','','','','','',2,7,'/catalog/imported-images/product-3800222850707.jpg',0,1,10.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2671,'2671','3800222850882','','','','','','',2,7,'/catalog/imported-images/product-3800222850882.jpg',0,1,10.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2672,'2672','3800222850714','','','','','','',2,7,'/catalog/imported-images/product-3800222850714.jpg',0,1,10.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2725,'2725','5996629017176','5996629016995','','','','','',3,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2726,'2726','2090000144147','','','','','','',6,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2727,'2727','50728','','','','','','',4,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2728,'2728','30976','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:12:00'),(2729,'2729','3800163901964','','','','','','',8,7,'/catalog/imported-images/product-3800163901964.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2730,'2730','52567','','','','','','',48,7,'/catalog/imported-images/product-52567.jpg',0,1,0.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2731,'2731','2090000197129','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2732,'2732','2090000197143','','','','','','',2,7,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2733,'2733','2090000191080','','','','','','',5,7,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2734,'2734','131','','','','','','',1,7,NULL,0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2735,'2735','5350151734015','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2736,'2736','112','','','','','','',5,7,'/catalog/imported-images/product-112.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2737,'2737','146','','','','','','',1,7,NULL,0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2738,'2738','8697410478028','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2739,'2739','8606103220455','','','','','','',7,7,'/catalog/imported-images/product-8606103220455.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2740,'2740','8680518411172','','','','','','',1,7,NULL,0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2741,'2741','13810','','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2742,'2742','1462','2000000061825','','','','','',2,7,NULL,0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2743,'2743','9000101545807','','','','','','',3,7,'/catalog/imported-images/product-9000101545807.jpg',0,1,3.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2744,'2744','8435495816324','','','','','','',1,7,'/catalog/imported-images/product-8435495816324.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2745,'2745','8435495816355','','','','','','',1,7,'/catalog/imported-images/product-8435495816355.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2746,'2746','8435495816294','','','','','','',2,7,'/catalog/imported-images/product-8435495816294.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2747,'2747','8054633839225','','','','','','',3,7,'/catalog/imported-images/product-8054633839225.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2748,'2748','8050999570222','','','','','','',3,7,'/catalog/imported-images/product-8050999570222.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2749,'2749','8054633839249','','','','','','',3,7,'/catalog/imported-images/product-8054633839249.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2750,'2750','8054633839232','','','','','','',4,7,'/catalog/imported-images/product-8054633839232.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2751,'2751','8054633839256','','','','','','',4,7,'/catalog/imported-images/product-8054633839256.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2752,'2752','7290102992706','','','','','','',2,7,'/catalog/imported-images/product-7290102992706.jpg',0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2753,'2753','7290102992225','','','','','','',3,7,'/catalog/imported-images/product-7290102992225.jpg',0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2754,'2754','7290102991402','','','','','','',3,7,'/catalog/imported-images/product-7290102991402.jpg',0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2755,'2755','7290102991426','','','','','','',2,7,'/catalog/imported-images/product-7290102991426.jpg',0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2756,'2756','7290102991433','','','','','','',3,7,'/catalog/imported-images/product-7290102991433.jpg',0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2757,'2757','7290102992232','','','','','','',0,5,'/catalog/imported-images/product-7290102992232.jpg',0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2758,'2758','7290102991419','','','','','','',2,7,'/catalog/imported-images/product-7290102991419.jpg',0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2759,'2759','7290102991396','','','','','','',3,7,'/catalog/imported-images/product-7290102991396.jpg',0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2760,'2760','7290102992027','','','','','','',2,7,'/catalog/imported-images/product-7290102992027.jpg',0,1,12.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2761,'2761','7290013269157','','','','','','',0,5,'/catalog/imported-images/product-7290013269157.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2762,'2762','7290004731519','','','','','','',3,7,'/catalog/imported-images/product-7290004731519.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2763,'2763','7290005423253','','','','','','',2,7,'/catalog/imported-images/product-7290005423253.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2764,'2764','8008970055206','','','','','','',12,7,'/catalog/imported-images/product-8008970055206.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2765,'2765','8008970041087','','','','','','',0,5,NULL,0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2766,'2766','8008970055244','','','','','','',10,7,'/catalog/imported-images/product-8008970055244.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2767,'2767','8008970055268','','','','','','',13,7,'/catalog/imported-images/product-8008970055268.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2768,'2768','8008970043814','','','','','','',0,5,NULL,0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2769,'2769','8008970055251','','','','','','',7,7,'/catalog/imported-images/product-8008970055251.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2770,'2770','7290107280761','','','','','','',1,7,'/catalog/imported-images/product-7290107280761.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2771,'2771','7290108352252','','','','','','',1,7,'/catalog/imported-images/product-7290108352252.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2772,'2772','7290108350548','','','','','','',1,7,'/catalog/imported-images/product-7290108350548.jpg',0,1,9.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2773,'2773','3800069496038','','','','','','',2,7,'/catalog/imported-images/product-3800069496038.jpg',0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2774,'2774','3800069402107','','','','','','',6,7,'/catalog/imported-images/product-3800069402107.jpg',0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2775,'2775','96086223','','','','','','',2,7,'/catalog/imported-images/product-96086223.jpg',0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2776,'2776','96086216','','','','','','',2,7,'/catalog/imported-images/product-96086216.jpg',0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2777,'2777','96116715','','','','','','',3,7,'/catalog/imported-images/product-96116715.jpg',0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2778,'2778','59085768','','','','','','',0,5,'/catalog/imported-images/product-59085768.jpg',0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2779,'2779','8001841394442','','','','','','',0,5,NULL,0,1,9.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2780,'2780','8699621630394','','','','','','',2,7,'/catalog/imported-images/product-8699621630394.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2781,'2781','8699621630172','','','','','','',3,7,'/catalog/imported-images/product-8699621630172.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2782,'2782','8699621630387','','','','','','',2,7,'/catalog/imported-images/product-8699621630387.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2783,'2783','6920354835971','','','','','','',0,5,'/catalog/imported-images/product-6920354835971.jpg',0,1,2.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2784,'2784','3801003002544','','','','','','',0,5,'/catalog/imported-images/product-3801003002544.jpg',0,1,2.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2785,'2785','5011417567050','','','','','','',0,5,'/catalog/imported-images/product-5011417567050.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2786,'2786','3059943018303','','','','','','',0,5,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2787,'2787','3059943009080','','','','','','',0,5,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2788,'2788','5011417568903','','','','','','',0,5,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2789,'2789','5904517366671','','','','','','',-8,5,'/catalog/imported-images/product-5904517366671.jpg',0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2790,'2790','3800144800408','','','','','','',2,7,'/catalog/imported-images/product-3800144800408.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2791,'2791','3800144803447','','','','','','',0,5,'/catalog/imported-images/product-3800144803447.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2792,'2792','3800144800439','','','','','','',2,7,'/catalog/imported-images/product-3800144800439.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2793,'2793','3800144803461','','','','','','',1,7,'/catalog/imported-images/product-3800144803461.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2795,'2795','3800034977814','','','','','','',2,7,'/catalog/imported-images/product-3800034977814.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2796,'2796','3800034958530','','','','','','',2,7,'/catalog/imported-images/product-3800034958530.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2797,'2797','3800034958547','','','','','','',1,7,'/catalog/imported-images/product-3800034958547.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2798,'2798','3800034975261','','','','','','',0,5,'/catalog/imported-images/product-3800034975261.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2799,'2799','3800034979863','','','','','','',1,7,'/catalog/imported-images/product-3800034979863.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2800,'2800','3800034979887','','','','','','',1,7,'/catalog/imported-images/product-3800034979887.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2801,'2801','3800034979870','','','','','','',0,5,'/catalog/imported-images/product-3800034979870.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2802,'2802','3800034980340','','','','','','',2,7,'/catalog/imported-images/product-3800034980340.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2803,'2803','3800034980357','','','','','','',2,7,'/catalog/imported-images/product-3800034980357.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2804,'2804','3800034978552','','','','','','',2,7,'/catalog/imported-images/product-3800034978552.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2805,'2805','3800034977791','','','','','','',0,5,'/catalog/imported-images/product-3800034977791.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2806,'2806','3800034978439','','','','','','',0,5,'/catalog/imported-images/product-3800034978439.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2807,'2807','3800034978422','','','','','','',2,7,'/catalog/imported-images/product-3800034978422.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2808,'2808','3800034977784','','','','','','',0,5,'/catalog/imported-images/product-3800034977784.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2809,'2809','3800034976404','','','','','','',0,5,'/catalog/imported-images/product-3800034976404.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2810,'2810','3800230610348','','','','','','',5,7,'/catalog/imported-images/product-3800230610348.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2811,'2811','96616','','','','','','',0,5,'/catalog/imported-images/product-96616.jpg',0,1,26.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2812,'2812','96617','','','','','','',0,5,NULL,0,1,28.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2813,'2813','96618','','','','','','',0,5,NULL,0,1,29.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2814,'2814','96620','','','','','','',0,5,NULL,0,1,32.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,4,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2815,'2815','96624','','','','','','',0,5,NULL,0,1,45.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2816,'2816','96625','','','','','','',0,5,'/catalog/imported-images/product-96625.jpg',0,1,35.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,2,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2817,'2817','8719743405004','8719743405028','','','','','',1,7,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2818,'2818','1000037237119','','','','','','',0,5,NULL,0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2819,'2819','3665468200279','','','','','','',3,7,'/catalog/imported-images/product-3665468200279.jpg',0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2820,'2820','3059940004910','','','','','','',0,5,'/catalog/imported-images/product-3059940004910.jpg',0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2821,'2821','3059940003609','','','','','','',0,5,'/catalog/imported-images/product-3059940003609.jpg',0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2822,'2822','3800131513625','','','','','','',0,5,NULL,0,1,16.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2823,'2823','2000000072586','','','','','','',7,7,'/catalog/imported-images/product-2000000072586.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2824,'2824','4823052324087','','','','','','',3,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2825,'2825','54196162','','','','','','',1,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2826,'2826','4012400502363','','','','','','',0,5,'/catalog/imported-images/product-4012400502363.jpg',0,1,39.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2827,'2827','4012400502387','','','','','','',1,7,'/catalog/imported-images/product-4012400502387.jpg',0,1,39.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2828,'2828','8710847886881','','','','','','',2,7,'/catalog/imported-images/product-8710847886881.jpg',0,1,20.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2829,'2829','8710847886867','','','','','','',0,5,NULL,0,1,20.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2830,'2830','8001090766489','','','','','','',1,7,'/catalog/imported-images/product-8001090766489.jpg',0,1,41.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2831,'2831','9000101541342','','','','','','',0,5,NULL,0,1,28.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2832,'2832','8410436445108','','','','','','',3,7,'/catalog/imported-images/product-8410436445108.jpg',0,1,38.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2833,'2833','7290014007222','','','','','','',0,5,NULL,0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2834,'2834','7290000292915','','','','','','',1,7,NULL,0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2835,'2835','7290014006935','','','','','','',0,5,NULL,0,1,10.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2836,'2836','3800144806097','','','','','','',5,7,'/catalog/imported-images/product-3800144806097.jpg',0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2837,'2837','5900627067668','','','','','','',2,7,'/catalog/imported-images/product-5900627067668.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2838,'2838','3801003001295','','','','','','',1,7,'/catalog/imported-images/product-3801003001295.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2839,'2839','3800069404811','','','','','','',2,7,'/catalog/imported-images/product-3800069404811.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2840,'2840','3800144800293','','','','','','',1,7,'/catalog/imported-images/product-3800144800293.jpg',0,1,1.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2841,'2841','5997321747880','','','','','','',1,7,'/catalog/imported-images/product-5997321747880.jpg',0,1,7.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2842,'2842','5900627081817','','','','','','',1,7,'/catalog/imported-images/product-5900627081817.jpg',0,1,7.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2843,'2843','40511','','','','','','',3,7,NULL,0,1,15.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2845,'2845','3800208727122','','','','','','',4,7,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2846,'2846','3800208727016','','','','','','',8,7,'/catalog/imported-images/product-3800208727016.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2847,'2847','3800226801330','','','','','','',7,7,'/catalog/imported-images/product-3800226801330.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2848,'2848','3800226801385','','','','','','',9,7,'/catalog/imported-images/product-3800226801385.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2849,'2849','4895139207439','','','','','','',1,7,'/catalog/imported-images/product-4895139207439.jpg',0,1,34.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2850,'2850','8606102287916','','','','','','',7,7,'/catalog/imported-images/product-8606102287916.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2851,'2851','4012400500758','','','','','','',0,5,'/catalog/imported-images/product-4012400500758.jpg',0,1,20.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2854,'2854','3800090305194','','','','','','',0,5,NULL,0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2855,'2855','3800077002696','','','','','','',2,7,'/catalog/imported-images/product-3800077002696.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2856,'2856','3800077000609','','','','','','',8,7,'/catalog/imported-images/product-3800077000609.jpg',0,1,1.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2857,'2857','3800077000593','','','','','','',3,7,'/catalog/imported-images/product-3800077000593.jpg',0,1,1.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2858,'2858','3800501924044','','','','','','',5,7,'/catalog/imported-images/product-3800501924044.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2859,'2859','3800501924198','','','','','','',5,7,'/catalog/imported-images/product-3800501924198.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2860,'2860','3800501924235','','','','','','',4,7,'/catalog/imported-images/product-3800501924235.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2861,'2861','3800077014781','','','','','','',5,7,'/catalog/imported-images/product-3800077014781.jpg',0,1,3.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2862,'2862','3800077011834','','','','','','',1,7,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2863,'2863','3800077011872','','','','','','',3,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2864,'2864','3800077010141','','','','','','',4,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2865,'2865','3800077017508','','','','','','',2,7,'/catalog/imported-images/product-3800077017508.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2866,'2866','291','','','','','','',3,7,'/catalog/imported-images/product-291.jpg',0,1,13.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2867,'2867','3800166201405','','','','','','',0,5,NULL,0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2868,'2868','3800166201399','','','','','','',0,5,NULL,0,1,3.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2869,'2869','8690546120199','','','','','','',0,5,NULL,0,1,5.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2870,'2870','3800166202037','','','','','','',3,7,'/catalog/imported-images/product-3800166202037.jpg',0,1,8.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2871,'2871','3800166202068','','','','','','',1,7,'/catalog/imported-images/product-3800166202068.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2872,'2872','3800166202044','','','','','','',2,7,'/catalog/imported-images/product-3800166202044.jpg',0,1,8.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2873,'2873','2090000200164','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2874,'2874','8699621630370','','','','','','',2,7,'/catalog/imported-images/product-8699621630370.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2875,'2875','3800144800453','','','','','','',0,5,'/catalog/imported-images/product-3800144800453.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2876,'2876','3800069405610','','','','','','',3,7,'/catalog/imported-images/product-3800069405610.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2877,'2877','3800069406341','','','','','','',3,7,'/catalog/imported-images/product-3800069406341.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2880,'2880','5903936002375','','','','','','',0,5,NULL,0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2881,'2881','5903936014408','','','','','','',0,5,'/catalog/imported-images/product-5903936014408.jpg',0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2882,'2882','5903936014071','','','','','','',0,5,NULL,0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2883,'2883','5903936042357','','','','','','',1,7,'/catalog/imported-images/product-5903936042357.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2884,'2884','5903936044252','','','','','','',1,7,'/catalog/imported-images/product-5903936044252.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2885,'2885','5903936038749','5903936044238','','','','','',2,7,'/catalog/imported-images/product-5903936038749.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2886,'2886','3800085124755','','','','','','',1,7,'/catalog/imported-images/product-3800085124755.jpg',0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2887,'2887','2400000000150','','','','','','',0,5,NULL,0,1,5.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2888,'2888','96097335','','','','','','',4,7,'/catalog/imported-images/product-96097335.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2889,'2889','73103714','','','','','','',4,7,'/catalog/imported-images/product-73103714.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2890,'2890','3800085126452','','','','','','',4,7,'/catalog/imported-images/product-3800085126452.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2891,'2891','3800085126421','','','','','','',3,7,'/catalog/imported-images/product-3800085126421.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2892,'2892','8712561845069','','','','','','',2,7,'/catalog/imported-images/product-8712561845069.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2893,'2893','8712561844857','','','','','','',2,7,'/catalog/imported-images/product-8712561844857.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2894,'2894','8712561844482','','','','','','',4,7,'/catalog/imported-images/product-8712561844482.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2895,'2895','2090000156522','','','','','','',3,7,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2896,'2896','2090000201277','','','','','','',5,7,'/catalog/imported-images/product-2090000201277.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2897,'2897','2090000202632','','','','','','',0,5,NULL,0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2898,'2898','54920','','','','','','',1,7,'/catalog/imported-images/product-54920.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2899,'2899','50527','','','','','','',1,7,NULL,0,1,34.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2900,'2900','72008','','','','','','',2,7,'/catalog/imported-images/product-72008.jpg',0,1,47.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2901,'2901','6923244505404','','','','','','',0,5,NULL,0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2902,'2902','8681734168468','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2903,'2903','13863','','','','','','',3,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2904,'2904','13864','','','','','','',3,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2905,'2905','10828','','','','','','',1,7,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2906,'2906','10829','','','','','','',2,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2907,'2907','10830','','','','','','',2,7,NULL,0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2909,'2909','3800144803539','','','','','','',1,7,'/catalog/imported-images/product-3800144803539.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2910,'2910','3800144800392','','','','','','',2,7,'/catalog/imported-images/product-3800144800392.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2911,'2911','3800144800422','','','','','','',2,7,'/catalog/imported-images/product-3800144800422.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2912,'2912','3800069405122','','','','','','',1,7,'/catalog/imported-images/product-3800069405122.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2913,'2913','3800069406952','','','','','','',0,5,'/catalog/imported-images/product-3800069406952.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2914,'2914','3800069405139','','','','','','',1,7,'/catalog/imported-images/product-3800069405139.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2915,'2915','3800069405108','','','','','','',0,5,'/catalog/imported-images/product-3800069405108.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2916,'2916','3800208724329','','','','','','',1,7,NULL,0,1,32.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2917,'2917','3800208724572','','','','','','',0,5,NULL,0,1,25.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2918,'2918','5608579028668','','','','','','',1,7,'/catalog/imported-images/product-5608579028668.jpg',0,1,8.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2919,'2919','3800230215819','','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2920,'2920','5903936012206','','','','','','',2,7,'/catalog/imported-images/product-5903936012206.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2921,'2921','5903936012213','','','','','','',2,7,'/catalog/imported-images/product-5903936012213.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2922,'2922','5903936016419','','','','','','',0,5,NULL,0,1,11.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2923,'2923','5903936016426','','','','','','',10,7,'/catalog/imported-images/product-5903936016426.jpg',0,1,5.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2924,'2924','5997272386756','','','','','','',3,7,'/catalog/imported-images/product-5997272386756.jpg',0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2925,'2925','9000101124422','','','','','','',2,7,'/catalog/imported-images/product-9000101124422.jpg',0,1,12.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2926,'2926','5997272386893','','','','','','',0,5,NULL,0,1,24.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2927,'2927','9000101554991','','','','','','',0,5,'/catalog/imported-images/product-9000101554991.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2928,'2928','2302','','','','','','',0,5,NULL,0,1,11.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2929,'2929','2313','','','','','','',0,5,NULL,0,1,17.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2930,'2930','60159520191979','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2931,'2931','3800222850721','','','','','','',0,5,'/catalog/imported-images/product-3800222850721.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2932,'2932','8690511170501','','','','','','',1,7,'/catalog/imported-images/product-8690511170501.jpg',0,1,27.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2933,'2933','8710447462577','','','','','','',0,5,NULL,0,1,18.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2935,'2935','8015194520052','','','','','','',49,7,'/catalog/imported-images/product-8015194520052.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2936,'2936','8015194520076','','','','','','',1,7,'/catalog/imported-images/product-8015194520076.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:13:00'),(2937,'2937','8015100576418','','','','','','',8,7,'/catalog/imported-images/product-8015100576418.jpg',0,1,12.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2938,'2938','8015100576364','','','','','','',4,7,'/catalog/imported-images/product-8015100576364.jpg',0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2939,'2939','5000204604542','','','','','','',6,7,'/catalog/imported-images/product-5000204604542.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2940,'2940','8015194100421','','','','','','',0,5,'/catalog/imported-images/product-8015194100421.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2941,'2941','8015194100254','','','','','','',12,7,'/catalog/imported-images/product-8015194100254.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2942,'2942','8015194528522','','','','','','',2,7,'/catalog/imported-images/product-8015194528522.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2943,'2943','8015194523053','','','','','','',11,7,'/catalog/imported-images/product-8015194523053.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2944,'2944','8015194523039','','','','','','',0,5,'/catalog/imported-images/product-8015194523039.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2945,'2945','8015194514853','','','','','','',7,7,'/catalog/imported-images/product-8015194514853.jpg',0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2946,'2946','8015194514860','','','','','','',12,7,'/catalog/imported-images/product-8015194514860.jpg',0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2947,'2947','8059602240668','','','','','','',0,5,NULL,0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2948,'2948','8059602240651','','','','','','',2,7,'/catalog/imported-images/product-8059602240651.jpg',0,1,5.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2949,'2949','8003752120004','','','','','','',8,7,'/catalog/imported-images/product-8003752120004.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2950,'2950','8001940011479','','','','','','',0,5,NULL,0,1,49.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2951,'2951','8001940001456','','','','','','',0,5,NULL,0,1,35.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2952,'2952','3665468400914','','','','','','',0,5,NULL,0,1,29.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2953,'2953','8008970055077','','','','','','',1,7,'/catalog/imported-images/product-8008970055077.jpg',0,1,8.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2954,'2954','3800218426466','','','','','','',1,7,'/catalog/imported-images/product-3800218426466.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2955,'2955','3800218426473','','','','','','',6,7,'/catalog/imported-images/product-3800218426473.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2956,'2956','5949031306765','','','','','','',1,7,'/catalog/imported-images/product-5949031306765.jpg',0,1,16.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2957,'2957','5949152111514','','','','','','',1,7,'/catalog/imported-images/product-5949152111514.jpg',0,1,16.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2958,'2958','5949152111897','','','','','','',0,5,'/catalog/imported-images/product-5949152111897.jpg',0,1,16.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2960,'2960','2090000200850','44737','','','','','',0,5,'/catalog/imported-images/product-2090000200850.jpg',0,1,8.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2961,'2961','2090000202168','','','','','','',3,7,NULL,0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2962,'2962','2090000178388','','','','','','',3,7,'/catalog/imported-images/product-2090000178388.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2963,'2963','8690802039920','','','','','','',0,5,NULL,0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2964,'2964','8015194520083','','','','','','',22,7,'/catalog/imported-images/product-8015194520083.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2965,'2965','3800090304586','','','','','','',1,7,'/catalog/imported-images/product-3800090304586.jpg',0,1,3.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2966,'2966','12264','','','','','','',77,7,'/catalog/imported-images/product-12264.jpg',0,1,0.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2967,'2967','10456','','','','','','',57,7,'/catalog/imported-images/product-10456.jpg',0,1,0.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2968,'2968','010458','','','','','','',53,7,'/catalog/imported-images/product-010458.jpg',0,1,0.1500,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2969,'2969','10460','','','','','','',70,7,'/catalog/imported-images/product-10460.jpg',0,1,0.2500,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2970,'2970','3800077002832','','','','','','',2,7,'/catalog/imported-images/product-3800077002832.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2971,'2971','8683581900017','','','','','','',4,7,'/catalog/imported-images/product-8683581900017.jpg',0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2972,'2972','8683581900024','','','','','','',3,7,'/catalog/imported-images/product-8683581900024.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2974,'2974','7290014006621','','','','','','',1,7,'/catalog/imported-images/product-7290014006621.jpg',0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2975,'2975','7290102991068','','','','','','',0,5,'/catalog/imported-images/product-7290102991068.jpg',0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2976,'2976','7290000292939','','','','','','',1,7,'/catalog/imported-images/product-7290000292939.jpg',0,1,11.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2977,'2977','8692624146282','','','','','','',2,7,'/catalog/imported-images/product-8692624146282.jpg',0,1,4.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2978,'2978','3800024046834','','','','','','',4,7,'/catalog/imported-images/product-3800024046834.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2979,'2979','8690536016501','','','','','','',2,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2980,'2980','8690536023189','','','','','','',2,7,'/catalog/imported-images/product-8690536023189.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2981,'2981','4895139241723','','','','','','',1,7,'/catalog/imported-images/product-4895139241723.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2982,'2982','5901969630152','','','','','','',0,5,'/catalog/imported-images/product-5901969630152.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2983,'2983','5901969630510','','','','','','',0,5,'/catalog/imported-images/product-5901969630510.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2984,'2984','5901969630572','','','','','','',0,5,'/catalog/imported-images/product-5901969630572.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2985,'2985','5908260617820','','','','','','',0,5,'/catalog/imported-images/product-5908260617820.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2986,'2986','5908260621810','','','','','','',0,5,'/catalog/imported-images/product-5908260621810.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2987,'2987','5901969630527','','','','','','',0,5,'/catalog/imported-images/product-5901969630527.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2988,'2988','5901969630619','','','','','','',2,7,'/catalog/imported-images/product-5901969630619.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2989,'2989','5908260635497','5901969633832','','','','','',0,5,'/catalog/imported-images/product-5908260635497.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2990,'2990','5908260607258','5908260608606','','','','','',2,7,'/catalog/imported-images/product-5908260607258.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2991,'2991','5900785708212','','','','','','',1,7,'/catalog/imported-images/product-5900785708212.jpg',0,1,6.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2992,'2992','8003350501991','','','','','','',2,7,'/catalog/imported-images/product-8003350501991.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2993,'2993','8697409846074','','','','','','',6,7,'/catalog/imported-images/product-8697409846074.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2994,'2994','8697409846081','','','','','','',1,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2996,'2996','2000000071282','21346','','','','','',4,7,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2997,'2997','2000000056340','','','','','','',1,7,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2998,'2998','2000000088747','','','','','','',2,7,'/catalog/imported-images/product-2000000088747.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(2999,'2999','5059001001115','','','','','','',2,7,'/catalog/imported-images/product-5059001001115.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3000,'3000','8003510004249','','','','','','',1,7,'/catalog/imported-images/product-8003510004249.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3001,'3001','8003510007523','','','','','','',0,5,'/catalog/imported-images/product-8003510007523.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3002,'3002','8003510025107','','','','','','',-1,5,'/catalog/imported-images/product-8003510025107.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3003,'3003','5900627071597','','','','','','',0,5,'/catalog/imported-images/product-5900627071597.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3004,'3004','5201314961109','','','','','','',5,7,'/catalog/imported-images/product-5201314961109.jpg',0,1,3.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3005,'3005','3800501924303','','','','','','',7,7,'/catalog/imported-images/product-3800501924303.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3006,'3006','3800501924334','3800501924327','','','','','',5,7,'/catalog/imported-images/product-3800501924334.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3008,'3008','3800034978514','','','','','','',2,7,'/catalog/imported-images/product-3800034978514.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3009,'3009','3800034977845','','','','','','',0,5,'/catalog/imported-images/product-3800034977845.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3010,'3010','3800034958554','','','','','','',1,7,'/catalog/imported-images/product-3800034958554.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3011,'3011','3800034960342','','','','','','',1,7,'/catalog/imported-images/product-3800034960342.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3012,'3012','3800034960328','','','','','','',2,7,'/catalog/imported-images/product-3800034960328.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3013,'3013','3800034978446','','','','','','',0,5,'/catalog/imported-images/product-3800034978446.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3014,'3014','3800034977838','','','','','','',0,5,'/catalog/imported-images/product-3800034977838.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3015,'3015','3800034968041','','','','','','',2,7,'/catalog/imported-images/product-3800034968041.jpg',0,1,11.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3016,'3016','3800034980371','','','','','','',0,5,'/catalog/imported-images/product-3800034980371.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3017,'3017','3800034980364','','','','','','',0,5,'/catalog/imported-images/product-3800034980364.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3018,'3018','3800034978484','','','','','','',1,7,'/catalog/imported-images/product-3800034978484.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3019,'3019','3800034978477','','','','','','',1,7,'/catalog/imported-images/product-3800034978477.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3020,'3020','3800034978460','','','','','','',1,7,'/catalog/imported-images/product-3800034978460.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3021,'3021','3800034978668','','','','','','',0,5,'/catalog/imported-images/product-3800034978668.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3022,'3022','3800034977777','','','','','','',1,7,'/catalog/imported-images/product-3800034977777.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3023,'3023','3800034977760','','','','','','',0,5,'/catalog/imported-images/product-3800034977760.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3024,'3024','3800034976411','','','','','','',1,7,'/catalog/imported-images/product-3800034976411.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3025,'3025','3800034976381','','','','','','',2,7,'/catalog/imported-images/product-3800034976381.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3026,'3026','3800034979733','','','','','','',2,7,'/catalog/imported-images/product-3800034979733.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3027,'3027','3800034982115','','','','','','',2,7,'/catalog/imported-images/product-3800034982115.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3028,'3028','3800034982092','','','','','','',2,7,'/catalog/imported-images/product-3800034982092.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3029,'3029','3800034982108','','','','','','',0,5,'/catalog/imported-images/product-3800034982108.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3030,'3030','3800034979740','','','','','','',0,5,'/catalog/imported-images/product-3800034979740.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3031,'3031','3800034979726','','','','','','',0,5,'/catalog/imported-images/product-3800034979726.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3032,'3032','3800085107864','','','','','','',2,7,'/catalog/imported-images/product-3800085107864.jpg',0,1,6.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3034,'3034','3800144800415','','','','','','',3,7,'/catalog/imported-images/product-3800144800415.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3035,'3035','3800069407607','','','','','','',1,7,'/catalog/imported-images/product-3800069407607.jpg',0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3036,'3036','3800069406921','','','','','','',1,7,'/catalog/imported-images/product-3800069406921.jpg',0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3037,'3037','3800069406907','','','','','','',0,5,'/catalog/imported-images/product-3800069406907.jpg',0,1,3.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3038,'3038','3800230214119','','','','','','',13,7,'/catalog/imported-images/product-3800230214119.jpg',0,1,6.1000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3039,'3039','8680853073059','','','','','','',0,5,NULL,0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3040,'3040','8697425880328','','','','','','',3,7,NULL,0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3041,'3041','3800134836127','','','','','','',3,7,'/catalog/imported-images/product-3800134836127.jpg',0,1,13.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,11,'2024-01-30 13:15:00','2024-06-27 16:14:00'),(3042,'3042','6954125108001','','','','','','',2,7,'/catalog/imported-images/product-6954125108001.jpg',0,1,27.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,2,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3043,'3043','8681212062271','','','','','','',0,5,NULL,0,1,0.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3044,'3044','5000204826586','','','','','','',0,5,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3045,'3045','5000204307122','','','','','','',3,7,'/catalog/imported-images/product-5000204307122.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3046,'3046','8015194517878','','','','','','',0,5,'/catalog/imported-images/product-8015194517878.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3048,'3048','3800069401315','','','','','','',2,7,'/catalog/imported-images/product-3800069401315.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3049,'3049','8718951270213','','','','','','',0,5,'/catalog/imported-images/product-8718951270213.jpg',0,1,8.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3050,'3050','8697427782804','','','','','','',2,7,'/catalog/imported-images/product-8697427782804.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3051,'3051','5413346322692','','','','','','',1,7,NULL,0,1,29.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3053,'3053','4650264370140','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3054,'3054','4650264370157','','','','','','',1,7,'/catalog/imported-images/product-4650264370157.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3055,'3055','3800235304556','','','','','','',1,7,'/catalog/imported-images/product-3800235304556.jpg',0,1,13.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3056,'3056','3800235304525','','','','','','',2,7,'/catalog/imported-images/product-3800235304525.jpg',0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3057,'3057','3800237041350','','','','','','',6,7,'/catalog/imported-images/product-3800237041350.jpg',0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3058,'3058','3800237042531','','','','','','',2,7,'/catalog/imported-images/product-3800237042531.jpg',0,1,18.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3059,'3059','3800237042548','','','','','','',1,7,'/catalog/imported-images/product-3800237042548.jpg',0,1,20.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3060,'3060','3800237042555','','','','','','',2,7,'/catalog/imported-images/product-3800237042555.jpg',0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3061,'3061','3800237042562','','','','','','',0,5,'/catalog/imported-images/product-3800237042562.jpg',0,1,18.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3062,'3062','3800237042579','','','','','','',1,7,'/catalog/imported-images/product-3800237042579.jpg',0,1,20.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3063,'3063','3800237042586','','','','','','',2,7,'/catalog/imported-images/product-3800237042586.jpg',0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3064,'3064','3800237041411','','','','','','',3,7,'/catalog/imported-images/product-3800237041411.jpg',0,1,7.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3065,'3065','5441926','','','','','','',0,5,NULL,0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3066,'3066','5441928','','','','','','',2,7,'/catalog/imported-images/product-5441928.jpg',0,1,11.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3067,'3067','3800235309964','','','','','','',2,7,'/catalog/imported-images/product-3800235309964.jpg',0,1,14.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3070,'3070','3800222850608','','','','','','',1,7,'/catalog/imported-images/product-3800222850608.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3075,'3075','8002910061708','','','','','','',0,5,NULL,0,1,25.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3076,'3076','8011164010363','','','','','','',3,7,NULL,0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3077,'3077','8058664096305','','','','','','',7,7,'/catalog/imported-images/product-8058664096305.jpg',0,1,3.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3078,'3078','5059001001122','','','','','','',1,7,'/catalog/imported-images/product-5059001001122.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3080,'3080','8435495816232','','','','','','',2,7,'/catalog/imported-images/product-8435495816232.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3084,'3084','8697512324001','','','','','','',1,7,'/catalog/imported-images/product-8697512324001.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3085,'3085','5900627070279','','','','','','',0,5,'/catalog/imported-images/product-5900627070279.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3086,'3086','3059943010406','','','','','','',0,5,'/catalog/imported-images/product-3059943010406.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3087,'3087','5997321756646','','','','','','',1,7,'/catalog/imported-images/product-5997321756646.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3088,'3088','5029053575179','','','','','','',1,7,'/catalog/imported-images/product-5029053575179.jpg',0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3089,'3089','3574669907392','','','','','','',0,5,'/catalog/imported-images/product-3574669907392.jpg',0,1,7.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3093,'3093','7290102993239','','','','','','',1,7,'/catalog/imported-images/product-7290102993239.jpg',0,1,38.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3098,'3098','7290102991037','','','','','','',2,7,'/catalog/imported-images/product-7290102991037.jpg',0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3099,'3099','8006540559482','','','','','','',2,7,'/catalog/imported-images/product-8006540559482.jpg',0,1,2.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3100,'3100','8697427781517','','','','','','',4,7,'/catalog/imported-images/product-8697427781517.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3101,'3101','8697427786550','','','','','','',3,7,'/catalog/imported-images/product-8697427786550.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3102,'3102','3800069404828','','','','','','',3,7,'/catalog/imported-images/product-3800069404828.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3103,'3103','3801003001233','','','','','','',3,7,'/catalog/imported-images/product-3801003001233.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3104,'3104','3801003001226','','','','','','',2,7,'/catalog/imported-images/product-3801003001226.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3105,'3105','3801003001240','','','','','','',2,7,'/catalog/imported-images/product-3801003001240.jpg',0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3106,'3106','3800226590081','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3107,'3107','8690536016518','','','','','','',2,7,'/catalog/imported-images/product-8690536016518.jpg',0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3108,'3108','3800085105488','','','','','','',1,7,'/catalog/imported-images/product-3800085105488.jpg',0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3109,'3109','3800085100018','','','','','','',1,7,'/catalog/imported-images/product-3800085100018.jpg',0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3110,'3110','3800085107642','','','','','','',1,7,'/catalog/imported-images/product-3800085107642.jpg',0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3111,'3111','3800085117290','','','','','','',1,7,'/catalog/imported-images/product-3800085117290.jpg',0,1,6.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3112,'3112','3800230214287','','','','','','',1,7,'/catalog/imported-images/product-3800230214287.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3113,'3113','44734','','','','','','',5,7,'/catalog/imported-images/product-44734.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3114,'3114','44735','','','','','','',7,7,'/catalog/imported-images/product-44735.jpg',0,1,4.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3115,'3115','10408','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3117,'3117','5060060212695','','','','','','',0,5,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3118,'3118','5060060212633','','','','','','',0,5,NULL,0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3119,'3119','5060060212732','','','','','','',1,7,'/catalog/imported-images/product-5060060212732.jpg',0,1,7.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3120,'3120','8693357586390','','','','','','',8,7,'/catalog/imported-images/product-8693357586390.jpg',0,1,11.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3121,'3121','8693357290761','','','','','','',2,7,'/catalog/imported-images/product-8693357290761.jpg',0,1,26.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3122,'3122','8693357041790','','','','','','',6,7,'/catalog/imported-images/product-8693357041790.jpg',0,1,5.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3123,'3123','6421937010407','','','','','','',4,7,'/catalog/imported-images/product-6421937010407.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3124,'3124','8693357076945','','','','','','',1,7,'/catalog/imported-images/product-8693357076945.jpg',0,1,7.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3125,'3125','6421937000217','','','','','','',3,7,'/catalog/imported-images/product-6421937000217.jpg',0,1,7.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3126,'3126','6421937000224','','','','','','',4,7,'/catalog/imported-images/product-6421937000224.jpg',0,1,5.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3127,'3127','8693357208704','','','','','','',7,7,'/catalog/imported-images/product-8693357208704.jpg',0,1,10.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3128,'3128','2090000184525','','','','','','',1,7,NULL,0,1,21.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3129,'3129','5906927351308','','','','','','',1,7,'/catalog/imported-images/product-5906927351308.jpg',0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3130,'3130','8680853073110','','','','','','',0,5,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3131,'3131','8696219345159','','','','','','',0,5,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3132,'3132','5202707990805','','','','','','',6,7,NULL,0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3133,'3133','4823052323837','','','','','','',8,7,NULL,0,1,5.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3134,'3134','4823052323813','','','','','','',4,7,NULL,0,1,3.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3135,'3135','8681873411364','','','','','','',9,7,'/catalog/imported-images/product-8681873411364.jpg',0,1,1.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3136,'3136','8697975028874','','','','','','',5,7,'/catalog/imported-images/product-8697975028874.jpg',0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3137,'3137','41034','','','','','','',10,7,'/catalog/imported-images/product-41034.jpg',0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3139,'3139','3800038938286','','','','','','',0,5,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3140,'3140','3800200011458','','','','','','',0,5,NULL,0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3142,'3142','3800034978521','','','','','','',1,7,'/catalog/imported-images/product-3800034978521.jpg',0,1,5.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3143,'3143','5903649056603','','','','','','',2,7,'/catalog/imported-images/product-5903649056603.jpg',0,1,4.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3144,'3144','5901737990372','','','','','','',0,5,NULL,0,1,19.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3146,'3146','3800151707332','','','','','','',1,7,NULL,0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,15,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3147,'3147','3800151762461','','','','','','',0,5,NULL,0,1,1.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3148,'3148','3800151762454','','','','','','',1,7,NULL,0,1,2.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3149,'3149','5350151783815','','','','','','',0,5,NULL,0,1,13.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3150,'3150','18743','5350151783914','','','','','',0,5,NULL,0,1,4.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3151,'3151','2058','','','','','','',1,7,NULL,0,1,6.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3152,'3152','5350151740894','','','','','','',2,7,'/catalog/imported-images/product-5350151740894.jpg',0,1,6.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3153,'3153','385','','','','','','',3,7,'/catalog/imported-images/product-385.jpg',0,1,8.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3154,'3154','386','','','','','','',3,7,'/catalog/imported-images/product-386.jpg',0,1,9.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3155,'3155','3836','','','','','','',1,7,'/catalog/imported-images/product-3836.jpg',0,1,11.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3156,'3156','5350151779023','','','','','','',0,5,NULL,0,1,11.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3157,'3157','5350151748708','','','','','','',0,5,NULL,0,1,7.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(3158,'3158','8720604312256','','','','','','',1,7,'/catalog/imported-images/product-8720604312256.jpg',0,1,2.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:15:00'),(2073,'2073','2400000000075','11785','','','','','',0,5,NULL,0,1,3.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:18:00'),(1650,'1650','3800163900875','3800163900868','','','','','',8,7,'/catalog/imported-images/product-3800163900868.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:18:00'),(2018,'2018','2400000000068','6920170217012','','','','','',1,7,NULL,0,1,1.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:18:00'),(188,'188','8695122003354','','','','','','',0,5,NULL,0,1,2.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:18:00'),(2147,'2147','2400000000082','8720181278723','','','','','',0,5,NULL,0,1,11.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:18:00'),(2852,'2852','9005800286563','4005808628087','','','','','',1,7,'/catalog/imported-images/product-9005800286563.jpg',0,1,8.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:18:00'),(3165,'3165','4744131013893','','','','','','',1,7,'/catalog/imported-images/product-4744131013893.jpg',0,1,22.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:18:00'),(3079,'3079','8435495816386','','','','','','',2,7,'/catalog/imported-images/product-8435495816386.jpg',0,1,3.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:18:00'),(3116,'3116','5060060211094','','','','','','',0,5,NULL,0,1,6.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:18:00'),(3159,'3159','3800002304550','','','','','','',2,7,'/catalog/imported-images/product-3800002304550.jpg',0,1,4.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:19:00'),(3141,'3141','3800200011465','','','','','','',5,7,'/catalog/imported-images/product-3800200011465.jpg',0,1,4.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:19:00'),(423,'423','2400000000037','','','','','','',0,5,NULL,0,1,0.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:19:00'),(2844,'2844','2400000000136','','','','','','',-1,5,NULL,0,1,2.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:19:00'),(8,'8','2090009140065','1213','','','','','',31,7,'/catalog/imported-images/product-2090009140065.jpg',0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,2,'2024-01-30 13:15:00','2024-06-27 16:19:00'),(3052,'3052','3800237041565','','','','','','',1,7,NULL,0,1,26.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:19:00'),(3007,'3007','2400000000174','','','','','','',0,5,NULL,0,1,0.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:19:00'),(2396,'2396','2400000000105','','','','','','',3,7,NULL,0,1,4.8000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(424,'424','2400000000044','','','','','','',0,5,NULL,0,1,0.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3081,'3081','8682241205448','','','','','','',0,5,'/catalog/imported-images/product-8682241205448.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3082,'3082','8682241205424','','','','','','',1,7,'/catalog/imported-images/product-8682241205424.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3083,'3083','8681212060666','','','','','','',2,7,'/catalog/imported-images/product-8681212060666.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3162,'3162','8697512323608','','','','','','',0,5,NULL,0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3160,'3160','8682241205417','','','','','','',9,7,'/catalog/imported-images/product-8682241205417.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3161,'3161','8697512320188','','','','','','',5,7,'/catalog/imported-images/product-8697512320188.jpg',0,1,2.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(16,'16','2400000000013','1212','','','','','',20,7,'/catalog/imported-images/product-2400000000013.jpg',0,1,5.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(17,'17','2400000000020','1211','','','','','',0,5,NULL,0,1,7.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3068,'3068','3800222850639','','','','','','',2,7,'/catalog/imported-images/product-3800222850639.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3069,'3069','3800222850615','','','','','','',2,7,'/catalog/imported-images/product-3800222850615.jpg',0,1,4.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3145,'3145','4895139202281','','','','','','',2,7,'/catalog/imported-images/product-4895139202281.jpg',0,1,24.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3097,'3097','7290102991044','','','','','','',2,7,'/catalog/imported-images/product-7290102991044.jpg',0,1,10.4000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3092,'3092','7290102993208','','','','','','',1,7,'/catalog/imported-images/product-7290102993208.jpg',0,1,38.3000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3095,'3095','7290102993192','','','','','','',2,7,'/catalog/imported-images/product-7290102993192.jpg',0,1,14.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3094,'3094','7290102993222','','','','','','',2,7,'/catalog/imported-images/product-7290102993222.jpg',0,1,14.5000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3071,'3071','8718951352100','','','','','','',1,7,'/catalog/imported-images/product-8718951352100.jpg',0,1,4.7000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(2412,'2412','2400000000112','','','','','','',2,7,'/catalog/imported-images/product-2400000000112.jpg',0,1,35.6000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3138,'3138','5903936001989','','','','','','',10,7,'/catalog/imported-images/product-5903936001989.jpg',0,1,6.2000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3091,'3091','8001841272030','','','','','','',1,7,'/catalog/imported-images/product-8001841272030.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3090,'3090','8001841271910','','','','','','',1,7,'/catalog/imported-images/product-8001841271910.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3072,'3072','8015194520069','','','','','','',23,7,'/catalog/imported-images/product-8015194520069.jpg',0,1,9.9000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,1,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(2879,'2879','2400000000143','','','','','','',0,5,NULL,0,1,17.0000,0,9,'2024-01-30',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-01-30 13:15:00','2024-06-27 16:20:00'),(3208,'3208','8595025835666','','','','','','',2,7,NULL,0,1,5.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3177,'3177','145626','','','','','','',0,5,NULL,0,1,7.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3205,'3205','8055348990553','','','','','','',0,5,NULL,0,1,1.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3206,'3206','8595025835680','','','','','','',2,7,NULL,0,1,5.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3213,'3213','8006540484197','','','','','','',0,5,NULL,0,1,9.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3216,'3216','8595025806055','','','','','','',1,7,NULL,0,1,5.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3166,'3166','3800089501347','','','','','','',0,5,NULL,0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3169,'3169','8694917002442','','','','','','',0,5,NULL,0,1,6.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3170,'3170','8696287140151','','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3171,'3171','45595','9888627022206','','','','','',3,7,NULL,0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3172,'3172','8681873432062','','','','','','',2,7,'/catalog/imported-images/product-8681873432062.jpg',0,1,7.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3173,'3173','45625','','','','','','',0,5,NULL,0,1,7.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3174,'3174','145625','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3175,'3175','45262','','','','','','',1,7,NULL,0,1,7.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3176,'3176','45626','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3178,'3178','45623','','','','','','',0,5,NULL,0,1,7.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3179,'3179','4008033493680','','','','','','',6,7,'/catalog/imported-images/product-4008033493680.jpg',0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3180,'3180','4008033428965','','','','','','',13,7,'/catalog/imported-images/product-4008033428965.jpg',0,1,3.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3181,'3181','4008033316903','','','','','','',8,7,'/catalog/imported-images/product-4008033316903.jpg',0,1,7.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3182,'3182','3800158114614','','','','','','',4,7,'/catalog/imported-images/product-3800158114614.jpg',0,1,5.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3183,'3183','3800158114263','','','','','','',1,7,'/catalog/imported-images/product-3800158114263.jpg',0,1,15.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3184,'3184','3800158114508','','','','','','',8,7,'/catalog/imported-images/product-3800158114508.jpg',0,1,2.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3168,'3168','3801003002568','','','','','','',0,5,NULL,0,1,3.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3185,'3185','3800158125276','','','','','','',2,7,'/catalog/imported-images/product-3800158125276.jpg',0,1,7.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3186,'3186','3800158115185','','','','','','',1,7,'/catalog/imported-images/product-3800158115185.jpg',0,1,12.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3187,'3187','3800158125245','','','','','','',2,7,'/catalog/imported-images/product-3800158125245.jpg',0,1,16.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3188,'3188','5059001015136','3665468401430','','','','','',5,7,'/catalog/imported-images/product-5059001015136.jpg',0,1,18.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3192,'3192','8694064010147','','','','','','',2,7,'/catalog/imported-images/product-8694064010147.jpg',0,1,5.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3193,'3193','8696643109228','','','','','','',3,7,'/catalog/imported-images/product-8696643109228.jpg',0,1,9.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3194,'3194','2000000093062','','','','','','',1,7,'/catalog/imported-images/product-2000000093062.jpg',0,1,5.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3195,'3195','5060176679283','5060176679290','','','','','',0,5,NULL,0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3196,'3196','4260634980086','','','','','','',1,7,'/catalog/imported-images/product-4260634980086.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3197,'3197','4260634980055','','','','','','',0,5,'/catalog/imported-images/product-4260634980055.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3198,'3198','4260634980062','','','','','','',2,7,'/catalog/imported-images/product-4260634980062.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3199,'3199','2090000186109','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3200,'3200','54748','2090000202786','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3201,'3201','2090000202557','','','','','','',3,7,NULL,0,1,3.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3204,'3204','8055348990560','','','','','','',8,7,'/catalog/imported-images/product-8055348990560.jpg',0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3207,'3207','8595025835673','','','','','','',2,7,NULL,0,1,5.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3209,'3209','8595025806031','','','','','','',1,7,NULL,0,1,5.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3210,'3210','8595025831149','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3211,'3211','8595025824905','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3212,'3212','8595025817747','','','','','','',0,5,NULL,0,1,8.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3203,'3203','6925414825640','','','','','','',5,7,'/catalog/imported-images/product-6925414825640.jpg',0,1,1.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3217,'3217','8595025806048','','','','','','',2,7,NULL,0,1,5.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3218,'3218','3800034975278','','','','','','',2,7,'/catalog/imported-images/product-3800034975278.jpg',0,1,11.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3220,'3220','3800170202665','','','','','','',6,7,'/catalog/imported-images/product-3800170202665.jpg',0,1,3.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3222,'3222','45610','','','','','','',1,7,NULL,0,1,19.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3223,'3223','8691857001443','','','','','','',5,7,NULL,0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3224,'3224','44174','','','','','','',1,7,NULL,0,1,3.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3225,'3225','8683143877153','','','','','','',0,5,NULL,0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3226,'3226','6952695605104','','','','','','',-1,5,NULL,0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3227,'3227','43793','','','','','','',1,7,NULL,0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3250,'3250','8002904821110','','','','','','',10,7,'/catalog/imported-images/product-8002904821110.jpg',0,1,2.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3251,'3251','8002904116261','','','','','','',5,7,'/catalog/imported-images/product-8002904116261.jpg',0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3252,'3252','8002904116254','','','','','','',7,7,'/catalog/imported-images/product-8002904116254.jpg',0,1,14.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3253,'3253','8002904763144','','','','','','',5,7,'/catalog/imported-images/product-8002904763144.jpg',0,1,6.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3254,'3254','8002904780080','','','','','','',6,7,'/catalog/imported-images/product-8002904780080.jpg',0,1,6.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3255,'3255','5011417551721','','','','','','',0,5,NULL,0,1,7.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3256,'3256','5999109542489','','','','','','',0,5,'/catalog/imported-images/product-5999109542489.jpg',0,1,7.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3257,'3257','5900627070286','','','','','','',0,5,NULL,0,1,7.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3258,'3258','5999109542496','','','','','','',0,5,'/catalog/imported-images/product-5999109542496.jpg',0,1,7.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3259,'3259','4012400500956','','','','','','',0,5,'/catalog/imported-images/product-4012400500956.jpg',0,1,10.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3261,'3261','8720065003946','8720065008361','','','','','',4,7,'/catalog/imported-images/product-8720065003946.jpg',0,1,10.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3262,'3262','8410104913892','','','','','','',0,5,NULL,0,1,15.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3263,'3263','8594002680138','','','','','','',0,5,NULL,0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3264,'3264','5997321700267','','','','','','',0,5,'/catalog/imported-images/product-5997321700267.jpg',0,1,11.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3265,'3265','4012400502097','','','','','','',0,5,'/catalog/imported-images/product-4012400502097.jpg',0,1,34.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3266,'3266','745114161307','','','','','','',0,5,'/catalog/imported-images/product-745114161307.jpg',0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3267,'3267','5900627061383','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3269,'3269','5900627061369','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3270,'3270','4002448130345','','','','','','',0,5,NULL,0,1,5.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3272,'3272','5201109655022','','','','','','',0,5,'/catalog/imported-images/product-5201109655022.jpg',0,1,2.1000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3275,'3275','3800235304211','','','','','','',1,7,NULL,0,1,44.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3277,'3277','3800085123475','','','','','','',1,7,'/catalog/imported-images/product-3800085123475.jpg',0,1,6.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3284,'3284','3800038928751','','','','','','',1,7,'/catalog/imported-images/product-3800038928751.jpg',0,1,6.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3285,'3285','4260634980079','','','','','','',0,5,'/catalog/imported-images/product-4260634980079.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3286,'3286','8002904107214','','','','','','',6,7,'/catalog/imported-images/product-8002904107214.jpg',0,1,7.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3288,'3288','8002904107580','','','','','','',0,5,NULL,0,1,8.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3291,'3291','7702018604067','','','','','','',1,7,'/catalog/imported-images/product-7702018604067.jpg',0,1,6.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3292,'3292','7702018308309','','','','','','',2,7,'/catalog/imported-images/product-7702018308309.jpg',0,1,6.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3294,'3294','7702018616978','','','','','','',1,7,'/catalog/imported-images/product-7702018616978.jpg',0,1,3.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3298,'3298','3800034971881','','','','','','',2,7,'/catalog/imported-images/product-3800034971881.jpg',0,1,13.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3307,'3307','3800032941220','','','','','','',3,7,'/catalog/imported-images/product-3800032941220.jpg',0,1,4.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3308,'3308','3800032904126','','','','','','',2,7,'/catalog/imported-images/product-3800032904126.jpg',0,1,5.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3309,'3309','3800032907509','','','','','','',2,7,'/catalog/imported-images/product-3800032907509.jpg',0,1,5.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3310,'3310','3800032907516','','','','','','',2,7,'/catalog/imported-images/product-3800032907516.jpg',0,1,7.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3318,'3318','6938383900003','','','','','','',1,7,'/catalog/imported-images/product-6938383900003.jpg',0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3319,'3319','42068','','','','','','',3,7,'/catalog/imported-images/product-42068.jpg',0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3320,'3320','20115','','','','','','',0,5,NULL,0,1,5.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3321,'3321','22315','','','','','','',2,7,NULL,0,1,6.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3324,'3324','3059946158945','','','','','','',1,7,'/catalog/imported-images/product-3059946158945.jpg',0,1,9.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3328,'3328','8697004822077','','','','','','',1,7,'/catalog/imported-images/product-8697004822077.jpg',0,1,59.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3329,'3329','5999071035279','','','','','','',5,7,NULL,0,1,2.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3330,'3330','7290108356793','','','','','','',0,5,'/catalog/imported-images/product-7290108356793.jpg',0,1,8.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3331,'3331','7290108356847','','','','','','',0,5,'/catalog/imported-images/product-7290108356847.jpg',0,1,9.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3333,'3333','3800038931799','','','','','','',-2,5,'/catalog/imported-images/product-3800038931799.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3334,'3334','3800038931805','','','','','','',13,7,'/catalog/imported-images/product-3800038931805.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3336,'3336','3800038919483','','','','','','',2,7,'/catalog/imported-images/product-3800038919483.jpg',0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3337,'3337','3800200010987','3800103100204','','','','','',9,7,'/catalog/imported-images/product-3800200010987.jpg',0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3338,'3338','8015194516536','','','','','','',1,7,'/catalog/imported-images/product-8015194516536.jpg',0,1,10.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3339,'3339','8697465000663','','','','','','',2,7,NULL,0,1,27.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3342,'3342','4895139236330','','','','','','',0,5,'/catalog/imported-images/product-4895139236330.jpg',0,1,39.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3349,'3349','4260418934427','','','','','','',5,7,'/catalog/imported-images/product-4260418934427.jpg',0,1,21.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3350,'3350','8008970007212','','','','','','',5,7,'/catalog/imported-images/product-8008970007212.jpg',0,1,11.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3351,'3351','8008970003627','','','','','','',6,7,'/catalog/imported-images/product-8008970003627.jpg',0,1,11.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:16:00','2024-06-27 16:15:00'),(3352,'3352','8008970005607','','','','','','',6,7,'/catalog/imported-images/product-8008970005607.jpg',0,1,11.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3353,'3353','4012400501670','','','','','','',2,7,'/catalog/imported-images/product-4012400501670.jpg',0,1,10.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3354,'3354','4012400501830','','','','','','',1,7,'/catalog/imported-images/product-4012400501830.jpg',0,1,16.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3355,'3355','4012400501946','','','','','','',1,7,'/catalog/imported-images/product-4012400501946.jpg',0,1,16.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3358,'3358','5201314995098','','','','','','',1,7,'/catalog/imported-images/product-5201314995098.jpg',0,1,14.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3363,'3363','5203278055184','','','','','','',10,7,'/catalog/imported-images/product-5203278055184.jpg',0,1,3.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3364,'3364','8001094123004','','','','','','',4,7,NULL,0,1,6.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3365,'3365','8001094182001','','','','','','',2,7,NULL,0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3366,'3366','3800718004805','','','','','','',0,5,'/catalog/imported-images/product-3800718004805.jpg',0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3367,'3367','8001094841779','','','','','','',0,5,NULL,0,1,9.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3369,'3369','8001094211084','','','','','','',1,7,NULL,0,1,9.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3370,'3370','8001094112121','','','','','','',2,7,NULL,0,1,10.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3372,'3372','3800718003921','','','','','','',2,7,NULL,0,1,3.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3375,'3375','3800718005673','','','','','','',2,7,'/catalog/imported-images/product-3800718005673.jpg',0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3377,'3377','3800718003983','','','','','','',5,7,'/catalog/imported-images/product-3800718003983.jpg',0,1,3.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3379,'3379','3800718505548','','','','','','',2,7,'/catalog/imported-images/product-3800718505548.jpg',0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3382,'3382','3800718005475','','','','','','',5,7,'/catalog/imported-images/product-3800718005475.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3383,'3383','3800718005482','','','','','','',5,7,'/catalog/imported-images/product-3800718005482.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3384,'3384','3800718005499','','','','','','',7,7,'/catalog/imported-images/product-3800718005499.jpg',0,1,4.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3385,'3385','8001094141619','','','','','','',2,7,NULL,0,1,12.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3387,'3387','6923933821389','','','','','','',4,7,'/catalog/imported-images/product-6923933821389.jpg',0,1,4.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3388,'3388','8006540888032','','','','','','',2,7,'/catalog/imported-images/product-8006540888032.jpg',0,1,13.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3389,'3389','8006540888025','','','','','','',0,5,'/catalog/imported-images/product-8006540888025.jpg',0,1,13.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3390,'3390','8006540887974','','','','','','',2,7,'/catalog/imported-images/product-8006540887974.jpg',0,1,13.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3391,'3391','8006540896754','','','','','','',0,5,'/catalog/imported-images/product-8006540896754.jpg',0,1,13.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3395,'3395','8697439141088','','','','','','',2,7,NULL,0,1,7.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3396,'3396','8697439141040','','','','','','',2,7,NULL,0,1,12.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3397,'3397','8697439141064','','','','','','',2,7,NULL,0,1,14.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3398,'3398','2090000156560','','','','','','',1,7,NULL,0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3399,'3399','2090000205107','','','','','','',8,7,'/catalog/imported-images/product-2090000205107.jpg',0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3401,'3401','8680853073585','','','','','','',1,7,NULL,0,1,7.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3402,'3402','2090000178227','','','','','','',4,7,NULL,0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3403,'3403','75152','','','','','','',3,7,'/catalog/imported-images/product-75152.jpg',0,1,5.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3404,'3404','75151','','','','','','',3,7,'/catalog/imported-images/product-75151.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3405,'3405','2000000070414','','','','','','',3,7,'/catalog/imported-images/product-2000000070414.jpg',0,1,2.1000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3406,'3406','70176','','','','','','',4,7,NULL,0,1,1.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3407,'3407','71948','','','','','','',6,7,NULL,0,1,1.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3408,'3408','71949','','','','','','',3,7,NULL,0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3409,'3409','2000000078717','','','','','','',8,7,'/catalog/imported-images/product-2000000078717.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3410,'3410','8606003593024','','','','','','',4,7,'/catalog/imported-images/product-8606003593024.jpg',0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3411,'3411','8699038085183','','','','','','',4,7,'/catalog/imported-images/product-8699038085183.jpg',0,1,3.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3412,'3412','8699038093782','','','','','','',3,7,'/catalog/imported-images/product-8699038093782.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3413,'3413','3800131504906','','','','','','',1,7,'/catalog/imported-images/product-3800131504906.jpg',0,1,9.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3414,'3414','3800131504913','','','','','','',1,7,'/catalog/imported-images/product-3800131504913.jpg',0,1,10.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3415,'3415','3800131573247','','','','','','',3,7,NULL,0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3416,'3416','2090000189773','','','','','','',2,7,NULL,0,1,7.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3417,'3417','2000000081052','','','','','','',4,7,NULL,0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3418,'3418','4607014710442','','','','','','',1,7,'/catalog/imported-images/product-4607014710442.jpg',0,1,20.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3419,'3419','3800131524386','','','','','','',0,5,'/catalog/imported-images/product-3800131524386.jpg',0,1,16.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3420,'3420','6902302277163','','','','','','',0,5,NULL,0,1,16.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3421,'3421','6902302277187','','','','','','',0,5,NULL,0,1,19.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3422,'3422','8693357091283','','','','','','',3,7,'/catalog/imported-images/product-8693357091283.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3423,'3423','8694064005778','','','','','','',0,5,NULL,0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3424,'3424','8694064005761','','','','','','',4,7,NULL,0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3425,'3425','8697409840454','','','','','','',1,7,NULL,0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3426,'3426','71256','','','','','','',2,7,NULL,0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3436,'3436','8690511125532','','','','','','',1,7,'/catalog/imported-images/product-8690511125532.jpg',0,1,3.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3437,'3437','КТ36017Л','','','','','','',0,5,NULL,0,1,5.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3438,'3438','0','','','','','','',0,5,NULL,0,1,0.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3439,'3439','KT036225L','','','','','','',0,5,NULL,0,1,10.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3440,'3440','5908260607463','','','','','','',1,7,'/catalog/imported-images/product-5908260607463.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3446,'3446','5903856971485','','','','','','',1,7,'/catalog/imported-images/product-5903856971485.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3449,'3449','5903856978118','','','','','','',1,7,'/catalog/imported-images/product-5903856978118.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3450,'3450','5903856976930','','','','','','',2,7,'/catalog/imported-images/product-5903856976930.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3455,'3455','5903856978583','','','','','','',0,5,'/catalog/imported-images/product-5903856978583.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3463,'3463','5908260621841','','','','','','',0,5,'/catalog/imported-images/product-5908260621841.jpg',0,1,5.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3464,'3464','5904378969349','','','','','','',1,7,'/catalog/imported-images/product-5904378969349.jpg',0,1,5.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3465,'3465','5901969630138','','','','','','',2,7,'/catalog/imported-images/product-5901969630138.jpg',0,1,5.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3466,'3466','5908260636678','5901969634518','','','','','',0,5,'/catalog/imported-images/product-5908260636678.jpg',0,1,5.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3467,'3467','8696033232024','8696033215126','','','','','',14,7,'/catalog/imported-images/product-8696033232024.jpg',0,1,12.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3468,'3468','8606005504714','','','','','','',1,7,NULL,0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3469,'3469','2000000067261','','','','','','',28,7,'/catalog/imported-images/product-2000000067261.jpg',0,1,0.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3470,'3470','4823052329464','','','','','','',1,7,NULL,0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3471,'3471','4823052329471','','','','','','',2,7,NULL,0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3472,'3472','4823052339098','','','','','','',2,7,NULL,0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3473,'3473','8697409843257','','','','','','',0,5,NULL,0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3474,'3474','8606003591563','','','','','','',1,7,'/catalog/imported-images/product-8606003591563.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3475,'3475','2000000081878','','','','','','',0,5,NULL,0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3476,'3476','8606006460668','','','','','','',4,7,'/catalog/imported-images/product-8606006460668.jpg',0,1,1.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3477,'3477','3800163902602','','','','','','',5,7,NULL,0,1,1.6900,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3481,'3481','8002904760013','','','','','','',6,7,'/catalog/imported-images/product-8002904760013.jpg',0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3483,'3483','3800077018765','','','','','','',5,7,'/catalog/imported-images/product-3800077018765.jpg',0,1,3.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3484,'3484','3800077018758','','','','','','',9,7,'/catalog/imported-images/product-3800077018758.jpg',0,1,3.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3487,'3487','3800002310605','','','','','','',1,7,'/catalog/imported-images/product-3800002310605.jpg',0,1,3.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3490,'3490','3800034977586','','','','','','',1,7,'/catalog/imported-images/product-3800034977586.jpg',0,1,26.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3491,'3491','3800034977609','','','','','','',1,7,'/catalog/imported-images/product-3800034977609.jpg',0,1,26.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3492,'3492','3800034977593','','','','','','',0,5,'/catalog/imported-images/product-3800034977593.jpg',0,1,26.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3493,'3493','3800718005208','','','','','','',5,7,'/catalog/imported-images/product-3800718005208.jpg',0,1,1.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3497,'3497','3800718502653','','','','','','',1,7,NULL,0,1,6.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3498,'3498','8009957006228','3800718502400','','','','','',11,7,NULL,0,1,6.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3499,'3499','6972538046314','','','','','','',9,7,'/catalog/imported-images/product-6972538046314.jpg',0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3500,'3500','6972538047731','','','','','','',0,5,NULL,0,1,10.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3501,'3501','6972538047519','','','','','','',2,7,NULL,0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3502,'3502','6972538047533','','','','','','',3,7,NULL,0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3503,'3503','6972538047571','','','','','','',4,7,NULL,0,1,3.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3504,'3504','6972538047588','','','','','','',2,7,NULL,0,1,3.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3505,'3505','6972538047526','','','','','','',2,7,NULL,0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3506,'3506','6972538047540','','','','','','',4,7,NULL,0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3512,'3512','8006540739693','','','','','','',0,5,'/catalog/imported-images/product-8006540739693.jpg',0,1,14.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3521,'3521','6971115421797','2220000100403','','','','','',12,7,NULL,0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:17:00','2024-06-27 16:16:00'),(3522,'3522','8697409840645','','','','','','',3,7,NULL,0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3523,'3523','45300','','','','','','',0,5,NULL,0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3524,'3524','45426','','','','','','',5,7,NULL,0,1,8.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3525,'3525','3800134811858','','','','','','',3,7,'/catalog/imported-images/product-3800134811858.jpg',0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3527,'3527','21942','','','','','','',4,7,NULL,0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3529,'3529','8690511125570','','','','','','',1,7,'/catalog/imported-images/product-8690511125570.jpg',0,1,3.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3532,'3532','8719497835768','','','','','','',3,7,'/catalog/imported-images/product-8719497835768.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3533,'3533','3059942033444','','','','','','',0,5,'/catalog/imported-images/product-3059942033444.jpg',0,1,9.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3536,'3536','6924393310307','','','','','','',6,7,'/catalog/imported-images/product-6924393310307.jpg',0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3537,'3537','2090000199307','','','','','','',1,7,NULL,0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3538,'3538','6924393310260','','','','','','',2,7,NULL,0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3539,'3539','2090000199291','','','','','','',1,7,NULL,0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3540,'3540','2090000196597','','','','','','',5,7,'/catalog/imported-images/product-2090000196597.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3544,'3544','3800034979894','','','','','','',1,7,'/catalog/imported-images/product-3800034979894.jpg',0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3547,'3547','6421937060112','','','','','','',6,7,'/catalog/imported-images/product-6421937060112.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3548,'3548','6421937060334','','','','','','',8,7,'/catalog/imported-images/product-6421937060334.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3550,'3550','8683907811645','','','','','','',5,7,'/catalog/imported-images/product-8683907811645.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3551,'3551','8683907810167','','','','','','',0,5,'/catalog/imported-images/product-8683907810167.jpg',0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3552,'3552','8683907810655','','','','','','',6,7,'/catalog/imported-images/product-8683907810655.jpg',0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3553,'3553','8683907810921','','','','','','',4,7,'/catalog/imported-images/product-8683907810921.jpg',0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3555,'3555','8683907810907','','','','','','',5,7,'/catalog/imported-images/product-8683907810907.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3556,'3556','8683907811140','','','','','','',0,5,'/catalog/imported-images/product-8683907811140.jpg',0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3557,'3557','8683907810952','','','','','','',5,7,'/catalog/imported-images/product-8683907810952.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3558,'3558','8683907810662','','','','','','',3,7,'/catalog/imported-images/product-8683907810662.jpg',0,1,9.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3559,'3559','8683907810679','','','','','','',0,5,'/catalog/imported-images/product-8683907810679.jpg',0,1,15.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3560,'3560','8683907810686','','','','','','',3,7,'/catalog/imported-images/product-8683907810686.jpg',0,1,23.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3561,'3561','6421937070074','','','','','','',2,7,'/catalog/imported-images/product-6421937070074.jpg',0,1,3.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3562,'3562','6421937070418','','','','','','',2,7,'/catalog/imported-images/product-6421937070418.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3563,'3563','6421937070425','','','','','','',5,7,'/catalog/imported-images/product-6421937070425.jpg',0,1,6.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3564,'3564','3800089503129','','','','','','',0,5,NULL,0,1,9.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3566,'3566','7290108356922','','','','','','',3,7,'/catalog/imported-images/product-7290108356922.jpg',0,1,26.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3567,'3567','7290108356915','','','','','','',3,7,'/catalog/imported-images/product-7290108356915.jpg',0,1,26.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3570,'3570','8697427787915','','','','','','',2,7,'/catalog/imported-images/product-8697427787915.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3578,'3578','8011851201005','','','','','','',100,7,'/catalog/imported-images/product-8011851201005.jpg',0,1,0.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3579,'3579','12700','(01)52020542121240','','','','','',100,7,'/catalog/imported-images/product-12700.jpg',0,1,0.1000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3580,'3580','12698','','','','','','',100,7,'/catalog/imported-images/product-12698.jpg',0,1,0.1500,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3582,'3582','3800158115345','','','','','','',2,7,'/catalog/imported-images/product-3800158115345.jpg',0,1,22.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3583,'3583','3800158115352','','','','','','',2,7,'/catalog/imported-images/product-3800158115352.jpg',0,1,16.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3586,'3586','45728','','','','','','',3,7,NULL,0,1,9.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3593,'3593','9000101515077','','','','','','',4,7,'/catalog/imported-images/product-9000101515077.jpg',0,1,19.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3594,'3594','8006540996850','','','','','','',0,5,'/catalog/imported-images/product-8006540996850.jpg',0,1,25.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3595,'3595','8006540869642','','','','','','',0,5,'/catalog/imported-images/product-8006540869642.jpg',0,1,25.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3597,'3597','8700216211444','','','','','','',0,5,'/catalog/imported-images/product-8700216211444.jpg',0,1,43.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3607,'3607','4823052336387','','','','','','',3,7,NULL,0,1,4.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3608,'3608','4823052323776','','','','','','',3,7,NULL,0,1,3.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3609,'3609','2090000206005','','','','','','',3,7,'/catalog/imported-images/product-2090000206005.jpg',0,1,9.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3610,'3610','2090000151091','','','','','','',8,7,'/catalog/imported-images/product-2090000151091.jpg',0,1,1.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3611,'3611','2090000149838','','','','','','',4,7,NULL,0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3612,'3612','8697975041583','','','','','','',4,7,'/catalog/imported-images/product-8697975041583.jpg',0,1,4.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3614,'3614','5202351205089','','','','','','',0,5,NULL,0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3615,'3615','3800089511520','','','','','','',0,5,NULL,0,1,17.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3620,'3620','6923933821426','','','','','','',3,7,'/catalog/imported-images/product-6923933821426.jpg',0,1,3.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3623,'3623','5902841453197','','','','','','',5,7,NULL,0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3625,'3625','5902841473812','','','','','','',4,7,'/catalog/imported-images/product-5902841473812.jpg',0,1,7.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3628,'3628','5201410226126','','','','','','',0,5,'/catalog/imported-images/product-5201410226126.jpg',0,1,1.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3629,'3629','5201410896015','','','','','','',12,7,'/catalog/imported-images/product-5201410896015.jpg',0,1,2.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3631,'3631','5054563125002','','','','','','',2,7,'/catalog/imported-images/product-5054563125002.jpg',0,1,6.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3638,'3638','5999109561091','5908252006274','','','','','',2,7,'/catalog/imported-images/product-5999109561091.jpg',0,1,6.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3639,'3639','8006540940099','','','','','','',0,5,'/catalog/imported-images/product-8006540940099.jpg',0,1,25.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3642,'3642','3800718005277','','','','','','',0,5,'/catalog/imported-images/product-3800718005277.jpg',0,1,3.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3643,'3643','5202707000641','','','','','','',3,7,NULL,0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3644,'3644','3800718005338','','','','','','',3,7,'/catalog/imported-images/product-3800718005338.jpg',0,1,5.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3645,'3645','3800718005352','','','','','','',9,7,'/catalog/imported-images/product-3800718005352.jpg',0,1,2.1000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3647,'3647','10918','','','','','','',2,7,NULL,0,1,7.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3648,'3648','6421937060747','','','','','','',7,7,NULL,0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3649,'3649','8693357506565','680678505269','','','','','',6,7,'/catalog/imported-images/product-8693357506565.jpg',0,1,6.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3650,'3650','8693357328792','','','','','','',8,7,'/catalog/imported-images/product-8693357328792.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3651,'3651','6421937070043','','','','','','',2,7,NULL,0,1,7.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3657,'3657','8006540919729','','','','','','',10,7,'/catalog/imported-images/product-8006540919729.jpg',0,1,10.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3658,'3658','8000903824590','','','','','','',3,7,'/catalog/imported-images/product-8000903824590.jpg',0,1,5.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3663,'3663','8697427785799','','','','','','',1,7,'/catalog/imported-images/product-8697427785799.jpg',0,1,3.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3665,'3665','50','','','','','','',7,7,'/catalog/imported-images/product-50.jpg',0,1,9.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3667,'3667','5904517381179','','','','','','',2,7,'/catalog/imported-images/product-5904517381179.jpg',0,1,13.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3668,'3668','5904517364035','','','','','','',3,7,'/catalog/imported-images/product-5904517364035.jpg',0,1,11.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3669,'3669','5904517366749','','','','','','',3,7,'/catalog/imported-images/product-5904517366749.jpg',0,1,8.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3670,'3670','5904517026285','','','','','','',9,7,'/catalog/imported-images/product-5904517026285.jpg',0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3672,'3672','8681873417908','','','','','','',3,7,'/catalog/imported-images/product-8681873417908.jpg',0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3673,'3673','8697410474204','','','','','','',5,7,NULL,0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3674,'3674','3800225188241','','','','','','',0,5,NULL,0,1,0.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3675,'3675','3800225189194','','','','','','',0,5,'/catalog/imported-images/product-3800225189194.jpg',0,1,1.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3676,'3676','3800225189170','','','','','','',0,5,'/catalog/imported-images/product-3800225189170.jpg',0,1,1.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3685,'3685','3800225187541','','','','','','',1,7,'/catalog/imported-images/product-3800225187541.jpg',0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3693,'3693','3800077001736','','','','','','',2,7,'/catalog/imported-images/product-3800077001736.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3697,'3697','4823052329457','','','','','','',0,5,NULL,0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3699,'3699','8697427787656','','','','','','',3,7,'/catalog/imported-images/product-8697427787656.jpg',0,1,5.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3701,'3701','8000798000369','','','','','','',2,7,NULL,0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3702,'3702','45001','','','','','','',6,7,'/catalog/imported-images/product-45001.jpg',0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3703,'3703','40684','','','','','','',3,7,NULL,0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3714,'3714','3800085124304','','','','','','',2,7,'/catalog/imported-images/product-3800085124304.jpg',0,1,0.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3716,'3716','3800085112981','','','','','','',1,7,'/catalog/imported-images/product-3800085112981.jpg',0,1,0.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3717,'3717','3800235307182','','','','','','',72,7,'/catalog/imported-images/product-3800235307182.jpg',0,1,7.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3718,'3718','3800218262422','','','','','','',2,7,NULL,0,1,10.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3720,'3720','5904517367050','','','','','','',11,7,'/catalog/imported-images/product-5904517367050.jpg',0,1,14.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3731,'3731','2400000000181','','','','','','',0,5,'/catalog/imported-images/product-2400000000181.jpg',0,1,0.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3732,'3732','2400000000198','','','','','','',0,5,'/catalog/imported-images/product-2400000000198.jpg',0,1,0.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3741,'3741','44934','','','','','','',8,7,'/catalog/imported-images/product-44934.jpg',0,1,12.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3743,'3743','44686','','','','','','',4,7,'/catalog/imported-images/product-44686.jpg',0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3744,'3744','20149','','','','','','',4,7,'/catalog/imported-images/product-20149.jpg',0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3745,'3745','20150','','','','','','',4,7,'/catalog/imported-images/product-20150.jpg',0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:18:00','2024-06-27 16:16:00'),(3747,'3747','70448','','','','','','',2,7,NULL,0,1,12.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3748,'3748','70765','','','','','','',2,7,NULL,0,1,17.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3749,'3749','6971804030163','20288','','','','','',5,7,NULL,0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3750,'3750','6924393305174','50454','','','','','',4,7,NULL,0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3751,'3751','6952712800062','21551','','','','','',5,7,NULL,0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3752,'3752','40510','','','','','','',11,7,'/catalog/imported-images/product-40510.jpg',0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3757,'3757','8600034206670','','','','','','',1,7,'/catalog/imported-images/product-8600034206670.jpg',0,1,35.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3758,'3758','8600034206717','','','','','','',1,7,'/catalog/imported-images/product-8600034206717.jpg',0,1,38.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3759,'3759','8600034206694','','','','','','',0,5,'/catalog/imported-images/product-8600034206694.jpg',0,1,45.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3760,'3760','8600034206731','','','','','','',1,7,'/catalog/imported-images/product-8600034206731.jpg',0,1,49.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3761,'3761','8600034206854','','','','','','',1,7,'/catalog/imported-images/product-8600034206854.jpg',0,1,56.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3762,'3762','8600034206793','','','','','','',1,7,'/catalog/imported-images/product-8600034206793.jpg',0,1,42.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3763,'3763','8600034207820','','','','','','',1,7,'/catalog/imported-images/product-8600034207820.jpg',0,1,24.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3764,'3764','8600034207844','','','','','','',0,5,'/catalog/imported-images/product-8600034207844.jpg',0,1,26.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3765,'3765','6970233832256','','','','','','',3,7,'/catalog/imported-images/product-6970233832256.jpg',0,1,14.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3766,'3766','6970233832270','','','','','','',3,7,'/catalog/imported-images/product-6970233832270.jpg',0,1,19.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3767,'3767','9000101571011','','','','','','',2,7,'/catalog/imported-images/product-9000101571011.jpg',0,1,20.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3768,'3768','9000101574418','','','','','','',2,7,'/catalog/imported-images/product-9000101574418.jpg',0,1,20.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3772,'3772','8435495837350','','','','','','',0,5,'/catalog/imported-images/product-8435495837350.jpg',0,1,5.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3773,'3773','8006540566022','','','','','','',1,7,'/catalog/imported-images/product-8006540566022.jpg',0,1,11.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3774,'3774','6923933821563','','','','','','',0,5,NULL,0,1,0.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3782,'3782','8682022661562','','','','','','',10,7,'/catalog/imported-images/product-8682022661562.jpg',0,1,7.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3783,'3783','3800225189187','','','','','','',2,7,'/catalog/imported-images/product-3800225189187.jpg',0,1,1.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3785,'3785','30070','','','','','','',2,7,NULL,0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3786,'3786','0000000300926','','','','','','',12,7,'/catalog/imported-images/product-0000000300926.jpg',0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3788,'3788','3800235300763','','','','','','',2,7,'/catalog/imported-images/product-3800235300763.jpg',0,1,18.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3789,'3789','3800237043538','','','','','','',0,5,'/catalog/imported-images/product-3800237043538.jpg',0,1,15.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3790,'3790','3800237043545','','','','','','',1,7,'/catalog/imported-images/product-3800237043545.jpg',0,1,18.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3791,'3791','3800237043569','','','','','','',0,5,'/catalog/imported-images/product-3800237043569.jpg',0,1,23.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3792,'3792','3800237043552','','','','','','',1,7,'/catalog/imported-images/product-3800237043552.jpg',0,1,19.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3793,'3793','3800237042302','','','','','','',3,7,'/catalog/imported-images/product-3800237042302.jpg',0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3794,'3794','3800235307915','','','','','','',2,7,'/catalog/imported-images/product-3800235307915.jpg',0,1,20.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3795,'3795','4690317018354','','','','','','',1,7,'/catalog/imported-images/product-4690317018354.jpg',0,1,24.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3796,'3796','4690317018356','','','','','','',1,7,'/catalog/imported-images/product-4690317018356.jpg',0,1,30.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3799,'3799','3800235307496','','','','','','',0,5,'/catalog/imported-images/product-3800235307496.jpg',0,1,13.2000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3801,'3801','6954125109350','1062600','','','','','',15,7,'/catalog/imported-images/product-6954125109350.jpg',0,1,9.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3802,'3802','1062800','','','','','','',14,7,'/catalog/imported-images/product-1062800.jpg',0,1,11.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3803,'3803','1062100','','','','','','',15,7,'/catalog/imported-images/product-1062100.jpg',0,1,14.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3805,'3805','8006540875131','8006540897379','','','','','',3,7,'/catalog/imported-images/product-8006540875131.jpg',0,1,7.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3807,'3807','8006540888551','','','','','','',2,7,'/catalog/imported-images/product-8006540888551.jpg',0,1,9.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3815,'3815','5906927330006','','','','','','',8,7,NULL,0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3822,'3822','8600034183919','','','','','','',1,7,'/catalog/imported-images/product-8600034183919.jpg',0,1,49.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3823,'3823','8600034183971','','','','','','',1,7,'/catalog/imported-images/product-8600034183971.jpg',0,1,55.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3824,'3824','8600034131521','','','','','','',1,7,'/catalog/imported-images/product-8600034131521.jpg',0,1,42.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3825,'3825','8600034200098','','','','','','',0,5,'/catalog/imported-images/product-8600034200098.jpg',0,1,48.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3827,'3827','8600034200135','','','','','','',0,5,'/catalog/imported-images/product-8600034200135.jpg',0,1,48.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3828,'3828','8600034200111','','','','','','',1,7,'/catalog/imported-images/product-8600034200111.jpg',0,1,34.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3829,'3829','8600034200197','','','','','','',0,5,'/catalog/imported-images/product-8600034200197.jpg',0,1,34.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3830,'3830','6970233838531','','','','','','',1,7,'/catalog/imported-images/product-6970233838531.jpg',0,1,25.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3831,'3831','К31','','','','','','',0,5,NULL,0,1,2.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3833,'3833','8681942501019','','','','','','',4,7,'/catalog/imported-images/product-8681942501019.jpg',0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3835,'3835','5903355097679','','','','','','',5,7,'/catalog/imported-images/product-5903355097679.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3836,'3836','5903355097709','','','','','','',0,5,'/catalog/imported-images/product-5903355097709.jpg',0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3837,'3837','5903355097686','','','','','','',5,7,'/catalog/imported-images/product-5903355097686.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3838,'3838','5903355000334','','','','','','',5,7,'/catalog/imported-images/product-5903355000334.jpg',0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3839,'3839','5903355002918','','','','','','',3,7,'/catalog/imported-images/product-5903355002918.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3840,'3840','8681695492749','','','','','','',6,7,'/catalog/imported-images/product-8681695492749.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3841,'3841','8681695490424','','','','','','',10,7,'/catalog/imported-images/product-8681695490424.jpg',0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3842,'3842','8681695491438','','','','','','',5,7,'/catalog/imported-images/product-8681695491438.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3843,'3843','8681695491735','','','','','','',5,7,'/catalog/imported-images/product-8681695491735.jpg',0,1,1.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3844,'3844','8681695499076','','','','','','',4,7,'/catalog/imported-images/product-8681695499076.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3845,'3845','8681695499229','','','','','','',3,7,'/catalog/imported-images/product-8681695499229.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3846,'3846','8681695495207','','','','','','',3,7,'/catalog/imported-images/product-8681695495207.jpg',0,1,3.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3847,'3847','8681695499090','','','','','','',1,7,'/catalog/imported-images/product-8681695499090.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3848,'3848','8681695499083','','','','','','',3,7,'/catalog/imported-images/product-8681695499083.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3849,'3849','8681695499472','','','','','','',3,7,'/catalog/imported-images/product-8681695499472.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3850,'3850','8681695499458','','','','','','',2,7,'/catalog/imported-images/product-8681695499458.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3851,'3851','8681695499151','','','','','','',3,7,'/catalog/imported-images/product-8681695499151.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3852,'3852','8681695495139','','','','','','',3,7,'/catalog/imported-images/product-8681695495139.jpg',0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3853,'3853','8681695493272','','','','','','',3,7,'/catalog/imported-images/product-8681695493272.jpg',0,1,7.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3854,'3854','8681695493265','','','','','','',3,7,'/catalog/imported-images/product-8681695493265.jpg',0,1,7.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3855,'3855','8681695499618','','','','','','',3,7,'/catalog/imported-images/product-8681695499618.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3856,'3856','8681695499670','','','','','','',3,7,'/catalog/imported-images/product-8681695499670.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3857,'3857','8681695499649','','','','','','',3,7,'/catalog/imported-images/product-8681695499649.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3858,'3858','8681695499625','','','','','','',3,7,'/catalog/imported-images/product-8681695499625.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3859,'3859','8681695499687','','','','','','',2,7,'/catalog/imported-images/product-8681695499687.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3860,'3860','360057','','','','','','',2,7,'/catalog/imported-images/product-360057.jpg',0,1,4.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3861,'3861','8693357052604','','','','','','',1,7,'/catalog/imported-images/product-8693357052604.jpg',0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3862,'3862','8693357051508','','','','','','',2,7,'/catalog/imported-images/product-8693357051508.jpg',0,1,7.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3863,'3863','8693357052581','','','','','','',2,7,'/catalog/imported-images/product-8693357052581.jpg',0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3864,'3864','8693357022157','','','','','','',6,7,'/catalog/imported-images/product-8693357022157.jpg',0,1,3.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3865,'3865','8693357593084','','','','','','',4,7,'/catalog/imported-images/product-8693357593084.jpg',0,1,2.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3866,'3866','8693357234192','','','','','','',2,7,'/catalog/imported-images/product-8693357234192.jpg',0,1,22.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3867,'3867','8693357052987','','','','','','',4,7,'/catalog/imported-images/product-8693357052987.jpg',0,1,6.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3869,'3869','8693357090446','','','','','','',3,7,'/catalog/imported-images/product-8693357090446.jpg',0,1,16.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3870,'3870','8699243469457','','','','','','',6,7,'/catalog/imported-images/product-8699243469457.jpg',0,1,3.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3873,'3873','8006540966976','','','','','','',4,7,'/catalog/imported-images/product-8006540966976.jpg',0,1,15.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3877,'3877','3800163900127','','','','','','',10,7,'/catalog/imported-images/product-3800163900127.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3878,'3878','8692531001070','','','','','','',3,7,'/catalog/imported-images/product-8692531001070.jpg',0,1,1.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3879,'3879','8681873420830','','','','','','',4,7,NULL,0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3885,'3885','8600034175402','','','','','','',2,7,'/catalog/imported-images/product-8600034175402.jpg',0,1,59.9900,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3893,'3893','2090000196429','','','','','','',5,7,'/catalog/imported-images/product-2090000196429.jpg',0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3894,'3894','8697762461921','','','','','','',1,7,'/catalog/imported-images/product-8697762461921.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3895,'3895','10647','','','','','','',4,7,'/catalog/imported-images/product-10647.jpg',0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3896,'3896','8682013135072','','','','','','',4,7,'/catalog/imported-images/product-8682013135072.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3897,'3897','3800226800487','','','','','','',4,7,'/catalog/imported-images/product-3800226800487.jpg',0,1,2.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3901,'3901','8600034206878','','','','','','',1,7,'/catalog/imported-images/product-8600034206878.jpg',0,1,41.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3902,'3902','8600034207684','','','','','','',1,7,'/catalog/imported-images/product-8600034207684.jpg',0,1,55.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3905,'3905','2090000206043','','','','','','',2,7,NULL,0,1,4.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:17:00'),(3908,'3908','8015100576449','','','','','','',8,7,'/catalog/imported-images/product-8015100576449.jpg',0,1,12.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3909,'3909','8002910063894','','','','','','',11,7,'/catalog/imported-images/product-8002910063894.jpg',0,1,27.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3912,'3912','8600034175389','','','','','','',1,7,'/catalog/imported-images/product-8600034175389.jpg',0,1,45.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3915,'3915','5059001009692','','','','','','',3,7,'/catalog/imported-images/product-5059001009692.jpg',0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3917,'3917','2090000195439','','','','','','',2,7,'/catalog/imported-images/product-2090000195439.jpg',0,1,19.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3919,'3919','2090000205992','','','','','','',3,7,NULL,0,1,8.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3920,'3920','3800034982443','','','','','','',1,7,NULL,0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3921,'3921','3800034982429','','','','','','',2,7,NULL,0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3922,'3922','3800034982436','','','','','','',2,7,NULL,0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3924,'3924','20213','','','','','','',6,7,'/catalog/imported-images/product-20213.jpg',0,1,3.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3925,'3925','50231','','','','','','',5,7,NULL,0,1,6.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3926,'3926','41631','','','','','','',9,7,'/catalog/imported-images/product-41631.jpg',0,1,5.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3927,'3927','7498564063679','','','','','','',12,7,'/catalog/imported-images/product-7498564063679.jpg',0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3928,'3928','20923','','','','','','',9,7,'/catalog/imported-images/product-20923.jpg',0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3929,'3929','7498564070592','','','','','','',12,7,NULL,0,1,2.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3931,'3931','2400000000204','','','','','','',0,5,NULL,0,1,0.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3488,'3488','3800002302662','','','','','','',2,7,'/catalog/imported-images/product-3800002302662.jpg',0,1,3.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3918,'3918','8699421200407','','','','','','',9,7,'/catalog/imported-images/product-8699421200407.jpg',0,1,1.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3343,'3343','8015194522506','','','','','','',8,7,'/catalog/imported-images/product-8015194522506.jpg',0,1,7.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3345,'3345','8015194522490','','','','','','',9,7,'/catalog/imported-images/product-8015194522490.jpg',0,1,6.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3659,'3659','8033993194113','','','','','','',11,7,'/catalog/imported-images/product-8033993194113.jpg',0,1,4.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3434,'3434','4895139236057','','','','','','',0,5,'/catalog/imported-images/product-4895139236057.jpg',0,1,29.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3588,'3588','4895139239799','','','','','','',2,7,'/catalog/imported-images/product-4895139239799.jpg',0,1,34.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3587,'3587','4895139208399','','','','','','',1,7,'/catalog/imported-images/product-4895139208399.jpg',0,1,39.8000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3435,'3435','4895139236064','','','','','','',1,7,'/catalog/imported-images/product-4895139236064.jpg',0,1,34.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3589,'3589','4895139239805','','','','','','',1,7,'/catalog/imported-images/product-4895139239805.jpg',0,1,38.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3590,'3590','4895139239812','','','','','','',2,7,'/catalog/imported-images/product-4895139239812.jpg',0,1,42.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3513,'3513','3800718004195','','','','','','',4,7,'/catalog/imported-images/product-3800718004195.jpg',0,1,2.7000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3244,'3244','4895139236095','','','','','','',1,7,'/catalog/imported-images/product-4895139236095.jpg',0,1,48.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3243,'3243','4895139202991','','','','','','',1,7,'/catalog/imported-images/product-4895139202991.jpg',0,1,52.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3603,'3603','8710447282977','','','','','','',3,7,'/catalog/imported-images/product-8710447282977.jpg',0,1,6.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3482,'3482','8690511171379','','','','','','',3,7,'/catalog/imported-images/product-8690511171379.jpg',0,1,11.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3430,'3430','3800038938446','','','','','','',3,7,'/catalog/imported-images/product-3800038938446.jpg',0,1,6.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3781,'3781','6001067022558','','','','','','',12,7,'/catalog/imported-images/product-6001067022558.jpg',0,1,2.0000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3821,'3821','8720182482105','','','','','','',1,7,'/catalog/imported-images/product-8720182482105.jpg',0,1,9.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3820,'3820','8720182482136','','','','','','',1,7,'/catalog/imported-images/product-8720182482136.jpg',0,1,9.5000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3534,'3534','4000388179004','','','','','','',0,5,'/catalog/imported-images/product-4000388179004.jpg',0,1,5.4000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3635,'3635','9005800291888','','','','','','',1,7,'/catalog/imported-images/product-9005800291888.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3633,'3633','9005800302300','','','','','','',1,7,'/catalog/imported-images/product-9005800302300.jpg',0,1,3.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3888,'3888','9005800243306','','','','','','',2,7,'/catalog/imported-images/product-9005800243306.jpg',0,1,8.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3817,'3817','42277767','','','','','','',0,5,'/catalog/imported-images/product-42277767.jpg',0,1,3.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3515,'3515','8690511000013','','','','','','',2,7,'/catalog/imported-images/product-8690511000013.jpg',0,1,8.6000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3514,'3514','8690511171331','','','','','','',3,7,'/catalog/imported-images/product-8690511171331.jpg',0,1,11.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3231,'3231','8690511000655','','','','','','',0,5,NULL,0,1,11.3000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00000000,0.00000000,0,1,1,0,1,0,'2024-06-20 17:19:00','2024-06-27 16:18:00'),(3528,'3528','8690511010067','','','','','','',2,7,'/catalog/imported-images/product-8690511010067.jpg',0,1,10.9000,0,9,'2024-06-20',0.00000000,0,0.00000000,0.00